/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import eduni.simjava.Sim_system;
import gridsim.AllocPolicy;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.ResGridlet;
import gridsim.ResGridletList;
import java.util.Iterator;

class TimeShared
extends AllocPolicy {
    private ResGridletList gridletInExecList_ = new ResGridletList();
    private ResGridletList gridletPausedList_ = new ResGridletList();
    private double lastUpdateTime_ = 0.0;
    private MIShares share_ = new MIShares();

    TimeShared(String string, String string2) throws Exception {
        super(string, string2);
    }

    public void body() {
        Sim_event sim_event = new Sim_event();
        while (Sim_system.running()) {
            super.sim_get_next(sim_event);
            if (sim_event.get_tag() == -1 || super.isEndSimulation()) break;
            if (sim_event.get_src() != this.myId_) continue;
            this.internalEvent();
        }
        while (super.sim_waiting() > 0) {
            super.sim_get_next(sim_event);
            System.out.println(this.resName_ + ".TimeShared.body(): ignoring internal events");
        }
    }

    public void gridletSubmit(Gridlet gridlet, boolean bl) {
        this.updateGridletProcessing();
        ResGridlet resGridlet = new ResGridlet(gridlet);
        resGridlet.setGridletStatus(3);
        this.gridletInExecList_.add(resGridlet);
        if (bl) {
            super.sendAck(22, true, gridlet.getGridletID(), gridlet.getUserID());
        }
        this.forecastGridlet();
    }

    public int gridletStatus(int n, int n2) {
        ResGridlet resGridlet = null;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletInExecList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        n3 = super.findGridlet(this.gridletPausedList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletPausedList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        return -1;
    }

    public void gridletCancel(int n, int n2) {
        ResGridlet resGridlet = this.cancel(n, n2);
        if (resGridlet == null) {
            System.out.println(this.resName_ + ".TimeShared.gridletCancel(): Cannot find " + "Gridlet #" + n + " for User #" + n2);
            super.sendCancelGridlet(23, null, n, n2);
            return;
        }
        resGridlet.finalizeGridlet();
        if (resGridlet.getGridletStatus() == 4) {
            System.out.println(this.resName_ + ".TimeShared.gridletCancel(): Cannot cancel" + " Gridlet #" + n + " for User #" + n2 + " since it has FINISHED.");
        }
        super.sendCancelGridlet(23, resGridlet.getGridlet(), n, n2);
    }

    public void gridletPause(int n, int n2, boolean bl) {
        boolean bl2 = false;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            this.updateGridletProcessing();
            ResGridlet resGridlet = (ResGridlet)this.gridletInExecList_.remove(n3);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                System.out.println(this.resName_ + ".TimeShared.gridletPause(): Cannot pause" + " Gridlet #" + n + " for User #" + n2 + " since it is FINISHED.");
                this.gridletFinish(resGridlet, 4);
            } else {
                bl2 = true;
                resGridlet.setGridletStatus(7);
                this.gridletPausedList_.add(resGridlet);
                System.out.println(this.resName_ + ".TimeShared.gridletPause(): Gridlet #" + n + " with User #" + n2 + " has been sucessfully PAUSED.");
            }
            this.forecastGridlet();
        } else {
            System.out.println(this.resName_ + ".TimeShared.gridletPause(): Cannot find " + "Gridlet #" + n + " for User #" + n2);
        }
        if (bl) {
            super.sendAck(26, bl2, n, n2);
        }
    }

    public void gridletMove(int n, int n2, int n3, boolean bl) {
        ResGridlet resGridlet = this.cancel(n, n2);
        if (resGridlet == null) {
            System.out.println(this.resName_ + ".TimeShared.gridletMove(): Cannot find " + "Gridlet #" + n + " for User #" + n2);
            if (bl) {
                super.sendAck(22, false, n, n2);
            }
            return;
        }
        resGridlet.finalizeGridlet();
        Gridlet gridlet = resGridlet.getGridlet();
        if (gridlet.getGridletStatus() == 4) {
            System.out.println(this.resName_ + ".TimeShared.gridletMove(): Cannot move" + " Gridlet #" + n + " for User #" + n2 + " since it has FINISHED.");
            if (bl) {
                super.sendAck(22, false, n, n2);
            }
            super.sendFinishGridlet(gridlet);
        } else {
            super.gridletMigrate(gridlet, n3, bl);
        }
    }

    public void gridletResume(int n, int n2, boolean bl) {
        boolean bl2 = false;
        int n3 = super.findGridlet(this.gridletPausedList_, n, n2);
        if (n3 >= 0) {
            this.updateGridletProcessing();
            ResGridlet resGridlet = (ResGridlet)this.gridletPausedList_.remove(n3);
            resGridlet.setGridletStatus(8);
            this.gridletInExecList_.add(resGridlet);
            this.forecastGridlet();
            bl2 = true;
            System.out.println(this.resName_ + ".TimeShared.gridletResume(): Gridlet #" + n + " with User #" + n2 + " has been sucessfully RESUMED.");
        } else {
            System.out.println(this.resName_ + ".TimeShared.gridletResume(): Cannot find Gridlet #" + n + " for User #" + n2);
        }
        if (bl) {
            super.sendAck(28, bl2, n, n2);
        }
    }

    private void updateGridletProcessing() {
        double d = GridSim.clock();
        double d2 = d - this.lastUpdateTime_;
        if (d2 <= 0.0) {
            return;
        }
        this.lastUpdateTime_ = d;
        int n = this.gridletInExecList_.size();
        double d3 = super.calculateTotalLoad(n);
        super.addTotalLoad(d3);
        if (n == 0) {
            return;
        }
        MIShares mIShares = this.getMIShare(d2, n);
        ResGridlet resGridlet = null;
        int n2 = 0;
        Iterator iterator = this.gridletInExecList_.iterator();
        while (iterator.hasNext()) {
            resGridlet = (ResGridlet)iterator.next();
            if (n2 < mIShares.maxCount) {
                resGridlet.updateGridletFinishedSoFar(mIShares.max);
            } else {
                resGridlet.updateGridletFinishedSoFar(mIShares.min);
            }
            ++n2;
        }
    }

    private MIShares getMIShare(double d, int n) {
        double d2 = this.resCalendar_.getCurrentLoad();
        double d3 = (double)this.resource_.getMIPSRatingOfOnePE() * d * (1.0 - d2);
        int n2 = n / this.totalPE_;
        int n3 = n % this.totalPE_;
        if (n2 > 0) {
            this.share_.min = d3 / (double)(n2 + 1);
            this.share_.max = d3 / (double)n2;
            this.share_.maxCount = (this.totalPE_ - n3) * n2;
        } else {
            this.share_.max = d3;
            this.share_.min = d3;
            this.share_.maxCount = n;
        }
        return this.share_;
    }

    private void forecastGridlet() {
        if (this.gridletInExecList_.size() == 0) {
            return;
        }
        this.checkGridletCompletion();
        MIShares mIShares = this.getMIShare(1.0, this.gridletInExecList_.size());
        ResGridlet resGridlet = null;
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Iterator iterator = this.gridletInExecList_.iterator();
        while (iterator.hasNext()) {
            resGridlet = (ResGridlet)iterator.next();
            d2 = n < mIShares.maxCount ? mIShares.max : mIShares.min;
            d = this.forecastFinishTime(d2, resGridlet.getRemainingGridletLength());
            resGridlet.setFinishTime(d);
            if (n == 0 || d3 > d) {
                d3 = d;
            }
            ++n;
        }
        super.sendInternalEvent(d3);
    }

    private void checkGridletCompletion() {
        ResGridlet resGridlet = null;
        int n = 0;
        while (n < this.gridletInExecList_.size()) {
            resGridlet = (ResGridlet)this.gridletInExecList_.get(n);
            if (resGridlet.getRemainingGridletLength() <= 0.0) {
                this.gridletFinish(resGridlet, 4);
                continue;
            }
            ++n;
        }
    }

    private double forecastFinishTime(double d, double d2) {
        double d3 = d2 / d;
        if (d3 < 1.0) {
            d3 = 1.0;
        }
        return d3;
    }

    private void gridletFinish(ResGridlet resGridlet, int n) {
        resGridlet.setGridletStatus(n);
        resGridlet.finalizeGridlet();
        Gridlet gridlet = resGridlet.getGridlet();
        super.sendFinishGridlet(gridlet);
        this.gridletInExecList_.remove(resGridlet);
    }

    private void internalEvent() {
        if (this.lastUpdateTime_ == GridSim.clock()) {
            return;
        }
        this.updateGridletProcessing();
        this.forecastGridlet();
    }

    private ResGridlet cancel(int n, int n2) {
        ResGridlet resGridlet = null;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            this.updateGridletProcessing();
            resGridlet = (ResGridlet)this.gridletInExecList_.remove(n3);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                resGridlet.setGridletStatus(4);
            } else {
                resGridlet.setGridletStatus(6);
            }
            this.forecastGridlet();
        } else {
            n3 = super.findGridlet(this.gridletPausedList_, n, n2);
            if (n3 >= 0) {
                resGridlet = (ResGridlet)this.gridletPausedList_.remove(n3);
                resGridlet.setGridletStatus(6);
            }
        }
        return resGridlet;
    }

    private class MIShares {
        public double max = 0.0;
        public double min = 0.0;
        public int maxCount = 0;
    }
}

