/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import eduni.simjava.Sim_system;
import gridsim.AllocPolicy;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.Machine;
import gridsim.MachineList;
import gridsim.PEList;
import gridsim.ResGridlet;
import gridsim.ResGridletList;
import java.util.Iterator;

class SpaceShared
extends AllocPolicy {
    private ResGridletList gridletQueueList_;
    private ResGridletList gridletInExecList_ = new ResGridletList();
    private ResGridletList gridletPausedList_ = new ResGridletList();
    private double lastUpdateTime_ = 0.0;
    private int[] machineRating_ = null;

    SpaceShared(String string, String string2) throws Exception {
        super(string, string2);
        this.gridletQueueList_ = new ResGridletList();
    }

    public void body() {
        MachineList machineList = this.resource_.getMachineList();
        int n = machineList.size();
        this.machineRating_ = new int[n];
        for (int i = 0; i < n; ++i) {
            this.machineRating_[i] = this.resource_.getMIPSRatingOfOnePE(i, 0);
        }
        Sim_event sim_event = new Sim_event();
        while (Sim_system.running()) {
            super.sim_get_next(sim_event);
            if (sim_event.get_tag() == -1 || super.isEndSimulation()) break;
            if (sim_event.get_src() != this.myId_ || this.gridletInExecList_.size() <= 0) continue;
            this.updateGridletProcessing();
            this.checkGridletCompletion();
        }
        while (super.sim_waiting() > 0) {
            super.sim_get_next(sim_event);
            System.out.println(this.resName_ + ".SpaceShared.body(): ignore internal events");
        }
    }

    public void gridletSubmit(Gridlet gridlet, boolean bl) {
        this.updateGridletProcessing();
        ResGridlet resGridlet = new ResGridlet(gridlet);
        boolean bl2 = false;
        if (this.gridletInExecList_.size() < this.totalPE_) {
            bl2 = this.allocatePEtoGridlet(resGridlet);
        }
        if (!bl2) {
            resGridlet.setGridletStatus(2);
            this.gridletQueueList_.add(resGridlet);
        }
        if (bl) {
            super.sendAck(22, true, gridlet.getGridletID(), gridlet.getUserID());
        }
    }

    public int gridletStatus(int n, int n2) {
        ResGridlet resGridlet = null;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletInExecList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        n3 = super.findGridlet(this.gridletPausedList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletPausedList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        n3 = super.findGridlet(this.gridletQueueList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletQueueList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        return -1;
    }

    public void gridletCancel(int n, int n2) {
        ResGridlet resGridlet = this.cancel(n, n2);
        if (resGridlet == null) {
            System.out.println(this.resName_ + ".SpaceShared.gridletCancel(): Cannot find " + "Gridlet #" + n + " for User #" + n2);
            super.sendCancelGridlet(23, null, n, n2);
            return;
        }
        if (resGridlet.getGridletStatus() == 4) {
            System.out.println(this.resName_ + ".SpaceShared.gridletCancel(): Cannot cancel" + " Gridlet #" + n + " for User #" + n2 + " since it has FINISHED.");
        }
        resGridlet.finalizeGridlet();
        super.sendCancelGridlet(23, resGridlet.getGridlet(), n, n2);
    }

    public void gridletPause(int n, int n2, boolean bl) {
        ResGridlet resGridlet;
        boolean bl2 = false;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            this.updateGridletProcessing();
            resGridlet = (ResGridlet)this.gridletInExecList_.remove(n3);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                n3 = -1;
                this.gridletFinish(resGridlet, 4);
                System.out.println(this.resName_ + ".SpaceShared.gridletPause(): Cannot pause" + " Gridlet #" + n + " for User #" + n2 + " since it has FINISHED.");
            } else {
                bl2 = true;
                resGridlet.setGridletStatus(7);
                this.gridletPausedList_.add(resGridlet);
                this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
                this.allocateQueueGridlet();
            }
        } else {
            n3 = super.findGridlet(this.gridletQueueList_, n, n2);
        }
        if (!bl2 && n3 >= 0) {
            bl2 = true;
            resGridlet = (ResGridlet)this.gridletQueueList_.remove(n3);
            resGridlet.setGridletStatus(7);
            this.gridletPausedList_.add(resGridlet);
        } else if (n3 == -1) {
            System.out.println(this.resName_ + ".SpaceShared.gridletPause(): Error - cannot " + "find Gridlet #" + n + " for User #" + n2);
        }
        if (bl) {
            super.sendAck(26, bl2, n, n2);
        }
    }

    public void gridletMove(int n, int n2, int n3, boolean bl) {
        ResGridlet resGridlet = this.cancel(n, n2);
        if (resGridlet == null) {
            System.out.println(this.resName_ + ".SpaceShared.gridletMove(): Cannot find " + "Gridlet #" + n + " for User #" + n2);
            if (bl) {
                super.sendAck(22, false, n, n2);
            }
            return;
        }
        if (resGridlet.getGridletStatus() == 4) {
            System.out.println(this.resName_ + ".SpaceShared.gridletMove(): Cannot move Gridlet #" + n + " for User #" + n2 + " since it has FINISHED.");
            if (bl) {
                super.sendAck(22, false, n, n2);
            }
            this.gridletFinish(resGridlet, 4);
        } else {
            resGridlet.finalizeGridlet();
            this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
            super.gridletMigrate(resGridlet.getGridlet(), n3, bl);
            this.allocateQueueGridlet();
        }
    }

    public void gridletResume(int n, int n2, boolean bl) {
        boolean bl2 = false;
        int n3 = super.findGridlet(this.gridletPausedList_, n, n2);
        if (n3 >= 0) {
            ResGridlet resGridlet = (ResGridlet)this.gridletPausedList_.remove(n3);
            resGridlet.setGridletStatus(8);
            this.updateGridletProcessing();
            bl2 = true;
            boolean bl3 = false;
            if (this.gridletInExecList_.size() < this.totalPE_) {
                bl3 = this.allocatePEtoGridlet(resGridlet);
            }
            if (!bl3) {
                resGridlet.setGridletStatus(2);
                this.gridletQueueList_.add(resGridlet);
            }
            System.out.println(this.resName_ + "TimeShared.gridletResume():" + " Gridlet #" + n + " with User ID #" + n2 + " has been sucessfully RESUMED.");
        } else {
            System.out.println(this.resName_ + "TimeShared.gridletResume(): Cannot find " + "Gridlet #" + n + " for User #" + n2);
        }
        if (bl) {
            super.sendAck(28, bl2, n, n2);
        }
    }

    private void allocateQueueGridlet() {
        ResGridlet resGridlet;
        boolean bl;
        if (this.gridletQueueList_.size() > 0 && this.gridletInExecList_.size() < this.totalPE_ && (bl = this.allocatePEtoGridlet(resGridlet = (ResGridlet)this.gridletQueueList_.get(0)))) {
            this.gridletQueueList_.remove(resGridlet);
        }
    }

    private void updateGridletProcessing() {
        double d = GridSim.clock();
        double d2 = d - this.lastUpdateTime_;
        if (d2 <= 0.0) {
            return;
        }
        this.lastUpdateTime_ = d;
        int n = this.gridletInExecList_.size();
        double d3 = super.calculateTotalLoad(n);
        super.addTotalLoad(d3);
        if (n == 0) {
            return;
        }
        ResGridlet resGridlet = null;
        Iterator iterator = this.gridletInExecList_.iterator();
        while (iterator.hasNext()) {
            resGridlet = (ResGridlet)iterator.next();
            d3 = this.getMIShare(d2, resGridlet.getMachineID());
            resGridlet.updateGridletFinishedSoFar(d3);
        }
    }

    private double getMIShare(double d, int n) {
        double d2 = this.resCalendar_.getCurrentLoad();
        double d3 = (double)this.machineRating_[n] * d * (1.0 - d2);
        return d3;
    }

    private boolean allocatePEtoGridlet(ResGridlet resGridlet) {
        Machine machine = this.resource_.getMachineWithFreePE();
        if (machine == null) {
            return false;
        }
        PEList pEList = machine.getPEList();
        int n = pEList.getFreePEID();
        resGridlet.setGridletStatus(3);
        resGridlet.setMachineAndPEID(machine.getMachineID(), n);
        this.gridletInExecList_.add(resGridlet);
        this.resource_.setStatusPE(false, resGridlet.getMachineID(), n);
        int n2 = this.machineRating_[resGridlet.getMachineID()];
        double d = this.forecastFinishTime(n2, resGridlet.getRemainingGridletLength());
        resGridlet.setFinishTime(d);
        super.sendInternalEvent(d);
        return true;
    }

    private double forecastFinishTime(double d, double d2) {
        double d3 = d2 / d;
        if (d3 < 1.0) {
            d3 = 1.0;
        }
        return d3;
    }

    private void checkGridletCompletion() {
        ResGridlet resGridlet = null;
        int n = 0;
        while (n < this.gridletInExecList_.size()) {
            resGridlet = (ResGridlet)this.gridletInExecList_.get(n);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                this.gridletInExecList_.remove(resGridlet);
                this.gridletFinish(resGridlet, 4);
                continue;
            }
            ++n;
        }
        if (this.gridletInExecList_.size() > 0) {
            super.sendInternalEvent(60.0);
        }
    }

    private void gridletFinish(ResGridlet resGridlet, int n) {
        this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
        resGridlet.setGridletStatus(n);
        resGridlet.finalizeGridlet();
        super.sendFinishGridlet(resGridlet.getGridlet());
        this.allocateQueueGridlet();
    }

    private ResGridlet cancel(int n, int n2) {
        ResGridlet resGridlet = null;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            this.updateGridletProcessing();
            resGridlet = (ResGridlet)this.gridletInExecList_.remove(n3);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                resGridlet.setGridletStatus(4);
            } else {
                resGridlet.setGridletStatus(6);
            }
            this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
            this.allocateQueueGridlet();
            return resGridlet;
        }
        n3 = super.findGridlet(this.gridletQueueList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletQueueList_.remove(n3);
            resGridlet.setGridletStatus(6);
        } else {
            n3 = super.findGridlet(this.gridletPausedList_, n, n2);
            if (n3 >= 0) {
                resGridlet = (ResGridlet)this.gridletPausedList_.remove(n3);
                resGridlet.setGridletStatus(6);
            }
        }
        return resGridlet;
    }
}

