/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_system;
import gridsim.GridSim;
import gridsim.GridSimRandom;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Random;

public class ResourceCalendar {
    private Random random_;
    private double timeZone_;
    private double[] weekdayLoad_;
    private double[] holidayLoad_;
    private LinkedList weekendList_;
    private LinkedList holidayList_;
    private final int TIME = 60;

    public ResourceCalendar(double d, double d2, double d3, double d4, LinkedList linkedList, LinkedList linkedList2, long l) {
        this.random_ = new Random(l);
        this.timeZone_ = d;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.2, 0.4, 0.8, 1.0, 1.0, 0.6, 0.6, 0.9, 1.0, 1.0, 0.5, 0.2, 0.1, 0.0, 0.0, 0.0};
        int n = 24;
        this.weekdayLoad_ = new double[n];
        this.holidayLoad_ = new double[n];
        double d5 = 0.0;
        double d6 = 0.1;
        for (int i = 0; i < n; ++i) {
            d5 = dArray[i] * (d2 - d3) + d3;
            this.weekdayLoad_[i] = GridSimRandom.real(d5, d6, d6, this.random_.nextDouble());
            this.holidayLoad_[i] = GridSimRandom.real(d4 * d5, d6, d6, this.random_.nextDouble());
        }
        this.weekendList_ = linkedList;
        this.holidayList_ = linkedList2;
    }

    public Calendar CalendarAtGivenSimTime(double d) throws NullPointerException {
        return this.getCalendarAtSimulationTime(d);
    }

    public Calendar getCalendarAtSimulationTime(double d) throws NullPointerException {
        Calendar calendar = GridSim.getSimulationCalendar();
        Date date = GridSim.getSimulationStartDate();
        if (date == null) {
            throw new NullPointerException("ResourceCalendar.getCalendarAtSimulationTime() : Error - Need to call GridSim.init() first before using any of GridSim entities.");
        }
        calendar.setTime(date);
        calendar.add(12, (int)(this.timeZone_ * 60.0));
        calendar.add(13, (int)d);
        return calendar;
    }

    public Calendar CalendarNow() throws NullPointerException {
        return this.getCurrentCalendar();
    }

    public Calendar getCurrentCalendar() throws NullPointerException {
        return this.getCalendarAtSimulationTime(Sim_system.clock());
    }

    public double SimulationTime(Calendar calendar) throws NullPointerException {
        return this.getSimulationTime(calendar);
    }

    public double getSimulationTime(Calendar calendar) throws NullPointerException {
        if (calendar == null) {
            throw new NullPointerException("ResourceCalendar.getSimulationTime() : Error - Calendar object must not be null.");
        }
        calendar.add(12, (int)(this.timeZone_ * 60.0));
        Date date = GridSim.getSimulationStartDate();
        if (date == null) {
            throw new NullPointerException("ResourceCalendar.getSimulationTime() : Error - Need to call GridSim.init() first before using any of GridSim entities.");
        }
        Calendar calendar2 = this.getCalendarAtGivenDate(date);
        Date date2 = calendar.getTime();
        Date date3 = calendar2.getTime();
        double d = (double)(date2.getTime() - date3.getTime()) / 1000.0;
        return d;
    }

    public Calendar CalendarAtGivenDate(Date date) {
        return this.getCalendarAtGivenDate(date);
    }

    public Calendar getCalendarAtGivenDate(Date date) {
        Calendar calendar = GridSim.getSimulationCalendar();
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        calendar.add(12, (int)(this.timeZone_ * 60.0));
        return calendar;
    }

    public boolean IsHoliday() throws NullPointerException {
        return this.isHoliday();
    }

    public boolean isHoliday() throws NullPointerException {
        Calendar calendar = this.getCurrentCalendar();
        int n = calendar.get(6);
        int n2 = calendar.get(7);
        if (this.holidayList_ != null && this.holidayList_.contains(new Integer(n))) {
            return true;
        }
        return this.weekendList_ != null && this.weekendList_.contains(new Integer(n2));
    }

    public boolean IsHoliday(Date date) {
        return this.isHoliday(date);
    }

    public boolean isHoliday(Date date) {
        if (this.holidayList_ == null) {
            return false;
        }
        Calendar calendar = this.getCalendarAtGivenDate(date);
        calendar.setTime(date);
        int n = calendar.get(6);
        int n2 = calendar.get(7);
        if (this.holidayList_ != null && this.holidayList_.contains(new Integer(n))) {
            return true;
        }
        return this.weekendList_ != null && this.weekendList_.contains(new Integer(n2));
    }

    public double CurrentLoad() throws NullPointerException {
        return this.getCurrentLoad();
    }

    public double getCurrentLoad() throws NullPointerException {
        if (this.isHoliday()) {
            this.getCurrentCalendar();
            return this.holidayLoad_[11];
        }
        this.getCurrentCalendar();
        return this.weekdayLoad_[11];
    }
}

