/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import gridsim.Machine;
import gridsim.PEList;
import java.util.Iterator;
import java.util.LinkedList;

public class MachineList
extends LinkedList {
    public Machine GetMachine(int n) {
        return this.getMachine(n);
    }

    public Machine getMachine(int n) {
        Machine machine = null;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            machine = (Machine)iterator.next();
            if (machine.getMachineID() != n) continue;
            return machine;
        }
        return null;
    }

    public int GetNoOfPEs() {
        return this.getNumPE();
    }

    public int getNumPE() {
        int n = 0;
        Machine machine = null;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            machine = (Machine)iterator.next();
            n += machine.getNumPE();
        }
        return n;
    }

    public int getNumFreePE() {
        int n = 0;
        Machine machine = null;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            machine = (Machine)iterator.next();
            n += machine.getNumFreePE();
        }
        return n;
    }

    public int getNumBusyPE() {
        return this.getNumPE() - this.getNumFreePE();
    }

    public Machine GetMachineWithFreePE() {
        return this.getMachineWithFreePE();
    }

    public Machine getMachineWithFreePE() {
        return this.getMachineWithFreePE(1);
    }

    public Machine getMachineWithFreePE(int n) {
        Machine machine = null;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            machine = (Machine)iterator.next();
            PEList pEList = machine.getPEList();
            if (pEList.getNumFreePE() < n) continue;
            return machine;
        }
        return null;
    }

    public boolean setStatusPE(boolean bl, int n, int n2) {
        Machine machine = this.getMachine(n);
        if (machine == null) {
            return false;
        }
        return machine.setStatusPE(bl, n2);
    }

    public int ByteSize() {
        return this.getByteSize();
    }

    public int getByteSize() {
        int n = 0;
        Machine machine = null;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            machine = (Machine)iterator.next();
            n += machine.getByteSize();
        }
        return n;
    }
}

