/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import java.util.Random;

public class GridSimRandom {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 1;
    private static Random random_ = new Random();
    private static double lessFactorIO_ = 0.0;
    private static double moreFactorIO_ = 0.0;
    private static double lessFactorExec_ = 0.0;
    private static double moreFactorExec_ = 0.0;

    public GridSimRandom() {
    }

    public GridSimRandom(long l) {
        random_.setSeed(l);
    }

    public GridSimRandom(long l, double d, double d2, double d3, double d4) {
        random_.setSeed(l);
        lessFactorIO_ = d;
        moreFactorIO_ = d2;
        lessFactorExec_ = d3;
        moreFactorExec_ = d4;
    }

    public static void set_factors(double d, double d2, double d3, double d4) {
        GridSimRandom.setAllFactors(d, d2, d3, d4);
    }

    public static void setAllFactors(double d, double d2, double d3, double d4) {
        lessFactorIO_ = d;
        moreFactorIO_ = d2;
        lessFactorExec_ = d3;
        moreFactorExec_ = d4;
    }

    public static int int_sample(int n) throws IllegalArgumentException {
        return GridSimRandom.intSample(n);
    }

    public static int intSample(int n) throws IllegalArgumentException {
        return random_.nextInt(n);
    }

    public static double double_sample() {
        return GridSimRandom.doubleSample();
    }

    public static double doubleSample() {
        return random_.nextDouble();
    }

    public static void set_less_factor_io(double d) throws IllegalArgumentException {
        GridSimRandom.setLessFactorIO(d);
    }

    public static void setLessFactorIO(double d) throws IllegalArgumentException {
        if (d < 0.0) {
            throw new IllegalArgumentException("GridSimRandom.setLessFactorIO() : Error - factor must be zero or positive value.");
        }
        lessFactorIO_ = d;
    }

    public static void set_more_factor_io(double d) throws IllegalArgumentException {
        GridSimRandom.setMoreFactorIO(d);
    }

    public static void setMoreFactorIO(double d) throws IllegalArgumentException {
        if (d < 0.0) {
            throw new IllegalArgumentException("GridSimRandom.setMoreFactorIO() : Error - factor must be zero or positive value.");
        }
        moreFactorIO_ = d;
    }

    public static void set_less_factor_e(double d) {
        GridSimRandom.setLessFactorExec(d);
    }

    public static void setLessFactorExec(double d) throws IllegalArgumentException {
        if (d < 0.0) {
            throw new IllegalArgumentException("GridSimRandom.setLessFactorExec() : Error - factor must be zero or positive value.");
        }
        lessFactorExec_ = d;
    }

    public static void set_more_factor_e(double d) {
        GridSimRandom.setMoreFactorExec(d);
    }

    public static void setMoreFactorExec(double d) throws IllegalArgumentException {
        if (d < 0.0) {
            throw new IllegalArgumentException("GridSimRandom.setMoreFactorExec() : Error - factor must be zero or positive value.");
        }
        moreFactorExec_ = d;
    }

    public static double get_factor_io() {
        return GridSimRandom.getFactorIO();
    }

    public static double getFactorIO() {
        return (moreFactorIO_ - lessFactorIO_) / 2.0;
    }

    public static double get_factor_e() {
        return GridSimRandom.getFactorExec();
    }

    public static double getFactorExec() {
        return (moreFactorExec_ - lessFactorExec_) / 2.0;
    }

    public static double real(double d, double d2, double d3, double d4) throws IllegalArgumentException {
        String string = "GridSimRandom.real(): Error - ";
        if (d < 0.0) {
            throw new IllegalArgumentException(string + "value must be zero or positive value.");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException(string + "lessFactor must be zero or positive value.");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException(string + "moreFactor must be within [0.0, 1.0].");
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException(string + "randDouble must be within [0.0, 1.0].");
        }
        double d5 = d * (1.0 - d2 + (d2 + d3) * d4);
        return d5;
    }

    public static double real_io(double d) throws IllegalArgumentException {
        return GridSimRandom.realIO(d);
    }

    public static double realIO(double d) throws IllegalArgumentException {
        return GridSimRandom.real(d, lessFactorIO_, moreFactorIO_, GridSimRandom.doubleSample());
    }

    public static double real_e(double d) throws IllegalArgumentException {
        return GridSimRandom.realExec(d);
    }

    public static double realExec(double d) throws IllegalArgumentException {
        return GridSimRandom.real(d, lessFactorExec_, moreFactorExec_, GridSimRandom.doubleSample());
    }

    public static double expected_io(double d) throws IllegalArgumentException {
        return GridSimRandom.expectedIO(d);
    }

    public static double expectedIO(double d) throws IllegalArgumentException {
        return d * (1.0 + GridSimRandom.getFactorIO());
    }

    public static double expected_e(double d) throws IllegalArgumentException {
        return GridSimRandom.expectedExec(d);
    }

    public static double expectedExec(double d) throws IllegalArgumentException {
        return d * (1.0 + GridSimRandom.getFactorExec());
    }
}

