/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import eduni.simjava.Sim_exception;
import eduni.simjava.Sim_port;
import eduni.simjava.Sim_system;
import eduni.simjava.Sim_type_p;
import gridsim.Accumulator;
import gridsim.GridInformationService;
import gridsim.GridSimCore;
import gridsim.GridSimRandom;
import gridsim.GridSimShutdown;
import gridsim.GridStatistics;
import gridsim.Gridlet;
import gridsim.IO_data;
import gridsim.ResourceCharacteristics;
import gridsim.Sim_from_port;
import gridsim.Stat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;

public class GridSim
extends GridSimCore {
    private int[] dataArray_ = new int[3];
    private Sim_event ev_ = new Sim_event();
    private final int SIZE = 12;
    public static Date SimulationStartDate = null;
    public static GridSimRandom rand = null;
    private static int gisID_ = -1;
    private static int shutdownID_ = -1;
    private static int statsID_ = -1;
    private static Calendar calendar_ = null;
    private static GridInformationService gis_ = null;
    private static final int NOT_FOUND = -1;

    public GridSim(String string) throws Exception {
        super(string);
    }

    public GridSim(String string, double d) throws Exception {
        super(string, d);
    }

    public static Date GetSimulationStartDate() {
        return GridSim.getSimulationStartDate();
    }

    public static Date getSimulationStartDate() {
        return SimulationStartDate;
    }

    public static Calendar getSimulationCalendar() {
        return calendar_;
    }

    public static void Init(int n, Calendar calendar, boolean bl, String[] stringArray, String[] stringArray2, String string) {
        GridSim.init(n, calendar, bl, stringArray, stringArray2, string);
    }

    public static void init(int n, Calendar calendar, boolean bl, String[] stringArray, String[] stringArray2, String string) {
        try {
            GridSim.initCommonVariable(calendar, bl, n, string);
            GridStatistics gridStatistics = null;
            gridStatistics = new GridStatistics("GridStatistics", "GridSim_stat.txt", true, stringArray, stringArray2);
            gis_ = new GridInformationService("GridInformationService", 9600.0);
            gisID_ = gis_.get_id();
            statsID_ = gridStatistics.get_id();
        }
        catch (Sim_exception sim_exception) {
            System.out.println("GridSim.init(): Unwanted errors happen");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            System.out.println("GridSim.init(): Unwanted errors happen");
            System.out.println(exception.getMessage());
        }
    }

    public static void init(int n, Calendar calendar, boolean bl) {
        try {
            GridSim.initCommonVariable(calendar, bl, n, null);
            gis_ = new GridInformationService("GridInformationService", 9600.0);
            gisID_ = gis_.get_id();
        }
        catch (Sim_exception sim_exception) {
            System.out.println("GridSim.init(): Unwanted errors happen");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            System.out.println("GridSim.init(): Unwanted errors happen");
            System.out.println(exception.getMessage());
        }
    }

    public static void init(int n, Calendar calendar, boolean bl, boolean bl2) {
        try {
            GridSim.initCommonVariable(calendar, bl, n, null);
            if (bl2) {
                gis_ = new GridInformationService("GridInformationService", 9600.0);
                gisID_ = gis_.get_id();
            }
        }
        catch (Sim_exception sim_exception) {
            System.out.println("GridSim.init(): Unwanted errors happen");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            System.out.println("GridSim.init(): Unwanted errors happen");
            System.out.println(exception.getMessage());
        }
    }

    public static boolean setGIS(GridInformationService gridInformationService) {
        if (gridInformationService == null) {
            return false;
        }
        gis_ = gridInformationService;
        gisID_ = gridInformationService.get_id();
        return true;
    }

    private static void initCommonVariable(Calendar calendar, boolean bl, int n, String string) throws Exception {
        Sim_system.initialise();
        Sim_system.set_trc_level(1);
        Sim_system.set_auto_trace(bl);
        calendar_ = calendar;
        if (calendar == null) {
            calendar_ = Calendar.getInstance();
        }
        SimulationStartDate = calendar_.getTime();
        rand = new GridSimRandom();
        GridSimShutdown gridSimShutdown = new GridSimShutdown("GridSimShutdown", n, string);
        shutdownID_ = gridSimShutdown.get_id();
    }

    public static void Start() throws NullPointerException {
        GridSim.startGridSimulation();
    }

    public static void startGridSimulation() throws NullPointerException {
        System.out.println("Starting GridSim version 3.0");
        try {
            Sim_system.run();
        }
        catch (Sim_exception sim_exception) {
            throw new NullPointerException("GridSim.startGridSimulation() : Error - you haven't initialized GridSim.");
        }
    }

    public static double Clock() {
        return GridSim.clock();
    }

    public static double clock() {
        return Sim_system.clock();
    }

    public void GridSimHold(double d) {
        this.gridSimHold(d);
    }

    public void gridSimHold(double d) {
        if (d < 0.0) {
            return;
        }
        super.sim_process(d);
    }

    public static void Stop() throws NullPointerException {
        GridSim.stopGridSimulation();
    }

    public static void stopGridSimulation() throws NullPointerException {
        try {
            Sim_system.run_stop();
        }
        catch (Sim_exception sim_exception) {
            throw new NullPointerException("GridSim.stopGridSimulation() : Error - can't stop Grid Simulation.");
        }
    }

    protected Object ReceiveEventObject() {
        return this.receiveEventObject();
    }

    protected Object receiveEventObject() {
        super.sim_get_next(this.ev_);
        return this.ev_.get_data();
    }

    protected Object ReceiveEventObject(Sim_port sim_port) {
        return this.receiveEventObject(sim_port);
    }

    protected Object receiveEventObject(Sim_port sim_port) {
        if (sim_port == null) {
            return null;
        }
        super.sim_get_next(new Sim_from_port(sim_port), this.ev_);
        return this.ev_.get_data();
    }

    protected boolean GridletSubmit(Gridlet gridlet, int n) {
        return this.gridletSubmit(gridlet, n);
    }

    protected boolean gridletSubmit(Gridlet gridlet, int n) {
        return this.gridletSubmit(gridlet, n, 0.0, false);
    }

    protected boolean gridletSubmit(Gridlet gridlet, int n, double d, boolean bl) {
        if (gridlet == null || d < 0.0) {
            return false;
        }
        if (gridlet.isFinished()) {
            System.out.println("GridSim.gridletSubmit(): Error - Gridlet #" + gridlet.getGridletID() + " for User #" + gridlet.getUserID() + " is already finished.");
            return false;
        }
        boolean bl2 = false;
        try {
            String string = "GridSim.gridletSubmit(): ";
            bl2 = this.validateValue(string, gridlet.getGridletID(), gridlet.getUserID(), n);
            if (!bl2) {
                return false;
            }
            if (bl) {
                this.send(this.output, d, 22, (Object)new IO_data(gridlet, gridlet.getGridletFileSize(), n));
                Sim_type_p sim_type_p = new Sim_type_p(22 + gridlet.getGridletID());
                super.sim_get_next(sim_type_p, this.ev_);
                bl2 = (Boolean)this.ev_.get_data();
            } else {
                bl2 = false;
                this.send(this.output, d, 21, (Object)new IO_data(gridlet, gridlet.getGridletFileSize(), n));
            }
        }
        catch (Sim_exception sim_exception) {
            bl2 = false;
            System.out.println("GridSim.gridletSubmit(): Error from SimJava occurs.");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.println("GridSim.gridletSubmit(): Error occurs.");
            System.out.println(exception.getMessage());
        }
        return bl2;
    }

    protected Gridlet GridletReceive() {
        return this.gridletReceive();
    }

    protected Gridlet gridletReceive() {
        Gridlet gridlet = null;
        try {
            gridlet = (Gridlet)this.receiveEventObject(this.input);
        }
        catch (ClassCastException classCastException) {
            return gridlet;
        }
        catch (Exception exception) {
            return gridlet;
        }
        return gridlet;
    }

    protected Gridlet gridletReceive(int n, int n2, int n3) {
        String string = "GridSim.gridletReceive(): ";
        boolean bl = this.validateValue(string, n, n2, n3);
        if (!bl) {
            return null;
        }
        Sim_type_p sim_type_p = new Sim_type_p(20 + n);
        super.sim_get_next(sim_type_p, this.ev_);
        Gridlet gridlet = null;
        try {
            gridlet = (Gridlet)this.ev_.get_data();
        }
        catch (ClassCastException classCastException) {
            gridlet = null;
        }
        catch (Exception exception) {
            gridlet = null;
        }
        return gridlet;
    }

    private boolean sendGridlet(String string, int n, int n2, int n3, double d, int n4, boolean bl) {
        boolean bl2 = this.validateValue(string, n, n2, n3);
        if (!bl2 || d < 0.0) {
            return false;
        }
        int n5 = 14;
        this.dataArray_[0] = n;
        this.dataArray_[1] = n2;
        this.dataArray_[2] = -1;
        int n6 = n4;
        if (bl) {
            switch (n4) {
                case 25: {
                    n6 = 26;
                    break;
                }
                case 27: {
                    n6 = 28;
                    break;
                }
            }
        }
        this.send(this.output, d, n6, (Object)new IO_data(this.dataArray_, n5, n3));
        return true;
    }

    private boolean validateValue(String string, int n, int n2, int n3) {
        boolean bl = true;
        if (n < 0) {
            bl = false;
            System.out.println(string + "Error - Gridlet ID must be >= 0, not " + n);
        }
        if (n2 < 0) {
            bl = false;
            System.out.println(string + "Error - User ID must be >= 0, not " + n2);
        }
        if (n3 < 0) {
            bl = false;
            System.out.println(string + "Error - GridResource ID must be >= 0, not " + n3);
        }
        if (!gis_.isResourceExist(n3)) {
            bl = false;
            System.out.println(string + "Error - GridResource ID #" + n3 + " doesn't exist");
        }
        return bl;
    }

    protected Gridlet gridletCancel(Gridlet gridlet, int n, double d) {
        if (gridlet == null || d < 0.0) {
            return null;
        }
        Gridlet gridlet2 = this.gridletCancel(gridlet.getGridletID(), gridlet.getUserID(), n, d);
        return gridlet2;
    }

    protected Gridlet gridletCancel(int n, int n2, int n3, double d) {
        Gridlet gridlet = null;
        try {
            String string = "GridSim.gridletCancel(): ";
            boolean bl = this.sendGridlet(string, n, n2, n3, d, 23, false);
            if (bl) {
                Sim_type_p sim_type_p = new Sim_type_p(23 + n);
                super.sim_get_next(sim_type_p, this.ev_);
                gridlet = (Gridlet)this.ev_.get_data();
            }
        }
        catch (Sim_exception sim_exception) {
            gridlet = null;
            System.out.println("GridSim.gridletCancel(): Error occurs.");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            gridlet = null;
            System.out.println("GridSim.gridletCancel(): Error occurs.");
            System.out.println(exception.getMessage());
        }
        return gridlet;
    }

    protected boolean gridletPause(Gridlet gridlet, int n, double d) {
        if (gridlet == null || d < 0.0) {
            return false;
        }
        return this.gridletPause(gridlet.getGridletID(), gridlet.getUserID(), n, d, true);
    }

    protected boolean gridletPause(int n, int n2, int n3, double d, boolean bl) {
        boolean bl2 = false;
        try {
            String string = "GridSim.gridletPause(): ";
            bl2 = this.sendGridlet(string, n, n2, n3, d, 25, bl);
            if (bl2 && bl) {
                Sim_type_p sim_type_p = new Sim_type_p(26 + n);
                super.sim_get_next(sim_type_p, this.ev_);
                bl2 = (Boolean)this.ev_.get_data();
            }
        }
        catch (Sim_exception sim_exception) {
            bl2 = false;
            System.out.println("GridSim.gridletPause(): Error occurs.");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.println("GridSim.gridletPause(): Error occurs.");
            System.out.println(exception.getMessage());
        }
        return bl2;
    }

    protected int gridletStatus(Gridlet gridlet, int n) {
        if (gridlet == null) {
            return -1;
        }
        return this.gridletStatus(gridlet.getGridletID(), gridlet.getUserID(), n);
    }

    protected int gridletStatus(int n, int n2, int n3) {
        int n4 = -1;
        try {
            String string = "GridSim.gridletStatus(): ";
            boolean bl = this.sendGridlet(string, n, n2, n3, 0.0, 24, false);
            if (!bl) {
                return n4;
            }
            Sim_type_p sim_type_p = new Sim_type_p(24 + n);
            super.sim_get_next(sim_type_p, this.ev_);
            n4 = (Integer)this.ev_.get_data();
        }
        catch (Sim_exception sim_exception) {
            n4 = -1;
            System.out.println("GridSim.gridletStatus(): Error occurs.");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            n4 = -1;
            System.out.println("GridSim.gridletStatus(): Error occurs.");
            System.out.println(exception.getMessage());
        }
        return n4;
    }

    protected boolean gridletResume(Gridlet gridlet, int n, double d) {
        if (gridlet == null || d < 0.0) {
            return false;
        }
        return this.gridletResume(gridlet.getGridletID(), gridlet.getUserID(), n, d, true);
    }

    protected boolean gridletResume(int n, int n2, int n3, double d, boolean bl) {
        boolean bl2 = false;
        try {
            String string = "GridSim.gridletResume(): ";
            bl2 = this.sendGridlet(string, n, n2, n3, d, 27, bl);
            if (bl2 && bl) {
                Sim_type_p sim_type_p = new Sim_type_p(28 + n);
                super.sim_get_next(sim_type_p, this.ev_);
                bl2 = (Boolean)this.ev_.get_data();
            }
        }
        catch (Sim_exception sim_exception) {
            bl2 = false;
            System.out.println("GridSim.gridletResume(): Error occurs.");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.println("GridSim.gridletResume(): Error occurs.");
            System.out.println(exception.getMessage());
        }
        return bl2;
    }

    protected boolean gridletMove(Gridlet gridlet, int n, int n2, double d) {
        if (gridlet == null || d < 0.0) {
            return false;
        }
        boolean bl = this.gridletMove(gridlet.getGridletID(), gridlet.getUserID(), n, n2, d, true);
        return bl;
    }

    protected boolean gridletMove(int n, int n2, int n3, int n4, double d, boolean bl) {
        String string = "GridSim.gridletMove(): ";
        if (n3 == n4) {
            System.out.println(string + "Error - Can't move a Gridlet to " + "the same GridResource.");
            return false;
        }
        boolean bl2 = this.validateValue(string, n, n2, n3);
        if (!bl2 || d < 0.0) {
            return false;
        }
        if (!gis_.isResourceExist(n4)) {
            System.out.println(string + "Error - GridResource ID #" + n4 + " doesn't exist. Hence, can't move Gridlet #" + n);
            return false;
        }
        try {
            int n5 = 14;
            this.dataArray_[0] = n;
            this.dataArray_[1] = n2;
            this.dataArray_[2] = n4;
            if (bl) {
                this.send(this.output, d, 30, (Object)new IO_data(this.dataArray_, n5, n3));
                Sim_type_p sim_type_p = new Sim_type_p(22 + n);
                super.sim_get_next(sim_type_p, this.ev_);
                bl2 = (Boolean)this.ev_.get_data();
            } else {
                bl2 = false;
                this.send(this.output, d, 29, (Object)new IO_data(this.dataArray_, n5, n3));
            }
        }
        catch (Sim_exception sim_exception) {
            bl2 = false;
            System.out.println("GridSim.gridletMove(): Error occurs.");
            System.out.println(sim_exception.getMessage());
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.println("GridSim.gridletMove(): Error occurs.");
            System.out.println(exception.getMessage());
        }
        return bl2;
    }

    public String GetEntityName() {
        return this.getEntityName();
    }

    public String getEntityName() {
        try {
            return super.get_name();
        }
        catch (Sim_exception sim_exception) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String GetEntityName(int n) {
        return GridSim.getEntityName(n);
    }

    public static String getEntityName(int n) {
        try {
            return Sim_system.get_entity(n).get_name();
        }
        catch (Sim_exception sim_exception) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int GetEntityId(String string) {
        return GridSim.getEntityId(string);
    }

    public static int getEntityId(String string) {
        if (string == null) {
            return -1;
        }
        try {
            return Sim_system.get_entity_id(string);
        }
        catch (Sim_exception sim_exception) {
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int GridStatisticsEntityId() {
        return GridSim.getGridStatisticsEntityId();
    }

    public static int getGridStatisticsEntityId() {
        return statsID_;
    }

    public static int GridInformationServiceEntityId() {
        return GridSim.getGridInfoServiceEntityId();
    }

    public static int getGridInfoServiceEntityId() {
        return gisID_;
    }

    public static int GridSimShutdownEntityId() {
        return GridSim.getGridSimShutdownEntityId();
    }

    public static int getGridSimShutdownEntityId() {
        return shutdownID_;
    }

    protected void ShutdownUserEntity() {
        this.shutdownUserEntity();
    }

    protected void shutdownUserEntity() {
        if (shutdownID_ != -1) {
            this.send(shutdownID_, 0.0, -1);
        }
    }

    protected void ShutdownGridStatisticsEntity() {
        this.shutdownGridStatisticsEntity();
    }

    protected void shutdownGridStatisticsEntity() {
        if (statsID_ != -1) {
            this.send(statsID_, 0.0, -1);
        }
    }

    public static LinkedList GetGridResourceList() {
        return GridSim.getGridResourceList();
    }

    public static LinkedList getGridResourceList() {
        if (gis_ == null) {
            return null;
        }
        return gis_.getList();
    }

    public static boolean resourceSupportAR(int n) {
        if (gis_ == null) {
            return false;
        }
        return gis_.resourceSupportAR(n);
    }

    public static boolean resourceSupportAR(Integer n) {
        if (gis_ == null || n == null) {
            return false;
        }
        return gis_.resourceSupportAR(n);
    }

    public static LinkedList getAdvancedReservationList() {
        if (gis_ == null) {
            return null;
        }
        return gis_.getAdvReservList();
    }

    public static boolean isResourceExist(int n) {
        if (gis_ == null) {
            return false;
        }
        return gis_.isResourceExist(n);
    }

    public static boolean isResourceExist(Integer n) {
        if (gis_ == null || n == null) {
            return false;
        }
        return GridSim.isResourceExist(n);
    }

    public int getNumPE(int n) {
        if (!GridSim.isResourceExist(n)) {
            return -1;
        }
        super.send(this.output, 0.0, 8, (Object)new IO_data(new Integer(super.get_id()), 12L, n));
        Sim_type_p sim_type_p = new Sim_type_p(8);
        super.sim_get_next(sim_type_p, this.ev_);
        int n2 = -1;
        try {
            Integer n3 = (Integer)this.ev_.get_data();
            n2 = n3;
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ".getNumPE(): Exception error.");
        }
        return n2;
    }

    public int getNumPE(Integer n) {
        if (n == null) {
            return -1;
        }
        return this.getNumPE((int)n);
    }

    public ResourceCharacteristics GetResourceCharacteristics(int n) {
        return this.getResourceCharacteristics(n);
    }

    public ResourceCharacteristics getResourceCharacteristics(int n) {
        if (!gis_.isResourceExist(n)) {
            return null;
        }
        this.send(this.output, 0.0, 6, (Object)new IO_data(new Integer(super.get_id()), 12L, n));
        try {
            return (ResourceCharacteristics)this.receiveEventObject(this.input);
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ".getResourceCharacteristics(): Exception error.");
            return null;
        }
    }

    public Accumulator GetResourceDynamicInformation(int n) {
        return this.getResourceDynamicInfo(n);
    }

    public Accumulator getResourceDynamicInfo(int n) {
        if (!gis_.isResourceExist(n)) {
            return null;
        }
        this.send(this.output, 0.0, 7, (Object)new IO_data(new Integer(super.get_id()), 12L, n));
        try {
            return (Accumulator)this.receiveEventObject(this.input);
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ".getResourceDynamicInfo(): Exception error.");
            return null;
        }
    }

    public void RecordStatistics(String string, double d) {
        this.recordStatistics(string, d);
    }

    public void recordStatistics(String string, double d) {
        if (statsID_ == -1 || string == null) {
            return;
        }
        super.send(statsID_, 0.0, 9, (Object)new Stat(GridSim.clock(), string, super.get_name(), d));
    }

    public void RecordStatistics(String string, int n) {
        this.recordStatistics(string, n);
    }

    public void recordStatistics(String string, int n) {
        if (statsID_ == -1 || string == null) {
            return;
        }
        super.send(statsID_, 0.0, 9, (Object)new Stat(GridSim.clock(), string, super.get_name(), n));
    }

    public void RecordStatistics(String string, String string2) {
        this.recordStatistics(string, string2);
    }

    public void recordStatistics(String string, String string2) {
        if (statsID_ == -1 || string == null || string2 == null) {
            return;
        }
        super.send(statsID_, 0.0, 9, (Object)new Stat(GridSim.clock(), string, super.get_name(), string2));
    }

    public void RecordStatistics(String string, boolean bl) {
        this.recordStatistics(string, bl);
    }

    public void recordStatistics(String string, boolean bl) {
        if (statsID_ == -1 || string == null) {
            return;
        }
        super.send(statsID_, 0.0, 9, (Object)new Stat(GridSim.clock(), string, super.get_name(), bl));
    }
}

