/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import eduni.simjava.Sim_system;
import gridsim.Accumulator;
import gridsim.AllocPolicy;
import gridsim.GridSim;
import gridsim.GridSimCore;
import gridsim.Gridlet;
import gridsim.IO_data;
import gridsim.ResourceCalendar;
import gridsim.ResourceCharacteristics;
import gridsim.SpaceShared;
import gridsim.TimeShared;
import java.util.LinkedList;

public class GridResource
extends GridSimCore {
    protected ResourceCharacteristics resource_;
    protected ResourceCalendar resCalendar_;
    protected AllocPolicy policy_;
    protected int policyType_;
    protected final int SIZE = 12;

    public GridResource(String string, double d, long l, ResourceCharacteristics resourceCharacteristics, double d2, double d3, double d4, LinkedList linkedList, LinkedList linkedList2) throws Exception {
        super(string, d);
        this.resource_ = resourceCharacteristics;
        this.resCalendar_ = new ResourceCalendar(this.resource_.getResourceTimeZone(), d2, d3, d4, linkedList, linkedList2, l);
        this.policy_ = null;
        this.init();
    }

    public GridResource(String string, double d, ResourceCharacteristics resourceCharacteristics, ResourceCalendar resourceCalendar) throws Exception {
        super(string, d);
        this.resource_ = resourceCharacteristics;
        this.resCalendar_ = resourceCalendar;
        this.policy_ = null;
        this.init();
    }

    public GridResource(String string, double d, ResourceCharacteristics resourceCharacteristics, ResourceCalendar resourceCalendar, AllocPolicy allocPolicy) throws Exception {
        super(string, d);
        this.resource_ = resourceCharacteristics;
        this.resCalendar_ = resourceCalendar;
        this.policy_ = allocPolicy;
        this.init();
    }

    public void body() {
        int n = 0;
        n = this.policyType_ == 4 ? 3 : 2;
        super.send(this.output, 0.0, n, (Object)new IO_data(new Integer(super.get_id()), 12L, GridSim.getGridInfoServiceEntityId()));
        this.registerOtherEntity();
        Sim_event sim_event = new Sim_event();
        while (Sim_system.running()) {
            super.sim_get_next(sim_event);
            if (sim_event.get_tag() == -1) {
                this.policy_.setEndSimulation();
                break;
            }
            this.processEvent(sim_event);
        }
        super.terminateIOEntities();
    }

    public void SpaceShare_AllocatePEtoGridlet(Gridlet gridlet) {
        this.spaceShared_AllocatePEtoGridlet(gridlet);
    }

    public void spaceShared_AllocatePEtoGridlet(Gridlet gridlet) {
        System.out.println("GridResource.spaceShared_AllocatePEtoGridlet() is OBSOLETE since GridSim 2.2. Don't use this method.");
    }

    protected void processOtherEvent(Sim_event sim_event) {
        if (sim_event == null) {
            System.out.println(super.get_name() + ".processOtherEvent(): " + "Error - an event is null.");
            return;
        }
        System.out.println(super.get_name() + ".processOtherEvent(): Unable to " + "handle request from GridSimTags with tag number " + sim_event.get_tag());
    }

    protected void registerOtherEntity() {
    }

    private void init() throws Exception {
        if (this.resource_.getNumPE() == 0) {
            throw new Exception(super.get_name() + " : Error - this entity " + "has no PEs. Therefore, can't process any Gridlets.");
        }
        this.resource_.setResourceID(super.get_id());
        this.policyType_ = this.resource_.getResourceAllocationPolicy();
        if (this.policy_ == null) {
            switch (this.policyType_) {
                case 0: {
                    this.policy_ = new TimeShared(super.get_name(), "TimeShared");
                    break;
                }
                case 1: {
                    this.policy_ = new SpaceShared(super.get_name(), "SpaceShared");
                    break;
                }
                default: {
                    throw new Exception(super.get_name() + " : Error - supports" + " only TimeShared or SpaceShared policy.");
                }
            }
        }
        this.policy_.init(this.resource_, this.resCalendar_, this.output);
    }

    private void processEvent(Sim_event sim_event) {
        int n = -1;
        switch (sim_event.get_tag()) {
            case 6: {
                n = (Integer)sim_event.get_data();
                super.send(this.output, 0.0, sim_event.get_tag(), (Object)new IO_data(this.resource_, this.resource_.getByteSize(), n));
                break;
            }
            case 7: {
                n = (Integer)sim_event.get_data();
                super.send(this.output, 0.0, sim_event.get_tag(), (Object)new IO_data(this.policy_.getTotalLoad(), Accumulator.getByteSize(), n));
                break;
            }
            case 8: {
                n = (Integer)sim_event.get_data();
                int n2 = this.resource_.getNumPE();
                super.send(this.output, 0.0, sim_event.get_tag(), (Object)new IO_data(new Integer(n2), 12L, n));
                break;
            }
            case 21: {
                this.processGridletSubmit(sim_event, false);
                break;
            }
            case 22: {
                this.processGridletSubmit(sim_event, true);
                break;
            }
            case 23: {
                this.processGridlet(sim_event, 23);
                break;
            }
            case 25: {
                this.processGridlet(sim_event, 25);
                break;
            }
            case 26: {
                this.processGridlet(sim_event, 26);
                break;
            }
            case 27: {
                this.processGridlet(sim_event, 27);
                break;
            }
            case 28: {
                this.processGridlet(sim_event, 28);
                break;
            }
            case 29: {
                this.processGridletMove(sim_event, 29);
                break;
            }
            case 30: {
                this.processGridletMove(sim_event, 30);
                break;
            }
            case 24: {
                this.processGridletStatus(sim_event);
                break;
            }
            default: {
                this.processOtherEvent(sim_event);
            }
        }
    }

    private void processGridletStatus(Sim_event sim_event) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        try {
            int[] nArray = (int[])sim_event.get_data();
            n = nArray[0];
            n2 = nArray[1];
            n3 = this.policy_.gridletStatus(n, n2);
        }
        catch (ClassCastException classCastException) {
            try {
                Gridlet gridlet = (Gridlet)sim_event.get_data();
                n = gridlet.getGridletID();
                n2 = gridlet.getUserID();
                n3 = this.policy_.gridletStatus(n, n2);
            }
            catch (Exception exception) {
                System.out.println(super.get_name() + ": Error in processing GridSimTags.GRIDLET_STATUS");
                System.out.println(exception.getMessage());
                return;
            }
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ": Error in processing GridSimTags.GRIDLET_STATUS");
            System.out.println(exception.getMessage());
            return;
        }
        int n4 = 24 + n;
        super.send(this.output, 0.0, n4, (Object)new IO_data(new Integer(n3), 12L, n2));
    }

    private void processGridlet(Sim_event sim_event, int n) {
        int n2 = 0;
        int n3 = 0;
        try {
            int[] nArray = (int[])sim_event.get_data();
            n2 = nArray[0];
            n3 = nArray[1];
        }
        catch (ClassCastException classCastException) {
            try {
                Gridlet gridlet = (Gridlet)sim_event.get_data();
                n2 = gridlet.getGridletID();
                n3 = gridlet.getUserID();
            }
            catch (Exception exception) {
                System.out.println(super.get_name() + ": Error in processing Gridlet");
                System.out.println(exception.getMessage());
                return;
            }
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ": Error in processing a Gridlet.");
            System.out.println(exception.getMessage());
            return;
        }
        switch (n) {
            case 23: {
                this.policy_.gridletCancel(n2, n3);
                break;
            }
            case 25: {
                this.policy_.gridletPause(n2, n3, false);
                break;
            }
            case 26: {
                this.policy_.gridletPause(n2, n3, true);
                break;
            }
            case 27: {
                this.policy_.gridletResume(n2, n3, false);
                break;
            }
            case 28: {
                this.policy_.gridletResume(n2, n3, true);
                break;
            }
        }
    }

    private void processGridletMove(Sim_event sim_event, int n) {
        boolean bl = false;
        if (n == 30) {
            bl = true;
        }
        try {
            int[] nArray = (int[])sim_event.get_data();
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            this.policy_.gridletMove(n2, n3, n4, bl);
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ": Error in moving a Gridlet.");
            System.out.println(exception.getMessage());
        }
    }

    private void processGridletSubmit(Sim_event sim_event, boolean bl) {
        try {
            Gridlet gridlet = (Gridlet)sim_event.get_data();
            if (gridlet.isFinished()) {
                System.out.println(super.get_name() + ": Error - Gridlet #" + gridlet.getGridletID() + " for User #" + gridlet.getUserID() + " is already finished.");
                if (bl) {
                    int n = 22 + gridlet.getGridletID();
                    super.send(this.output, 0.0, n, (Object)new IO_data(new Boolean(false), 12L, gridlet.getUserID()));
                }
                super.send(this.output, 0.0, 20, (Object)new IO_data(gridlet, gridlet.getGridletOutputSize(), gridlet.getUserID()));
                return;
            }
            gridlet.setResourceParameter(super.get_id(), this.resource_.getCostPerSec());
            this.policy_.gridletSubmit(gridlet, bl);
        }
        catch (ClassCastException classCastException) {
            System.out.println(super.get_name() + ".processGridletSubmit(): " + "ClassCastException error.");
            System.out.println(classCastException.getMessage());
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ".processGridletSubmit(): " + "Exception error.");
            System.out.println(exception.getMessage());
        }
    }
}

