/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_entity;
import eduni.simjava.Sim_port;
import gridsim.Accumulator;
import gridsim.AdvanceReservation;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.IO_data;
import gridsim.ResGridlet;
import gridsim.ResourceCalendar;
import gridsim.ResourceCharacteristics;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;

public abstract class AllocPolicy
extends Sim_entity {
    protected ResourceCharacteristics resource_;
    protected ResourceCalendar resCalendar_;
    protected Sim_port outputPort_;
    protected int totalPE_;
    protected final int resId_;
    protected final int myId_;
    protected final String resName_;
    protected long initTime_;
    private Accumulator accTotalLoad_;
    private boolean endSimulation_;

    public abstract void gridletSubmit(Gridlet var1, boolean var2);

    public abstract void gridletCancel(int var1, int var2);

    public abstract void gridletPause(int var1, int var2, boolean var3);

    public abstract void gridletResume(int var1, int var2, boolean var3);

    public abstract int gridletStatus(int var1, int var2);

    public abstract void gridletMove(int var1, int var2, int var3, boolean var4);

    public Accumulator getTotalLoad() {
        return this.accTotalLoad_;
    }

    public void setEndSimulation() {
        this.endSimulation_ = true;
    }

    protected boolean isEndSimulation() {
        return this.endSimulation_;
    }

    public void init(ResourceCharacteristics resourceCharacteristics, ResourceCalendar resourceCalendar, Sim_port sim_port) {
        this.resource_ = resourceCharacteristics;
        this.resCalendar_ = resourceCalendar;
        this.outputPort_ = sim_port;
        this.totalPE_ = this.resource_.getNumPE();
        double d = this.calculateTotalLoad(0);
        this.accTotalLoad_.add(d);
        Calendar calendar = GridSim.getSimulationCalendar();
        long l = calendar.getTimeInMillis();
        int n = calendar.getTimeZone().getRawOffset() / 3600000;
        this.initTime_ = AdvanceReservation.convertTimeZone(l, n, this.resource_.getResourceTimeZone());
    }

    protected AllocPolicy(String string, String string2) throws Exception {
        super(string + "_" + string2);
        this.myId_ = GridSim.getEntityId(string + "_" + string2);
        this.resId_ = GridSim.getEntityId(string);
        this.resName_ = string;
        this.initTime_ = 0L;
        this.outputPort_ = null;
        this.resource_ = null;
        this.resCalendar_ = null;
        this.endSimulation_ = false;
        this.totalPE_ = 0;
        this.accTotalLoad_ = new Accumulator();
    }

    protected void addTotalLoad(double d) {
        this.accTotalLoad_.add(d);
    }

    protected int findGridlet(Collection collection, int n, int n2) {
        ResGridlet resGridlet = null;
        int n3 = -1;
        try {
            int n4 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                resGridlet = (ResGridlet)iterator.next();
                if (resGridlet.getGridletID() == n && resGridlet.getUserID() == n2) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ".findGridlet(): Exception error occurs.");
            System.out.println(exception.getMessage());
        }
        return n3;
    }

    protected double calculateTotalLoad(int n) {
        double d = ((double)n + 1.0) / (double)this.totalPE_;
        int n2 = (int)Math.ceil(d);
        double d2 = this.resCalendar_.getCurrentLoad();
        double d3 = 1.0 - (1.0 - d2) / (double)n2;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    protected boolean sendAck(int n, boolean bl, int n2, int n3) {
        boolean bl2 = false;
        switch (n) {
            case 22: 
            case 26: 
            case 28: {
                int n4 = n + n2;
                super.sim_schedule(this.outputPort_, 0.0, n4, (Object)new IO_data(new Boolean(bl), 8L, n3));
                bl2 = true;
                break;
            }
            default: {
                System.out.println(super.get_name() + ".sendAck(): Invalid tag ID.");
            }
        }
        return bl2;
    }

    protected boolean sendCancelGridlet(int n, Gridlet gridlet, int n2, int n3) {
        if (n != 23) {
            return false;
        }
        long l = 0L;
        if (gridlet != null) {
            l = gridlet.getGridletOutputSize();
        }
        int n4 = 23 + n2;
        super.sim_schedule(this.outputPort_, 0.0, n4, (Object)new IO_data(gridlet, l, n3));
        return true;
    }

    protected boolean gridletMigrate(Gridlet gridlet, int n, boolean bl) {
        if (gridlet == null) {
            return false;
        }
        IO_data iO_data = new IO_data(gridlet, gridlet.getGridletOutputSize(), n);
        int n2 = 0;
        n2 = bl ? 22 : 21;
        super.sim_schedule(this.outputPort_, 0.0, n2, (Object)iO_data);
        return true;
    }

    protected boolean sendFinishGridlet(Gridlet gridlet) {
        super.sim_schedule(this.outputPort_, 0.0, 20, (Object)new IO_data(gridlet, gridlet.getGridletOutputSize(), gridlet.getUserID()));
        return true;
    }

    protected boolean sendInternalEvent(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        super.sim_schedule(this.myId_, d, 0);
        return true;
    }

    protected boolean sendInternalEvent(double d, int n) {
        if (d < 0.0) {
            d = 0.0;
        }
        super.sim_schedule(this.myId_, d, n);
        return true;
    }
}

