/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import eduni.simjava.Sim_type_p;
import gridsim.ARObject;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.GridletList;
import gridsim.IO_data;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

public class AdvanceReservation
extends GridSim {
    private final int MAX_ID = 4;
    private final int SIZE_ARRAY = 16;
    private int[] idArray_;
    private long[] timeArray_;
    private Object[] commitObj_;
    private Sim_event ev_;
    private ARObject createObj_;
    private long initTime_;
    private double timeZone_;
    private int transactionID_;
    private ArrayList booking_;
    private final int MILLI_SEC = 1000;
    public static final int HOUR = 3600000;

    public static long convertTimeZone(long l, double d, double d2) {
        int n = -12;
        int n2 = 13;
        if (d < (double)n || d > (double)n2) {
            return -1L;
        }
        if (d2 < (double)n || d2 > (double)n2) {
            return -1L;
        }
        double d3 = d2 - d;
        return l + (long)((int)(d3 * 3600000.0));
    }

    public static boolean validateTimeZone(double d) {
        int n = -12;
        int n2 = 13;
        if (d < (double)n || d > (double)n2) {
            return false;
        }
        double d2 = d - (double)((int)d);
        return !(d2 >= 0.6);
    }

    public static String getCreateResult(int n) {
        String string = null;
        switch (n) {
            case -7: {
                string = "AR_CREATE_ERROR";
                break;
            }
            case -1: {
                string = "AR_CREATE_ERROR_INVALID_START_TIME";
                break;
            }
            case -2: {
                string = "AR_CREATE_ERROR_INVALID_END_TIME";
                break;
            }
            case -3: {
                string = "AR_CREATE_ERROR_INVALID_DURATION_TIME";
                break;
            }
            case -4: {
                string = "AR_CREATE_ERROR_INVALID_NUM_PE";
                break;
            }
            case -5: {
                string = "AR_CREATE_ERROR_INVALID_RESOURCE_ID";
                break;
            }
            case -6: {
                string = "AR_CREATE_ERROR_INVALID_RESOURCE_NAME";
                break;
            }
            case -8: {
                string = "AR_CREATE_FAIL_RESOURCE_CANT_SUPPORT";
                break;
            }
            case -9: {
                string = "AR_CREATE_FAIL_RESOURCE_NOT_ENOUGH_PE";
                break;
            }
            case -11: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_1_SEC";
                break;
            }
            case -12: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_5_SECS";
                break;
            }
            case -13: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_10_SECS";
                break;
            }
            case -14: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_15_SECS";
                break;
            }
            case -15: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_30_SECS";
                break;
            }
            case -16: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_45_SECS";
                break;
            }
            case -17: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_1_MIN";
                break;
            }
            case -18: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_5_MINS";
                break;
            }
            case -19: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_10_MINS";
                break;
            }
            case -20: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_15_MINS";
                break;
            }
            case -21: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_30_MINS";
                break;
            }
            case -22: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_45_MINS";
                break;
            }
            case -23: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_1_HOUR";
                break;
            }
            case -24: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_5_HOURS";
                break;
            }
            case -25: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_10_HOURS";
                break;
            }
            case -26: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_15_HOURS";
                break;
            }
            case -27: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_30_HOURS";
                break;
            }
            case -28: {
                string = "AR_CREATE_FAIL_RESOURCE_FULL_IN_45_HOURS";
                break;
            }
        }
        return string;
    }

    public static String getCancelResult(int n) {
        String string = null;
        switch (n) {
            case 55: {
                string = "AR_CANCEL_ERROR";
                break;
            }
            case 50: {
                string = "AR_CANCEL_FAIL";
                break;
            }
            case 51: {
                string = "AR_CANCEL_FAIL_INVALID_BOOKING_ID";
                break;
            }
            case 52: {
                string = "AR_CANCEL_FAIL_GRIDLET_FINISHED";
                break;
            }
            case 53: {
                string = "AR_CANCEL_SUCCESS";
                break;
            }
            case 54: {
                string = "AR_CANCEL_ERROR_RESOURCE_CANT_SUPPORT";
                break;
            }
        }
        return string;
    }

    public static String getQueryResult(int n) {
        String string = null;
        switch (n) {
            case 40: {
                string = "AR_STATUS_NOT_STARTED";
                break;
            }
            case 43: {
                string = "AR_STATUS_ACTIVE";
                break;
            }
            case 44: {
                string = "AR_STATUS_COMPLETED";
                break;
            }
            case 45: {
                string = "AR_STATUS_CANCELED";
                break;
            }
            case 47: {
                string = "AR_STATUS_ERROR_INVALID_BOOKING_ID";
                break;
            }
            case 46: {
                string = "AR_STATUS_EXPIRED";
                break;
            }
            case 41: {
                string = "AR_STATUS_NOT_COMMITTED";
                break;
            }
            case 48: {
                string = "AR_STATUS_RESERVATION_DOESNT_EXIST";
                break;
            }
            case 42: {
                string = "AR_STATUS_TERMINATED";
                break;
            }
            case 49: {
                string = "AR_STATUS_ERROR";
                break;
            }
        }
        return string;
    }

    public static String getCommitResult(int n) {
        String string = null;
        switch (n) {
            case 60: {
                string = "AR_COMMIT_SUCCESS";
                break;
            }
            case 61: {
                string = "AR_COMMIT_FAIL";
                break;
            }
            case 62: {
                string = "AR_COMMIT_FAIL_EXPIRED";
                break;
            }
            case 63: {
                string = "AR_COMMIT_FAIL_INVALID_BOOKING_ID";
                break;
            }
            case 64: {
                string = "AR_COMMIT_ERROR_RESOURCE_CANT_SUPPORT";
                break;
            }
            case 65: {
                string = "AR_COMMIT_ERROR";
                break;
            }
        }
        return string;
    }

    public static String getModifyResult(int n) {
        String string = null;
        switch (n) {
            case 75: {
                string = "AR_MODIFY_ERROR";
                break;
            }
            case 76: {
                string = "AR_MODIFY_SUCCESS";
                break;
            }
            case 73: {
                string = "AR_MODIFY_FAIL_INVALID_END_TIME";
                break;
            }
            case 72: {
                string = "AR_MODIFY_FAIL_INVALID_START_TIME";
                break;
            }
            case 74: {
                string = "AR_MODIFY_FAIL_INVALID_NUM_PE";
                break;
            }
            case 70: {
                string = "AR_MODIFY_FAIL_INVALID_BOOKING_ID";
                break;
            }
            case 71: {
                string = "AR_MODIFY_FAIL_RESERVATION_ACTIVE";
                break;
            }
            case 77: {
                string = "AR_MODIFY_FAIL_RESOURCE_CANT_SUPPORT";
                break;
            }
        }
        return string;
    }

    public AdvanceReservation(String string, double d) throws Exception {
        super(string, d);
        Calendar calendar = GridSim.getSimulationCalendar();
        this.timeZone_ = calendar == null ? 0.0 : (double)(calendar.getTimeZone().getRawOffset() / 3600000);
        this.init();
    }

    public AdvanceReservation(String string, double d, double d2) throws Exception {
        super(string, d);
        if (!AdvanceReservation.validateTimeZone(d2)) {
            throw new Exception(string + ": Error - invalid time zone");
        }
        this.timeZone_ = d2;
        this.init();
    }

    public long getExpiryTime(String string) {
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            return -1L;
        }
        ARObject aRObject = this.searchBooking(nArray[0], nArray[1]);
        if (aRObject == null) {
            return -1L;
        }
        return aRObject.getExpiryTime();
    }

    public String createReservation(Calendar calendar, Calendar calendar2, int n, int n2) {
        long l = 0L;
        long l2 = 0L;
        if (calendar != null) {
            l = calendar.getTimeInMillis();
        }
        if (calendar2 != null) {
            l2 = calendar2.getTimeInMillis();
        }
        return this.createReservation(l, l2, n, n2);
    }

    public String createReservation(Calendar calendar, Calendar calendar2, int n, String string) {
        long l = 0L;
        long l2 = 0L;
        if (calendar != null) {
            l = calendar.getTimeInMillis();
        }
        if (calendar2 != null) {
            l2 = calendar2.getTimeInMillis();
        }
        return this.createReservation(l, l2, n, string);
    }

    public String createReservation(Calendar calendar, int n, int n2, int n3) {
        long l = 0L;
        if (calendar != null) {
            l = calendar.getTimeInMillis();
        }
        return this.createReservation(l, n, n2, n3);
    }

    public String createReservation(Calendar calendar, int n, int n2, String string) {
        long l = 0L;
        if (calendar != null) {
            l = calendar.getTimeInMillis();
        }
        return this.createReservation(l, n, n2, string);
    }

    public String createReservation(long l, long l2, int n, int n2) {
        int n3 = 0;
        boolean bl = true;
        if (l == 0L || l2 == 0L) {
            bl = false;
            n3 = 34;
        } else {
            n3 = 33;
        }
        String string = this.validateValue(l, l2, n, n2, bl);
        if (string != null) {
            return string;
        }
        this.createObj_.setStartTime(l);
        int n4 = (int)(l2 - l) / 1000;
        this.createObj_.setDurationTime(n4);
        this.createObj_.setNumPE(n);
        this.createObj_.setResourceID(n2);
        return this.sendReservation(n2, this.createObj_, n3);
    }

    public String createReservation(long l, long l2, int n, String string) {
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        if (string == null) {
            n2 = -6;
            bl = true;
        } else {
            n3 = GridSim.getEntityId(string);
            if (n3 == -1) {
                n2 = -6;
                bl = true;
            }
        }
        if (bl) {
            return AdvanceReservation.getCreateResult(n2);
        }
        return this.createReservation(l, l2, n, n3);
    }

    public String createReservation(long l, int n, int n2, int n3) {
        int n4 = 0;
        boolean bl = true;
        if (l == 0L || n == 0) {
            bl = false;
            n4 = 34;
        } else {
            n4 = 33;
        }
        String string = this.validateValue(l, n, n2, n3, bl);
        if (string != null) {
            return string;
        }
        this.createObj_.setStartTime(l);
        this.createObj_.setDurationTime(n);
        this.createObj_.setNumPE(n2);
        this.createObj_.setResourceID(n3);
        return this.sendReservation(n3, this.createObj_, n4);
    }

    public String createReservation(long l, int n, int n2, String string) {
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        if (string == null) {
            n3 = -6;
            bl = true;
        } else {
            n4 = GridSim.getEntityId(string);
            if (n4 == -1) {
                n3 = -6;
                bl = true;
            }
        }
        if (bl) {
            return AdvanceReservation.getCreateResult(n3);
        }
        return this.createReservation(l, n, n2, n4);
    }

    public int modifyReservation(String string, ARObject aRObject) {
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            return 70;
        }
        ARObject aRObject2 = this.searchBooking(nArray[0], nArray[1]);
        if (aRObject2 == null) {
            return 70;
        }
        int n = this.incrementID();
        aRObject.setTransactionID(n);
        super.send(this.output, 0.0, 39, (Object)new IO_data(aRObject, aRObject.getByteSize(), nArray[0]));
        Sim_type_p sim_type_p = new Sim_type_p(39 + n);
        super.sim_get_next(sim_type_p, this.ev_);
        int n2 = 75;
        try {
            n2 = (Integer)this.ev_.get_data();
            if (n2 == 76) {
                aRObject.setStatus(40);
                aRObject2.copy(aRObject);
            }
        }
        catch (Exception exception) {
            n2 = 75;
        }
        return n2;
    }

    public int cancelReservation(String string) {
        return this.cancelReservation(string, -1);
    }

    public int cancelReservation(String string, ArrayList arrayList) {
        if (string == null) {
            return 51;
        }
        if (arrayList == null) {
            return 50;
        }
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            return 51;
        }
        this.commitObj_[0] = new Integer(nArray[1]);
        this.commitObj_[1] = arrayList;
        int n = this.incrementID();
        this.commitObj_[2] = new Integer(n);
        this.commitObj_[3] = new Integer(super.get_id());
        int n2 = arrayList.size() * 12;
        super.send(this.output, 0.0, 35, (Object)new IO_data(this.commitObj_, n2, nArray[0]));
        Sim_type_p sim_type_p = new Sim_type_p(35 + n);
        super.sim_get_next(sim_type_p, this.ev_);
        int n3 = 0;
        try {
            n3 = (Integer)this.ev_.get_data();
        }
        catch (Exception exception) {
            n3 = 55;
        }
        return n3;
    }

    public int cancelReservation(String string, Gridlet gridlet) {
        if (gridlet == null) {
            return 55;
        }
        return this.cancelReservation(string, gridlet.getGridletID());
    }

    public int cancelReservation(String string, int n) {
        if (string == null) {
            return 51;
        }
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            return 51;
        }
        int n2 = nArray[0];
        nArray[2] = this.incrementID();
        nArray[0] = n;
        nArray[3] = super.get_id();
        super.send(this.output, 0.0, 35, (Object)new IO_data(nArray, 16L, n2));
        Sim_type_p sim_type_p = new Sim_type_p(35 + nArray[2]);
        super.sim_get_next(sim_type_p, this.ev_);
        int n3 = 0;
        try {
            n3 = (Integer)this.ev_.get_data();
        }
        catch (Exception exception) {
            n3 = 55;
        }
        return n3;
    }

    public ArrayList queryFreeTime(Integer n, long l, long l2) {
        if (n == null) {
            return null;
        }
        return this.queryFreeTime((int)n, l, l2);
    }

    public ArrayList queryFreeTime(int n, long l, long l2) {
        int n2 = 37;
        return this.queryTime(n, l, l2, n2);
    }

    public ArrayList queryBusyTime(int n, long l, long l2) {
        int n2 = 36;
        return this.queryTime(n, l, l2, n2);
    }

    private ArrayList queryTime(int n, long l, long l2, int n2) {
        int n3 = 1;
        String string = this.validateValue(l, l2, n3, n, true);
        if (string != null) {
            return null;
        }
        this.timeArray_[0] = l;
        this.timeArray_[1] = l2;
        this.timeArray_[2] = this.incrementID();
        this.timeArray_[3] = super.get_id();
        int n4 = this.timeArray_.length * 8;
        super.send(this.output, 0.0, n2, (Object)new IO_data(this.timeArray_, n4, n));
        Sim_type_p sim_type_p = new Sim_type_p(n2 + (int)this.timeArray_[2]);
        super.sim_get_next(sim_type_p, this.ev_);
        ArrayList arrayList = null;
        try {
            arrayList = (ArrayList)this.ev_.get_data();
        }
        catch (Exception exception) {
            arrayList = null;
        }
        return arrayList;
    }

    public ArrayList queryBusyTime(Integer n, long l, long l2) {
        if (n == null) {
            return null;
        }
        return this.queryBusyTime((int)n, l, l2);
    }

    public ARObject getReservation(String string) {
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            return null;
        }
        ARObject aRObject = this.searchBooking(nArray[0], nArray[1]);
        return aRObject;
    }

    public int queryReservation(String string) {
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            return 47;
        }
        ARObject aRObject = this.searchBooking(nArray[0], nArray[1]);
        if (aRObject == null) {
            return 47;
        }
        if (!aRObject.hasCommitted()) {
            return 41;
        }
        int n = aRObject.getStatus();
        nArray[2] = this.incrementID();
        nArray[3] = super.get_id();
        super.send(this.output, 0.0, 38, (Object)new IO_data(nArray, 16L, nArray[0]));
        Sim_type_p sim_type_p = new Sim_type_p(38 + nArray[2]);
        super.sim_get_next(sim_type_p, this.ev_);
        try {
            n = (Integer)this.ev_.get_data();
        }
        catch (Exception exception) {
            n = 49;
        }
        aRObject.setStatus(n);
        return n;
    }

    public int commitReservation(String string) {
        int n = 0;
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            n = 63;
        } else {
            nArray[2] = this.incrementID();
            nArray[3] = super.get_id();
            super.send(this.output, 0.0, 31, (Object)new IO_data(nArray, 16L, nArray[0]));
            Sim_type_p sim_type_p = new Sim_type_p(31 + nArray[2]);
            super.sim_get_next(sim_type_p, this.ev_);
            try {
                n = (Integer)this.ev_.get_data();
                n = this.updateCommitList(nArray[0], nArray[1], n);
            }
            catch (Exception exception) {
                n = 65;
            }
        }
        return n;
    }

    public int commitReservation(String string, GridletList gridletList) {
        int n;
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            return 63;
        }
        int n2 = 0;
        n2 = gridletList == null ? 61 : ((n = this.calculateTotalGridletSize(gridletList)) == 0 ? 61 : this.commit(nArray[0], nArray[1], gridletList, n));
        return n2;
    }

    public int commitReservation(String string, Gridlet gridlet) {
        int[] nArray = this.parseBookingID(string);
        if (nArray == null) {
            return 63;
        }
        int n = 0;
        if (gridlet == null) {
            n = 61;
        } else {
            gridlet.setUserID(super.get_id());
            n = this.commit(nArray[0], nArray[1], gridlet, gridlet.getGridletFileSize());
        }
        return n;
    }

    private void init() {
        this.initTime_ = GridSim.getSimulationCalendar().getTimeInMillis();
        this.booking_ = new ArrayList();
        this.idArray_ = new int[4];
        this.timeArray_ = new long[4];
        this.commitObj_ = new Object[4];
        this.createObj_ = new ARObject(super.get_id(), this.timeZone_);
        this.ev_ = new Sim_event();
        this.transactionID_ = 0;
    }

    private int incrementID() {
        ++this.transactionID_;
        return this.transactionID_ + super.get_id();
    }

    private String validateValue(long l, long l2, int n, int n2, boolean bl) {
        long l3 = this.initTime_ + (long)((int)(GridSim.clock() * 1000.0));
        if (!bl && l < 0L) {
            return "AR_CREATE_ERROR_INVALID_START_TIME";
        }
        if (bl && l < l3) {
            return "AR_CREATE_ERROR_INVALID_START_TIME";
        }
        if (!bl && l2 < 0L) {
            return "AR_CREATE_ERROR_INVALID_END_TIME";
        }
        if (bl && (l2 < l3 || l2 < l)) {
            return "AR_CREATE_ERROR_INVALID_END_TIME";
        }
        if (n < 1) {
            return "AR_CREATE_ERROR_INVALID_NUM_PE";
        }
        if (!GridSim.isResourceExist(n2)) {
            return "AR_CREATE_ERROR_INVALID_RESOURCE_ID";
        }
        if (!GridSim.resourceSupportAR(n2)) {
            return "AR_CREATE_ERROR_FAIL_RESOURCE_CANT_SUPPORT";
        }
        return null;
    }

    private String validateValue(long l, int n, int n2, int n3, boolean bl) {
        long l2;
        long l3 = this.initTime_ + (long)((int)(GridSim.clock() * 1000.0));
        if (!bl && l < 0L) {
            return "AR_CREATE_ERROR_INVALID_START_TIME";
        }
        if (bl && l < l3) {
            return "AR_CREATE_ERROR_INVALID_START_TIME";
        }
        if (!bl && n < 0) {
            return "AR_CREATE_ERROR_INVALID_END_TIME";
        }
        if (bl && ((l2 = l + (long)(n * 1000)) < l3 || l2 < l)) {
            return "AR_CREATE_ERROR_INVALID_END_TIME";
        }
        if (n2 < 1) {
            return "AR_CREATE_ERROR_INVALID_NUM_PE";
        }
        if (!GridSim.isResourceExist(n3)) {
            return "AR_CREATE_ERROR_INVALID_RESOURCE_ID";
        }
        if (!GridSim.resourceSupportAR(n3)) {
            return "AR_CREATE_ERROR_FAIL_RESOURCE_CANT_SUPPORT";
        }
        return null;
    }

    private int commit(int n, int n2, Object object, long l) {
        this.commitObj_[0] = new Integer(n2);
        this.commitObj_[1] = object;
        int n3 = this.incrementID();
        this.commitObj_[2] = new Integer(n3);
        this.commitObj_[3] = new Integer(super.get_id());
        super.send(this.output, 0.0, 32, (Object)new IO_data(this.commitObj_, l, n));
        Sim_type_p sim_type_p = new Sim_type_p(32 + n3);
        super.sim_get_next(sim_type_p, this.ev_);
        int n4 = 0;
        try {
            n4 = (Integer)this.ev_.get_data();
            n4 = this.updateCommitList(n, n2, n4);
        }
        catch (Exception exception) {
            n4 = 65;
        }
        return n4;
    }

    private int[] parseBookingID(String string) {
        try {
            if (string == null) {
                return null;
            }
            int n = 2;
            String[] stringArray = string.split("_");
            if (stringArray.length != n) {
                return null;
            }
            this.idArray_[0] = Integer.parseInt(stringArray[0]);
            this.idArray_[1] = Integer.parseInt(stringArray[1]);
            if (!GridSim.isResourceExist(this.idArray_[0])) {
                return null;
            }
            return this.idArray_;
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ": Error - Invalid booking ID of " + string);
            return null;
        }
    }

    private String sendReservation(int n, ARObject aRObject, int n2) {
        int n3 = this.incrementID();
        aRObject.setTransactionID(n3);
        super.send(this.output, 0.0, n2, (Object)new IO_data(aRObject, ARObject.getByteSize(), n));
        Sim_type_p sim_type_p = new Sim_type_p(n2 + n3);
        super.sim_get_next(sim_type_p, this.ev_);
        int n4 = -7;
        try {
            long[] lArray = (long[])this.ev_.get_data();
            n4 = (int)lArray[0];
            if (n4 > 0) {
                ARObject aRObject2 = new ARObject(aRObject);
                aRObject2.setReservation(n4, lArray[1]);
                aRObject2.setStatus(41);
                this.booking_.add(aRObject2);
                return n + "_" + n4;
            }
        }
        catch (ClassCastException classCastException) {
            try {
                n4 = (Integer)this.ev_.get_data();
            }
            catch (Exception exception) {
                n4 = -7;
            }
        }
        catch (Exception exception) {
            n4 = -7;
        }
        return AdvanceReservation.getCreateResult(n4);
    }

    private int calculateTotalGridletSize(GridletList gridletList) {
        int n = 0;
        try {
            Gridlet gridlet = null;
            Iterator iterator = gridletList.iterator();
            int n2 = super.get_id();
            while (iterator.hasNext()) {
                gridlet = (Gridlet)iterator.next();
                gridlet.setUserID(n2);
                n = (int)((long)n + gridlet.getGridletFileSize());
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    private int updateCommitList(int n, int n2, int n3) {
        int n4 = 61;
        ARObject aRObject = this.searchBooking(n, n2);
        if (aRObject != null) {
            if (n3 == 60) {
                aRObject.setCommitted();
                aRObject.setStatus(40);
                n4 = n3;
            } else if (n3 == 62) {
                aRObject.setStatus(46);
                n4 = n3;
            } else {
                aRObject.setStatus(49);
            }
        }
        return n4;
    }

    private ARObject searchBooking(int n, int n2) {
        ARObject aRObject = null;
        boolean bl = false;
        try {
            Iterator iterator = this.booking_.iterator();
            while (iterator.hasNext()) {
                aRObject = (ARObject)iterator.next();
                if (aRObject.getReservationID() != n2 || aRObject.getResourceID() != n) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println(super.get_name() + ": Error - can't search reservation booking.");
        }
        if (!bl) {
            aRObject = null;
        }
        return aRObject;
    }
}

