/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import eduni.simjava.Sim_system;
import gridsim.ARObject;
import gridsim.ARPolicy;
import gridsim.AdvanceReservation;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.GridletList;
import gridsim.Machine;
import gridsim.MachineList;
import gridsim.PEList;
import gridsim.ResGridlet;
import gridsim.ResGridletList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class ARSimpleSpaceShared
extends ARPolicy {
    private ResGridletList gridletQueueList_;
    private ResGridletList gridletInExecList_;
    private ResGridletList gridletPausedList_;
    private ResGridletList gridletWaitingList_;
    private double lastUpdateTime_;
    private int[] machineRating_;
    private ArrayList reservList_;
    private ArrayList expiryList_;
    private int reservID_;
    private int commitPeriod_;
    private final int SUCCESS = 1;
    private final int NOT_FOUND = -1;
    private final int EMPTY = -88888888;
    private final int EXPIRY_TIME = 2;
    private final int PERFORM_RESERVATION = 3;

    public ARSimpleSpaceShared(String string, String string2) throws Exception {
        super(string, string2);
        this.commitPeriod_ = 1800;
        this.init();
    }

    public ARSimpleSpaceShared(String string, String string2, int n) throws Exception {
        super(string, string2);
        if (n <= 0) {
            throw new Exception(string + "." + string2 + ": Error -" + " Invalid expiry time.");
        }
        this.commitPeriod_ = n;
        this.init();
    }

    public void handleModifyReservation(ARObject aRObject, int n, int n2) {
        System.out.println(super.get_name() + ".handleModifyReservation(): not supported at the moment.");
        super.replyModifyReservation(n, n2, 77);
    }

    public void handleImmediateReservation(ARObject aRObject, int n, int n2) {
        if (aRObject.getNumPE() > this.totalPE_) {
            super.replyCreateReservation(n, n2, -1L, -9);
            return;
        }
        if (aRObject.getDurationTime() <= 0) {
            System.out.println(super.get_name() + ".handleImmediateReservation(): Error - can't handle " + "duration or end time = 0.");
            super.replyCreateReservation(n, n2, -1L, -2);
            return;
        }
        long l = super.getCurrentTime();
        aRObject.setStartTime(l);
        int n3 = aRObject.getDurationTime();
        this.getClass();
        long l2 = l + (long)(n3 * 1000);
        if (this.reservList_.size() == 0) {
            this.acceptReservation(aRObject, 0, n, n2, l2, false);
        } else {
            int n4 = this.findEmptySlot(l, l2, aRObject.getNumPE());
            if (n4 > -1) {
                this.acceptReservation(aRObject, n4, n, n2, l2, false);
            } else {
                super.replyCreateReservation(n, n2, -1L, n4);
            }
        }
    }

    public void handleCreateReservation(ARObject aRObject, int n, int n2) {
        long l;
        if (aRObject.getNumPE() > this.totalPE_) {
            super.replyCreateReservation(n, n2, -1L, -9);
            return;
        }
        long l2 = AdvanceReservation.convertTimeZone(aRObject.getStartTime(), aRObject.getTimeZone(), this.resource_.getResourceTimeZone());
        if (l2 < (l = super.getCurrentTime())) {
            super.replyCreateReservation(n, n2, -1L, -1);
            return;
        }
        aRObject.setStartTime(l2);
        this.getClass();
        long l3 = l + (long)(this.commitPeriod_ * 1000);
        if (this.reservList_.size() == 0) {
            this.acceptReservation(aRObject, 0, n, n2, l3, true);
        } else {
            int n3 = aRObject.getDurationTime();
            this.getClass();
            long l4 = l2 + (long)(n3 * 1000);
            int n4 = this.findEmptySlot(l2, l4, aRObject.getNumPE());
            if (n4 > -1) {
                this.acceptReservation(aRObject, n4, n, n2, l3, true);
            } else {
                super.replyCreateReservation(n, n2, -1L, n4);
            }
        }
    }

    public void handleCancelReservation(int n, int n2, ArrayList arrayList, int n3) {
        int n4 = 0;
        int n5 = super.searchReservation(this.reservList_, n);
        if (n5 == -1) {
            n5 = super.searchReservation(this.expiryList_, n);
            n4 = n5 == -1 ? 51 : 53;
            super.replyCancelReservation(n2, n3, n4);
            return;
        }
        ARObject aRObject = (ARObject)this.reservList_.get(n5);
        if (aRObject.getTotalGridlet() == 0) {
            n4 = 50;
            super.replyCancelReservation(n2, n3, n4);
            return;
        }
        try {
            Integer n6 = null;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                n6 = (Integer)iterator.next();
                n4 = this.cancelReservation(n6, n2);
            }
        }
        catch (Exception exception) {
            n4 = 55;
        }
        super.replyCancelReservation(n2, n3, n4);
    }

    public void handleCancelReservation(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = super.searchReservation(this.reservList_, n);
        if (n5 == -1) {
            n5 = super.searchReservation(this.expiryList_, n);
            n4 = n5 == -1 ? 51 : 53;
            super.replyCancelReservation(n2, n3, n4);
            return;
        }
        ARObject aRObject = (ARObject)this.reservList_.get(n5);
        int n6 = 0;
        n6 = !aRObject.hasCommitted() ? 0 : aRObject.getTotalGridlet();
        for (int i = 0; i < n6; ++i) {
            ResGridlet resGridlet = this.cancelReservationGridlet(n);
            if (resGridlet == null) {
                n4 = 50;
                super.replyCancelReservation(n2, n3, n4);
                return;
            }
            resGridlet.finalizeGridlet();
            super.sendCancelGridlet(23, resGridlet.getGridlet(), resGridlet.getGridletID(), n2);
        }
        aRObject.setStatus(45);
        this.reservList_.remove(aRObject);
        this.expiryList_.add(aRObject);
        n4 = 53;
        super.replyCancelReservation(n2, n3, n4);
    }

    public void handleCancelReservation(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = super.searchReservation(this.reservList_, n);
        if (n6 == -1) {
            n6 = super.searchReservation(this.expiryList_, n);
            n5 = n6 == -1 ? 51 : 53;
            super.replyCancelReservation(n2, n4, n5);
            return;
        }
        n5 = this.cancelReservation(n3, n2);
        super.replyCancelReservation(n2, n4, n5);
    }

    private int cancelReservation(int n, int n2) {
        int n3 = 0;
        ResGridlet resGridlet = this.cancel(n, n2);
        if (resGridlet == null) {
            n3 = 50;
            return n3;
        }
        n3 = resGridlet.getGridletStatus() == 4 ? 52 : 53;
        resGridlet.finalizeGridlet();
        super.sendCancelGridlet(23, resGridlet.getGridlet(), n, n2);
        return n3;
    }

    private ResGridlet cancelReservationGridlet(int n) {
        ResGridlet resGridlet = null;
        int n2 = this.findGridlet(this.gridletInExecList_, n);
        if (n2 >= 0) {
            this.updateGridletProcessing();
            resGridlet = (ResGridlet)this.gridletInExecList_.remove(n2);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                resGridlet.setGridletStatus(4);
            } else {
                resGridlet.setGridletStatus(6);
            }
            this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
            this.allocateQueueGridlet();
            return resGridlet;
        }
        n2 = this.findGridlet(this.gridletQueueList_, n);
        if (n2 >= 0) {
            resGridlet = (ResGridlet)this.gridletQueueList_.remove(n2);
            resGridlet.setGridletStatus(6);
            return resGridlet;
        }
        n2 = this.findGridlet(this.gridletPausedList_, n);
        if (n2 >= 0) {
            resGridlet = (ResGridlet)this.gridletPausedList_.remove(n2);
            resGridlet.setGridletStatus(6);
            return resGridlet;
        }
        n2 = this.findGridlet(this.gridletWaitingList_, n);
        if (n2 >= 0) {
            resGridlet = (ResGridlet)this.gridletWaitingList_.remove(n2);
            resGridlet.setGridletStatus(6);
            return resGridlet;
        }
        resGridlet = null;
        return resGridlet;
    }

    private int findGridlet(LinkedList linkedList, int n) {
        ResGridlet resGridlet = null;
        int n2 = -1;
        try {
            int n3 = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                resGridlet = (ResGridlet)iterator.next();
                if (resGridlet.getReservationID() == n) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(super.get_name() + ".findGridlet(): Exception error occurs.");
            System.out.println(exception.getMessage());
        }
        return n2;
    }

    public void handleQueryBusyTime(long l, long l2, int n, int n2) {
        System.out.println(super.get_name() + ".handleQueryBusyTime(): not supported at the moment.");
        super.replyTimeReservation(n, n2, null);
    }

    public void handleQueryFreeTime(long l, long l2, int n, int n2) {
        System.out.println(super.get_name() + ".handleQueryFreeTime(): not supported at the moment.");
        super.replyTimeReservation(n, n2, null);
    }

    public void handleCommitOnly(int n, int n2, int n3) {
        int n4 = this.doCommitReservation(n, null);
        super.replyCommitReservation(n2, n3, n4);
    }

    public void handleCommitReservation(int n, int n2, int n3, GridletList gridletList) {
        int n4 = this.doCommitReservation(n, gridletList);
        super.replyCommitReservation(n2, n3, n4);
    }

    public void handleCommitReservation(int n, int n2, int n3, Gridlet gridlet) {
        int n4 = this.doCommitReservation(n, gridlet);
        super.replyCommitReservation(n2, n3, n4);
    }

    private int doCommitReservation(int n, Object object) {
        int n2 = super.searchReservation(this.reservList_, n);
        if (n2 == -1) {
            return 63;
        }
        ARObject aRObject = (ARObject)this.reservList_.get(n2);
        long l = super.getCurrentTime();
        if (!aRObject.hasCommitted() && aRObject.getExpiryTime() < l) {
            aRObject.setStatus(46);
            this.expiryList_.add(aRObject);
            this.reservList_.remove(aRObject);
            return 62;
        }
        long l2 = aRObject.getStartTime();
        int n3 = aRObject.getDurationTime();
        this.getClass();
        long l3 = l2 + (long)(n3 * 1000);
        if (l3 < l) {
            aRObject.setStatus(46);
            this.expiryList_.add(aRObject);
            this.reservList_.remove(aRObject);
            return 62;
        }
        int n4 = 0;
        if (object == null) {
            n4 = 60;
        } else {
            Gridlet gridlet = null;
            try {
                gridlet = (Gridlet)object;
                if (aRObject.getTotalGridlet() == aRObject.getNumPE()) {
                    return 61;
                }
                ResGridlet resGridlet = new ResGridlet(gridlet, aRObject.getStartTime(), aRObject.getDurationTime(), aRObject.getReservationID());
                n4 = 60;
                n2 = this.findPosition(this.gridletWaitingList_, aRObject.getStartTime());
                this.gridletWaitingList_.add(n2, resGridlet);
                aRObject.addTotalGridlet(1);
            }
            catch (ClassCastException classCastException) {
                try {
                    GridletList gridletList = (GridletList)object;
                    int n5 = gridletList.size();
                    if (aRObject.getTotalGridlet() + n5 > aRObject.getNumPE()) {
                        n5 = aRObject.getNumPE() - aRObject.getTotalGridlet();
                    }
                    for (int i = 0; i < n5; ++i) {
                        gridlet = (Gridlet)gridletList.get(i);
                        ResGridlet resGridlet = new ResGridlet(gridlet, aRObject.getStartTime(), aRObject.getDurationTime(), aRObject.getReservationID());
                        if (i == 0) {
                            n2 = this.findPosition(this.gridletWaitingList_, aRObject.getStartTime());
                        }
                        this.gridletWaitingList_.add(n2, resGridlet);
                    }
                    n4 = 60;
                    aRObject.addTotalGridlet(n5);
                }
                catch (Exception exception) {
                    n4 = 65;
                }
            }
            catch (Exception exception) {
                n4 = 65;
            }
        }
        if (n4 == 60) {
            int n6 = 40;
            long l4 = aRObject.getStartTime() - l;
            this.getClass();
            int n7 = (int)(l4 / 1000L);
            if (n7 <= 0) {
                n6 = 43;
                n7 = 0;
            }
            aRObject.setCommitted();
            aRObject.setStatus(n6);
            super.sendInternalEvent(n7, 3);
        }
        return n4;
    }

    private int findPosition(LinkedList linkedList, long l) {
        int n = 0;
        if (linkedList.size() == 0) {
            return n;
        }
        Iterator iterator = linkedList.iterator();
        ResGridlet resGridlet = null;
        while (iterator.hasNext() && (resGridlet = (ResGridlet)iterator.next()).getStartTime() <= l) {
            ++n;
        }
        if (n > linkedList.size()) {
            n = linkedList.size();
        }
        return n;
    }

    private void performReservation() {
        this.updateGridletProcessing();
        if (this.gridletWaitingList_.size() == 0) {
            return;
        }
        Object var1_1 = null;
        long l = super.getCurrentTime();
        this.getClass();
        long l2 = l + (long)(5 * 1000);
        int n = this.findPosition(this.gridletWaitingList_, l2);
        if (n <= 0) {
            return;
        }
        this.executeReservedGridlet(n);
    }

    private void executeReservedGridlet(int n) {
        boolean bl = false;
        if (this.gridletInExecList_.size() + n <= this.totalPE_) {
            bl = true;
        }
        if (!bl) {
            this.clearExecList(n);
        }
        ResGridlet resGridlet = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            resGridlet = (ResGridlet)this.gridletWaitingList_.get(n2);
            bl = this.allocatePEtoGridlet(resGridlet);
            if (bl) {
                this.gridletWaitingList_.remove(n2);
                ++n3;
                continue;
            }
            ++n2;
        }
    }

    private int clearExecList(int n) {
        int n2 = 0;
        ResGridlet resGridlet = null;
        int n3 = 0;
        while (n3 < this.gridletInExecList_.size()) {
            resGridlet = (ResGridlet)this.gridletInExecList_.get(n3);
            if (n2 <= n && !resGridlet.hasReserved()) {
                resGridlet.setGridletStatus(2);
                this.gridletInExecList_.remove(n3);
                this.gridletQueueList_.add(resGridlet);
                this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n2 == n) {
            return n2;
        }
        long l = super.getCurrentTime();
        long l2 = 0L;
        n3 = 0;
        while (n3 < this.gridletInExecList_.size() && n2 <= n) {
            resGridlet = (ResGridlet)this.gridletInExecList_.get(n3);
            if (n2 <= n && resGridlet.hasReserved() && (l2 = resGridlet.getStartTime() + (long)(resGridlet.getDurationTime() * 1000)) <= l) {
                resGridlet.setGridletStatus(2);
                this.gridletInExecList_.remove(n3);
                this.gridletQueueList_.add(resGridlet);
                this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
                ++n2;
                continue;
            }
            ++n3;
        }
        return n2;
    }

    public void handleQueryReservation(int n, int n2, int n3) {
        ARObject aRObject = null;
        int n4 = 0;
        int n5 = super.searchReservation(this.reservList_, n);
        if (n5 == -1) {
            n5 = super.searchReservation(this.expiryList_, n);
            if (n5 == -1) {
                n4 = 48;
            } else {
                aRObject = (ARObject)this.expiryList_.get(n5);
                n4 = aRObject.getStatus();
            }
        } else {
            aRObject = (ARObject)this.reservList_.get(n5);
            n4 = aRObject.getStatus();
        }
        super.replyQueryReservation(n2, n3, n4);
    }

    public void body() {
        MachineList machineList = this.resource_.getMachineList();
        int n = machineList.size();
        this.machineRating_ = new int[n];
        for (int i = 0; i < n; ++i) {
            this.machineRating_[i] = this.resource_.getMIPSRatingOfOnePE(i, 0);
        }
        Sim_event sim_event = new Sim_event();
        while (Sim_system.running()) {
            super.sim_get_next(sim_event);
            if (sim_event.get_tag() == -1 || super.isEndSimulation()) {
                this.gridletInExecList_.clear();
                this.gridletQueueList_.clear();
                this.gridletWaitingList_.clear();
                this.reservList_.clear();
                break;
            }
            if (sim_event.get_src() == this.myId_ && sim_event.get_tag() == 2) {
                this.checkExpiryTime();
                continue;
            }
            if (sim_event.get_src() == this.myId_ && sim_event.get_tag() == 3) {
                this.performReservation();
                continue;
            }
            if (sim_event.get_src() != this.myId_ || this.gridletInExecList_.size() <= 0) continue;
            this.updateGridletProcessing();
            this.checkGridletCompletion();
            this.performReservation();
        }
        while (super.sim_waiting() > 0) {
            super.sim_get_next(sim_event);
            System.out.println(super.get_name() + ".body(): ignore internal events");
        }
    }

    public void gridletSubmit(Gridlet gridlet, boolean bl) {
        this.updateGridletProcessing();
        ResGridlet resGridlet = new ResGridlet(gridlet);
        boolean bl2 = false;
        if (this.gridletInExecList_.size() < this.totalPE_) {
            bl2 = this.allocatePEtoGridlet(resGridlet);
        }
        if (!bl2) {
            resGridlet.setGridletStatus(2);
            this.gridletQueueList_.add(resGridlet);
        }
        if (bl) {
            super.sendAck(22, true, gridlet.getGridletID(), gridlet.getUserID());
        }
    }

    public int gridletStatus(int n, int n2) {
        ResGridlet resGridlet = null;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletInExecList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        n3 = super.findGridlet(this.gridletPausedList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletPausedList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        n3 = super.findGridlet(this.gridletQueueList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletQueueList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        n3 = super.findGridlet(this.gridletWaitingList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletWaitingList_.get(n3);
            return resGridlet.getGridletStatus();
        }
        return -1;
    }

    public void gridletCancel(int n, int n2) {
        ResGridlet resGridlet = this.cancel(n, n2);
        if (resGridlet == null) {
            System.out.println(super.get_name() + ".gridletCancel(): Cannot " + "find Gridlet #" + n + " for User #" + n2);
            super.sendCancelGridlet(23, null, n, n2);
            return;
        }
        if (resGridlet.getGridletStatus() == 4) {
            System.out.println(super.get_name() + ".gridletCancel(): Cannot " + "cancel Gridlet #" + n + " for User #" + n2 + " since it has FINISHED.");
        }
        resGridlet.finalizeGridlet();
        super.sendCancelGridlet(23, resGridlet.getGridlet(), n, n2);
    }

    public void gridletPause(int n, int n2, boolean bl) {
        ResGridlet resGridlet;
        boolean bl2 = false;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            this.updateGridletProcessing();
            resGridlet = (ResGridlet)this.gridletInExecList_.remove(n3);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                n3 = -1;
                this.gridletFinish(resGridlet, 4);
                System.out.println(super.get_name() + ".gridletPause(): Cannot pause" + " Gridlet #" + n + " for User #" + n2 + " since it has FINISHED.");
            } else {
                bl2 = true;
                resGridlet.setGridletStatus(7);
                this.gridletPausedList_.add(resGridlet);
                this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
                this.allocateQueueGridlet();
            }
        } else {
            n3 = super.findGridlet(this.gridletQueueList_, n, n2);
        }
        if (!bl2 && n3 >= 0) {
            bl2 = true;
            resGridlet = (ResGridlet)this.gridletQueueList_.remove(n3);
            resGridlet.setGridletStatus(7);
            this.gridletPausedList_.add(resGridlet);
        } else {
            n3 = super.findGridlet(this.gridletWaitingList_, n, n2);
        }
        if (!bl2 && n3 >= 0) {
            bl2 = true;
            resGridlet = (ResGridlet)this.gridletWaitingList_.remove(n3);
            resGridlet.setGridletStatus(7);
            this.gridletPausedList_.add(resGridlet);
        } else if (n3 == -1) {
            System.out.println(super.get_name() + ".gridletPause(): Error - cannot " + "find Gridlet #" + n + " for User #" + n2);
        }
        if (bl) {
            super.sendAck(26, bl2, n, n2);
        }
    }

    public void gridletMove(int n, int n2, int n3, boolean bl) {
        ResGridlet resGridlet = this.cancel(n, n2);
        if (resGridlet == null) {
            System.out.println(super.get_name() + ".gridletMove(): Cannot " + "find Gridlet #" + n + " for User #" + n2);
            if (bl) {
                super.sendAck(22, false, n, n2);
            }
            return;
        }
        if (resGridlet.getGridletStatus() == 4) {
            System.out.println(super.get_name() + ".gridletMove(): Cannot move" + " Gridlet #" + n + " for User #" + n2 + " since it has FINISHED.");
            if (bl) {
                super.sendAck(22, false, n, n2);
            }
            this.gridletFinish(resGridlet, 4);
        } else {
            resGridlet.finalizeGridlet();
            this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
            super.gridletMigrate(resGridlet.getGridlet(), n3, bl);
            this.allocateQueueGridlet();
        }
    }

    public void gridletResume(int n, int n2, boolean bl) {
        boolean bl2 = false;
        int n3 = super.findGridlet(this.gridletPausedList_, n, n2);
        if (n3 >= 0) {
            ResGridlet resGridlet = (ResGridlet)this.gridletPausedList_.remove(n3);
            resGridlet.setGridletStatus(8);
            this.updateGridletProcessing();
            bl2 = true;
            boolean bl3 = false;
            if (this.gridletInExecList_.size() < this.totalPE_) {
                bl3 = this.allocatePEtoGridlet(resGridlet);
            }
            if (!bl3) {
                resGridlet.setGridletStatus(2);
                this.gridletQueueList_.add(resGridlet);
            }
            System.out.println(super.get_name() + ".gridletResume():" + " Gridlet #" + n + " with User ID #" + n2 + " has been sucessfully RESUMED.");
        } else {
            System.out.println(super.get_name() + ".gridletResume(): Cannot " + "find Gridlet #" + n + " for User #" + n2);
        }
        if (bl) {
            super.sendAck(28, bl2, n, n2);
        }
    }

    private void init() {
        this.reservID_ = 1;
        this.reservList_ = new ArrayList();
        this.expiryList_ = new ArrayList();
        this.gridletInExecList_ = new ResGridletList();
        this.gridletPausedList_ = new ResGridletList();
        this.gridletQueueList_ = new ResGridletList();
        this.gridletWaitingList_ = new ResGridletList();
        this.lastUpdateTime_ = 0.0;
        this.machineRating_ = null;
    }

    private void checkExpiryTime() {
        long l = super.getCurrentTime();
        ARObject aRObject = null;
        try {
            long l2 = 0L;
            for (int i = 0; i < this.reservList_.size() && this.reservList_.size() != 0; ++i) {
                aRObject = (ARObject)this.reservList_.get(i);
                if (!aRObject.hasCommitted() && aRObject.getExpiryTime() <= l) {
                    aRObject.setStatus(46);
                    this.expiryList_.add(aRObject);
                    this.reservList_.remove(aRObject);
                    continue;
                }
                l2 = aRObject.getStartTime() + (long)(aRObject.getDurationTime() * 1000);
                if (aRObject.getTotalGridlet() != 0 || l2 > l) continue;
                aRObject.setStatus(44);
                this.expiryList_.add(aRObject);
                this.reservList_.remove(aRObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void acceptReservation(ARObject aRObject, int n, int n2, int n3, long l, boolean bl) {
        ARObject aRObject2 = new ARObject(aRObject);
        if (bl && l > aRObject.getStartTime()) {
            l = aRObject.getStartTime();
        }
        aRObject2.setReservation(this.reservID_, l);
        this.reservList_.add(n, aRObject2);
        l = AdvanceReservation.convertTimeZone(l, this.resource_.getResourceTimeZone(), aRObject.getTimeZone());
        super.replyCreateReservation(n2, n3, l, this.reservID_);
        int n4 = (int)(l - super.getCurrentTime());
        this.getClass();
        int n5 = n4 / 1000;
        super.sendInternalEvent(n5, 2);
        ++this.reservID_;
    }

    private int findEmptySlot(long l, long l2, int n) {
        int n2;
        long l3 = 0L;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        ARObject aRObject = null;
        Iterator iterator = this.reservList_.iterator();
        int n6 = 0;
        while (iterator.hasNext()) {
            aRObject = (ARObject)iterator.next();
            l3 = aRObject.getStartTime() + (long)(aRObject.getDurationTime() * 1000);
            if (l <= aRObject.getStartTime()) {
                if (n3 == -1) {
                    n3 = n6;
                }
                if (n4 == -1 && l <= l3) {
                    n4 = n6;
                }
            } else if (n4 == -1 && l <= l3) {
                n4 = n6;
            }
            if (aRObject.getStartTime() > l2) {
                n5 = n6 - 1;
                break;
            }
            n5 = n6++;
        }
        if (n5 == -1 || n5 < n4) {
            n5 = n4;
        }
        if (n3 == -1) {
            n3 = this.reservList_.size();
        }
        if ((n2 = this.isAvailable(n4, n5, n, l, l2)) < 0) {
            n3 = n2;
        }
        return n3;
    }

    private int isAvailable(int n, int n2, int n3, long l, long l2) {
        if (n == -1) {
            return 1;
        }
        ARObject aRObject = null;
        long l3 = 0L;
        int n4 = 0;
        if (n == n2) {
            aRObject = (ARObject)this.reservList_.get(n);
            if (l2 < aRObject.getStartTime()) {
                n4 = 1;
            } else if (aRObject.getNumPE() + n3 <= this.totalPE_) {
                n4 = 1;
            } else {
                l3 = aRObject.getStartTime() + (long)(aRObject.getDurationTime() * 1000) - l;
                n4 = this.approxBusyTime(l3);
            }
        } else {
            n4 = this.calculateEmptySlot(n, n2, n3, l);
        }
        return n4;
    }

    private int calculateEmptySlot(int n, int n2, int n3, long l) {
        int n4 = 0;
        int n5 = -1;
        int[] nArray = new int[(n2 - n + 1) * 2];
        int n6 = 0;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            nArray[n4] = -88888888;
        }
        ARObject aRObject = null;
        long l2 = 0L;
        Iterator iterator = this.reservList_.iterator();
        n4 = 0;
        while (iterator.hasNext()) {
            if (n <= n4 && n4 <= n2) {
                aRObject = (ARObject)iterator.next();
                l2 = aRObject.getStartTime() + (long)(aRObject.getDurationTime() * 1000);
                if (l2 < l) continue;
                if (n6 == 0) {
                    nArray[0] = n4;
                    nArray[1] = n4 * n5;
                    n6 = 2;
                } else {
                    n6 = this.insertionSort(n4, n6, nArray);
                }
            }
            if (n4 > n2) break;
            ++n4;
        }
        boolean bl = false;
        int n7 = 0;
        n4 = 0;
        int n8 = -1;
        for (n4 = 0; n4 < n6; ++n4) {
            if (nArray[n4] == 0 && bl) {
                n8 = n4;
                break;
            }
            if (nArray[n4] < 0) {
                n8 = n4;
                break;
            }
            if (nArray[n4] != 0 || bl) continue;
            bl = true;
        }
        for (n4 = 0; n4 < n8; ++n4) {
            if (nArray[n4] == n8 * -1) continue;
            aRObject = (ARObject)this.reservList_.get(n4);
            n7 += aRObject.getNumPE();
        }
        int n9 = 0;
        n9 = n7 + n3 <= this.totalPE_ ? 1 : this.approxBusyTime(l2 - l);
        return n9;
    }

    private int insertionSort(int n, int n2, int[] nArray) {
        ARObject aRObject = null;
        ARObject aRObject2 = null;
        int n3 = -1;
        int n4 = -1;
        long l = 0L;
        long l2 = 0L;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        for (n5 = 0; n5 < n2; ++n5) {
            aRObject2 = (ARObject)this.reservList_.get(n);
            l = aRObject2.getStartTime() + (long)(aRObject2.getDurationTime() * 1000);
            if (nArray[n5] == -88888888) break;
            if (nArray[n5] < 0 || nArray[n5] == 0 && bl) {
                n6 = nArray[n5] * -1;
                aRObject = (ARObject)this.reservList_.get(n6);
                l2 = aRObject.getStartTime() + (long)(aRObject.getDurationTime() * 1000);
            } else {
                aRObject = (ARObject)this.reservList_.get(nArray[n5]);
                l2 = aRObject.getStartTime();
            }
            if (n3 == -1 && aRObject2.getStartTime() < l2) {
                n3 = n5;
            }
            if (l < l2) {
                n4 = n5;
                break;
            }
            if (nArray[n5] != 0 || bl) continue;
            bl = true;
        }
        if (n3 == -1) {
            nArray[n2] = n;
            nArray[n2 + 1] = n * -1;
            return n2 + 2;
        }
        int n7 = 2;
        for (n5 = n2 - 1; n5 < n2; --n5) {
            if (n4 == -1) {
                n7 = 1;
                nArray[n2 + 1] = n * -1;
            }
            nArray[n5 + n7] = nArray[n5];
            if (n5 == n4) {
                n7 = 1;
                nArray[n5 + n7] = n * -1;
            }
            if (n5 != n3) continue;
            nArray[n5] = n;
            break;
        }
        return n2 + 2;
    }

    private void allocateQueueGridlet() {
        ResGridlet resGridlet;
        boolean bl;
        if (this.gridletQueueList_.size() > 0 && this.gridletInExecList_.size() < this.totalPE_ && (bl = this.allocatePEtoGridlet(resGridlet = (ResGridlet)this.gridletQueueList_.get(0)))) {
            this.gridletQueueList_.remove(resGridlet);
        }
    }

    private void updateGridletProcessing() {
        double d = GridSim.clock();
        double d2 = d - this.lastUpdateTime_;
        if (d2 <= 0.0) {
            return;
        }
        this.lastUpdateTime_ = d;
        int n = this.gridletInExecList_.size();
        double d3 = super.calculateTotalLoad(n);
        super.addTotalLoad(d3);
        if (n == 0) {
            return;
        }
        ResGridlet resGridlet = null;
        Iterator iterator = this.gridletInExecList_.iterator();
        while (iterator.hasNext()) {
            resGridlet = (ResGridlet)iterator.next();
            d3 = this.getMIShare(d2, resGridlet.getMachineID());
            resGridlet.updateGridletFinishedSoFar(d3);
        }
    }

    private double getMIShare(double d, int n) {
        double d2 = this.resCalendar_.getCurrentLoad();
        double d3 = (double)this.machineRating_[n] * d * (1.0 - d2);
        return d3;
    }

    private boolean allocatePEtoGridlet(ResGridlet resGridlet) {
        Machine machine = this.resource_.getMachineWithFreePE(resGridlet.getNumPE());
        if (machine == null) {
            return false;
        }
        PEList pEList = machine.getPEList();
        int n = pEList.getFreePEID();
        this.resource_.setStatusPE(false, machine.getMachineID(), n);
        resGridlet.setGridletStatus(3);
        resGridlet.setMachineAndPEID(machine.getMachineID(), n);
        this.gridletInExecList_.add(resGridlet);
        int n2 = this.machineRating_[resGridlet.getMachineID()];
        double d = this.forecastFinishTime(n2 * resGridlet.getNumPE(), resGridlet.getRemainingGridletLength());
        resGridlet.setFinishTime(d);
        super.sendInternalEvent(d);
        return true;
    }

    private double forecastFinishTime(double d, double d2) {
        double d3 = d2 / d;
        if (d3 < 1.0) {
            d3 = 1.0;
        }
        return d3;
    }

    private void checkGridletCompletion() {
        ResGridlet resGridlet = null;
        int n = 0;
        while (n < this.gridletInExecList_.size()) {
            resGridlet = (ResGridlet)this.gridletInExecList_.get(n);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                this.gridletInExecList_.remove(resGridlet);
                this.gridletFinish(resGridlet, 4);
                continue;
            }
            ++n;
        }
        if (this.gridletInExecList_.size() > 0) {
            super.sendInternalEvent(60.0);
        }
    }

    private void gridletFinish(ResGridlet resGridlet, int n) {
        int n2;
        this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
        resGridlet.setGridletStatus(n);
        resGridlet.finalizeGridlet();
        super.sendFinishGridlet(resGridlet.getGridlet());
        this.allocateQueueGridlet();
        if (resGridlet.hasReserved() && (n2 = super.searchReservation(this.reservList_, resGridlet.getReservationID())) != -1) {
            ARObject aRObject = (ARObject)this.reservList_.get(n2);
            aRObject.reduceTotalGridlet();
            long l = super.getCurrentTime();
            long l2 = aRObject.getStartTime() + (long)(aRObject.getDurationTime() * 1000);
            if (aRObject.getTotalGridlet() == 0 && l > l2) {
                aRObject.setStatus(44);
                this.expiryList_.add(aRObject);
                this.reservList_.remove(aRObject);
            }
        }
    }

    private ResGridlet cancel(int n, int n2) {
        ResGridlet resGridlet = null;
        int n3 = super.findGridlet(this.gridletInExecList_, n, n2);
        if (n3 >= 0) {
            this.updateGridletProcessing();
            resGridlet = (ResGridlet)this.gridletInExecList_.remove(n3);
            if (resGridlet.getRemainingGridletLength() == 0.0) {
                resGridlet.setGridletStatus(4);
            } else {
                resGridlet.setGridletStatus(6);
            }
            this.resource_.setStatusPE(true, resGridlet.getMachineID(), resGridlet.getPEID());
            this.allocateQueueGridlet();
            return resGridlet;
        }
        n3 = super.findGridlet(this.gridletQueueList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletQueueList_.remove(n3);
            resGridlet.setGridletStatus(6);
            return resGridlet;
        }
        n3 = super.findGridlet(this.gridletPausedList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletPausedList_.remove(n3);
            resGridlet.setGridletStatus(6);
            return resGridlet;
        }
        n3 = super.findGridlet(this.gridletWaitingList_, n, n2);
        if (n3 >= 0) {
            resGridlet = (ResGridlet)this.gridletWaitingList_.remove(n3);
            resGridlet.setGridletStatus(6);
            return resGridlet;
        }
        resGridlet = null;
        return resGridlet;
    }
}

