/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import gridsim.ARObject;
import gridsim.AllocPolicy;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.GridletList;
import gridsim.IO_data;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class ARPolicy
extends AllocPolicy {
    protected final int MILLI_SEC = 1000;
    private int MAX = 2;
    private long[] sendArray_;
    private final int SIZE = 12;
    private final int TAG_SIZE = 6;
    private int[] timeArray_ = new int[]{1, 5, 10, 15, 30, 45};
    private int[] tagArray_;

    public abstract void handleImmediateReservation(ARObject var1, int var2, int var3);

    public abstract void handleCreateReservation(ARObject var1, int var2, int var3);

    public abstract void handleModifyReservation(ARObject var1, int var2, int var3);

    public abstract void handleCancelReservation(int var1, int var2, int var3, int var4);

    public abstract void handleCancelReservation(int var1, int var2, ArrayList var3, int var4);

    public abstract void handleCancelReservation(int var1, int var2, int var3);

    public abstract void handleCommitOnly(int var1, int var2, int var3);

    public abstract void handleCommitReservation(int var1, int var2, int var3, Gridlet var4);

    public abstract void handleCommitReservation(int var1, int var2, int var3, GridletList var4);

    public abstract void handleQueryReservation(int var1, int var2, int var3);

    public abstract void handleQueryBusyTime(long var1, long var3, int var5, int var6);

    public abstract void handleQueryFreeTime(long var1, long var3, int var5, int var6);

    protected ARPolicy(String string, String string2) throws Exception {
        super(string, string2);
        this.sendArray_ = new long[this.MAX];
        this.tagArray_ = new int[18];
        for (int i = 0; i < this.tagArray_.length; ++i) {
            this.tagArray_[i] = -11 - i;
        }
    }

    protected void replyCreateReservation(int n, int n2, long l, int n3) {
        this.sendArray_[0] = n3;
        this.sendArray_[1] = l;
        int n4 = 16;
        super.sim_schedule(this.outputPort_, 0.0, n2, (Object)new IO_data(this.sendArray_, n4, n));
    }

    protected void replyCancelReservation(int n, int n2, int n3) {
        super.sim_schedule(this.outputPort_, 0.0, n2, (Object)new IO_data(new Integer(n3), 12L, n));
    }

    protected void replyCommitReservation(int n, int n2, int n3) {
        super.sim_schedule(this.outputPort_, 0.0, n2, (Object)new IO_data(new Integer(n3), 12L, n));
    }

    protected void replyQueryReservation(int n, int n2, int n3) {
        super.sim_schedule(this.outputPort_, 0.0, n2, (Object)new IO_data(new Integer(n3), 12L, n));
    }

    protected void replyModifyReservation(int n, int n2, int n3) {
        super.sim_schedule(this.outputPort_, 0.0, n2, (Object)new IO_data(new Integer(n3), 12L, n));
    }

    protected void replyTimeReservation(int n, int n2, ArrayList arrayList) {
        int n3 = 12;
        if (arrayList != null) {
            n3 = 32 + arrayList.size();
        }
        super.sim_schedule(this.outputPort_, 0.0, n2, (Object)new IO_data(arrayList, 12L, n));
    }

    protected long getCurrentTime() {
        return this.initTime_ + (long)((int)(GridSim.clock() * 1000.0));
    }

    protected int searchReservation(Collection collection, int n) {
        ARObject aRObject = null;
        int n2 = -1;
        try {
            int n3 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                aRObject = (ARObject)iterator.next();
                if (aRObject.getReservationID() == n) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println("ARPolicy.findReservedGridlet(): Error occurs.");
            System.out.println(exception.getMessage());
        }
        return n2;
    }

    protected int approxBusyTime(long l) {
        int n = 1;
        int n2 = 60 * n;
        int n3 = 60 * n2;
        int n4 = (int)l / 1000;
        int n5 = 0;
        n5 = n4 < n2 ? n : (n4 < n3 ? n2 : n3);
        int n6 = 0;
        int n7 = 0;
        for (n7 = 0; n7 < this.timeArray_.length && n4 > (n6 = this.timeArray_[n7] * n5); ++n7) {
        }
        if (n7 == this.timeArray_.length) {
            n7 = this.timeArray_.length - 1;
        }
        n6 = n5 == n ? 0 : (n5 == n2 ? 6 : 12);
        return this.tagArray_[n7 + n6];
    }
}

