/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import gridsim.AdvanceReservation;
import gridsim.GridSim;
import java.util.Calendar;

public class ARObject {
    private long startTime_;
    private int duration_;
    private int numPE_;
    private int resID_;
    private int userID_;
    private int transactionID_;
    private double timeZone_;
    private int status_;
    private final int NOT_FOUND = -1;
    private boolean committed_;
    private int reservID_;
    private long expiryTime_;
    private int totalGridlet_;

    public ARObject(ARObject aRObject) {
        if (aRObject != null) {
            this.startTime_ = aRObject.getStartTime();
            this.duration_ = aRObject.getDurationTime();
            this.numPE_ = aRObject.getNumPE();
            this.resID_ = aRObject.getResourceID();
            this.transactionID_ = aRObject.getTransactionID();
            this.timeZone_ = aRObject.getTimeZone();
            this.status_ = aRObject.getStatus();
            this.reservID_ = aRObject.getReservationID();
            this.committed_ = aRObject.hasCommitted();
            this.expiryTime_ = aRObject.getExpiryTime();
            this.userID_ = aRObject.getUserID();
            this.totalGridlet_ = aRObject.getTotalGridlet();
        }
    }

    public static int getByteSize() {
        int n = 32;
        int n2 = 8;
        int n3 = 16;
        int n4 = 8;
        return n + n2 + n3 + n4;
    }

    public ARObject(String string) {
        Calendar calendar = GridSim.getSimulationCalendar();
        this.timeZone_ = calendar == null ? 0.0 : (double)(calendar.getTimeZone().getRawOffset() / 3600000);
        this.init(GridSim.getEntityId(string));
    }

    public ARObject(String string, double d) {
        this.timeZone_ = !AdvanceReservation.validateTimeZone(d) ? 0.0 : d;
        this.init(GridSim.getEntityId(string));
    }

    public ARObject(int n, double d) {
        this.timeZone_ = !AdvanceReservation.validateTimeZone(d) ? 0.0 : d;
        this.init(n);
    }

    public ARObject(int n) {
        Calendar calendar = GridSim.getSimulationCalendar();
        this.timeZone_ = calendar == null ? 0.0 : (double)(calendar.getTimeZone().getRawOffset() / 3600000);
        this.init(n);
    }

    public boolean copy(ARObject aRObject) {
        boolean bl = false;
        if (aRObject != null) {
            bl = true;
            this.startTime_ = aRObject.getStartTime();
            this.duration_ = aRObject.getDurationTime();
            this.numPE_ = aRObject.getNumPE();
            this.resID_ = aRObject.getResourceID();
            this.transactionID_ = aRObject.getTransactionID();
            this.timeZone_ = aRObject.getTimeZone();
            this.status_ = aRObject.getStatus();
            this.reservID_ = aRObject.getReservationID();
            this.committed_ = aRObject.hasCommitted();
            this.expiryTime_ = aRObject.getExpiryTime();
            this.userID_ = aRObject.getUserID();
            this.totalGridlet_ = aRObject.getTotalGridlet();
        }
        return bl;
    }

    public boolean setTransactionID(int n) {
        if (n <= 0) {
            return false;
        }
        this.transactionID_ = n;
        return true;
    }

    public boolean setStartTime(long l) {
        if (l <= 0L) {
            return false;
        }
        this.startTime_ = l;
        return true;
    }

    public boolean setDurationTime(int n) {
        if (n <= 0) {
            return false;
        }
        this.duration_ = n;
        return true;
    }

    public boolean setNumPE(int n) {
        if (n <= 0) {
            return false;
        }
        this.numPE_ = n;
        return true;
    }

    public boolean setResourceID(int n) {
        if (n <= 0) {
            return false;
        }
        this.resID_ = n;
        return true;
    }

    public boolean setTimeZone(double d) {
        if (!AdvanceReservation.validateTimeZone(d)) {
            return false;
        }
        this.timeZone_ = d;
        return true;
    }

    public int getUserID() {
        return this.userID_;
    }

    public String getEntityName() {
        return GridSim.getEntityName(this.userID_);
    }

    public int getTransactionID() {
        return this.transactionID_;
    }

    public long getStartTime() {
        return this.startTime_;
    }

    public int getDurationTime() {
        return this.duration_;
    }

    public int getNumPE() {
        return this.numPE_;
    }

    public int getResourceID() {
        return this.resID_;
    }

    public double getTimeZone() {
        return this.timeZone_;
    }

    public int getTotalGridlet() {
        return this.totalGridlet_;
    }

    public void addTotalGridlet(int n) {
        this.totalGridlet_ += n;
    }

    public void reduceTotalGridlet() {
        if (this.totalGridlet_ == 0) {
            return;
        }
        --this.totalGridlet_;
    }

    public void setReservation(int n, long l) {
        if (n <= 0 || l <= 0L) {
            return;
        }
        this.reservID_ = n;
        this.expiryTime_ = l;
    }

    public void setStatus(int n) {
        this.status_ = n;
    }

    public void setCommitted() {
        this.committed_ = true;
    }

    public int getStatus() {
        return this.status_;
    }

    public int getReservationID() {
        return this.reservID_;
    }

    public long getExpiryTime() {
        return this.expiryTime_;
    }

    public boolean hasCommitted() {
        return this.committed_;
    }

    private void init(int n) {
        if (n == -1) {
            System.out.println("ARObject: Invalid userID or userName.");
        }
        this.userID_ = n;
        this.startTime_ = -1L;
        this.duration_ = -1;
        this.numPE_ = -1;
        this.resID_ = -1;
        this.transactionID_ = -1;
        this.status_ = -1;
        this.reservID_ = -1;
        this.expiryTime_ = -1L;
        this.totalGridlet_ = 0;
        this.committed_ = false;
    }
}

