/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import gridsim.ARObject;
import gridsim.ARPolicy;
import gridsim.GridResource;
import gridsim.Gridlet;
import gridsim.GridletList;
import gridsim.IO_data;
import gridsim.ResourceCalendar;
import gridsim.ResourceCharacteristics;
import java.util.ArrayList;

public class ARGridResource
extends GridResource {
    public ARGridResource(String string, double d, ResourceCharacteristics resourceCharacteristics, ResourceCalendar resourceCalendar, ARPolicy aRPolicy) throws Exception {
        super(string, d, resourceCharacteristics, resourceCalendar, aRPolicy);
    }

    protected void processOtherEvent(Sim_event sim_event) {
        switch (sim_event.get_tag()) {
            case 33: 
            case 34: {
                this.handleCreateReservation(sim_event);
                break;
            }
            case 31: {
                this.handleCommitOnly(sim_event);
                break;
            }
            case 32: {
                this.handleCommitReservation(sim_event);
                break;
            }
            case 35: {
                this.handleCancelReservation(sim_event);
                break;
            }
            case 38: {
                this.handleQueryReservation(sim_event);
                break;
            }
            case 39: {
                this.handleModifyReservation(sim_event);
                break;
            }
            case 36: 
            case 37: {
                this.handleQueryTime(sim_event);
                break;
            }
            default: {
                System.out.println(super.get_name() + ".processOtherEvent(): " + "Unable to handle request from GridSimTags with " + "tag number " + sim_event.get_tag());
            }
        }
    }

    private boolean checkResourceType(int n, int n2, int n3, String string) {
        boolean bl = true;
        if (this.policyType_ != 4) {
            System.out.println(super.get_name() + " : Error - " + string + ". This resource doesn't support Advance Reservation.");
            bl = false;
            Integer n4 = new Integer(n3);
            this.getClass();
            super.send(n, 0.0, n2, (Object)new IO_data(n4, 12L, n));
        }
        return bl;
    }

    private void handleQueryReservation(Sim_event sim_event) {
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        try {
            int[] nArray = (int[])sim_event.get_data();
            int n3 = nArray[1];
            n2 = 38 + nArray[2];
            n = nArray[3];
            bl = this.checkResourceType(n, n2, 49, "can't query a reservation");
            if (!bl) {
                return;
            }
            ((ARPolicy)this.policy_).handleQueryReservation(n3, n, n2);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl && n2 != -1) {
            System.out.println(super.get_name() + " : Error - can't query a " + "new reservation.");
            super.send(n, 0.0, n2, (Object)new IO_data(new Integer(49), 12L, n));
        }
    }

    private void handleModifyReservation(Sim_event sim_event) {
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        try {
            ARObject aRObject = (ARObject)sim_event.get_data();
            n2 = 39 + aRObject.getTransactionID();
            n = aRObject.getUserID();
            bl = this.checkResourceType(n, n2, 77, "can't modify an existing reservation");
            if (!bl) {
                return;
            }
            ((ARPolicy)this.policy_).handleModifyReservation(aRObject, n, n2);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl && n2 != -1) {
            System.out.println(super.get_name() + " : Error - can't modify an " + " existing reservation.");
            super.send(n, 0.0, n2, (Object)new IO_data(new Integer(75), 12L, n));
        }
    }

    private void handleQueryTime(Sim_event sim_event) {
        long[] lArray;
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        try {
            lArray = (long[])sim_event.get_data();
            long l = lArray[0];
            long l2 = lArray[1];
            n = (int)lArray[3];
            n2 = sim_event.get_tag() + (int)lArray[2];
            if (this.policyType_ != 4) {
                bl = false;
            } else {
                bl = true;
                if (sim_event.get_tag() == 37) {
                    ((ARPolicy)this.policy_).handleQueryFreeTime(l, l2, n, n2);
                } else if (sim_event.get_tag() == 36) {
                    ((ARPolicy)this.policy_).handleQueryBusyTime(l, l2, n, n2);
                }
            }
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl && n2 != -1) {
            System.out.println(super.get_name() + " : Error - can't list busy" + " or free reservation time.");
            lArray = null;
            this.getClass();
            super.send(n, 0.0, n2, (Object)new IO_data(lArray, 12L, n));
        }
    }

    private void handleCancelReservation(Sim_event sim_event) {
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        try {
            int[] nArray = (int[])sim_event.get_data();
            int n3 = nArray[1];
            int n4 = nArray[2];
            n = nArray[3];
            int n5 = nArray[0];
            n2 = 35 + n4;
            bl = this.checkResourceType(n, n2, 54, "can't cancel a reservation");
            if (!bl) {
                return;
            }
            if (bl && n5 != -1) {
                ((ARPolicy)this.policy_).handleCancelReservation(n3, n, n5, n2);
            } else if (bl && n5 == -1) {
                ((ARPolicy)this.policy_).handleCancelReservation(n3, n, n2);
            }
        }
        catch (ClassCastException classCastException) {
            this.handleCancelList(sim_event);
            return;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl && n2 != -1) {
            System.out.println(super.get_name() + " : Error - can't cancel a " + "new reservation.");
            super.send(n, 0.0, n2, (Object)new IO_data(new Integer(55), 12L, n));
        }
    }

    private void handleCancelList(Sim_event sim_event) {
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        try {
            Object[] objectArray = (Object[])sim_event.get_data();
            int n3 = (Integer)objectArray[0];
            ArrayList arrayList = (ArrayList)objectArray[1];
            int n4 = (Integer)objectArray[2];
            n2 = (Integer)objectArray[3];
            n = 35 + n4;
            bl = this.checkResourceType(n2, n, 54, "can't cancel a reservation");
            if (arrayList == null) {
                bl = false;
            }
            if (bl) {
                ((ARPolicy)this.policy_).handleCancelReservation(n3, n2, arrayList, n);
            }
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl && n != -1) {
            System.out.println(super.get_name() + " : Error - can't cancel a " + "new reservation.");
            super.send(n2, 0.0, n, (Object)new IO_data(new Integer(55), 12L, n2));
        }
    }

    private void handleCommitOnly(Sim_event sim_event) {
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        try {
            int[] nArray = (int[])sim_event.get_data();
            n2 = 31 + nArray[2];
            n = nArray[3];
            bl = this.checkResourceType(n, n2, 64, "can't commit a reservation");
            if (!bl) {
                return;
            }
            ((ARPolicy)this.policy_).handleCommitOnly(nArray[1], n, n2);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl && n2 != -1) {
            System.out.println(super.get_name() + " : Error - can't commit a " + "reservation.");
            super.send(n, 0.0, n2, (Object)new IO_data(new Integer(65), 12L, n));
        }
    }

    private void handleCommitReservation(Sim_event sim_event) {
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        try {
            Object[] objectArray = (Object[])sim_event.get_data();
            int n3 = (Integer)objectArray[0];
            int n4 = (Integer)objectArray[2];
            n = (Integer)objectArray[3];
            n2 = 32 + n4;
            bl = this.checkResourceType(n, n2, 64, "can't commit a reservation");
            if (!bl) {
                return;
            }
            bl = this.selectCommitMethod(objectArray[1], n3, n, n2);
        }
        catch (ClassCastException classCastException) {
            bl = false;
            classCastException.printStackTrace();
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl && n2 != -1) {
            System.out.println(super.get_name() + " : Error - can't commit a" + " reservation.");
            super.send(n, 0.0, n2, (Object)new IO_data(new Integer(65), 12L, n));
        }
    }

    private boolean selectCommitMethod(Object object, int n, int n2, int n3) {
        boolean bl = true;
        try {
            Gridlet gridlet = (Gridlet)object;
            if (this.checkGridlet(gridlet)) {
                ((ARPolicy)this.policy_).handleCommitReservation(n, n2, n3, gridlet);
            } else {
                bl = false;
            }
        }
        catch (ClassCastException classCastException) {
            try {
                GridletList gridletList = (GridletList)object;
                Gridlet gridlet = null;
                for (int i = 0; i < gridletList.size(); ++i) {
                    gridlet = (Gridlet)gridletList.get(i);
                    if (this.checkGridlet(gridlet)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    ((ARPolicy)this.policy_).handleCommitReservation(n, n2, n3, gridletList);
                }
            }
            catch (ClassCastException classCastException2) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private boolean checkGridlet(Gridlet gridlet) {
        if (gridlet.isFinished()) {
            System.out.println(super.get_name() + ": Error - Gridlet #" + gridlet.getGridletID() + " for User #" + gridlet.getUserID() + " is already finished.");
            return false;
        }
        gridlet.setResourceParameter(super.get_id(), this.resource_.getCostPerSec());
        return true;
    }

    private void handleCreateReservation(Sim_event sim_event) {
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        try {
            ARObject aRObject = (ARObject)sim_event.get_data();
            n = aRObject.getUserID();
            n2 = sim_event.get_tag() + aRObject.getTransactionID();
            bl = this.checkResourceType(n, n2, -8, "can't create a new reservation");
            if (!bl) {
                return;
            }
            if (sim_event.get_tag() == 33) {
                ((ARPolicy)this.policy_).handleCreateReservation(aRObject, n, n2);
            } else {
                ((ARPolicy)this.policy_).handleImmediateReservation(aRObject, n, n2);
            }
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl && n2 != -1) {
            System.out.println(super.get_name() + " : Error - can't create a" + " new reservation.");
            super.send(n, 0.0, n2, (Object)new IO_data(new Integer(-7), 12L, n));
        }
    }
}

