/*
 * Decompiled with CFR 0.152.
 */
package eduni.simdiag;

import eduni.simdiag.Linedata;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.util.ArrayList;
import java.util.List;

class GraphPanel
extends Panel {
    String xax = "X";
    String yax = "Y";
    List data = new ArrayList();
    double xmin = 0.0;
    double xmax = 1.0;
    double ymin = 0.0;
    double ymax = 1.0;
    int xoff = 40;
    int yoff = 40;
    Image offscreen;
    Dimension offscreensize = new Dimension();
    Graphics offg;

    Linedata getLine(String string) {
        int n = 0;
        while (n < this.data.size()) {
            Linedata linedata = (Linedata)this.data.get(n);
            if (string.compareTo(linedata.getName()) == 0) {
                return linedata;
            }
            ++n;
        }
        return null;
    }

    GraphPanel() {
        this.resetScale();
    }

    void resetScale() {
        this.xmin = 0.0;
        this.xmax = 1.0;
        this.ymin = 0.0;
        this.ymax = 1.0;
    }

    public int xscale(double d) {
        int n = this.getSize().width;
        return (int)((d - this.xmin) / (this.xmax - this.xmin) * (double)(n - this.xoff)) + this.xoff;
    }

    public int yscale(double d) {
        int n = this.getSize().height;
        return n - ((int)((d - this.ymin) / (this.ymax - this.ymin) * (double)(n - this.yoff)) + this.yoff);
    }

    public void clear() {
        this.data.clear();
        this.resetScale();
    }

    public void setAxes(String string, String string2) {
        this.xax = string;
        this.yax = string2;
    }

    public void setScale(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public void data(String string, double d, double d2) {
        Linedata linedata = this.getLine(string);
        if (linedata == null) {
            linedata = new Linedata(string);
            this.data.add(linedata);
        }
        linedata.add(d, d2);
        if (d > this.xmax) {
            this.xmax = d;
        }
        if (d2 > this.ymax) {
            this.ymax = d2;
        }
        if (d < this.xmin) {
            this.xmin = d;
        }
        if (d2 < this.ymin) {
            this.ymin = d2;
        }
    }

    public void display() {
        this.repaint();
    }

    double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    void drawNotches(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        boolean bl = n2 == n4;
        double d3 = d2 - d;
        double d4 = this.log10(d3);
        int n5 = (int)d4;
        double d5 = Math.pow(10.0, n5);
        if (d3 / d5 < 3.0) {
            d5 /= 2.0;
        }
        double d6 = 0.5 + d / d5;
        int n6 = (int)d6;
        double d7 = (double)n6 * d5;
        if (bl) {
            int n7 = this.yoff / 10;
            double d8 = d7;
            while (d8 <= d2) {
                int n8 = this.xscale(d8);
                String string = Double.toString(d8);
                graphics.setColor(Color.blue);
                graphics.drawLine(n8, n2, n8, n7 + n2);
                int n9 = graphics.getFontMetrics().stringWidth(string);
                int n10 = graphics.getFontMetrics().getHeight();
                graphics.drawString(string, n8 - n9 / 2, n2 + n7 + n10);
                graphics.setColor(Color.gray.brighter());
                graphics.drawLine(n8, n2, n8, 0);
                d8 += d5;
            }
        } else {
            int n11 = this.xoff / 10;
            double d9 = d7;
            while (d9 <= d2) {
                int n12 = this.yscale(d9);
                String string = Double.toString(d9);
                graphics.setColor(Color.blue);
                graphics.drawLine(n, n12, n - n11, n12);
                int n13 = graphics.getFontMetrics().stringWidth(string);
                int n14 = graphics.getFontMetrics().getHeight();
                graphics.drawString(string, n - n13 - n11, n12 + n14 / 2);
                graphics.setColor(Color.gray.brighter());
                graphics.drawLine(n, n12, this.getSize().width, n12);
                d9 += d5;
            }
        }
    }

    void drawAxes(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Color.blue);
        graphics.drawLine(this.xoff, n2 - this.yoff, n, n2 - this.yoff);
        graphics.drawLine(this.xoff, n2 - this.yoff, this.xoff, 0);
        graphics.drawString(this.xax, n / 2, n2 - this.yoff / 3);
        graphics.drawString(this.yax, this.xoff / 3, n2 / 2);
        this.drawNotches(graphics, this.xoff, n2 - this.yoff, n, n2 - this.yoff, this.xmin, this.xmax);
        this.drawNotches(graphics, this.xoff, n2 - this.yoff, this.xoff, 0, this.ymin, this.ymax);
        graphics.setColor(Color.blue.brighter());
        graphics.drawLine(this.xoff, n2 - this.yoff + 1, n, n2 - this.yoff + 1);
        graphics.drawLine(this.xoff + 1, n2 - this.yoff, this.xoff + 1, 0);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            this.offg = this.offscreen.getGraphics();
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        System.out.println("Painting " + n + " " + n2);
        this.offg.setColor(Color.lightGray.darker());
        this.offg.fillRect(0, 0, n, n2);
        this.offg.setColor(Color.lightGray);
        this.offg.fillRect(this.xoff, 0, n, n2 - this.yoff);
        this.drawAxes(this.offg);
        int n3 = 0;
        while (n3 < this.data.size()) {
            Linedata linedata = (Linedata)this.data.get(n3);
            linedata.draw(this.offg, n3, this);
            ++n3;
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }
}

