/*
 * Decompiled with CFR 0.152.
 */
package eduni.simanim;

import eduni.simanim.Anim_entity;
import eduni.simanim.Sim_anim;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class Anim_port {
    private String name;
    private int side;
    private int pos;
    private Point ppos;
    private Point lpos;
    private int w;
    private int h;
    private Anim_port link;
    private Anim_entity parent;
    private boolean primary;
    private double msg_pos;
    private String data;
    private Image image;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final String[] enum_side = new String[]{"LEFT", "RIGHT", "TOP", "BOTTOM"};

    public Anim_port(String string, String string2) {
        this.name = string;
        this.side = 1;
        this.pos = 0;
        this.link = null;
        this.parent = null;
        this.primary = false;
        this.msg_pos = -1.0;
        this.data = new String();
        this.image = Sim_anim.get_image(string2);
        this.w = this.image.getWidth(null);
        this.h = this.image.getHeight(null);
    }

    public void set_position(int n, int n2) {
        this.side = n;
        this.pos = n2;
        if (n < 0 || n > 3) {
            System.out.println("Error: Anim_port.set_position() - invalid side " + n);
            this.side = 1;
        }
        this.update_position();
    }

    static int parseSide(String string) {
        int n = 0;
        while (n < enum_side.length) {
            if (enum_side[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void update_position() {
        if (this.parent != null) {
            Dimension dimension = this.parent.get_size();
            Point point = this.parent.get_position();
            switch (this.side) {
                case 0: {
                    this.ppos = new Point(point.x - this.w, point.y + this.pos);
                    this.lpos = new Point(this.ppos.x, this.ppos.y + this.h / 2);
                    break;
                }
                case 1: {
                    this.ppos = new Point(point.x + dimension.width, point.y + this.pos);
                    this.lpos = new Point(this.ppos.x + this.w, this.ppos.y + this.h / 2);
                    break;
                }
                case 2: {
                    this.ppos = new Point(point.x + this.pos, point.y - this.w);
                    this.lpos = new Point(this.ppos.x + this.w / 2, this.ppos.y);
                    break;
                }
                case 3: {
                    this.ppos = new Point(point.x + this.pos, point.y + dimension.height);
                    this.lpos = new Point(this.ppos.x + this.w / 2, this.ppos.y + this.h);
                }
            }
        }
    }

    void link_port(Anim_port anim_port, boolean bl) {
        this.link = anim_port;
        this.primary = bl;
    }

    String get_name() {
        return this.name;
    }

    void move_msg(double d) {
        this.msg_pos = d;
    }

    void set_data(String string) {
        this.data = string;
    }

    void set_parent(Anim_entity anim_entity) {
        this.parent = anim_entity;
    }

    Anim_entity get_parent() {
        return this.parent;
    }

    Point get_link_pos() {
        return this.lpos;
    }

    Point get_port_pos() {
        return this.ppos;
    }

    public void draw_messages(Graphics graphics) {
        if (this.link != null) {
            Point point = this.link.get_link_pos();
            if (this.msg_pos >= 0.0) {
                int n = (int)((1.0 - this.msg_pos) * (double)this.lpos.x + this.msg_pos * (double)point.x);
                int n2 = (int)((1.0 - this.msg_pos) * (double)this.lpos.y + this.msg_pos * (double)point.y);
                graphics.setColor(Color.blue);
                graphics.fillRect(n, n2, 5, 5);
                graphics.setColor(Color.black);
                graphics.drawString(this.data, n, n2);
            }
        }
    }

    void draw(Graphics graphics) {
        graphics.drawImage(this.image, this.ppos.x, this.ppos.y, null);
        if (this.link != null) {
            Point point = this.link.get_link_pos();
            Anim_entity anim_entity = this.link.get_parent();
            if (anim_entity != null && !anim_entity.is_invisible() && this.primary) {
                graphics.setColor(Color.blue);
                graphics.drawLine(this.lpos.x, this.lpos.y, point.x, point.y);
            }
        }
    }
}

