/*
 * Title:        Visual Modeler for GridSim Toolkit
 * Description:  This Visual Modeler enables the user to quickly create
 *               experiments on different Grid testbeds and generate the
 *               default Grid Broker source codes (in Java).
 *
 * $Id: VisualModeler.java,v 1.6 2003/12/14 00:54:25 anthony Exp $
 */

package visualmodeler;

import java.awt.BorderLayout;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import java.util.Observer;
import java.util.Observable;


/**
 * VisualModeler setups the main frame for the visual modeler
 *
 * @author       Anthony Sulistio and Chee Shin Yeo
 * @version      1.1
 * @invariant $none
 */
public class VisualModeler extends JFrame implements WindowListener
{
    //private TreeView treeView_;
    private MenuView menuView_;
    private IconView iconView_;
    private DisplayView displayView_;

    // the models for the system;
    private UserModel userModel_;
    private ResourceModel resModel_;
    private FileModel fileModel_;


    /**
     * Constructs the main frame of Visual Modeler program
     * @pre $none
     * @post $none
     */
    public VisualModeler()
    {
        getContentPane().setLayout(new BorderLayout());
        super.setSize(570, 450);
        super.setLocation(10, 10);
        super.setTitle("Visual Modeler");

        // when user clicks the exit icon, it will automatically exit
        this.addWindowListener(this);
        super.setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);

        // setting up the model classes
        userModel_ = new UserModel();
        resModel_ = new ResourceModel();
        fileModel_ = new FileModel(this, userModel_, resModel_);

        // setting up the view or gui classes
        menuView_ = new MenuView(this, fileModel_);
        iconView_ = new IconView(this, BorderLayout.NORTH, fileModel_,
                            userModel_, resModel_);
        displayView_ = new DisplayView(this, BorderLayout.CENTER,
                            userModel_, resModel_);

        // link the models into the appropriate gui
        fileModel_.addObserver(iconView_);
        fileModel_.addObserver(menuView_);

        userModel_.addObserver(displayView_);
        userModel_.addObserver(menuView_);
        userModel_.addObserver(iconView_);

        resModel_.addObserver(displayView_);
        resModel_.addObserver(menuView_);
        resModel_.addObserver(iconView_);
    }

    /**
     * Performed when window is going to be closed
     * @param evt    a WindowEvent object
     * @pre $none
     * @post $none
     */
    public void windowClosing(WindowEvent evt)
    {
        if (fileModel_.quitProgram() == true)
        {
            dispose();
            System.exit(0);
        }
    }

    /**
     * Performed when window is closed
     * @param evt    a WindowEvent object
     * @pre $none
     * @post $none
     */
    public void windowClosed(WindowEvent evt) {
        //empty - not needed but have to due to WindowListener interface
    }

    /**
     * Performed when window is opened
     * @param evt    a WindowEvent object
     * @pre $none
     * @post $none
     */
    public void windowOpened(WindowEvent evt) {
        //empty - not needed but have to due to WindowListener interface
    }

    /**
     * Performed when window is iconified
     * @param evt    a WindowEvent object
     * @pre $none
     * @post $none
     */
    public void windowIconified(WindowEvent evt) {
        //empty - not needed but have to due to WindowListener interface
    }

    /**
     * Performed when window is deiconified
     * @param evt    a WindowEvent object
     * @pre $none
     * @post $none
     */
    public void windowDeiconified(WindowEvent evt) {
        //empty - not needed but have to due to WindowListener interface
    }

    /**
     * Performed when window is activated
     * @param evt    a WindowEvent object
     * @pre $none
     * @post $none
     */
    public void windowActivated(WindowEvent evt) {
        //empty - not needed but have to due to WindowListener interface
    }

    /**
     * Performed when window is deactivated
     * @param evt    a WindowEvent object
     * @pre $none
     * @post $none
     */
    public void windowDeactivated(WindowEvent evt) {
        //empty - not needed but have to due to WindowListener interface
    }

    /**
     * Main method to execute Visual Modeler program
     * @param args  the number of arguments (if any)
     * @pre  $none
     * @post $none
     */
    public static void main(String args[])
    {
        String platform = "";
        String windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

        try
        {
            platform = UIManager.getSystemLookAndFeelClassName();
            if (platform.equals(windows) == true) {
                UIManager.setLookAndFeel(platform);
            }
            else
            {
                UIManager.setLookAndFeel(
                    UIManager.getCrossPlatformLookAndFeelClassName() );
            }

            VisualModeler window = new VisualModeler();
            window.setVisible(true);
        }
        catch(Exception e)
        {
            System.out.println("Exception occurs. Quit Program");
            e.printStackTrace();
        }
    }

} // end class

