/*
 * Title:        Visual Modeler for GridSim Toolkit
 * Description:  This Visual Modeler enables the user to quickly create
 *               experiments on different Grid testbeds and generate the
 *               default Grid Broker source codes (in Java).
 *
 * $Id: MenuAbout.java,v 1.6 2003/06/20 12:45:45 anthony Exp $
 */

package visualmodeler;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;


/**
 * MenuAbout setups About Dialog box
 *
 * @author       Anthony Sulistio and Chee Shin Yeo
 * @version      1.1
 * @invariant $none
 */
public class MenuAbout extends JDialog implements ActionListener
{
    /**
     * Constructs the About Dialog box
     * @param parent   Parent frame of about dialog box
     * @pre parent != null
     * @post $none
     */
    public MenuAbout(JFrame parent)
    {
        super(parent, true);
        super.setSize(300, 470);   // width and height
        super.setLocation(150, 150);
        super.setTitle("About Visual Modeler");

        initComponents();
    }

    /**
     * Action to be performed when event is triggered
     * @param evt   an action event
     * @pre evt != null
     * @post $none
     */
    public void actionPerformed(ActionEvent evt) {
        dispose();
    }


    //////////////////////////////// PRIVATE METHODS /////////////////////////

    /**
     * This method is called from within the constructor to
     * initialize the form
     * @pre $none
     * @post $none
     */
    private void initComponents()
    {
        Font font = new Font(null, Font.BOLD, 11);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        getContentPane().setLayout(gridbag);

        ImageIcon icon = null;
        String dir = "";
        try 
        {
            dir = System.getProperty("user.dir") + "/image/";
            icon = new ImageIcon(dir + "gridbus.gif");

            // If the user decided to run Visual Modeler directly from jar file
            // then look the images inside the file
            if (icon.getIconWidth() == -1)
            {
                // get the location from jar file
                URL url = super.getClass().getResource("image/gridbus.gif"); 
                Image image = Toolkit.getDefaultToolkit().getImage(url); 
                icon.setImage(image);
            }

        }
        catch (Exception e) 
        {
            System.out.println(
                    "VisualModeler : Error - Can't find image files.");
        }

        int index = 1;
        c.gridy = index++;
        c.insets = new Insets(25, 0, 25, 0);  // add gap to the top & buttom
        JLabel label = new JLabel(icon);
        getContentPane().add(label, c);

        c.gridy = index++;
        c.insets = new Insets(0, 0, 0, 0);
        label = new JLabel("Grid Computing and Distributed Systems");
        label.setFont(font);
        getContentPane().add(label, c);

        c.gridy = index++;
        label = new JLabel("(GRIDS) Laboratory");
        label.setFont(font);
        getContentPane().add(label, c);

        c.gridy = index++;
        c.insets = new Insets(15, 0, 0, 0);  // add gap to the top & buttom
        getContentPane().add(new JLabel(
                "School of Computer Science and Software Engineering"), c);

        c.gridy = index++;
        c.insets = new Insets(0, 0, 0, 0);
        getContentPane().add(new JLabel(
                "The University of Melbourne, Australia"), c);

        /////////
        c.gridy = index++;
        c.insets = new Insets(20, 0, 0, 0);  // add gap to the top
        label = new JLabel("Developers");
        label.setFont(font);
        getContentPane().add(label, c);

        c.gridy = index++;
        c.insets = new Insets(0, 0, 0, 0);  // reset
        getContentPane().add(new JLabel("Anthony Sulistio"), c);

        c.gridy = index++;
        getContentPane().add(new JLabel("Chee Shin Yeo"), c);


        c.gridy = index++;
        c.insets = new Insets(25, 0, 0, 0);  // add gap to the top
        getContentPane().add(new JLabel("Version: 1.1"), c);

        c.gridy = index++;
        c.insets = new Insets(0, 0, 0, 0);  // reset
        getContentPane().add(new JLabel("Date: June 2003"), c);

        c.gridy = index++;
        c.insets = new Insets(25, 0, 0, 0);  // add gap to the top
        label = new JLabel("Acknowledgements");
        label.setFont(font);
        getContentPane().add(label, c);

        c.gridy = index++;
        c.insets = new Insets(0, 0, 0, 0);  // reset
        getContentPane().add(new JLabel("Dr. Rajkumar Buyya"), c);

        c.gridy = index++;
        getContentPane().add(new JLabel("Mr. Zhao Hui Koh"), c);

        c.gridy = index++;
        getContentPane().add(new JLabel("Mr. Rod Farmer"), c);

        c.gridy = index++;
        c.weighty = 1;
        JButton button = new JButton("Close");
        button.addActionListener(this);
        getContentPane().add(button, c);
    }

} // end class

