/*
 * Title:        GridSim Toolkit
 * Description:  GridSim (Grid Simulation) Toolkit for Modeling and Simulation 
 *               of Parallel and Distributed Systems such as Clusters and Grids
 * Licence:      GPL - http://www.gnu.org/copyleft/gpl.html
 *
 * $Id: Sim_from_port.java,v 1.6 2003/12/13 15:54:12 anthony Exp $
 */

package gridsim;

import eduni.simjava.*;

/**
 * This class creates a new Sim_predicate to evaluate whether an event is
 * coming through a specific port.
 *
 * @author       Manzur Murshed and Rajkumar Buyya
 * @version      2.2, December 2003
 * @invariant $none
 */
public class Sim_from_port extends Sim_predicate
{
    private Sim_port port_;

    /**
     * Allocates a new Sim_from_port object
     * @param port an object of Sim_port
     * @see eduni.simjava.Sim_port
     * @pre port != null
     * @post $none
     */
    public Sim_from_port(Sim_port port)
    {
        super();
        this.port_ = port;
    }

    /**
     * Matches a given <tt>Sim_event</tt> object with the one from
     * the port.
     * @param event an object of Sim_event
     * @return <tt>true</tt> if the event was scheduled through the port
     * @see eduni.simjava.Sim_event
     * @pre event != null
     * @post $result == true || $result == false
     */
    public boolean match(Sim_event event) {
        return event.from_port(port_);
    }
    
} // end class

