/*
 * Title:        GridSim Toolkit
 * Description:  GridSim (Grid Simulation) Toolkit for Modeling and Simulation 
 *               of Parallel and Distributed Systems such as Clusters and Grids
 * Licence:      GPL - http://www.gnu.org/copyleft/gpl.html
 *
 * $Id: ResGridletList.java,v 1.6 2003/12/13 15:54:12 anthony Exp $
 */

package gridsim;

import java.util.LinkedList;


/**
 * GridSim ResGridletList maintains a linked-list of Gridlet 
 *
 * @author       Manzur Murshed and Rajkumar Buyya
 * @version      2.2, December 2003
 * @invariant $none
 */
public class ResGridletList extends LinkedList
{
    /**
     * Allocates a new ResGridletList object
     * @pre $none
     * @post $none
     */
    public ResGridletList() {
        super();
    }

    /**
     * Move a ResGridlet object from this linked-list into a specified one
     * @param obj a ResGridlet object to be moved
     * @param list a ResGridletList object to store the new ResGridlet object
     * @return <b>true</b> if the moving operation successful, 
     *         otherwise return <b>false</b>
     * @pre obj != null
     * @pre list != null
     * @post $result == true || $result == false
     */
    public boolean move(ResGridlet obj, ResGridletList list)
    {
        if (super.remove(obj))
        {
            list.add(obj);
            return true;
        }
        
        return false;
    }
    
} // end class
