/*
 * Title:        GridSim Toolkit
 * Description:  GridSim (Grid Simulation) Toolkit for Modeling and Simulation 
 *               of Parallel and Distributed Systems such as Clusters and Grids
 * Licence:      GPL - http://www.gnu.org/copyleft/gpl.html
 *
 * $Id: IO_data.java,v 1.8 2003/12/13 15:54:12 anthony Exp $
 */

package gridsim;

/**
 * Class relates to a communication between user entities and resources
 *
 * @author       Manzur Murshed and Rajkumar Buyya
 * @version      2.2, December 2003
 * @invariant $none
 */
public class IO_data
{
    private Object data_;
    private long byteSize_;
    private int destID_;
    

    /**
     * Allocates a new IO_data object
     * @param data         the data object
     * @param byteSize     the size of a data (in bytes)
     * @param destID       the destination ID
     * @pre data != null
     * @pre byteSize >= 0
     * @pre destID >= 0
     * @post $none
     */
    public IO_data(Object data, long byteSize, int destID)
    {
        this.data_ = data;
        this.byteSize_ = byteSize;
        this.destID_ = destID;
    }

    /**
     * Gets the Object data
     * @return the Object data
     * @deprecated As of GridSim 2.1, replaced by {@link #getData()}
     * @pre $none
     * @post $result != null
     */
    public Object get_data() {
        return this.getData();
    }
    
    /**
     * Gets the Object data
     * @return the Object data
     * @pre $none
     * @post $result != null
     */
    public Object getData() {
        return data_;
    }

    /**
     * Gets the size of a data
     * @return the data size
     * @deprecated As of GridSim 2.1, replaced by {@link #getByteSize()}
     * @pre $none
     * @post $result >= 0
     */
    public long get_byte_size() {
        return this.getByteSize();
    }
    
    /**
     * Gets the size of a data
     * @return the data size
     * @pre $none
     * @post $result >= 0
     */
    public long getByteSize() {
        return byteSize_;
    }

    /**
     * Gets the destination ID
     * @return the destination ID
     * @deprecated As of GridSim 2.1, replaced by {@link #getDestID()}
     * @pre $none
     * @post $result >= 0
     */
    public int get_dest_id() {
        return this.getDestID();
    }
    
    /**
     * Gets the destination ID
     * @return the destination ID
     * @pre $none
     * @post $result >= 0
     */
    public int getDestID() {
        return destID_;
    }

} // end class

