/*
 * Title:        GridSim Toolkit
 * Description:  GridSim (Grid Simulation) Toolkit for Modeling and Simulation 
 *               of Parallel and Distributed Systems such as Clusters and Grids
 * Licence:      GPL - http://www.gnu.org/copyleft/gpl.html
 *
 * $Id: GridletList.java,v 1.7 2003/12/13 15:54:12 anthony Exp $
 */

package gridsim;

import java.util.*;

/**
 * Gridsim GridletList class is used to maintain a list of Gridlets 
 * (in linked-list) and support methods for organizing them
 *
 * @author       Manzur Murshed and Rajkumar Buyya
 * @version      2.2, December 2003
 * @invariant $none
 */
public class GridletList extends LinkedList
{
    /**
     * Allocates a new GridletList object
     * @pre $none
     * @post $none
     */
    public GridletList() {
        super();
    }

    /**
     * Sorts the Gridlets in a list based on their lengths 
     * @pre $none
     * @post $none
     */
    public void sort() {
        Collections.sort( this, new OrderLength() );
    }

    
    ///////////// INTERNAL CLASS //////////////////////////////
    
    /**
     * A class that compares the order of Gridlet length
     * @invarian $none
     */
    private class OrderLength implements Comparator
    {
        /**
         * Allocates a new OrderLength object
         * @pre $none
         * @post $none
         */
        public OrderLength() {
            super();
        }
        
        /**
         * Compares two objects
         * @param a     the first Object to be compared
         * @param b     the second Object to be compared
         * @return the value 0 if both Objects are numerically equal; 
         *         a value less than 0 if the first Object is 
         *         numerically less than the second Object; 
         *         and a value greater than 0 if the first Object is 
         *         numerically greater than the second Object. 
         * @throws ClassCastException   <tt>a</tt> and <tt>b</tt> are expected
         *              to be of type <tt>Gridlet</tt>
         * @pre a != null
         * @pre b != null
         * @post $none
         */
        public int compare(Object a, Object b) throws ClassCastException
        {
            Double jla = new Double( ((Gridlet) a).getGridletLength() );
            Double jlb = new Double( ((Gridlet) b).getGridletLength() );
            
            return jla.compareTo(jlb);
        }
        
    } // end internal class
    
} // end class

