/*
 * Title:        GridSim Toolkit
 * Description:  GridSim (Grid Simulation) Toolkit for Modeling and Simulation
 *               of Parallel and Distributed Systems such as Clusters and Grids
 * Licence:      GPL - http://www.gnu.org/copyleft/gpl.html
 *
 * $Id: GridSimTags.java,v 1.14 2003/12/13 16:01:06 anthony Exp $
 */

package gridsim;

/**
 * Contains various static command tags that indicate a type of action that
 * needs to be undertaken by GridSim entities when they receive events.
 *
 * @author       Manzur Murshed and Rajkumar Buyya
 * @version      2.2, December 2003
 * @invariant $none
 */
public class GridSimTags
{
    /** Schedules an entity without any delay */
    public static final double SCHEDULE_NOW = 0.0;

    /** Denotes the end of simulation */
    public static final int END_OF_SIMULATION = -1;

    /**
     * Denotes insignificant simulation entity or time. This tag will not be
     * used for identification purposes.
     */
    public static final int INSIGNIFICANT = 0;

    /** Sends an Experiment object between UserEntity and Broker entity */
    public static final int EXPERIMENT = 1;

    /**
     * Denotes a resource to be registered. This tag is normally used between
     * GridInformationService and GridResouce entity.
     */
    public static final int REGISTER_RESOURCE = 2;

    /**
     * Denotes a list of resources. This tag is normally used between
     * GridInformationService and GridSim entity.
     */
    public static final int RESOURCE_LIST = 3;

    /**
     * Denotes grid resource characteristics information. This tag is normally
     * used between GridSim and GridResource entity.
     */
    public static final int RESOURCE_CHARACTERISTICS = 4;

    /**
     * Denotes grid resource allocation policy. This tag is normally
     * used between GridSim and GridResource entity.
     */
    public static final int RESOURCE_DYNAMICS = 5;

    /**
     * Denotes the return of a Gridlet back to sender. This tag is
     * normally used by GridResource entity.
     */
    public static final int GRIDLET_RETURN = 6;

    /**
     * Denotes the submission of a Gridlet. This tag is normally
     * used between GridSim User and GridResource entity.
     */
    public static final int GRIDLET_SUBMIT = 7;

    /**
     * Denotes the submission of a Gridlet with an acknowledgement.
     * This tag is normally used between GridSim User and GridResource entity.
     */
    public static final int GRIDLET_SUBMIT_ACK = 8;

    /** Cancels a Gridlet submitted in the GridResource entity */
    public static final int GRIDLET_CANCEL = 9;

    /** Denotes the status of a Gridlet. */
    public static final int GRIDLET_STATUS = 10;

    /** Pauses a Gridlet submitted in the GridResource entity */
    public static final int GRIDLET_PAUSE = 11;

    /** Pauses a Gridlet submitted in the GridResource entity with an
     * acknowledgement
     */
    public static final int GRIDLET_PAUSE_ACK = 12;

    /** Resumes a Gridlet submitted in the GridResource entity */
    public static final int GRIDLET_RESUME = 13;

    /** Resumes a Gridlet submitted in the GridResource entity with an
     * acknowledgement
     */
    public static final int GRIDLET_RESUME_ACK = 14;

    /** Moves a Gridlet to another GridResource entity */
    public static final int GRIDLET_MOVE = 15;

    /** Moves a Gridlet to another GridResource entity with an acknowledgement
     */
    public static final int GRIDLET_MOVE_ACK = 16;

    /**
     * Denotes a request to record events for statistical purposes. This tag is
     * normally used between GridSim and GridStatistics entity.
     */
    public static final int RECORD_STATISTICS = 17;

    /** Denotes a request to get a statistical list */
    public static final int RETURN_STAT_LIST = 18;

    /**
     * Denotes a request to send an Accumulator object based on category into
     * an event scheduler. This tag is normally used between ReportWriter and
     * GridStatistics entity.
     */
    public static final int RETURN_ACC_STATISTICS_BY_CATEGORY = 19;

    /** Denotes the default baud rate for some GridSim entities */
    public static final int DEFAULT_BAUD_RATE = 9600;


    /**
     * Private Constructor
     */
    private GridSimTags() {
        // empty
    }

} // end class

