/*
 * Decompiled with CFR 0.152.
 */
package gridbroker;

import gridsim.Accumulator;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.GridletList;
import gridsim.ResourceCharacteristics;

public class BrokerResource {
    public ResourceCharacteristics resource;
    public double LatestLoad;
    public GridletList glList;
    public int NoOfGridletsFinishedSoFar;
    public int NoOfGridletsDispatchedSoFar;
    public double ProcessingExpensesSoFar;
    public static final int PARAM_GRIDLETS_ON_RESOURCE = 1;
    public static final int PARAM_GRIDLETS_COMMITTED_FOR_RESOURCE = 2;
    public static final int PARAM_GRIDLETS_FINISHED = 3;
    public static final int PARAM_PROCESSING_EXPENSES = 4;
    private double availableMIPS_;
    private double availableMIPS_PrevSchedule_;

    public BrokerResource(ResourceCharacteristics resourceCharacteristics, double d) {
        this.resource = resourceCharacteristics;
        this.LatestLoad = d;
        this.glList = new GridletList();
        try {
            this.availableMIPS_ = this.resource.getMIPSRating();
        }
        catch (Exception exception) {
            this.availableMIPS_ = 0.0;
        }
        this.availableMIPS_PrevSchedule_ = this.availableMIPS_;
        this.NoOfGridletsFinishedSoFar = 0;
        this.NoOfGridletsDispatchedSoFar = 0;
        this.ProcessingExpensesSoFar = 0.0;
    }

    public double GetParameterValue(int n) {
        return this.getParameterValue(n);
    }

    public double getParameterValue(int n) {
        double d = -1.0;
        switch (n) {
            case 1: {
                d = this.getNumGridletInQueue() + this.getNumGridletInExec();
                break;
            }
            case 2: {
                d = this.getNumGridletCommitted();
                break;
            }
            case 3: {
                d = this.NoOfGridletsFinishedSoFar;
                break;
            }
            case 4: {
                d = this.ProcessingExpensesSoFar;
                break;
            }
        }
        return d;
    }

    public double GetAvailableMIPS() {
        return this.getAvailableMIPS();
    }

    public double getAvailableMIPS() {
        return this.availableMIPS_;
    }

    public double GetAvailableMIPS_PreviousSchedule() {
        return this.getAvailableMIPS_PreviousSchedule();
    }

    public double getAvailableMIPS_PreviousSchedule() {
        return this.availableMIPS_PrevSchedule_;
    }

    public void SetAvailableMIPS_PreviousSchedule() {
        this.setAvailableMIPS_PreviousSchedule();
    }

    public void setAvailableMIPS_PreviousSchedule() {
        this.availableMIPS_PrevSchedule_ = this.availableMIPS_;
    }

    public double ResourceShareVariation() {
        return this.getResourceShareVariation();
    }

    public double getResourceShareVariation() {
        double d = 0.0;
        if (this.availableMIPS_PrevSchedule_ != 0.0) {
            d = this.availableMIPS_ / this.availableMIPS_PrevSchedule_;
        }
        return d;
    }

    public void UpdateAvailableMIPS(Gridlet gridlet, int n) {
        this.updateAvailableMIPS(gridlet, n);
    }

    public void updateAvailableMIPS(Gridlet gridlet, int n) {
        double d = gridlet.getWallClockTime();
        double d2 = 0.0;
        if (d != 0.0) {
            d2 = gridlet.getGridletLength() / d;
        }
        int n2 = this.resource.getNumPE();
        double d3 = 0.0;
        if (n2 > 0) {
            d3 = Math.max(1.0, (double)((this.getNumGridletInExec() + 1) / n2));
        }
        d3 = Math.min(d3, (double)n);
        this.availableMIPS_ = d2 * d3 * (double)n2;
    }

    public void UpdateAvailableMIPSDuringSchedule() {
        this.updateAvailableMIPSDuringSchedule();
    }

    public void updateAvailableMIPSDuringSchedule() {
        this.availableMIPS_PrevSchedule_ = this.availableMIPS_;
    }

    public double GetAvailableMIPSPerPE() {
        return this.getAvailableMIPSPerPE();
    }

    public double getAvailableMIPSPerPE() {
        double d = 0.0;
        int n = this.resource.getNumPE();
        if (n > 0) {
            d = this.availableMIPS_ / (double)n;
        }
        return d;
    }

    public double FirstAvailableSlotTime() {
        return this.getFirstAvailableSlotTime();
    }

    public double getFirstAvailableSlotTime() {
        double d;
        int n = this.resource.getNumPE();
        int n2 = 0;
        if (n > 0) {
            n2 = this.getNumGridletCommitted() / n;
        }
        Accumulator accumulator = this.getUnFinishedGridletLengthAccumulator();
        double d2 = 0.0;
        if (accumulator.getCount() != 0 && (d = this.getAvailableMIPSPerPE()) > 0.0) {
            d2 = accumulator.getMean() / d;
        }
        d = (double)n2 * d2;
        return d;
    }

    public double ExpectedCompletionTime(Gridlet gridlet) {
        return this.getExpectedCompletionTime(gridlet);
    }

    public double getExpectedCompletionTime(Gridlet gridlet) {
        double d = this.getAvailableMIPSPerPE();
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = this.getFirstAvailableSlotTime() + gridlet.getGridletLength() / d;
        }
        return d2;
    }

    public Accumulator GetUnFinishedGridletsLengthAccumulator() {
        return this.getUnFinishedGridletLengthAccumulator();
    }

    public Accumulator getUnFinishedGridletLengthAccumulator() {
        Accumulator accumulator = new Accumulator();
        for (int i = 0; i < this.glList.size(); ++i) {
            int n = ((Gridlet)this.glList.get(i)).getGridletStatus();
            if (n != 1 && n != 2 && n != 3) continue;
            accumulator.add(((Gridlet)this.glList.get(i)).getGridletLength());
        }
        return accumulator;
    }

    public double RemainingTimePeriodFromNow(double d) {
        return this.getRemainingTimePeriod(d);
    }

    public double getRemainingTimePeriod(double d) {
        return d - GridSim.clock();
    }

    public boolean IsSufficientMIAvailableOnSinglePE(Gridlet gridlet, double d) {
        return this.isSufficientMIAvailableOnSinglePE(gridlet, d);
    }

    public boolean isSufficientMIAvailableOnSinglePE(Gridlet gridlet, double d) {
        double d2 = gridlet.getGridletLength();
        double d3 = this.getRemainingTimePeriod(d);
        double d4 = this.getAvailableMIPSPerPE() * d3;
        return d4 >= d2;
    }

    public double GetAvailableMI(double d) {
        return this.getAvailableMI(d);
    }

    public double getAvailableMI(double d) {
        double d2 = this.getRemainingTimePeriod(d);
        double d3 = this.availableMIPS_ * d2;
        Gridlet gridlet = null;
        for (int i = 0; i < this.glList.size(); ++i) {
            gridlet = (Gridlet)this.glList.get(i);
            if (gridlet.getGridletStatus() == 1) continue;
            d3 -= gridlet.getGridletLength();
        }
        return d3;
    }

    public int NoOfGridletsCommitted() {
        return this.getNumGridletCommitted();
    }

    public int getNumGridletCommitted() {
        int n = this.getNumGridletInReady() + this.getNumGridletInQueue() + this.getNumGridletInExec();
        return n;
    }

    public int NoOfGridletsInReady() {
        return this.getNumGridletInReady();
    }

    public int getNumGridletInReady() {
        return this.getNumGridlet(1);
    }

    public int NoOfGridletsInQueue() {
        return this.getNumGridletInQueue();
    }

    public int getNumGridletInQueue() {
        return this.getNumGridlet(2);
    }

    public int NoOfGridletsInExec() {
        return this.getNumGridletInExec();
    }

    public int getNumGridletInExec() {
        return this.getNumGridlet(3);
    }

    public double ExpectedProcessingCost(Gridlet gridlet) {
        return this.getExpectedProcessingCost(gridlet);
    }

    public double getExpectedProcessingCost(Gridlet gridlet) {
        double d = gridlet.getGridletLength() * this.resource.getCostPerMI();
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    private int getNumGridlet(int n) {
        int n2 = 0;
        Gridlet gridlet = null;
        for (int i = 0; i < this.glList.size(); ++i) {
            gridlet = (Gridlet)this.glList.get(i);
            if (gridlet.getGridletStatus() != n) continue;
            ++n2;
        }
        return n2;
    }
}

