/*
 * Decompiled with CFR 0.152.
 */
package gridbroker;

import eduni.simjava.Sim_event;
import eduni.simjava.Sim_predicate;
import gridbroker.BrokerResource;
import gridbroker.Experiment;
import gridsim.Accumulator;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.GridletList;
import gridsim.ResourceCharacteristics;
import gridsim.Sim_from_port;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class Broker
extends GridSim {
    private Experiment experiment_ = null;
    private LinkedList resIDList_ = null;
    private LinkedList brokerResourceList_ = null;
    private GridletList glUnfinishedList_ = null;
    private GridletList glFinishedList_ = null;
    private int gridletDispatched_ = 0;
    private int gridletReturned_ = 0;
    private double expenses_ = 0.0;
    private int maxGridletPerPE_ = 1;

    public Broker(String string, double d) throws Exception {
        super(string, d);
    }

    public void ScheduleReport(Experiment experiment, LinkedList linkedList, boolean bl) {
        this.scheduleReport(experiment, linkedList, bl);
    }

    public void scheduleReport(Experiment experiment, LinkedList linkedList, boolean bl) {
        if (experiment.getExperimentID() != 0) {
            return;
        }
        String string = experiment.getReportFileName() + ".sched1";
        String string2 = experiment.getReportFileName() + ".sched2";
        String string3 = experiment.getReportFileName() + ".sched3";
        String string4 = experiment.getReportFileName() + ".sched31";
        this.writeScheduleReport("Gridlets Finished Report", string, 3, experiment, linkedList, bl);
        this.writeScheduleReport("Gridlets Processing Expenses Report", string2, 4, experiment, linkedList, bl);
        this.writeScheduleReport("Gridlets on Resource Report", string3, 1, experiment, linkedList, bl);
        this.writeScheduleReport("Gridlets Committed for Resource Report", string4, 2, experiment, linkedList, bl);
    }

    public void WriteScheduleReport(String string, String string2, int n, Experiment experiment, LinkedList linkedList, boolean bl) {
        this.writeScheduleReport(string, string2, n, experiment, linkedList, bl);
    }

    public void writeScheduleReport(String string, String string2, int n, Experiment experiment, LinkedList linkedList, boolean bl) {
        try {
            FileWriter fileWriter = new FileWriter(string2, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            String[] stringArray = experiment.getResourceNameList();
            int n2 = stringArray.length;
            if (bl) {
                printWriter.println(string);
                printWriter.println("Deadline: " + experiment.getDeadline() + " Budget: " + experiment.getBudget());
                printWriter.print("Time-Stamp");
                for (int i = 0; i < n2; ++i) {
                    printWriter.print("\t" + stringArray[i]);
                }
                printWriter.print("\tTotal");
                printWriter.println();
            } else {
                printWriter.print(GridSim.clock());
                double d = 0.0;
                double d2 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    BrokerResource brokerResource = this.findBrokerResourceWithName(linkedList, stringArray[i]);
                    d2 = brokerResource.getParameterValue(n);
                    printWriter.print("\t" + d2);
                    d += d2;
                }
                printWriter.print("\t" + d);
                printWriter.println();
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Broker.writeScheduleReport(): Error - unable to open \"" + string2 + "\"");
        }
    }

    public void AggregatedScheduleReport(Experiment experiment, LinkedList linkedList) {
        this.aggregatedScheduleReport(experiment, linkedList);
    }

    public void aggregatedScheduleReport(Experiment experiment, LinkedList linkedList) {
        if (experiment.getExperimentID() != 0) {
            return;
        }
        String string = experiment.getReportFileName() + ".sched4";
        String string2 = experiment.getReportFileName() + ".sched5";
        String string3 = experiment.getReportFileName() + ".sched6";
        this.writeAggregateScheduleReport("Gridlets Finished Report", string, 3, experiment, linkedList, false);
        this.writeAggregateScheduleReport("Gridlets Processing Expenses Report", string2, 4, experiment, linkedList, false);
        this.writeAggregateScheduleReport("Gridlets on Resource Report", string3, 1, experiment, linkedList, false);
    }

    public void WriteAggregateScheduleReport(String string, String string2, int n, Experiment experiment, LinkedList linkedList, boolean bl) {
        this.writeAggregateScheduleReport(string, string2, n, experiment, linkedList, bl);
    }

    public void writeAggregateScheduleReport(String string, String string2, int n, Experiment experiment, LinkedList linkedList, boolean bl) {
        try {
            FileWriter fileWriter = new FileWriter(string2, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            String[] stringArray = experiment.getResourceNameList();
            int n2 = stringArray.length;
            if (bl) {
                printWriter.println(string);
                printWriter.println("Deadline: " + experiment.getDeadline() + " Budget: " + experiment.getBudget());
                for (int i = 0; i < n2; ++i) {
                    printWriter.print("\t" + stringArray[i]);
                }
                printWriter.print("\tTotal");
                printWriter.println();
            } else {
                printWriter.print(GridSim.clock() + "\t" + experiment.getDeadline() + "\t" + experiment.getBudget());
                double d = 0.0;
                double d2 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    BrokerResource brokerResource = this.findBrokerResourceWithName(linkedList, stringArray[i]);
                    d2 = brokerResource.getParameterValue(n);
                    printWriter.print("\t" + d2);
                    d += d2;
                }
                printWriter.print("\t" + d);
                printWriter.println();
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Broker.writeAggregateScheduleReport(): Error - unable to open \"" + string2 + "\"");
        }
    }

    public void body() {
        Sim_event sim_event = new Sim_event();
        this.sim_get_next(sim_event);
        while (sim_event.get_tag() != -1) {
            if (sim_event.get_tag() != 1) {
                System.out.println(super.getEntityName() + ": A late delivery of Gridlet!");
                System.out.println("-->1. Please ensure that GridBroker waits for arrival of all Gridlets assigned to resource.");
                System.out.println("-->2. Make sure that Resources are NOT returning more Gridlets than assigned to it!");
                System.out.println(sim_event.get_data());
            } else {
                this.experiment_ = (Experiment)sim_event.get_data();
                int n = sim_event.get_src();
                this.experiment_.setStartTime();
                int n2 = 0;
                int n3 = super.get_id();
                for (n2 = 0; n2 < this.experiment_.getGridletList().size(); ++n2) {
                    ((Gridlet)this.experiment_.getGridletList().get(n2)).setUserID(n3);
                }
                this.resIDList_ = GridSim.getGridResourceList();
                super.recordStatistics("BROKER.Resource.Count", this.resIDList_.size());
                this.brokerResourceList_ = new LinkedList();
                Accumulator accumulator = new Accumulator();
                Accumulator accumulator2 = new Accumulator();
                Accumulator accumulator3 = new Accumulator();
                Accumulator accumulator4 = new Accumulator();
                for (n2 = 0; n2 < this.resIDList_.size(); ++n2) {
                    int n4 = (Integer)this.resIDList_.get(n2);
                    ResourceCharacteristics resourceCharacteristics = super.getResourceCharacteristics(n4);
                    accumulator2.add((double)resourceCharacteristics.getMIPSRatingOfOnePE());
                    accumulator.add((double)resourceCharacteristics.getMIPSRating());
                    accumulator4.add(resourceCharacteristics.getCostPerMI());
                    Accumulator accumulator5 = super.getResourceDynamicInfo(n4);
                    accumulator3.add((double)resourceCharacteristics.getMIPSRating() * (1.0 - accumulator5.getMean()));
                    this.brokerResourceList_.add(new BrokerResource(resourceCharacteristics, accumulator5.getMean()));
                }
                if (this.experiment_.getFactorFlag()) {
                    Accumulator accumulator6 = this.experiment_.getAllGridletLengthAccumulator();
                    double d = accumulator6.getSum();
                    double d2 = accumulator2.getMax();
                    double d3 = accumulator6.getMax();
                    double d4 = Math.max(d / accumulator3.getMin(), d3 / d2);
                    double d5 = Math.max(d / accumulator.getSum(), d3 / d2);
                    double d6 = d5 + this.experiment_.getDeadlineFactor() * (d4 - d5);
                    d6 += d6 * 0.1;
                    double d7 = d * accumulator4.getMax();
                    double d8 = d * accumulator4.getMin();
                    double d9 = d8 + this.experiment_.getBudgetFactor() * (d7 - d8);
                    this.experiment_.setDeadlineBudget(d6, d9);
                }
                System.out.println(super.getEntityName() + ":: Deadline: " + this.experiment_.getDeadline() + " Budget: " + this.experiment_.getBudget());
                super.recordStatistics("USER.Experiment.Deadline", this.experiment_.getDeadline());
                super.recordStatistics("USER.Experiment.Budget", this.experiment_.getBudget());
                this.glUnfinishedList_ = (GridletList)this.experiment_.getGridletList().clone();
                this.glFinishedList_ = new GridletList();
                this.gridletDispatched_ = 0;
                this.gridletReturned_ = 0;
                this.expenses_ = 0.0;
                LinkedList linkedList = (LinkedList)this.brokerResourceList_.clone();
                this.scheduleReport(this.experiment_, linkedList, true);
                this.scheduleReport(this.experiment_, linkedList, false);
                while (this.glFinishedList_.size() < this.experiment_.getGridletList().size() && !(GridSim.clock() >= this.experiment_.getDeadlineTime()) && !(this.expenses_ >= this.experiment_.getBudget())) {
                    int n5 = this.scheduleAdviser();
                    int n6 = this.dispatcher();
                    int n7 = this.gridletReceptor();
                    this.scheduleReport(this.experiment_, linkedList, false);
                    if (n7 != 0) continue;
                    double d = this.experiment_.getDeadlineTime() - GridSim.clock();
                    double d10 = Math.max(d * 0.01, 1.0);
                    super.gridSimHold(d10);
                }
                while (this.gridletDispatched_ > this.gridletReturned_) {
                    this.gridletReceptor();
                    this.scheduleReport(this.experiment_, linkedList, false);
                }
                this.aggregatedScheduleReport(this.experiment_, linkedList);
                super.send(n, 0.0, 1, (Object)this.experiment_);
            }
            this.sim_get_next(sim_event);
        }
        super.terminateIOEntities();
    }

    private BrokerResource findBrokerResourceWithName(LinkedList linkedList, String string) {
        for (int i = 0; i < linkedList.size(); ++i) {
            BrokerResource brokerResource = (BrokerResource)linkedList.get(i);
            if (string.compareTo(brokerResource.resource.getResourceName()) != 0) continue;
            return brokerResource;
        }
        return null;
    }

    private int gridletReceptor() {
        int n = 0;
        if (this.gridletDispatched_ > this.gridletReturned_) {
            do {
                Gridlet gridlet = super.gridletReceive();
                super.recordStatistics("BROKER.Gridlet.EndTime", gridlet.getGridletID());
                BrokerResource brokerResource = this.whoServed(gridlet);
                ++brokerResource.NoOfGridletsFinishedSoFar;
                brokerResource.ProcessingExpensesSoFar += gridlet.getProcessingCost();
                brokerResource.updateAvailableMIPS(gridlet, this.maxGridletPerPE_);
                brokerResource.glList.remove((Object)gridlet);
                this.glFinishedList_.add((Object)gridlet);
                ++this.gridletReturned_;
                this.expenses_ += gridlet.getProcessingCost();
                ++n;
            } while (super.sim_waiting((Sim_predicate)new Sim_from_port(this.input)) > 0);
        }
        return n;
    }

    private BrokerResource whoServed(Gridlet gridlet) {
        BrokerResource brokerResource = null;
        for (int i = 0; i < this.brokerResourceList_.size(); ++i) {
            brokerResource = (BrokerResource)this.brokerResourceList_.get(i);
            if (brokerResource.glList.contains((Object)gridlet)) break;
        }
        return brokerResource;
    }

    private double budgetOnHold() {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.brokerResourceList_.size(); ++i) {
            BrokerResource brokerResource = (BrokerResource)this.brokerResourceList_.get(i);
            for (n = 0; n < brokerResource.glList.size(); ++n) {
                Gridlet gridlet = (Gridlet)brokerResource.glList.get(n);
                n2 = gridlet.getGridletStatus();
                if (n2 != 1 && n2 != 2 && n2 != 3) continue;
                d += brokerResource.getExpectedProcessingCost(gridlet);
            }
        }
        return d;
    }

    private boolean isBudgetAvailable(Gridlet gridlet, BrokerResource brokerResource) {
        return this.expenses_ + this.budgetOnHold() + brokerResource.getExpectedProcessingCost(gridlet) <= this.experiment_.getBudget();
    }

    private double experimentRemainingBudget() {
        return this.experiment_.getBudget() - (this.expenses_ + this.budgetOnHold());
    }

    private double remainingBudgetForGridlet(Gridlet gridlet) {
        double d = this.experimentRemainingBudget();
        double d2 = 0.0;
        for (int i = 0; i < this.glUnfinishedList_.size(); ++i) {
            d2 += ((Gridlet)this.glUnfinishedList_.get(i)).getGridletLength();
        }
        double d3 = d / d2;
        return d3 * gridlet.getGridletLength();
    }

    private int scheduleAdviser() {
        int n;
        if (this.experiment_.getOptimizationStrategy() == 3) {
            n = 0;
            int n2 = 0;
            for (int i = 0; i < this.brokerResourceList_.size(); ++i) {
                BrokerResource brokerResource = (BrokerResource)this.brokerResourceList_.get(i);
                n = brokerResource.resource.getMIPSRating();
                double d = brokerResource.getAvailableMIPS_PreviousSchedule() / (double)n;
                double d2 = brokerResource.getAvailableMIPS() / (double)n;
                n2 = brokerResource.getNumGridletInReady();
                int n3 = (int)(d2 / d * (double)n2);
                int n4 = n2 - n3;
                GridletList gridletList = (GridletList)brokerResource.glList.clone();
                for (int j = 0; n4 > 0 && j < gridletList.size(); ++j) {
                    Gridlet gridlet = (Gridlet)gridletList.get(j);
                    if (gridlet.getGridletStatus() != 1) continue;
                    try {
                        gridlet.setGridletStatus(0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    brokerResource.glList.remove((Object)gridlet);
                    this.glUnfinishedList_.add((Object)gridlet);
                    --n4;
                }
                brokerResource.setAvailableMIPS_PreviousSchedule();
            }
        } else {
            for (n = 0; n < this.brokerResourceList_.size(); ++n) {
                BrokerResource brokerResource = (BrokerResource)this.brokerResourceList_.get(n);
                GridletList gridletList = (GridletList)brokerResource.glList.clone();
                for (int i = 0; i < gridletList.size(); ++i) {
                    Gridlet gridlet = (Gridlet)gridletList.get(i);
                    if (gridlet.getGridletStatus() != 1) continue;
                    try {
                        gridlet.setGridletStatus(0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    brokerResource.glList.remove((Object)gridlet);
                    this.glUnfinishedList_.add((Object)gridlet);
                }
            }
        }
        n = this.experiment_.getNumGridlet() - (this.glFinishedList_.size() + this.glUnfinishedList_.size());
        if (this.glUnfinishedList_.size() == 0) {
            return n;
        }
        this.glUnfinishedList_.sort();
        switch (this.experiment_.getOptimizationStrategy()) {
            case 0: {
                n += this.scheduleWithDBC_CostOptimisation(new OrderCost());
                break;
            }
            case 1: {
                n += this.scheduleWithDBC_CostOptimisation(new OrderCostTime());
                break;
            }
            case 2: {
                n += this.scheduleWithDBC_CostTimeOptimisation();
                break;
            }
            case 3: {
                n += this.scheduleWithDBC_TimeOptimisation();
                break;
            }
            case 4: {
                break;
            }
        }
        return n;
    }

    private int scheduleWithDBC_CostOptimisation(Comparator comparator) {
        int n = 0;
        Collections.sort(this.brokerResourceList_, comparator);
        for (int i = 0; i < this.brokerResourceList_.size() && this.glUnfinishedList_.size() > 0; ++i) {
            BrokerResource brokerResource = (BrokerResource)this.brokerResourceList_.get(i);
            double d = brokerResource.getAvailableMI(this.experiment_.getDeadlineTime());
            GridletList gridletList = (GridletList)this.glUnfinishedList_.clone();
            for (int j = 0; j < gridletList.size() && d > 0.0; ++j) {
                Gridlet gridlet = (Gridlet)gridletList.get(j);
                if (!this.isBudgetAvailable(gridlet, brokerResource) || !brokerResource.isSufficientMIAvailableOnSinglePE(gridlet, this.experiment_.getDeadlineTime())) continue;
                try {
                    gridlet.setGridletStatus(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                gridlet.setResourceParameter(brokerResource.resource.getResourceID(), brokerResource.resource.getCostPerSec());
                this.glUnfinishedList_.remove((Object)gridlet);
                brokerResource.glList.add((Object)gridlet);
                d -= gridlet.getGridletLength();
                ++n;
            }
        }
        return n;
    }

    private int scheduleWithDBC_CostTimeOptimisation() {
        int n = 0;
        Collections.sort(this.brokerResourceList_, new OrderCostTime());
        LinkedList<BrokerResource> linkedList = new LinkedList<BrokerResource>();
        for (int i = 0; this.glUnfinishedList_.size() > 0 && i < this.brokerResourceList_.size(); ++i) {
            linkedList.clear();
            BrokerResource brokerResource = (BrokerResource)this.brokerResourceList_.get(i);
            linkedList.add(brokerResource);
            while (i < this.brokerResourceList_.size() - 1 && brokerResource.resource.getCostPerMI() == ((BrokerResource)this.brokerResourceList_.get((int)(i + 1))).resource.getCostPerMI()) {
                brokerResource = (BrokerResource)this.brokerResourceList_.get(++i);
                linkedList.add(brokerResource);
            }
            LinkedList<BRGridletProcessingTime> linkedList2 = new LinkedList<BRGridletProcessingTime>();
            GridletList gridletList = (GridletList)this.glUnfinishedList_.clone();
            for (int j = 0; j < gridletList.size(); ++j) {
                int n2;
                Gridlet gridlet = (Gridlet)gridletList.get(j);
                linkedList2.clear();
                for (n2 = 0; n2 < linkedList.size(); ++n2) {
                    linkedList2.add(new BRGridletProcessingTime((BrokerResource)linkedList.get(n2), gridlet));
                }
                Collections.sort(linkedList2, new OrderBRGridletProcessingTime());
                n2 = 0;
                for (int k = 0; k < linkedList2.size() && n2 == 0; ++k) {
                    BrokerResource brokerResource2 = ((BRGridletProcessingTime)linkedList2.get((int)k)).br;
                    double d = GridSim.clock() + ((BRGridletProcessingTime)linkedList2.get((int)k)).gridlet_processing_time;
                    if (!(d <= this.experiment_.getDeadlineTime()) || !this.isBudgetAvailable(gridlet, brokerResource2)) continue;
                    try {
                        gridlet.setGridletStatus(1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    gridlet.setResourceParameter(brokerResource2.resource.getResourceID(), brokerResource2.resource.getCostPerSec());
                    this.glUnfinishedList_.remove((Object)gridlet);
                    brokerResource2.glList.add((Object)gridlet);
                    ++n;
                    n2 = 1;
                }
            }
        }
        return n;
    }

    private int scheduleWithDBC_TimeOptimisation() {
        int n = 0;
        Collections.sort(this.brokerResourceList_, new OrderCostTime());
        LinkedList<BrokerResource> linkedList = new LinkedList<BrokerResource>();
        LinkedList<BRGridletProcessingTime> linkedList2 = new LinkedList<BRGridletProcessingTime>();
        GridletList gridletList = (GridletList)this.glUnfinishedList_.clone();
        for (int i = 0; i < gridletList.size(); ++i) {
            int n2;
            Gridlet gridlet = (Gridlet)gridletList.get(i);
            linkedList2.clear();
            linkedList.clear();
            for (n2 = 0; n2 < this.brokerResourceList_.size(); ++n2) {
                BrokerResource brokerResource = (BrokerResource)this.brokerResourceList_.get(n2);
                if (!(brokerResource.getExpectedProcessingCost(gridlet) <= this.remainingBudgetForGridlet(gridlet))) continue;
                linkedList.add(brokerResource);
            }
            if (linkedList.size() <= 0) continue;
            for (n2 = 0; n2 < linkedList.size(); ++n2) {
                linkedList2.add(new BRGridletProcessingTime((BrokerResource)linkedList.get(n2), gridlet));
            }
            Collections.sort(linkedList2, new OrderBRGridletProcessingTime());
            n2 = 0;
            for (int j = 0; j < linkedList2.size() && n2 == 0; ++j) {
                BrokerResource brokerResource = ((BRGridletProcessingTime)linkedList2.get((int)j)).br;
                double d = GridSim.clock() + ((BRGridletProcessingTime)linkedList2.get((int)j)).gridlet_processing_time;
                if (!(d <= this.experiment_.getDeadlineTime())) continue;
                try {
                    gridlet.setGridletStatus(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                gridlet.setResourceParameter(brokerResource.resource.getResourceID(), brokerResource.resource.getCostPerSec());
                this.glUnfinishedList_.remove((Object)gridlet);
                brokerResource.glList.add((Object)gridlet);
                ++n;
                n2 = 1;
            }
        }
        return n;
    }

    private int dispatcher() {
        int n = 0;
        for (int i = 0; i < this.brokerResourceList_.size(); ++i) {
            BrokerResource brokerResource = (BrokerResource)this.brokerResourceList_.get(i);
            int n2 = brokerResource.resource.getNumPE();
            int n3 = brokerResource.getNumGridletInReady();
            int n4 = brokerResource.getNumGridletInExec() + brokerResource.getNumGridletInQueue();
            int n5 = 0;
            int n6 = 0;
            switch (brokerResource.resource.getResourceAllocationPolicy()) {
                case 0: {
                    n6 = n2 * this.maxGridletPerPE_ - n4;
                    n5 = Math.min(n3, n6);
                    break;
                }
                case 1: {
                    n6 = n2 * this.maxGridletPerPE_ - brokerResource.getNumGridletInQueue();
                    n5 = Math.min(n3, n6);
                    break;
                }
                case 4: {
                    break;
                }
            }
            for (int j = 0; j < brokerResource.glList.size() && n5 > 0; ++j) {
                Gridlet gridlet = (Gridlet)brokerResource.glList.get(j);
                if (gridlet.getGridletStatus() != 1) continue;
                super.gridletSubmit(gridlet, brokerResource.resource.getResourceID());
                ++brokerResource.NoOfGridletsDispatchedSoFar;
                ++this.gridletDispatched_;
                --n5;
                ++n;
            }
        }
        return n;
    }

    private class OrderBRGridletProcessingTime
    implements Comparator {
        public int compare(Object object, Object object2) {
            BRGridletProcessingTime bRGridletProcessingTime = (BRGridletProcessingTime)object;
            BRGridletProcessingTime bRGridletProcessingTime2 = (BRGridletProcessingTime)object2;
            Double d = new Double(bRGridletProcessingTime.gridlet_processing_time);
            Double d2 = new Double(bRGridletProcessingTime2.gridlet_processing_time);
            return d.compareTo(d2);
        }
    }

    private class BRGridletProcessingTime {
        public BrokerResource br;
        public double gridlet_processing_time;

        public BRGridletProcessingTime(BrokerResource brokerResource, Gridlet gridlet) {
            this.br = brokerResource;
            this.gridlet_processing_time = brokerResource.getExpectedCompletionTime(gridlet);
        }
    }

    private class OrderCostTime
    implements Comparator {
        public int compare(Object object, Object object2) throws ClassCastException {
            Double d;
            BrokerResource brokerResource = (BrokerResource)object;
            BrokerResource brokerResource2 = (BrokerResource)object2;
            Double d2 = new Double(brokerResource.resource.getCostPerMI());
            if (d2.equals(d = new Double(brokerResource2.resource.getCostPerMI()))) {
                Double d3 = new Double((double)brokerResource.resource.getMIPSRating() * (1.0 - brokerResource.LatestLoad));
                Double d4 = new Double((double)brokerResource2.resource.getMIPSRating() * (1.0 - brokerResource2.LatestLoad));
                return d4.compareTo(d3);
            }
            return d2.compareTo(d);
        }
    }

    private class OrderCost
    implements Comparator {
        public int compare(Object object, Object object2) throws ClassCastException {
            BrokerResource brokerResource = (BrokerResource)object;
            BrokerResource brokerResource2 = (BrokerResource)object2;
            Double d = new Double(brokerResource.resource.getCostPerMI());
            Double d2 = new Double(brokerResource2.resource.getCostPerMI());
            return d.compareTo(d2);
        }
    }
}

