/*
 * Decompiled with CFR 0.152.
 */
package eduni.simjava.distributions;

import eduni.simjava.distributions.ContinuousGenerator;
import eduni.simjava.distributions.Sim_normal_obj;
import eduni.simjava.distributions.Sim_parameter_exception;
import eduni.simjava.distributions.Sim_random_obj;

public class Sim_lognormal_obj
implements ContinuousGenerator {
    private Sim_random_obj source;
    private double mean;
    private double std_dev;
    private String name;

    public Sim_lognormal_obj(String string, double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_lognormal_obj: The mean and variance must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG");
        this.mean = d;
        this.std_dev = Math.sqrt(d2);
        this.name = string;
    }

    public Sim_lognormal_obj(String string, double d, double d2, long l) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_lognormal_obj: The mean and variance must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG", l);
        this.mean = d;
        this.std_dev = Math.sqrt(d2);
        this.name = string;
    }

    public double sample() {
        return Math.exp(this.mean + this.std_dev * Sim_normal_obj.sample(this.source, 0.0, 1.0));
    }

    static double sample(Sim_random_obj sim_random_obj, double d, double d2) {
        return Math.exp(d + Math.sqrt(d2) * Sim_normal_obj.sample(sim_random_obj, 0.0, 1.0));
    }

    public void set_seed(long l) {
        this.source.set_seed(l);
    }

    public long get_seed() {
        return this.source.get_seed();
    }

    public String get_name() {
        return this.name;
    }
}

