/*
 * Decompiled with CFR 0.152.
 */
package eduni.simjava;

import eduni.simanim.Sim_anim;
import eduni.simjava.Evqueue;
import eduni.simjava.Semaphore;
import eduni.simjava.Sim_any_p;
import eduni.simjava.Sim_entity;
import eduni.simjava.Sim_event;
import eduni.simjava.Sim_exception;
import eduni.simjava.Sim_none_p;
import eduni.simjava.Sim_outfile;
import eduni.simjava.Sim_output;
import eduni.simjava.Sim_port;
import eduni.simjava.Sim_predicate;
import eduni.simjava.Sim_reporter;
import eduni.simjava.Sim_reportfile;
import eduni.simjava.Sim_stat;
import eduni.simjava.distributions.Generator;
import eduni.simjava.distributions.Sim_random_obj;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.GZIPOutputStream;

public class Sim_system {
    public static final int NONE = 0;
    public static final int EVENTS_COMPLETED = 1;
    public static final int TIME_ELAPSED = 2;
    public static final int MIN_MAX = 3;
    public static final int IND_REPLICATIONS = 4;
    public static final int BATCH_MEANS = 5;
    public static final int INTERVAL_ACCURACY = 6;
    private static int term_condition = 0;
    private static int term_entity_id;
    private static int term_event_type;
    private static double term_time;
    private static double initial_term_time;
    private static long initial_term_count;
    private static long term_count;
    private static int[] term_count_bm;
    private static List term_times;
    private static long term_event_counter;
    private static long transient_term_event_count;
    private static String term_measure;
    private static double term_accuracy;
    private static int trans_condition;
    private static int trans_entity_id;
    private static int trans_event_type;
    private static double trans_time;
    private static String trans_measure;
    private static double initial_trans_time;
    private static long trans_count;
    private static long initial_trans_count;
    private static long trans_event_counter;
    private static boolean include_transient;
    private static boolean in_steady_state;
    private static int output_analysis_type;
    private static boolean incomplete;
    private static int replication_count;
    private static double confidence_level;
    private static List replications;
    private static double total_time_elapsed;
    private static double total_transient_time;
    private static int min_batches;
    private static int max_batches;
    private static Object[] run_data;
    private static int[] trace_tags;
    private static boolean default_trace;
    private static boolean entity_trace;
    private static boolean event_trace;
    private static List entities;
    private static List backup;
    private static Evqueue future;
    private static Evqueue deferred;
    private static double clock;
    private static boolean running;
    private static Semaphore onestopped;
    private static Semaphore onecompleted;
    private static Sim_output trcout;
    private static int trace_level;
    private static boolean auto_trace;
    private static boolean animation;
    private static Thread simThread;
    private static NumberFormat nf;
    private static HashMap wait_predicates;
    private static long start_date;
    private static boolean detailed_report;
    private static boolean include_seeds;
    private static List initial_seeds;
    private static long root_seed;
    private static int seed_spacing;
    private static Sim_random_obj seed_source;
    private static boolean not_sampled;
    private static boolean anim_stopped;
    private static final String suffix = ".sjg";
    private static boolean generate_graphs;
    private static String graph_file;
    private static boolean efficient_measure_defined;
    public static Sim_any_p SIM_ANY;
    public static Sim_none_p SIM_NONE;

    public Sim_system() {
        throw new Sim_exception("Attempt to instantiate Sim_system.");
    }

    public static void initialise() {
        Sim_system.initialise(new Sim_outfile(), null);
    }

    public static void initialise(Sim_anim sim_anim, Thread thread) {
        animation = true;
        Sim_system.initialise((Sim_output)sim_anim, thread);
    }

    public static void initialise(Sim_output sim_output, Thread thread) {
        if (!animation) {
            System.out.println("Initialising...");
        }
        entities = new ArrayList();
        future = new Evqueue();
        deferred = new Evqueue();
        wait_predicates = new HashMap();
        clock = 0.0;
        running = false;
        onestopped = new Semaphore(0);
        onecompleted = new Semaphore(0);
        trcout = sim_output;
        trcout.initialise();
        trace_level = 255;
        auto_trace = false;
        simThread = thread;
        nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(2);
    }

    public static NumberFormat getNumberFormat() {
        return nf;
    }

    public static double clock() {
        return clock;
    }

    public static double sim_clock() {
        return clock;
    }

    public static int get_num_entities() {
        return entities.size();
    }

    public static int get_trc_level() {
        return trace_level;
    }

    public static int get_trace_level() {
        return trace_level;
    }

    public static Sim_entity get_entity(int n) {
        if (n < 0 || n >= entities.size()) {
            throw new Sim_exception("Entity " + n + " does not exist.");
        }
        return (Sim_entity)entities.get(n);
    }

    public static Sim_entity get_entity(String string) {
        int n = entities.size();
        int n2 = 0;
        while (n2 < n) {
            Sim_entity sim_entity = (Sim_entity)entities.get(n2);
            if (string.compareTo(sim_entity.get_name()) == 0) {
                return sim_entity;
            }
            ++n2;
        }
        throw new Sim_exception("Entity " + string + " does not exist.");
    }

    public static int get_entity_id(String string) {
        int n = entities.indexOf(Sim_system.get_entity(string));
        if (n == -1) {
            throw new Sim_exception("Entity " + string + " does not exist.");
        }
        return n;
    }

    public static Sim_entity current_ent() {
        return (Sim_entity)Thread.currentThread();
    }

    public static void set_trc_level(int n) {
        auto_trace = true;
        trace_level = n;
    }

    public static void set_trace_level(int n) {
        auto_trace = true;
        trace_level = n;
    }

    public static void set_auto_trace(boolean bl) {
        auto_trace = bl;
    }

    public static void add(Sim_entity sim_entity) {
        if (running) {
            Sim_event sim_event = new Sim_event(3, clock, Sim_system.current_ent().get_id(), 0, 0, sim_entity);
            future.add_event(sim_event);
        } else if (sim_entity.get_id() == -1) {
            sim_entity.set_id(entities.size());
            entities.add(sim_entity);
        }
    }

    static synchronized void add_entity_dynamically(Sim_entity sim_entity) {
        sim_entity.set_id(entities.size());
        if (sim_entity == null) {
            throw new Sim_exception("Adding null entity.");
        }
        Sim_system.print_message("Adding: " + sim_entity.get_name());
        entities.add(sim_entity);
        sim_entity.start();
        onestopped.p();
    }

    public static void link_ports(String string, String string2, String string3, String string4) {
        Sim_entity sim_entity = Sim_system.get_entity(string);
        Sim_entity sim_entity2 = Sim_system.get_entity(string3);
        if (sim_entity == null) {
            throw new Sim_exception("Sim_system: " + string + " not found.");
        }
        if (sim_entity2 == null) {
            throw new Sim_exception("Sim_system: " + string3 + " not found.");
        }
        Sim_port sim_port = sim_entity.get_port(string2);
        Sim_port sim_port2 = sim_entity2.get_port(string4);
        if (sim_port == null) {
            throw new Sim_exception("Sim_system: " + string2 + " not found.");
        }
        if (sim_port2 == null) {
            throw new Sim_exception("Sim_system: " + string4 + " not found.");
        }
        sim_port.connect(sim_entity2);
        sim_port2.connect(sim_entity);
        if (animation) {
            ((Sim_anim)trcout).link_ports(string, string2, string3, string4);
        }
    }

    public static boolean run_tick() {
        boolean bl;
        int n = 0;
        int n2 = entities.size();
        int n3 = 0;
        while (n3 < n2) {
            Sim_entity sim_entity = (Sim_entity)entities.get(n3);
            if (sim_entity.get_state() == 0) {
                sim_entity.restart();
                ++n;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            onestopped.p();
            ++n4;
        }
        if (simThread != null) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (future.size() > 0) {
            bl = false;
            Sim_event sim_event = future.pop();
            Sim_system.process_event(sim_event);
            boolean bl2 = future.size() > 0;
            while (bl2) {
                Sim_event sim_event2 = future.top();
                if (sim_event2.event_time() == sim_event.event_time()) {
                    Sim_system.process_event(future.pop());
                    bl2 = future.size() > 0;
                    continue;
                }
                bl2 = false;
            }
        } else {
            bl = true;
            running = false;
            Sim_system.print_message("Sim_system: No more future events");
        }
        return bl;
    }

    public static void run_stop() {
        Sim_system.print_message("Simulation completed.");
        trcout.close();
    }

    public static Sim_output get_trcout() {
        return trcout;
    }

    static void paused() {
        onestopped.v();
    }

    static synchronized void hold(int n, double d) {
        Sim_event sim_event = new Sim_event(2, clock + d, n);
        future.add_event(sim_event);
        ((Sim_entity)entities.get(n)).set_state(2);
        if (auto_trace && default_trace) {
            Sim_system.trace(n, "start processing");
        }
    }

    static synchronized void pause(int n, double d) {
        Sim_event sim_event = new Sim_event(2, clock + d, n);
        future.add_event(sim_event);
        ((Sim_entity)entities.get(n)).set_state(2);
        if (auto_trace && default_trace) {
            Sim_system.trace(n, "start pausing");
        }
    }

    static synchronized void send(int n, int n2, double d, int n3, Object object) {
        if (d < 0.0) {
            throw new Sim_exception("Sim_system: Send delay can't be negative.");
        }
        Sim_event sim_event = new Sim_event(1, clock + d, n, n2, n3, object);
        if (auto_trace && (default_trace || event_trace && Sim_system.is_trace_tag(n3))) {
            Sim_system.trace(n, "scheduling event type " + n3 + " for " + ((Sim_entity)entities.get(n2)).get_name() + " with delay " + d);
        }
        future.add_event(sim_event);
    }

    static synchronized void wait(int n, Sim_predicate sim_predicate) {
        ((Sim_entity)entities.get(n)).set_state(1);
        if (sim_predicate != SIM_ANY) {
            wait_predicates.put(new Integer(n), sim_predicate);
        }
        if (auto_trace && default_trace) {
            Sim_system.trace(n, "waiting for an event");
        }
    }

    static synchronized int waiting(int n, Sim_predicate sim_predicate) {
        int n2 = 0;
        ListIterator listIterator = deferred.listIterator();
        while (listIterator.hasNext()) {
            Sim_event sim_event = (Sim_event)listIterator.next();
            if (sim_event.get_dest() != n || !sim_predicate.match(sim_event)) continue;
            ++n2;
        }
        return n2;
    }

    static synchronized void select(int n, Sim_predicate sim_predicate) {
        Sim_event sim_event = null;
        boolean bl = false;
        ListIterator listIterator = deferred.listIterator();
        while (listIterator.hasNext()) {
            sim_event = (Sim_event)listIterator.next();
            if (sim_event.get_dest() != n || !sim_predicate.match(sim_event)) continue;
            listIterator.remove();
            bl = true;
            break;
        }
        if (bl) {
            ((Sim_entity)entities.get(n)).set_evbuf((Sim_event)sim_event.clone());
            if (auto_trace && (default_trace || event_trace && Sim_system.is_trace_tag(sim_event.get_tag()))) {
                Sim_system.trace(n, "selected event type " + sim_event.get_tag() + " (event time was " + sim_event.event_time() + ")");
            }
        } else {
            ((Sim_entity)entities.get(n)).set_evbuf(null);
            if (auto_trace && default_trace) {
                Sim_system.trace(n, "no event selected");
            }
        }
    }

    static synchronized void cancel(int n, Sim_predicate sim_predicate) {
        Sim_event sim_event = null;
        boolean bl = false;
        int n2 = future.size();
        int n3 = 0;
        while (n3 < n2) {
            sim_event = (Sim_event)future.get(n3);
            if (sim_event.get_src() == n && sim_predicate.match(sim_event)) {
                future.remove(n3);
                bl = true;
                break;
            }
            ++n3;
        }
        if (bl) {
            ((Sim_entity)entities.get(n)).set_evbuf((Sim_event)sim_event.clone());
            if (auto_trace && (default_trace || event_trace && Sim_system.is_trace_tag(sim_event.get_tag()))) {
                Sim_system.trace(n, "cancelled event type " + sim_event.get_tag() + " (event time was " + sim_event.event_time() + ")");
            }
        } else {
            ((Sim_entity)entities.get(n)).set_evbuf(null);
            if (auto_trace && default_trace) {
                Sim_system.trace(n, "no event cancelled");
            }
        }
    }

    static synchronized void putback(Sim_event sim_event) {
        deferred.add_event(sim_event);
    }

    private static void process_event(Sim_event sim_event) {
        if (sim_event.event_time() < clock) {
            throw new Sim_exception("Sim_system: Past event detected.");
        }
        clock = sim_event.event_time();
        switch (sim_event.get_type()) {
            case 0: {
                throw new Sim_exception("Sim_system: Event has a null type.");
            }
            case 3: {
                Sim_entity sim_entity = (Sim_entity)sim_event.get_data();
                Sim_system.add_entity_dynamically(sim_entity);
                break;
            }
            case 1: {
                Sim_entity sim_entity;
                int n = sim_event.get_dest();
                if (n < 0) {
                    throw new Sim_exception("Sim_system: Attempt to send to a null entity detected.");
                }
                int n2 = sim_event.get_tag();
                if ((n != sim_event.get_src() || n2 != 9999) && ((Sim_entity)entities.get(n)).has_stat()) {
                    ((Sim_entity)entities.get(n)).update(0, n2, clock);
                }
                if ((sim_entity = (Sim_entity)entities.get(n)).get_state() == 1) {
                    Integer n3 = new Integer(n);
                    Sim_predicate sim_predicate = (Sim_predicate)wait_predicates.get(n3);
                    if (sim_predicate == null || n2 == 9999 || sim_predicate.match(sim_event)) {
                        sim_entity.set_evbuf((Sim_event)sim_event.clone());
                        sim_entity.set_state(0);
                        wait_predicates.remove(n3);
                        break;
                    }
                    deferred.add_event(sim_event);
                    break;
                }
                deferred.add_event(sim_event);
                break;
            }
            case 2: {
                int n = sim_event.get_src();
                if (n < 0) {
                    throw new Sim_exception("Sim_system: Null entity holding.");
                }
                ((Sim_entity)entities.get(n)).set_state(0);
            }
        }
    }

    public static void set_seed_sequence(int n, long l) {
        seed_spacing = n;
        root_seed = l;
        seed_source.set_seed(l);
        not_sampled = true;
    }

    public static void set_spacing(int n) {
        seed_spacing = n;
    }

    public static int get_spacing() {
        return seed_spacing;
    }

    public static void set_seed(long l) {
        root_seed = l;
        seed_source.set_seed(l);
        not_sampled = true;
    }

    public static long get_root_seed() {
        return root_seed;
    }

    public static long next_seed() {
        long l = seed_source.get_seed();
        if (l == root_seed && not_sampled) {
            not_sampled = false;
        } else {
            int n = 0;
            while (n < seed_spacing) {
                seed_source.sample();
                ++n;
            }
            l = seed_source.get_seed();
        }
        return l;
    }

    static synchronized void job_completed(int n, int n2) {
        if (term_condition == 1 && n == term_entity_id && n2 == term_event_type) {
            ++term_event_counter;
            if (trans_condition == 3) {
                term_times.add(new Double(clock));
            }
        }
        if (trans_condition == 1 && n == trans_entity_id && n2 == trans_event_type) {
            ++trans_event_counter;
        }
        if (auto_trace && (default_trace || event_trace && Sim_system.is_trace_tag(n2))) {
            Sim_system.trace(n, "event type " + n2 + " completed service");
        }
    }

    static synchronized void observation_collected(int n, String string) {
        if (term_condition == 6 && n == term_entity_id && string.equals(term_measure) && in_steady_state) {
            ++term_event_counter;
        }
    }

    public static void run_initialise() {
        int n;
        start_date = System.currentTimeMillis();
        if (term_condition == 6) {
            switch (output_analysis_type) {
                case 4: {
                    initial_term_count = 2500L;
                    break;
                }
                case 5: {
                    term_count_bm = new int[2];
                    Sim_system.term_count_bm[0] = 600;
                    Sim_system.term_count_bm[1] = 800;
                    term_count = 800L;
                }
            }
        } else if (term_condition == 1) {
            term_count = initial_term_count;
        } else {
            term_time = initial_term_time;
        }
        trans_count = initial_trans_count;
        if (output_analysis_type == 4) {
            backup = new ArrayList();
            n = entities.size();
            int n2 = 0;
            while (n2 < n) {
                Sim_entity sim_entity = (Sim_entity)entities.get(n2);
                try {
                    backup.add((Sim_entity)sim_entity.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new Sim_exception("Could not make backup of entity " + sim_entity.get_name() + ".");
                }
                ++n2;
            }
        }
        initial_seeds = new ArrayList();
        int n3 = entities.size();
        n = 0;
        while (n < n3) {
            Sim_entity sim_entity = (Sim_entity)entities.get(n);
            String string = sim_entity.get_name();
            List list = sim_entity.get_generators();
            if (list.size() != 0) {
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                int n4 = list.size();
                int n5 = 0;
                while (n5 < n4) {
                    Generator generator = (Generator)list.get(n5);
                    arrayList.add(new Object[]{generator.get_name(), new Long(generator.get_seed())});
                    ++n5;
                }
                initial_seeds.add(new Object[]{string, arrayList});
            }
            ++n;
        }
    }

    public static void run_start() {
        int n;
        if (output_analysis_type == 4) {
            n = 1;
            if (replications != null) {
                n = replications.size() + 1;
            }
            Sim_system.print_message("Performing replication #" + n + ".");
        }
        running = true;
        n = entities.size();
        int n2 = 0;
        while (n2 < n) {
            ((Sim_entity)entities.get(n2)).start();
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            onestopped.p();
            ++n3;
        }
        Sim_system.print_message("Entities started.");
    }

    public static void set_termination_condition(int n, String string, int n2, long l, boolean bl) {
        if (n != 1) {
            throw new Sim_exception("The method used must be passed a condition based on completed events.");
        }
        if (l <= 0L) {
            throw new Sim_exception("The count for events completed must be positive.");
        }
        if (term_condition != 0) {
            throw new Sim_exception("You can't specify two termination conditions.");
        }
        term_condition = n;
        term_entity_id = Sim_system.get_entity_id(string);
        term_event_type = n2;
        initial_term_count = l;
        include_transient = bl;
    }

    public static void set_termination_condition(int n, double d, boolean bl) {
        if (n != 2) {
            throw new Sim_exception("The method used must be passed a condition based on the elapsed simulation time.");
        }
        if (d <= 0.0) {
            throw new Sim_exception("The simulation termination time completed must be positive.");
        }
        if (term_condition != 0) {
            throw new Sim_exception("You can't specify two termination conditions.");
        }
        term_condition = n;
        initial_term_time = d;
        include_transient = bl;
    }

    public static void set_termination_condition(int n, int n2, double d, double d2, String string, String string2) {
        if (n != 6) {
            throw new Sim_exception("The method used must be passed a condition based on the accuracy of a confidence interval.");
        }
        if (n2 != 4 && n2 != 5) {
            throw new Sim_exception("The output analysis method to be used must be either IND_REPLICATIONS or BATCH_MEANS.");
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new Sim_exception("The confidence level must be between 0.0 and 1.0.");
        }
        if (d2 <= 0.0) {
            throw new Sim_exception("The interval accuracy tolerance must be greater than 0.0.");
        }
        if (output_analysis_type != 0) {
            throw new Sim_exception("When using this termination condition no other output analysis method can be specified.");
        }
        if (trans_condition == 3) {
            throw new Sim_exception("This termination condition can't be used when the minimum-maximum method is used.");
        }
        if (term_condition != 0) {
            throw new Sim_exception("You can't specify two termination conditions.");
        }
        if (n2 == 5 && efficient_measure_defined) {
            throw new Sim_exception("Batch means may not be used when efficient measures are defined.");
        }
        term_entity_id = Sim_system.get_entity_id(string);
        Sim_stat sim_stat = ((Sim_entity)entities.get(term_entity_id)).get_stat();
        if (sim_stat == null) {
            throw new Sim_exception("No measures have been defined for " + string + ".");
        }
        int n3 = sim_stat.get_type(string2);
        if (n3 == -1) {
            throw new Sim_exception(string2 + " has not been defined for " + string + ".");
        }
        term_condition = n;
        term_measure = string2;
        output_analysis_type = n2;
        confidence_level = d;
        term_accuracy = d2;
        replication_count = 5;
    }

    public static void set_termination_condition(int n, int n2, double d, double d2, String string, int n3) {
        if (n != 6) {
            throw new Sim_exception("The method used must be passed a condition based on the accuracy of a confidence interval.");
        }
        if (n2 != 4 && n2 != 5) {
            throw new Sim_exception("The output analysis method to be used must be either IND_REPLICATIONS or BATCH_MEANS.");
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new Sim_exception("The confidence level must be between 0.0 and 1.0.");
        }
        if (d2 <= 0.0) {
            throw new Sim_exception("The interval accuracy tolerance must be greater than 0.0.");
        }
        if (output_analysis_type != 0) {
            throw new Sim_exception("When using this termination condition no other output analysis method can be specified.");
        }
        if (trans_condition == 3) {
            throw new Sim_exception("This termination condition can't be used when the minimum-maximum method is used.");
        }
        if (term_condition != 0) {
            throw new Sim_exception("You can't specify two termination conditions.");
        }
        if (n2 == 5 && efficient_measure_defined) {
            throw new Sim_exception("Batch means may not be used when efficient measures are defined.");
        }
        term_entity_id = Sim_system.get_entity_id(string);
        Sim_stat sim_stat = ((Sim_entity)entities.get(term_entity_id)).get_stat();
        if (sim_stat == null) {
            throw new Sim_exception("No measures have been defined for " + string + ".");
        }
        String string2 = sim_stat.get_name_default(n3);
        int n4 = sim_stat.get_type(string2);
        if (n4 == -1) {
            throw new Sim_exception(string2 + " has not been defined for " + string + ".");
        }
        term_condition = n;
        term_measure = string2;
        output_analysis_type = n2;
        confidence_level = d;
        term_accuracy = d2;
        replication_count = 5;
    }

    public static void set_transient_condition(int n, String string, String string2) {
        if (n != 3) {
            throw new Sim_exception("The method used must be passed a condition based on minimum-maximum values of observations of a specific entity's measure.");
        }
        if (trans_condition != 0) {
            throw new Sim_exception("You can't specify two transient conditions.");
        }
        if (term_condition == 6 || term_condition == 0) {
            throw new Sim_exception("The minimum-maximum method can only be used with a termination of event completions or elapsed time.");
        }
        if (efficient_measure_defined) {
            throw new Sim_exception("The minimum-maximum method can't be used with efficient measures.");
        }
        trans_condition = n;
        trans_entity_id = Sim_system.get_entity_id(string);
        Sim_stat sim_stat = ((Sim_entity)entities.get(trans_entity_id)).get_stat();
        if (sim_stat == null) {
            throw new Sim_exception("No measures have been defined for " + string + ".");
        }
        int n2 = sim_stat.get_type(string2);
        if (n2 == -1) {
            throw new Sim_exception(string2 + " has not been defined for " + string + ".");
        }
        if (n2 != 1 && n2 != 2 || string2.equals("Utilisation")) {
            throw new Sim_exception(string2 + " of " + string + " has invalid type for a transient period estimator.");
        }
        trans_measure = string2;
        term_times = new ArrayList();
    }

    public static void set_transient_condition(int n, String string, int n2) {
        if (n != 3) {
            throw new Sim_exception("The method used must be passed a condition based on minimum-maximum values of observations of a specific entity's measure.");
        }
        if (trans_condition != 0) {
            throw new Sim_exception("You can't specify two transient conditions.");
        }
        if (term_condition == 6 || term_condition == 0) {
            throw new Sim_exception("The minimum-maximum method can only be used with a termination of event completions or elapsed time.");
        }
        if (efficient_measure_defined) {
            throw new Sim_exception("The minimum-maximum method can't be used with efficient measures.");
        }
        trans_condition = n;
        trans_entity_id = Sim_system.get_entity_id(string);
        Sim_stat sim_stat = ((Sim_entity)entities.get(trans_entity_id)).get_stat();
        if (sim_stat == null) {
            throw new Sim_exception("No measures have been defined for " + string + ".");
        }
        String string2 = sim_stat.get_name_default(n2);
        int n3 = sim_stat.get_type(string2);
        if (n3 == -1) {
            throw new Sim_exception(string2 + " has not been defined for " + string + ".");
        }
        if (n3 != 1 && n3 != 2 || string2.equals("Utilisation")) {
            throw new Sim_exception(string2 + " of " + string + " has invalid type for a transient period estimator.");
        }
        trans_measure = string2;
        term_times = new ArrayList();
    }

    public static void set_transient_condition(int n, String string, int n2, long l) {
        if (n != 1) {
            throw new Sim_exception("The method used must be passed a condition based on completed events.");
        }
        if (l <= 0L) {
            throw new Sim_exception("The count for events completed must be positive.");
        }
        if (trans_condition != 0) {
            throw new Sim_exception("You can't specify two transient conditions.");
        }
        trans_condition = n;
        trans_entity_id = Sim_system.get_entity_id(string);
        trans_event_type = n2;
        initial_trans_count = l;
    }

    public static void set_transient_condition(int n, double d) {
        if (n != 2) {
            throw new Sim_exception("The method used must be passed a condition based on the elapsed simulation time.");
        }
        if (d <= 0.0) {
            throw new Sim_exception("The transient time must be positive.");
        }
        if (trans_condition != 0) {
            throw new Sim_exception("You can't specify two transient conditions.");
        }
        trans_condition = n;
        initial_trans_time = d;
    }

    public static void set_output_analysis(int n) {
        if (n != 0 && n != 4 && n != 5) {
            throw new Sim_exception("The output analysis method must be either NONE, IND_REPLICATIONS or BATCH_MEANS.");
        }
        if (term_condition == 6) {
            throw new Sim_exception("No additional output analysis method can be specified when using a termination condition based on an interval accuracy.");
        }
        if (output_analysis_type != 0) {
            throw new Sim_exception("You can't specify two output analysis methods.");
        }
        if (output_analysis_type == 5 && efficient_measure_defined) {
            throw new Sim_exception("Batch means may not be used when efficient measures are defined.");
        }
        output_analysis_type = n;
    }

    public static void set_output_analysis(int n, double d) {
        if (n != 4 && n != 5) {
            throw new Sim_exception("The output analysis method must be either IND_REPLICATIONS or BATCH_MEANS.");
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new Sim_exception("The confidence level must be between 0.0 and 1.0.");
        }
        if (term_condition == 6) {
            throw new Sim_exception("No additional output analysis method can be specified when using a termination condition based on an interval accuracy.");
        }
        if (output_analysis_type != 0) {
            throw new Sim_exception("You can't specify two output analysis methods.");
        }
        if (output_analysis_type == 5 && efficient_measure_defined) {
            throw new Sim_exception("Batch means may not be used when efficient measures are defined.");
        }
        output_analysis_type = n;
        confidence_level = d;
    }

    public static void set_output_analysis(int n, int n2, int n3, double d) {
        if (n != 5) {
            throw new Sim_exception("The output analysis method must be either IND_REPLICATIONS or BATCH_MEANS.");
        }
        if (n2 <= 1 || n2 > n3) {
            throw new Sim_exception("Invalid minimum and maximum number of batches.");
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new Sim_exception("The confidence level must be between 0.0 and 1.0.");
        }
        if (term_condition == 6) {
            throw new Sim_exception("No additional output analysis method can be specified when using a termination condition based on an interval accuracy.");
        }
        if (output_analysis_type != 0) {
            throw new Sim_exception("You can't specify two output analysis methods.");
        }
        if (efficient_measure_defined) {
            throw new Sim_exception("Batch means may not be used when efficient measures are defined.");
        }
        output_analysis_type = n;
        min_batches = n2;
        max_batches = n3;
        confidence_level = d;
    }

    public static void set_output_analysis(int n, int n2, double d) {
        if (n != 4) {
            throw new Sim_exception("This method may only be used to specify IND_REPLICATIONS as the output analysis method.");
        }
        if (n2 < 2) {
            throw new Sim_exception("The number of replications must be greater than 2.");
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new Sim_exception("The confidence level must be between 0.0 and 1.0.");
        }
        if (term_condition == 6) {
            throw new Sim_exception("No additional output analysis method can be specified when using a termination condition based on an interval accuracy.");
        }
        if (output_analysis_type != 0) {
            throw new Sim_exception("You can't specify two output analysis methods.");
        }
        output_analysis_type = n;
        replication_count = n2;
        confidence_level = d;
    }

    public static void set_report_detail(boolean bl, boolean bl2) {
        detailed_report = bl;
        include_seeds = bl2;
    }

    public static void generate_graphs(boolean bl) {
        generate_graphs = bl;
    }

    public static void generate_graphs(String string) {
        generate_graphs = true;
        if (!string.endsWith(suffix)) {
            string = string + suffix;
        }
        graph_file = string;
    }

    public static synchronized boolean running() {
        return running;
    }

    public static void tidy_up_stats() {
        int n = entities.size();
        int n2 = 0;
        while (n2 < n) {
            ((Sim_entity)entities.get(n2)).tidy_up_stat();
            ++n2;
        }
    }

    public static boolean check_conditions() {
        boolean bl;
        block66: {
            bl = true;
            block0 : switch (term_condition) {
                case 1: {
                    switch (trans_condition) {
                        case 1: {
                            if (include_transient) {
                                if (trans_event_counter >= trans_count && !in_steady_state) {
                                    trans_time = clock;
                                    in_steady_state = true;
                                    if (efficient_measure_defined) {
                                        Sim_system.notify_stats_trans(trans_time);
                                    }
                                }
                                if (term_event_counter < term_count) break;
                                bl = false;
                                if (!(trans_time < 0.0)) break;
                                Sim_system.print_message("The termination condition has been satisfied but no transient period has been identified.");
                                Sim_system.print_message("The run will complete with no transient period.");
                                break;
                            }
                            if (in_steady_state) {
                                if (term_event_counter < term_count) break;
                                bl = false;
                                break;
                            }
                            if (trans_event_counter < trans_count) break;
                            in_steady_state = true;
                            transient_term_event_count = term_event_counter;
                            term_event_counter = 0L;
                            trans_time = clock;
                            if (!efficient_measure_defined) break;
                            Sim_system.notify_stats_trans(trans_time);
                            break;
                        }
                        case 2: {
                            if (include_transient) {
                                if (clock >= initial_trans_time && !in_steady_state) {
                                    in_steady_state = true;
                                    trans_time = clock;
                                    if (efficient_measure_defined) {
                                        Sim_system.notify_stats_trans(trans_time);
                                    }
                                }
                                if (term_event_counter < term_count) break;
                                bl = false;
                                if (!(trans_time < 0.0)) break;
                                Sim_system.print_message("The termination condition has been satisfied but no transient period has been identified.");
                                Sim_system.print_message("The run will complete with no transient period.");
                                break;
                            }
                            if (in_steady_state) {
                                if (term_event_counter < term_count) break;
                                bl = false;
                                break;
                            }
                            if (!(clock >= initial_trans_time)) break;
                            in_steady_state = true;
                            trans_time = clock;
                            transient_term_event_count = term_event_counter;
                            term_event_counter = 0L;
                            if (!efficient_measure_defined) break;
                            Sim_system.notify_stats_trans(trans_time);
                            break;
                        }
                        case 3: {
                            if (term_event_counter < term_count) break;
                            if (include_transient) {
                                bl = false;
                                trans_time = ((Sim_entity)entities.get(trans_entity_id)).get_stat().min_max_time(trans_measure);
                                if (trans_time != -1.0) {
                                    in_steady_state = true;
                                    break;
                                }
                                Sim_system.print_message("The termination condition has been satisfied but no transient period has been identified.");
                                Sim_system.print_message("The run will complete with no transient period.");
                                break;
                            }
                            if (in_steady_state) {
                                bl = false;
                                break;
                            }
                            trans_time = ((Sim_entity)entities.get(trans_entity_id)).get_stat().min_max_time(trans_measure);
                            if (trans_time == -1.0) {
                                double d = 0.0;
                                if (!animation) {
                                    d = Sim_system.prompt_modeller(0);
                                }
                                if (d < 0.0) {
                                    bl = false;
                                    break;
                                }
                                term_count += (long)d;
                                break;
                            }
                            in_steady_state = true;
                            transient_term_event_count = 0L;
                            int n = term_times.size();
                            int n2 = 0;
                            while (n2 < n) {
                                double d = (Double)term_times.get(n2);
                                if (d < trans_time) {
                                    ++transient_term_event_count;
                                }
                                ++n2;
                            }
                            term_event_counter -= transient_term_event_count;
                            break;
                        }
                        case 0: {
                            if (term_event_counter < term_count) break;
                            bl = false;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (trans_condition) {
                        case 1: {
                            if (include_transient) {
                                if (trans_event_counter >= trans_count + 1L && !in_steady_state) {
                                    trans_time = clock;
                                    in_steady_state = true;
                                    if (efficient_measure_defined) {
                                        Sim_system.notify_stats_trans(trans_time);
                                    }
                                }
                                if (!(clock >= term_time)) break;
                                bl = false;
                                if (!(trans_time < 0.0)) break;
                                Sim_system.print_message("The termination condition has been satisfied but no transient period has been identified.");
                                Sim_system.print_message("The run will complete with no transient period.");
                                break;
                            }
                            if (in_steady_state) {
                                if (!(clock >= term_time)) break;
                                bl = false;
                                break;
                            }
                            if (trans_event_counter < trans_count) break;
                            in_steady_state = true;
                            transient_term_event_count = term_event_counter;
                            term_event_counter = 0L;
                            trans_time = clock;
                            term_time += trans_time;
                            if (!efficient_measure_defined) break;
                            Sim_system.notify_stats_trans(trans_time);
                            break;
                        }
                        case 2: {
                            if (include_transient) {
                                if (clock >= initial_trans_time && !in_steady_state) {
                                    in_steady_state = true;
                                    trans_time = clock;
                                    if (efficient_measure_defined) {
                                        Sim_system.notify_stats_trans(trans_time);
                                    }
                                }
                                if (!(clock >= term_time)) break;
                                bl = false;
                                if (!(trans_time < 0.0)) break;
                                Sim_system.print_message("The termination condition has been satisfied but no transient period has been identified.");
                                Sim_system.print_message("The run will complete with no transient period.");
                                break;
                            }
                            if (in_steady_state) {
                                if (!(clock >= term_time)) break;
                                bl = false;
                                break;
                            }
                            if (!(clock >= initial_trans_time)) break;
                            in_steady_state = true;
                            trans_time = clock;
                            term_time += trans_time;
                            if (!efficient_measure_defined) break;
                            Sim_system.notify_stats_trans(trans_time);
                            break;
                        }
                        case 3: {
                            if (!(clock >= term_time)) break;
                            if (include_transient) {
                                bl = false;
                                trans_time = ((Sim_entity)entities.get(trans_entity_id)).get_stat().min_max_time(trans_measure);
                                if (trans_time != -1.0) {
                                    in_steady_state = true;
                                    break;
                                }
                                Sim_system.print_message("The termination condition has been satisfied but no transient period has been identified.");
                                Sim_system.print_message("The run will complete with no transient period.");
                                break;
                            }
                            if (in_steady_state) {
                                bl = false;
                                break;
                            }
                            trans_time = ((Sim_entity)entities.get(trans_entity_id)).get_stat().min_max_time(trans_measure);
                            if (trans_time == -1.0) {
                                double d = Sim_system.prompt_modeller(1);
                                if (d < 0.0) {
                                    bl = false;
                                    break;
                                }
                                term_time += d;
                                break;
                            }
                            term_time += trans_time;
                            in_steady_state = true;
                            break;
                        }
                        case 0: {
                            if (!(clock >= term_time)) break;
                            bl = false;
                        }
                    }
                    break;
                }
                case 6: {
                    if (in_steady_state) {
                        switch (output_analysis_type) {
                            case 4: {
                                if (term_event_counter < initial_term_count) break;
                                bl = false;
                                break;
                            }
                            case 5: {
                                if (term_event_counter < term_count) break;
                                bl = false;
                            }
                        }
                        break;
                    }
                    switch (trans_condition) {
                        case 1: {
                            if (trans_event_counter < trans_count + 1L) break;
                            trans_time = clock;
                            in_steady_state = true;
                            if (!efficient_measure_defined) break;
                            Sim_system.notify_stats_trans(trans_time);
                            break;
                        }
                        case 2: {
                            if (!(clock >= initial_trans_time)) break;
                            in_steady_state = true;
                            trans_time = clock;
                            if (!efficient_measure_defined) break;
                            Sim_system.notify_stats_trans(trans_time);
                            break;
                        }
                        case 0: {
                            in_steady_state = true;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (trans_condition) {
                        case 1: {
                            if (trans_event_counter >= trans_count + 1L) {
                                trans_time = clock;
                                in_steady_state = true;
                                if (efficient_measure_defined) {
                                    Sim_system.notify_stats_trans(trans_time);
                                    break block0;
                                }
                            }
                            break block66;
                        }
                        case 2: {
                            if (clock >= initial_trans_time) {
                                in_steady_state = true;
                                trans_time = clock;
                                if (efficient_measure_defined) {
                                    Sim_system.notify_stats_trans(trans_time);
                                    break block0;
                                }
                            }
                            break block66;
                        }
                        case 0: {
                            in_steady_state = true;
                        }
                    }
                }
            }
        }
        running = bl;
        return bl;
    }

    /*
     * Loose catch block
     */
    private static double prompt_modeller(int n) {
        double d;
        block22: {
            BufferedReader bufferedReader = null;
            d = -1.0;
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            switch (n) {
                case 0: {
                    String string;
                    System.out.println("The transient period could not be estimated. How should the run proceed?");
                    System.out.println("1. Complete run immediately with no transient period.");
                    System.out.println("2. Extend the run for a number of event completions and try again.");
                    System.out.print("Choice: ");
                    while (!(string = bufferedReader.readLine()).equals("1") && !string.equals("2")) {
                    }
                    if (string.equals("1")) break;
                    long l = 0L;
                    Sim_system.print_message("Event completions for which the run will be extended: ");
                    do {
                        try {
                            l = Long.valueOf(bufferedReader.readLine());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    } while (l > 0L);
                    d = l;
                    break;
                }
                case 1: {
                    String string;
                    System.out.println("The transient period could not be estimated. How should the run proceed?");
                    System.out.println("1. Complete run immediately with no transient period.");
                    System.out.println("2. Extend the run for a time period and try again.");
                    System.out.print("Choice: ");
                    while (!(string = bufferedReader.readLine()).equals("1") && !string.equals("2")) {
                    }
                    if (string.equals("1")) break;
                    double d2 = 0.0;
                    System.out.println("Time for which the run will be extended: ");
                    try {
                        d2 = Double.valueOf(bufferedReader.readLine());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    d = d2;
                }
            }
            Object var9_10 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block22;
            }
            catch (IOException iOException) {}
            break block22;
            {
                catch (IOException iOException) {
                    Object var9_11 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block22;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return d;
    }

    public static void run() {
        Sim_system.run_initialise();
        while (incomplete) {
            if (!running) {
                Sim_system.run_start();
            }
            while (Sim_system.check_conditions()) {
                if (Sim_system.run_tick()) break;
            }
            Sim_system.tidy_up_stats();
            Sim_system.apply_variance_reduction();
            Sim_system.end_current_run();
        }
        Sim_system.run_stop();
        Sim_system.generate_report();
        Sim_system.generate_graphs();
    }

    public static void end_current_run() {
        if (anim_stopped) {
            running = false;
        }
        if (incomplete && output_analysis_type == 5 && !anim_stopped) {
            running = true;
        } else {
            int n = entities.size();
            int n2 = 0;
            while (n2 < n) {
                Sim_entity sim_entity = (Sim_entity)entities.get(n2);
                if (sim_entity.get_state() != 3) {
                    sim_entity.restart();
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                onecompleted.p();
                ++n3;
            }
            if (incomplete && !anim_stopped) {
                Sim_system.reset();
            }
        }
    }

    static void completed() {
        Sim_system.paused();
        onecompleted.v();
    }

    public static void apply_variance_reduction() {
        switch (output_analysis_type) {
            case 4: {
                Sim_system.print_message("Applying output analysis.");
                incomplete = Sim_system.independent_replications();
                break;
            }
            case 5: {
                Sim_system.print_message("Applying output analysis.");
                incomplete = Sim_system.batch_means();
                break;
            }
            case 0: {
                Sim_system.print_message("Gathering simulation data.");
                Sim_system.gather_data();
                incomplete = false;
            }
        }
    }

    private static void gather_data() {
        run_data = new Object[5];
        if (trans_time < 0.0) {
            trans_time = 0.0;
        }
        ArrayList<Sim_stat> arrayList = new ArrayList<Sim_stat>();
        int n = entities.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(((Sim_entity)entities.get(n2)).get_stat());
            ++n2;
        }
        long l = System.currentTimeMillis();
        Sim_system.run_data[0] = new long[]{start_date, l};
        Sim_system.run_data[1] = new int[]{trans_condition, term_condition, output_analysis_type};
        Sim_system.run_data[2] = new double[]{clock, trans_time};
        Sim_system.run_data[3] = initial_seeds;
        Sim_system.run_data[4] = arrayList;
    }

    private static boolean independent_replications() {
        boolean bl;
        block44: {
            double d;
            int n;
            double d2;
            Object object;
            Object object2;
            Serializable serializable;
            int n2;
            block43: {
                if ((replications == null || replications.size() == 0) && anim_stopped) {
                    output_analysis_type = 0;
                    Sim_system.gather_data();
                    return false;
                }
                bl = false;
                if (replications == null) {
                    replications = new ArrayList();
                }
                Object[] objectArray = new Object[2];
                if (trans_time < 0.0) {
                    trans_time = 0.0;
                }
                ArrayList<Sim_stat> arrayList = new ArrayList<Sim_stat>();
                n2 = entities.size();
                int n3 = 0;
                while (n3 < n2) {
                    serializable = ((Sim_entity)entities.get(n3)).get_stat();
                    if (serializable == null) {
                        arrayList.add(null);
                    } else {
                        arrayList.add(((Sim_stat)serializable).get_stat_copy());
                    }
                    ++n3;
                }
                objectArray[0] = new double[]{clock, trans_time};
                objectArray[1] = arrayList;
                replications.add(objectArray);
                total_transient_time += trans_time;
                total_time_elapsed += clock;
                if (replications.size() >= replication_count || anim_stopped) break block43;
                bl = true;
                break block44;
            }
            if (term_condition == 6 && !anim_stopped) {
                int n4 = replications.size();
                double d3 = 0.0;
                object2 = new double[n4];
                int n5 = 0;
                while (n5 < n4) {
                    Object[] objectArray = (Object[])replications.get(n5);
                    double[] dArray = (double[])objectArray[0];
                    double d4 = dArray[0];
                    double d5 = dArray[1];
                    object = (Sim_stat)((List)objectArray[1]).get(term_entity_id);
                    d2 = ((Sim_stat)object).is_efficient(term_measure) ? ((Sim_stat)object).average(term_measure) : ((Sim_stat)object).average(term_measure, d5, d4);
                    object2[n5] = d2;
                    d3 += d2;
                    ++n5;
                }
                d3 /= (double)n4;
                double d6 = 0.0;
                n = 0;
                while (n < n4) {
                    d6 += Math.pow((double)(object2[n] - d3), 2.0);
                    ++n;
                }
                d6 = d6 / (double)(n4 - 1) / (double)n4;
                double d7 = Math.sqrt(d6);
                double d8 = Sim_system.qt(1.0 - (1.0 - confidence_level) / 2.0, n4 - 1, true);
                d2 = d8 * d7;
                d = d2 / d3;
                if (d >= term_accuracy) {
                    int n6 = replication_count;
                    replication_count = (int)Math.ceil((double)n4 * Math.pow(d2 / (term_accuracy * d3), 2.0));
                    Sim_system.print_message("Performing " + (replication_count - n6) + " additional replications.");
                    return true;
                }
            }
            serializable = new ArrayList();
            int n7 = 0;
            while (n7 < n2) {
                block46: {
                    String string;
                    block45: {
                        string = ((Sim_entity)entities.get(n7)).get_name();
                        object2 = ((Sim_entity)entities.get(n7)).get_stat();
                        if (object2 != null) break block45;
                        serializable.add(new Object[]{string, null});
                        break block46;
                    }
                    List list = ((Sim_stat)object2).get_measures();
                    ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                    int n8 = list.size();
                    n = 0;
                    while (n < n8) {
                        Object[] objectArray;
                        double d9;
                        double d10;
                        String string2 = (String)((Object[])list.get(n))[0];
                        Integer n9 = (Integer)((Object[])list.get(n))[1];
                        int n10 = n9;
                        object = ((Sim_stat)object2).get_levels(string2);
                        d2 = 0.0;
                        d = -1.0;
                        double d11 = -1.0;
                        double[] dArray = object != null ? new double[((Object)object).length] : new double[]{};
                        double d12 = 0.0;
                        int n11 = replications.size();
                        double[] dArray2 = new double[n11];
                        int n12 = 0;
                        while (n12 < n11) {
                            block48: {
                                double d13;
                                Sim_stat sim_stat;
                                Object[] objectArray2;
                                block47: {
                                    double d14;
                                    objectArray2 = (Object[])replications.get(n12);
                                    sim_stat = (Sim_stat)((List)objectArray2[1]).get(n7);
                                    if (!sim_stat.is_efficient(string2)) break block47;
                                    dArray2[n12] = d14 = sim_stat.average(string2);
                                    d12 += d14;
                                    switch (n10) {
                                        case 0: {
                                            d2 += (double)sim_stat.count(string2);
                                            break;
                                        }
                                        default: {
                                            if (!string2.equals("Utilisation")) {
                                                double d15 = sim_stat.maximum(string2);
                                                double d16 = sim_stat.minimum(string2);
                                                if (n12 == 0) {
                                                    d11 = d15;
                                                    d = d16;
                                                } else {
                                                    if (d15 >= d11) {
                                                        d11 = d15;
                                                    }
                                                    if (d16 <= d) {
                                                        d = d16;
                                                    }
                                                }
                                                if (object != null) {
                                                    double[] dArray3 = sim_stat.exc_proportion(string2);
                                                    int n13 = 0;
                                                    while (n13 < dArray3.length) {
                                                        int n14 = n13;
                                                        dArray[n14] = dArray[n14] + dArray3[n13];
                                                        ++n13;
                                                    }
                                                    break block0;
                                                } else {
                                                    break;
                                                }
                                            } else {
                                                break;
                                            }
                                        }
                                    }
                                    break block48;
                                }
                                double[] dArray4 = (double[])objectArray2[0];
                                d10 = dArray4[0];
                                d9 = dArray4[1];
                                dArray2[n12] = d13 = sim_stat.average(string2, d9, d10);
                                d12 += d13;
                                switch (n10) {
                                    case 0: {
                                        d2 += (double)sim_stat.count(string2, d9, d10);
                                        break;
                                    }
                                    default: {
                                        if (string2.equals("Utilisation")) break;
                                        double d17 = sim_stat.maximum(string2, d9, d10);
                                        double d18 = sim_stat.minimum(string2, d9, d10);
                                        if (n12 == 0) {
                                            d11 = d17;
                                            d = d18;
                                        } else {
                                            if (d17 >= d11) {
                                                d11 = d17;
                                            }
                                            if (d18 <= d) {
                                                d = d18;
                                            }
                                        }
                                        if (object == null) break;
                                        double[] dArray5 = sim_stat.exc_proportion(string2, (double[])object, d9, d10);
                                        int n15 = 0;
                                        while (n15 < dArray5.length) {
                                            int n16 = n15;
                                            dArray[n16] = dArray[n16] + dArray5[n15];
                                            ++n15;
                                        }
                                        break block3;
                                    }
                                }
                            }
                            ++n12;
                        }
                        d12 /= (double)n11;
                        double d19 = 0.0;
                        int n17 = 0;
                        while (n17 < n11) {
                            d19 += Math.pow(dArray2[n17] - d12, 2.0);
                            ++n17;
                        }
                        d19 = d19 / (double)(n11 - 1) / (double)n11;
                        d10 = Math.sqrt(d19);
                        d9 = Sim_system.qt(1.0 - (1.0 - confidence_level) / 2.0, n11 - 1, true);
                        switch (n10) {
                            case 0: {
                                d2 /= (double)n11;
                                objectArray = new Object[7];
                                break;
                            }
                            default: {
                                if (string2.equals("Utilisation")) {
                                    objectArray = new Object[6];
                                    break;
                                }
                                if (object != null) {
                                    int n18 = 0;
                                    while (n18 < ((Object)object).length) {
                                        dArray[n18] = dArray[n18] / (double)n11;
                                        ++n18;
                                    }
                                    objectArray = new Object[9];
                                    break;
                                }
                                objectArray = new Object[8];
                            }
                        }
                        double d20 = d9 * d10;
                        double d21 = d12 - d20;
                        double d22 = d12 + d20;
                        objectArray[0] = new Double(d21);
                        objectArray[1] = new Double(d12);
                        objectArray[2] = new Double(d22);
                        objectArray[3] = new Double(d19);
                        objectArray[4] = d12 == 0.0 ? new Double(0.0) : new Double(d20 / d12);
                        objectArray[5] = new Double(d10);
                        if (!string2.equals("Utilisation")) {
                            switch (n10) {
                                case 0: {
                                    objectArray[6] = new Double(d2);
                                    break;
                                }
                                default: {
                                    objectArray[6] = new Double(d11);
                                    objectArray[7] = new Double(d);
                                    if (object == null) break;
                                    double[][] dArray6 = new double[((Object)object).length][2];
                                    int n19 = 0;
                                    while (n19 < ((Object)object).length) {
                                        dArray6[n19][0] = (double)object[n19];
                                        dArray6[n19][1] = dArray[n19];
                                        ++n19;
                                    }
                                    objectArray[8] = dArray6;
                                }
                            }
                        }
                        arrayList.add(new Object[]{string2, n9, objectArray});
                        ++n;
                    }
                    serializable.add(new Object[]{string, arrayList});
                }
                ++n7;
            }
            run_data = new Object[8];
            long l = System.currentTimeMillis();
            Sim_system.run_data[0] = new long[]{start_date, l};
            Sim_system.run_data[1] = new int[]{trans_condition, term_condition, output_analysis_type};
            Sim_system.run_data[2] = new double[]{total_time_elapsed, total_transient_time};
            Sim_system.run_data[3] = initial_seeds;
            Sim_system.run_data[4] = new Double(confidence_level);
            Sim_system.run_data[5] = serializable;
            Sim_system.run_data[6] = new Integer(replications.size());
            Sim_system.run_data[7] = replications;
            bl = false;
        }
        return bl;
    }

    private static boolean batch_means() {
        Object object;
        Object object2;
        if (trans_time < 0.0) {
            trans_time = 0.0;
        }
        double d = clock - trans_time;
        if (term_condition == 6 && !anim_stopped) {
            double d2;
            double d3;
            double d4;
            double d5;
            object2 = ((Sim_entity)entities.get(term_entity_id)).get_stat();
            int n = 400;
            double d6 = d / (double)n;
            double d7 = 0.0;
            object = new double[n];
            int n2 = 0;
            while (n2 < n) {
                d5 = trans_time + (double)n2 * d6;
                double d8 = trans_time + (double)(n2 + 1) * d6;
                double d9 = ((Sim_stat)object2).average(term_measure, d5, d8);
                object[n2] = d9;
                d7 += d9;
                ++n2;
            }
            d5 = Sim_system.serial_correlation(d7 /= (double)n, (double[])object);
            if (d5 > 0.4) {
                int n3 = 2 * term_count_bm[0];
                Sim_system.print_message("Collecting " + (n3 - term_count_bm[1]) + " additional observations (Total: " + (term_count += (long)(n3 - term_count_bm[1])) + ").");
                Sim_system.term_count_bm[0] = term_count_bm[1];
                Sim_system.term_count_bm[1] = n3;
                return true;
            }
            if (d5 >= 0.0) {
                n = 200;
                d6 = d / (double)n;
                d7 = 0.0;
                int n4 = 0;
                while (n4 < n) {
                    d4 = trans_time + (double)n4 * d6;
                    d3 = trans_time + (double)(n4 + 1) * d6;
                    d2 = ((Sim_stat)object2).average(term_measure, d4, d3);
                    object[n4] = d2;
                    d7 += d2;
                    ++n4;
                }
                d4 = Sim_system.serial_correlation(d7 /= (double)n, (double[])object);
                if (d4 > d5) {
                    int n5 = 2 * term_count_bm[0];
                    Sim_system.print_message("Collecting " + (n5 - term_count_bm[1]) + " additional observations (Total: " + (term_count += (long)(n5 - term_count_bm[1])) + ").");
                    Sim_system.term_count_bm[0] = term_count_bm[1];
                    Sim_system.term_count_bm[1] = n5;
                    return true;
                }
            }
            n = 30;
            d6 = d / (double)n;
            d7 = 0.0;
            int n6 = 0;
            while (n6 < n) {
                d4 = trans_time + (double)n6 * d6;
                d3 = trans_time + (double)(n6 + 1) * d6;
                d2 = ((Sim_stat)object2).average(term_measure, d4, d3);
                object[n6] = d2;
                d7 += d2;
                ++n6;
            }
            d7 /= (double)n;
            d4 = 0.0;
            int n7 = 0;
            while (n7 < n) {
                d4 += Math.pow((double)(object[n7] - d7), 2.0);
                ++n7;
            }
            d4 = d4 / (double)(n - 1) / (double)n;
            double d10 = Math.sqrt(d4);
            double d11 = Sim_system.qt(1.0 - (1.0 - confidence_level) / 2.0, n, true);
            double d12 = d11 * d10;
            double d13 = d12 / d7;
            if (d13 >= term_accuracy) {
                int n8 = 2 * term_count_bm[0];
                term_count += (long)(n8 - term_count_bm[1]);
                Sim_system.print_message("Collecting " + (n8 - term_count_bm[1]) + " additional observations.");
                Sim_system.term_count_bm[0] = term_count_bm[1];
                Sim_system.term_count_bm[1] = n8;
                return true;
            }
            max_batches = min_batches = 30;
        }
        object2 = new int[max_batches - min_batches + 1];
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n = entities.size();
        int n9 = 0;
        while (n9 < n) {
            String string = ((Sim_entity)entities.get(n9)).get_name();
            Sim_stat sim_stat = ((Sim_entity)entities.get(n9)).get_stat();
            if (sim_stat == null) {
                arrayList.add(new Object[]{string, null});
            } else {
                object = sim_stat.get_measures();
                ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
                int n10 = object.size();
                int n11 = 0;
                while (n11 < n10) {
                    String string2 = (String)((Object[])object.get(n11))[0];
                    Integer n12 = (Integer)((Object[])object.get(n11))[1];
                    int n13 = min_batches;
                    double d14 = -1.0;
                    ArrayList<double[]> arrayList3 = new ArrayList<double[]>();
                    int n14 = min_batches;
                    while (n14 <= max_batches) {
                        double d15;
                        double d16 = d / (double)n14;
                        double d17 = 0.0;
                        double[] dArray = new double[n14];
                        int n15 = 0;
                        while (n15 < n14) {
                            double d18;
                            d15 = trans_time + (double)n15 * d16;
                            double d19 = trans_time + (double)(n15 + 1) * d16;
                            dArray[n15] = d18 = sim_stat.average(string2, d15, d19);
                            d17 += d18;
                            ++n15;
                        }
                        d17 /= (double)n14;
                        d15 = 0.0;
                        int n16 = 0;
                        while (n16 < n14) {
                            d15 += Math.pow(dArray[n16] - d17, 2.0);
                            ++n16;
                        }
                        d15 = d15 / (double)(n14 - 1) / (double)n14;
                        double d20 = Math.sqrt(d15);
                        double d21 = Sim_system.qt(1.0 - (1.0 - confidence_level) / 2.0, n14 - 1, true);
                        double d22 = d21 * d20;
                        double[] dArray2 = new double[]{d17 - d22, d17, d17 + d22, d15, d17 == 0.0 ? 0.0 : d22 / d17};
                        arrayList3.add(dArray2);
                        double d23 = Sim_system.serial_correlation(d17, dArray);
                        if (n14 == min_batches) {
                            d14 = d23;
                        } else if (d23 < d14) {
                            n13 = n14;
                            d14 = d23;
                        }
                        ++n14;
                    }
                    arrayList2.add(new Object[]{string2, n12, arrayList3});
                    Object object3 = object2;
                    int n17 = n13 - min_batches;
                    object3[n17] = object3[n17] + true;
                    ++n11;
                }
                arrayList.add(new Object[]{string, arrayList2});
            }
            ++n9;
        }
        int n18 = 0;
        int n19 = 1;
        while (n19 < ((int[])object2).length) {
            if (object2[n19] > object2[n18]) {
                n18 = n19;
            }
            ++n19;
        }
        int n20 = arrayList.size();
        int n21 = 0;
        while (n21 < n20) {
            List list = (List)((Object[])arrayList.get(n21))[1];
            if (list != null) {
                Sim_stat sim_stat = ((Sim_entity)entities.get(n21)).get_stat();
                int n22 = list.size();
                int n23 = 0;
                while (n23 < n22) {
                    Object[] objectArray;
                    Object[] objectArray2 = (Object[])list.get(n23);
                    String string = (String)objectArray2[0];
                    int n24 = (Integer)objectArray2[1];
                    double[] dArray = sim_stat.get_levels(string);
                    List list2 = (List)objectArray2[2];
                    double[] dArray3 = (double[])list2.get(n18);
                    switch (n24) {
                        case 0: {
                            objectArray = new Object[]{new Double(dArray3[0]), new Double(dArray3[1]), new Double(dArray3[2]), new Double(dArray3[3]), new Double(dArray3[4]), new Double(Math.sqrt(dArray3[3])), new Double(sim_stat.count(string, trans_time, clock))};
                            break;
                        }
                        default: {
                            objectArray = dArray != null ? new Object[9] : new Object[8];
                            objectArray[0] = new Double(dArray3[0]);
                            objectArray[1] = new Double(dArray3[1]);
                            objectArray[2] = new Double(dArray3[2]);
                            objectArray[3] = new Double(dArray3[3]);
                            objectArray[4] = new Double(dArray3[4]);
                            objectArray[5] = new Double(Math.sqrt(dArray3[3]));
                            if (string.equals("Utilisation")) break;
                            objectArray[6] = new Double(sim_stat.maximum(string, trans_time, clock));
                            objectArray[7] = new Double(sim_stat.minimum(string, trans_time, clock));
                            if (dArray == null) break;
                            double[] dArray4 = sim_stat.exc_proportion(string, dArray, trans_time, clock);
                            double[][] dArray5 = new double[dArray.length][2];
                            int n25 = 0;
                            while (n25 < dArray.length) {
                                dArray5[n25][0] = dArray[n25];
                                dArray5[n25][1] = dArray4[n25];
                                ++n25;
                            }
                            objectArray[8] = dArray5;
                        }
                    }
                    objectArray2[2] = objectArray;
                    ++n23;
                }
            }
            ++n21;
        }
        ArrayList<Sim_stat> arrayList4 = new ArrayList<Sim_stat>();
        int n26 = 0;
        while (n26 < n) {
            arrayList4.add(((Sim_entity)entities.get(n26)).get_stat());
            ++n26;
        }
        run_data = new Object[8];
        long l = System.currentTimeMillis();
        Sim_system.run_data[0] = new long[]{start_date, l};
        Sim_system.run_data[1] = new int[]{trans_condition, term_condition, output_analysis_type};
        Sim_system.run_data[2] = new double[]{clock, trans_time};
        Sim_system.run_data[3] = initial_seeds;
        Sim_system.run_data[4] = new Double(confidence_level);
        Sim_system.run_data[5] = arrayList;
        Sim_system.run_data[6] = new Object[]{new Integer(n18 + min_batches), new Double((clock - trans_time) / (double)(n18 + min_batches))};
        Sim_system.run_data[7] = arrayList4;
        return false;
    }

    private static double serial_correlation(double d, double[] dArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = dArray.length;
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n) {
            if (n3 < n - 1) {
                d2 += (dArray[n3] - d) * (dArray[n3 + 1] - d);
            }
            if (n3 < n2 - 1) {
                d4 += dArray[n3];
            } else {
                d5 += dArray[n3];
            }
            d3 += Math.pow(dArray[n3] - d, 2.0);
            ++n3;
        }
        double d6 = d2 / d3;
        d4 /= (double)n2;
        d5 /= (double)n2;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        int n4 = 0;
        while (n4 < n - 1) {
            if (n4 < n2 - 1) {
                d7 += (dArray[n4] - d4) * (dArray[n4 + 1] - d4);
                d8 += Math.pow(dArray[n4] - d4, 2.0);
            } else {
                d9 += (dArray[n4] - d5) * (dArray[n4 + 1] - d5);
                d10 += Math.pow(dArray[n4] - d5, 2.0);
            }
            ++n4;
        }
        double d11 = d7 / d8;
        double d12 = d9 / d10;
        return 2.0 * d6 - (d11 + d12) / 2.0;
    }

    private static double qnorm(double d) {
        double d2 = 0.42;
        double d3 = 2.50662823884;
        double d4 = -18.61500062529;
        double d5 = 41.39119773534;
        double d6 = -25.44106049637;
        double d7 = -8.4735109309;
        double d8 = 23.08336743743;
        double d9 = -21.06224101826;
        double d10 = 3.13082909833;
        double d11 = -2.78718931138;
        double d12 = -2.29796479134;
        double d13 = 4.85014127135;
        double d14 = 2.32121276858;
        double d15 = 3.54388924762;
        double d16 = 1.63706781897;
        double d17 = d - 0.5;
        double d18 = -1.0;
        if (Math.abs(d17) <= d2) {
            double d19 = d17 * d17;
            d18 = d17 * (((d6 * d19 + d5) * d19 + d4) * d19 + d3) / ((((d10 * d19 + d9) * d19 + d8) * d19 + d7) * d19 + 1.0);
        } else {
            double d20 = d;
            if (d17 > 0.0) {
                d20 = 1.0 - d;
            }
            if (d20 > 0.0) {
                d20 = Math.sqrt(-Math.log(d20));
                d18 = (((d14 * d20 + d13) * d20 + d12) * d20 + d11) / ((d16 * d20 + d15) * d20 + 1.0);
                d18 = d17 < 0.0 ? -d18 : 0.0;
            }
        }
        return d18;
    }

    private static double qt(double d, int n, boolean bl) {
        double d2;
        double d3;
        boolean bl2;
        if (d <= 0.0 || d >= 1.0 || n < 1) {
            return -1.0;
        }
        double d4 = 1.0E-12;
        double d5 = 1.5707963267948966;
        if (bl && d > 0.5 || !bl && d < 0.5) {
            bl2 = false;
            d3 = 2.0 * (bl ? 1.0 - d : d);
        } else {
            bl2 = true;
            d3 = 2.0 * (bl ? d : 1.0 - d);
        }
        if ((double)Math.abs(n - 2) < d4) {
            d2 = Math.sqrt(2.0 / (d3 * (2.0 - d3)) - 2.0);
        } else if ((double)n < 1.0 + d4) {
            double d6 = d3 * d5;
            d2 = Math.cos(d6) / Math.sin(d6);
        } else {
            double d7 = 1.0 / ((double)n - 0.5);
            double d8 = 48.0 / (d7 * d7);
            double d9 = ((20700.0 * d7 / d8 - 98.0) * d7 - 16.0) * d7 + 96.36;
            double d10 = ((94.5 / (d8 + d9) - 3.0) / d8 + 1.0) * Math.sqrt(d7 * d5) * (double)n;
            double d11 = Math.pow(d10 * d3, 2 / n);
            if (d11 > 0.05 + d7) {
                double d12 = Sim_system.qnorm(0.5 * d3);
                d11 = d12 * d12;
                if (n < 5) {
                    d9 += 0.3 * ((double)n - 4.5) * (d12 + 0.6);
                }
                d9 = (((0.05 * d10 * d12 - 5.0) * d12 - 7.0) * d12 - 2.0) * d12 + d8 + d9;
                d11 = (((((0.4 * d11 + 6.3) * d11 + 36.0) * d11 + 94.5) / d9 - d11 - 3.0) / d8 + 1.0) * d12;
                d11 = (d11 = d7 * d11 * d11) > 0.002 ? Math.exp(d11) - 1.0 : (0.5 * d11 + 1.0) * d11;
            } else {
                d11 = ((1.0 / (((double)(n + 6) / ((double)n * d11) - 0.089 * d10 - 0.822) * (double)(n + 2) * 3.0) + 0.5 / (double)(n + 4)) * d11 - 1.0) * (double)(n + 1) / (double)(n + 2) + 1.0 / d11;
            }
            d2 = Math.sqrt((double)n * d11);
        }
        if (bl2) {
            d2 = -d2;
        }
        return d2;
    }

    private static void reset() {
        future.clear();
        deferred.clear();
        entities.clear();
        wait_predicates.clear();
        int n = backup.size();
        int n2 = 0;
        while (n2 < n) {
            Sim_entity sim_entity;
            Sim_entity sim_entity2 = (Sim_entity)backup.get(n2);
            try {
                sim_entity = (Sim_entity)sim_entity2.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Sim_exception("Could not reset entity " + sim_entity2.get_name() + ".");
            }
            sim_entity.reset();
            entities.add(sim_entity);
            ++n2;
        }
        clock = 0.0;
        term_count = initial_term_count;
        trans_count = initial_trans_count;
        term_time = initial_term_time;
        trans_time = -1.0;
        term_event_counter = 0L;
        transient_term_event_count = 0L;
        trans_event_counter = 0L;
        in_steady_state = false;
        onestopped = new Semaphore(0);
        onecompleted = new Semaphore(0);
        if (term_times != null) {
            term_times.clear();
        }
    }

    public static void generate_report() {
        List list;
        int n;
        Object object;
        int n2;
        Object object2;
        int n3;
        Object object3;
        Object[] objectArray;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        Object object4;
        Object object5;
        int n11;
        List list2;
        String string;
        String string2;
        String string3;
        Sim_reporter sim_reporter = animation ? ((Sim_anim)trcout).get_reporter() : new Sim_reportfile("sim_report");
        sim_reporter.setup_report();
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        DateFormat dateFormat2 = DateFormat.getTimeInstance(1);
        sim_reporter.append_report("############################################################");
        sim_reporter.append_report("#                                                          #");
        sim_reporter.append_report("#                    SIMULATION REPORT                     #");
        sim_reporter.append_report("#                                                          #");
        sim_reporter.append_report("############################################################");
        sim_reporter.append_report("");
        sim_reporter.append_report("Version: SimJava 2.0");
        sim_reporter.append_report("");
        sim_reporter.append_report("Simulation date:         " + dateFormat.format(new Date(((long[])run_data[0])[0])));
        sim_reporter.append_report("Simulation start time:   " + dateFormat2.format(new Date(((long[])run_data[0])[0])));
        sim_reporter.append_report("Simulation end time:     " + dateFormat2.format(new Date(((long[])run_data[0])[1])));
        sim_reporter.append_report("");
        sim_reporter.append_report("############################################################");
        sim_reporter.append_report("#            Overall simulation run information            #");
        sim_reporter.append_report("############################################################");
        sim_reporter.append_report("");
        sim_reporter.append_report("Total simulated time:    " + ((double[])run_data[2])[0]);
        sim_reporter.append_report("Total transient time:    " + ((double[])run_data[2])[1]);
        sim_reporter.append_report("Total steady state time: " + (((double[])run_data[2])[0] - ((double[])run_data[2])[1]));
        int n12 = ((int[])run_data[1])[0];
        int n13 = ((int[])run_data[1])[1];
        int n14 = ((int[])run_data[1])[2];
        switch (n12) {
            case 1: {
                string3 = initial_trans_count + " event completions at " + Sim_system.get_entity(trans_entity_id).get_name();
                break;
            }
            case 2: {
                string3 = initial_trans_time + " units of elapsed simulated time";
                break;
            }
            case 3: {
                string3 = "Truncation based on minimum and maximum observations for " + trans_measure + " of " + Sim_system.get_entity(trans_entity_id).get_name();
                break;
            }
            default: {
                string3 = "None";
            }
        }
        switch (n13) {
            case 1: {
                string2 = initial_term_count + " event completions at " + Sim_system.get_entity(term_entity_id).get_name();
                break;
            }
            case 2: {
                string2 = initial_term_time + " units of elapsed simulated time";
                break;
            }
            case 6: {
                string2 = "Confidence interval accuracy for " + term_measure + " of " + Sim_system.get_entity(term_entity_id).get_name();
                break;
            }
            default: {
                string2 = "None";
            }
        }
        switch (n14) {
            case 4: {
                string = "Independent replications";
                break;
            }
            case 5: {
                string = "Batch means";
                break;
            }
            default: {
                string = "None";
            }
        }
        sim_reporter.append_report("Transient condition:     " + string3);
        sim_reporter.append_report("Termination condition:   " + string2);
        sim_reporter.append_report("Output analysis method:  " + string);
        if (n14 == 4) {
            sim_reporter.append_report("Confidence level:        " + (Double)run_data[4]);
            sim_reporter.append_report("Replications performed:  " + (Integer)run_data[6]);
        } else if (n14 == 5) {
            sim_reporter.append_report("Confidence level:        " + (Double)run_data[4]);
            sim_reporter.append_report("Number of batches:       " + (Integer)((Object[])run_data[6])[0]);
            sim_reporter.append_report("Individual batch length: " + (Double)((Object[])run_data[6])[1]);
        }
        sim_reporter.append_report("");
        if (n14 != 0) {
            list2 = (List)run_data[5];
            if (Sim_system.measures_exist()) {
                sim_reporter.append_report("############################################################");
                sim_reporter.append_report("#       Total measurements and confidence intervals        #");
                sim_reporter.append_report("############################################################");
                sim_reporter.append_report("");
                n11 = list2.size();
                int n15 = 0;
                while (n15 < n11) {
                    object5 = (Object[])list2.get(n15);
                    object4 = (String)object5[0];
                    List list3 = (List)object5[1];
                    if (list3 != null) {
                        n10 = ((String)object4).length();
                        n9 = (60 - (n10 + 2)) / 2;
                        n8 = 60 - (n9 + n10 + 2);
                        StringBuffer stringBuffer = new StringBuffer(60);
                        n7 = 0;
                        while (n7 < n9) {
                            stringBuffer.append('-');
                            ++n7;
                        }
                        stringBuffer.append(" " + (String)object4 + " ");
                        n6 = 0;
                        while (n6 < n8) {
                            stringBuffer.append('-');
                            ++n6;
                        }
                        sim_reporter.append_report(stringBuffer.toString());
                        sim_reporter.append_report("");
                        n5 = list3.size();
                        n4 = 0;
                        while (n4 < n5) {
                            objectArray = (Object[])list3.get(n4);
                            object3 = (String)objectArray[0];
                            n3 = (Integer)objectArray[1];
                            Object[] objectArray2 = (Object[])objectArray[2];
                            sim_reporter.append_report("- " + (String)object3);
                            sim_reporter.append_report("");
                            switch (n3) {
                                case 0: {
                                    sim_reporter.append_report("Total mean:          " + (Double)objectArray2[1]);
                                    sim_reporter.append_report("Interval low bound:  " + (Double)objectArray2[0]);
                                    sim_reporter.append_report("Interval high bound: " + (Double)objectArray2[2]);
                                    sim_reporter.append_report("Interval half width: " + ((Double)objectArray2[2] - (Double)objectArray2[0]) / 2.0);
                                    sim_reporter.append_report("Accuracy ratio:      " + (Double)objectArray2[4]);
                                    sim_reporter.append_report("Mean variance:       " + (Double)objectArray2[3]);
                                    sim_reporter.append_report("Mean std deviation:  " + (Double)objectArray2[5]);
                                    sim_reporter.append_report("Average event count: " + (Double)objectArray2[6]);
                                    break;
                                }
                                default: {
                                    sim_reporter.append_report("Total mean:          " + (Double)objectArray2[1]);
                                    sim_reporter.append_report("Interval low bound:  " + (Double)objectArray2[0]);
                                    sim_reporter.append_report("Interval high bound: " + (Double)objectArray2[2]);
                                    sim_reporter.append_report("Interval half width: " + ((Double)objectArray2[2] - (Double)objectArray2[0]) / 2.0);
                                    sim_reporter.append_report("Accuracy ratio:      " + (Double)objectArray2[4]);
                                    sim_reporter.append_report("Mean variance:       " + (Double)objectArray2[3]);
                                    sim_reporter.append_report("Mean std deviation:  " + (Double)objectArray2[5]);
                                    if (((String)object3).equals("Utilisation")) break;
                                    sim_reporter.append_report("Total maximum:       " + (Double)objectArray2[6]);
                                    sim_reporter.append_report("Total minimum:       " + (Double)objectArray2[7]);
                                    if (objectArray2.length != 9) break;
                                    sim_reporter.append_report("Total average exceedence proportions:");
                                    object2 = (double[][])objectArray2[8];
                                    int n16 = 0;
                                    while (n16 < ((Object[])object2).length) {
                                        if (n16 + 1 == ((Object)object2).length) {
                                            sim_reporter.append_report("    " + (double)object2[n16][0] + " < " + (String)object3 + " : " + (double)object2[n16][1]);
                                        } else {
                                            sim_reporter.append_report("    " + (double)object2[n16][0] + " < " + (String)object3 + " <= " + (double)object2[n16 + 1][0] + " : " + Math.abs((double)(object2[n16][1] - object2[n16 + 1][1])));
                                        }
                                        ++n16;
                                    }
                                    break block14;
                                }
                            }
                            sim_reporter.append_report("");
                            ++n4;
                        }
                    }
                    ++n15;
                }
            }
        } else {
            double d = ((double[])run_data[2])[0];
            double d2 = ((double[])run_data[2])[1];
            object4 = (List)run_data[4];
            if (Sim_system.measures_exist()) {
                sim_reporter.append_report("############################################################");
                sim_reporter.append_report("#               Simulation run measurements                #");
                sim_reporter.append_report("############################################################");
                sim_reporter.append_report("");
                int n17 = object4.size();
                n10 = 0;
                while (n10 < n17) {
                    Sim_stat sim_stat = (Sim_stat)object4.get(n10);
                    if (sim_stat != null) {
                        String string4 = sim_stat.get_name();
                        int n18 = string4.length();
                        n7 = (60 - (n18 + 2)) / 2;
                        n6 = 60 - (n7 + n18 + 2);
                        StringBuffer stringBuffer = new StringBuffer(60);
                        n4 = 0;
                        while (n4 < n7) {
                            stringBuffer.append('-');
                            ++n4;
                        }
                        stringBuffer.append(" " + string4 + " ");
                        int n19 = 0;
                        while (n19 < n6) {
                            stringBuffer.append('-');
                            ++n19;
                        }
                        sim_reporter.append_report(stringBuffer.toString());
                        sim_reporter.append_report("");
                        object3 = sim_stat.get_measures();
                        n3 = object3.size();
                        int n20 = 0;
                        while (n20 < n3) {
                            object2 = (Object[])object3.get(n20);
                            String string5 = (String)object2[0];
                            n2 = (Integer)object2[1];
                            double[] dArray = sim_stat.get_levels(string5);
                            sim_reporter.append_report("- " + string5);
                            sim_reporter.append_report("");
                            switch (n2) {
                                case 0: {
                                    if (sim_stat.is_efficient(string5)) {
                                        sim_reporter.append_report("Sample mean:          " + sim_stat.average(string5));
                                        sim_reporter.append_report("Event count:          " + sim_stat.count(string5));
                                        break;
                                    }
                                    sim_reporter.append_report("Sample mean:          " + sim_stat.average(string5, d2, d));
                                    sim_reporter.append_report("Event count:          " + sim_stat.count(string5, d2, d));
                                    break;
                                }
                                default: {
                                    if (sim_stat.is_efficient(string5)) {
                                        sim_reporter.append_report("Sample mean:          " + sim_stat.average(string5));
                                        if (string5.equals("Utilisation")) break;
                                        sim_reporter.append_report("Sample variance:      Not available in efficient mode");
                                        sim_reporter.append_report("Sample std deviation: Not available in efficient mode");
                                        sim_reporter.append_report("Maximum:              " + sim_stat.maximum(string5));
                                        sim_reporter.append_report("Minimum:              " + sim_stat.minimum(string5));
                                        if (dArray == null) break;
                                        sim_reporter.append_report("Exceedence proportions:");
                                        object = sim_stat.exc_proportion(string5);
                                        n = 0;
                                        while (n < dArray.length) {
                                            if (n + 1 == dArray.length) {
                                                sim_reporter.append_report("      " + dArray[n] + " < " + string5 + " : " + (double)object[n]);
                                            } else {
                                                sim_reporter.append_report("      " + dArray[n] + " < " + string5 + " <= " + dArray[n + 1] + " : " + Math.abs((double)(object[n] - object[n + 1])));
                                            }
                                            ++n;
                                        }
                                    } else {
                                        sim_reporter.append_report("Sample mean:          " + sim_stat.average(string5, d2, d));
                                        if (string5.equals("Utilisation")) break;
                                        sim_reporter.append_report("Sample variance:      " + sim_stat.variance(string5, d2, d));
                                        sim_reporter.append_report("Sample std deviation: " + sim_stat.std_deviation(string5, d2, d));
                                        sim_reporter.append_report("Maximum:              " + sim_stat.maximum(string5, d2, d));
                                        sim_reporter.append_report("Minimum:              " + sim_stat.minimum(string5, d2, d));
                                        if (dArray == null) break;
                                        sim_reporter.append_report("Exceedence proportions:");
                                        object = sim_stat.exc_proportion(string5, dArray, d2, d);
                                        n = 0;
                                        while (n < dArray.length) {
                                            if (n + 1 == dArray.length) {
                                                sim_reporter.append_report("      " + dArray[n] + " < " + string5 + " : " + (double)object[n]);
                                            } else {
                                                sim_reporter.append_report("      " + dArray[n] + " < " + string5 + " <= " + dArray[n + 1] + " : " + Math.abs((double)(object[n] - object[n + 1])));
                                            }
                                            ++n;
                                        }
                                        break block17;
                                    }
                                }
                            }
                            sim_reporter.append_report("");
                            ++n20;
                        }
                    }
                    ++n10;
                }
            }
        }
        if (detailed_report) {
            Object[] objectArray3;
            int n21;
            Object object6;
            int n22;
            if (n14 == 4) {
                sim_reporter.append_report("############################################################");
                sim_reporter.append_report("#           Individual replication measurements            #");
                sim_reporter.append_report("############################################################");
                sim_reporter.append_report("");
                list2 = (List)run_data[7];
                n11 = list2.size();
                int n23 = 0;
                while (n23 < n11) {
                    object5 = "Replication " + (n23 + 1);
                    int n24 = ((String)object5).length();
                    int n25 = (60 - (n24 + 2)) / 2;
                    n10 = 60 - (n25 + n24 + 2);
                    StringBuffer stringBuffer = new StringBuffer(60);
                    stringBuffer.append('#');
                    n8 = 0;
                    while (n8 < n25 - 1) {
                        stringBuffer.append(' ');
                        ++n8;
                    }
                    stringBuffer.append(" " + (String)object5 + " ");
                    int n26 = 0;
                    while (n26 < n10 - 1) {
                        stringBuffer.append(' ');
                        ++n26;
                    }
                    stringBuffer.append('#');
                    sim_reporter.append_report("############################################################");
                    sim_reporter.append_report(stringBuffer.toString());
                    sim_reporter.append_report("############################################################");
                    sim_reporter.append_report("");
                    Object[] objectArray4 = (Object[])list2.get(n23);
                    double d = ((double[])objectArray4[0])[0];
                    double d3 = ((double[])objectArray4[0])[1];
                    sim_reporter.append_report("Total time:        " + d);
                    sim_reporter.append_report("Transient time:    " + d3);
                    sim_reporter.append_report("Steady state time: " + (d - d3));
                    sim_reporter.append_report("");
                    object3 = (List)objectArray4[1];
                    n3 = object3.size();
                    int n27 = 0;
                    while (n27 < n3) {
                        object2 = (Sim_stat)object3.get(n27);
                        if (object2 != null) {
                            String string6 = ((Sim_stat)object2).get_name();
                            n24 = string6.length();
                            n25 = (60 - (n24 + 2)) / 2;
                            n10 = 60 - (n25 + n24 + 2);
                            stringBuffer = new StringBuffer(60);
                            n2 = 0;
                            while (n2 < n25) {
                                stringBuffer.append('-');
                                ++n2;
                            }
                            stringBuffer.append(" " + string6 + " ");
                            int n28 = 0;
                            while (n28 < n10) {
                                stringBuffer.append('-');
                                ++n28;
                            }
                            sim_reporter.append_report(stringBuffer.toString());
                            sim_reporter.append_report("");
                            object = ((Sim_stat)object2).get_measures();
                            n = object.size();
                            n22 = 0;
                            while (n22 < n) {
                                Object[] objectArray5 = (Object[])object.get(n22);
                                object6 = (String)objectArray5[0];
                                n21 = (Integer)objectArray5[1];
                                double[] dArray = ((Sim_stat)object2).get_levels((String)object6);
                                sim_reporter.append_report("- " + (String)object6);
                                sim_reporter.append_report("");
                                switch (n21) {
                                    case 0: {
                                        if (((Sim_stat)object2).is_efficient((String)object6)) {
                                            sim_reporter.append_report("Sample mean:          " + ((Sim_stat)object2).average((String)object6));
                                            sim_reporter.append_report("Event count:          " + ((Sim_stat)object2).count((String)object6));
                                            break;
                                        }
                                        sim_reporter.append_report("Sample mean:          " + ((Sim_stat)object2).average((String)object6, d3, d));
                                        sim_reporter.append_report("Event count:          " + ((Sim_stat)object2).count((String)object6, d3, d));
                                        break;
                                    }
                                    default: {
                                        int n29;
                                        if (((Sim_stat)object2).is_efficient((String)object6)) {
                                            sim_reporter.append_report("Sample mean:          " + ((Sim_stat)object2).average((String)object6));
                                            if (((String)object6).equals("Utilisation")) break;
                                            sim_reporter.append_report("Sample variance:      Not available in efficient mode");
                                            sim_reporter.append_report("Sample std deviation: Not available in efficient mode");
                                            sim_reporter.append_report("Maximum:              " + ((Sim_stat)object2).maximum((String)object6));
                                            sim_reporter.append_report("Minimum:              " + ((Sim_stat)object2).minimum((String)object6));
                                            if (dArray == null) break;
                                            sim_reporter.append_report("Exceedence proportions:");
                                            objectArray3 = ((Sim_stat)object2).exc_proportion((String)object6);
                                            n29 = 0;
                                            while (n29 < dArray.length) {
                                                if (n29 + 1 == dArray.length) {
                                                    sim_reporter.append_report("      " + dArray[n29] + " < " + (String)object6 + " : " + (double)objectArray3[n29]);
                                                } else {
                                                    sim_reporter.append_report("      " + dArray[n29] + " < " + (String)object6 + " <= " + dArray[n29 + 1] + " : " + Math.abs((double)(objectArray3[n29] - objectArray3[n29 + 1])));
                                                }
                                                ++n29;
                                            }
                                        } else {
                                            sim_reporter.append_report("Sample mean:          " + ((Sim_stat)object2).average((String)object6, d3, d));
                                            if (((String)object6).equals("Utilisation")) break;
                                            sim_reporter.append_report("Sample variance:      " + ((Sim_stat)object2).variance((String)object6, d3, d));
                                            sim_reporter.append_report("Sample std deviation: " + ((Sim_stat)object2).std_deviation((String)object6, d3, d));
                                            sim_reporter.append_report("Maximum:              " + ((Sim_stat)object2).maximum((String)object6, d3, d));
                                            sim_reporter.append_report("Minimum:              " + ((Sim_stat)object2).minimum((String)object6, d3, d));
                                            if (dArray == null) break;
                                            sim_reporter.append_report("Exceedence proportions:");
                                            objectArray3 = ((Sim_stat)object2).exc_proportion((String)object6, dArray, d3, d);
                                            n29 = 0;
                                            while (n29 < dArray.length) {
                                                if (n29 + 1 == dArray.length) {
                                                    sim_reporter.append_report("      " + dArray[n29] + " < " + (String)object6 + " : " + (double)objectArray3[n29]);
                                                } else {
                                                    sim_reporter.append_report("      " + dArray[n29] + " < " + (String)object6 + " <= " + dArray[n29 + 1] + " : " + Math.abs((double)(objectArray3[n29] - objectArray3[n29 + 1])));
                                                }
                                                ++n29;
                                            }
                                            break block20;
                                        }
                                    }
                                }
                                sim_reporter.append_report("");
                                ++n22;
                            }
                        }
                        ++n27;
                    }
                    ++n23;
                }
            } else if (n14 == 5) {
                sim_reporter.append_report("############################################################");
                sim_reporter.append_report("#              Individual batch measurements               #");
                sim_reporter.append_report("############################################################");
                sim_reporter.append_report("");
                double d = ((double[])run_data[2])[0];
                double d4 = ((double[])run_data[2])[1];
                int n30 = (Integer)((Object[])run_data[6])[0];
                double d5 = (Double)((Object[])run_data[6])[1];
                n9 = 0;
                while (n9 < n30) {
                    String string7 = "Batch " + (n9 + 1);
                    int n31 = string7.length();
                    n7 = (60 - (n31 + 2)) / 2;
                    n6 = 60 - (n7 + n31 + 2);
                    StringBuffer stringBuffer = new StringBuffer(60);
                    stringBuffer.append('#');
                    n4 = 0;
                    while (n4 < n7 - 1) {
                        stringBuffer.append(' ');
                        ++n4;
                    }
                    stringBuffer.append(" " + string7 + " ");
                    int n32 = 0;
                    while (n32 < n6 - 1) {
                        stringBuffer.append(' ');
                        ++n32;
                    }
                    stringBuffer.append('#');
                    sim_reporter.append_report("############################################################");
                    sim_reporter.append_report(stringBuffer.toString());
                    sim_reporter.append_report("############################################################");
                    sim_reporter.append_report("");
                    object3 = (List)run_data[7];
                    double d6 = d4 + (double)n9 * d5;
                    double d7 = d4 + (double)(n9 + 1) * d5;
                    sim_reporter.append_report("Start time: " + d6);
                    sim_reporter.append_report("End time:   " + d7);
                    sim_reporter.append_report("");
                    n2 = object3.size();
                    int n33 = 0;
                    while (n33 < n2) {
                        object = (Sim_stat)object3.get(n33);
                        if (object != null) {
                            String string8 = ((Sim_stat)object).get_name();
                            n31 = string8.length();
                            n7 = (60 - (n31 + 2)) / 2;
                            n6 = 60 - (n7 + n31 + 2);
                            stringBuffer = new StringBuffer(60);
                            n22 = 0;
                            while (n22 < n7) {
                                stringBuffer.append('-');
                                ++n22;
                            }
                            stringBuffer.append(" " + string8 + " ");
                            int n34 = 0;
                            while (n34 < n6) {
                                stringBuffer.append('-');
                                ++n34;
                            }
                            sim_reporter.append_report(stringBuffer.toString());
                            sim_reporter.append_report("");
                            object6 = ((Sim_stat)object).get_measures();
                            n21 = object6.size();
                            int n35 = 0;
                            while (n35 < n21) {
                                objectArray3 = (Object[])object6.get(n35);
                                String string9 = (String)objectArray3[0];
                                int n36 = (Integer)objectArray3[1];
                                double[] dArray = ((Sim_stat)object).get_levels(string9);
                                sim_reporter.append_report("- " + string9);
                                sim_reporter.append_report("");
                                switch (n36) {
                                    case 0: {
                                        sim_reporter.append_report("Sample mean:          " + ((Sim_stat)object).average(string9, d6, d7));
                                        sim_reporter.append_report("Event count:          " + ((Sim_stat)object).count(string9, d6, d7));
                                        break;
                                    }
                                    default: {
                                        sim_reporter.append_report("Sample mean:          " + ((Sim_stat)object).average(string9, d6, d7));
                                        if (string9.equals("Utilisation")) break;
                                        sim_reporter.append_report("Sample variance:      " + ((Sim_stat)object).variance(string9, d6, d7));
                                        sim_reporter.append_report("Sample std deviation: " + ((Sim_stat)object).std_deviation(string9, d6, d7));
                                        sim_reporter.append_report("Maximum:              " + ((Sim_stat)object).maximum(string9, d6, d7));
                                        sim_reporter.append_report("Minimum:              " + ((Sim_stat)object).minimum(string9, d6, d7));
                                        if (dArray == null) break;
                                        sim_reporter.append_report("Exceedence proportions:");
                                        double[] dArray2 = ((Sim_stat)object).exc_proportion(string9, dArray, d6, d7);
                                        int n37 = 0;
                                        while (n37 < dArray.length) {
                                            if (n37 + 1 == dArray.length) {
                                                sim_reporter.append_report("      " + dArray[n37] + " < " + string9 + " : " + dArray2[n37]);
                                            } else {
                                                sim_reporter.append_report("      " + dArray[n37] + " < " + string9 + " <= " + dArray[n37 + 1] + " : " + Math.abs(dArray2[n37] - dArray2[n37 + 1]));
                                            }
                                            ++n37;
                                        }
                                        break block23;
                                    }
                                }
                                sim_reporter.append_report("");
                                ++n35;
                            }
                        }
                        ++n33;
                    }
                    ++n9;
                }
            }
        }
        if (include_seeds && (list = (List)run_data[3]).size() != 0) {
            sim_reporter.append_report("############################################################");
            sim_reporter.append_report("#                     Generator seeds                      #");
            sim_reporter.append_report("############################################################");
            sim_reporter.append_report("");
            n11 = list.size();
            int n38 = 0;
            while (n38 < n11) {
                object5 = (Object[])list.get(n38);
                String string10 = (String)object5[0];
                int n39 = string10.length();
                n10 = (60 - (n39 + 2)) / 2;
                n9 = 60 - (n10 + n39 + 2);
                StringBuffer stringBuffer = new StringBuffer(60);
                int n40 = 0;
                while (n40 < n10) {
                    stringBuffer.append('-');
                    ++n40;
                }
                stringBuffer.append(" " + string10 + " ");
                int n41 = 0;
                while (n41 < n9) {
                    stringBuffer.append('-');
                    ++n41;
                }
                sim_reporter.append_report(stringBuffer.toString());
                sim_reporter.append_report("");
                List list4 = (List)object5[1];
                n5 = list4.size();
                int n42 = 0;
                while (n42 < n5) {
                    objectArray = (Object[])list4.get(n42);
                    object3 = (String)objectArray[0];
                    Long l = (Long)objectArray[1];
                    sim_reporter.append_report("- " + (String)object3 + ": " + l);
                    ++n42;
                }
                sim_reporter.append_report("");
                ++n38;
            }
        }
        sim_reporter.close_report();
    }

    private static void print_message(String string) {
        if (animation) {
            ((Sim_anim)trcout).get_applet().add_message(string);
        } else {
            System.out.println(string);
        }
    }

    public static boolean incomplete() {
        return incomplete;
    }

    public static void animation_stopped() {
        anim_stopped = true;
    }

    public static void set_trace_detail(boolean bl, boolean bl2, boolean bl3) {
        auto_trace = true;
        default_trace = bl;
        entity_trace = bl2;
        event_trace = bl3;
    }

    public static void track_event(int n) {
        auto_trace = true;
        if (trace_tags == null) {
            trace_tags = new int[1];
            Sim_system.trace_tags[0] = n;
        } else {
            int[] nArray = trace_tags;
            trace_tags = new int[nArray.length + 1];
            int n2 = 0;
            while (n2 < nArray.length) {
                Sim_system.trace_tags[n2] = nArray[n2];
                ++n2;
            }
            Sim_system.trace_tags[nArray.length] = n;
        }
    }

    public static void track_events(int[] nArray) {
        auto_trace = true;
        if (trace_tags == null) {
            trace_tags = nArray;
        } else {
            int[] nArray2 = trace_tags;
            trace_tags = new int[nArray2.length + nArray.length];
            int n = 0;
            while (n < nArray2.length) {
                Sim_system.trace_tags[n] = nArray2[n];
                ++n;
            }
            int n2 = nArray2.length - 1;
            while (n2 < nArray.length) {
                Sim_system.trace_tags[n2] = nArray[n2];
                ++n2;
            }
        }
    }

    static synchronized void trace(int n, String string) {
        trcout.println("u: " + ((Sim_entity)entities.get(n)).get_name() + " at " + clock + ": " + string);
    }

    static synchronized void ent_trace(int n, String string) {
        if (auto_trace && entity_trace || animation) {
            Sim_system.trace(n, string);
        }
    }

    private static boolean is_trace_tag(int n) {
        boolean bl = false;
        if (trace_tags != null) {
            int n2 = 0;
            while (n2 < trace_tags.length) {
                if (trace_tags[n2] == n) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generate_graphs() {
        if (!generate_graphs) {
            return;
        }
        ObjectOutputStream objectOutputStream = null;
        objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(graph_file)));
        System.out.print("Generating graph data...");
        objectOutputStream.writeObject(run_data);
        objectOutputStream.flush();
        objectOutputStream.close();
        System.out.println("finished.");
        Object var3_1 = null;
        if (objectOutputStream == null) return;
        try {
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                System.out.println("Unable to generate graph data: " + iOException.getMessage());
                Object var3_2 = null;
                if (objectOutputStream == null) return;
                try {
                    objectOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (objectOutputStream == null) throw throwable;
            try {
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static boolean measures_exist() {
        List list = output_analysis_type == 0 ? (List)run_data[4] : (output_analysis_type == 4 ? (List)((Object[])((List)run_data[7]).get(0))[1] : (List)run_data[7]);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Sim_stat sim_stat = (Sim_stat)list.get(n2);
            if (sim_stat != null && sim_stat.get_measures().size() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static synchronized double get_trans_time() {
        return trans_time;
    }

    static synchronized void efficient_measure_defined() {
        efficient_measure_defined = true;
    }

    private static void notify_stats_trans(double d) {
        int n = entities.size();
        int n2 = 0;
        while (n2 < n) {
            Sim_entity sim_entity = (Sim_entity)entities.get(n2);
            Sim_stat sim_stat = sim_entity.get_stat();
            if (sim_stat != null) {
                sim_stat.steady_state_reached(d);
            }
            ++n2;
        }
    }

    static boolean default_tracing() {
        return auto_trace && default_trace;
    }

    static {
        term_time = 0.0;
        initial_term_time = 0.0;
        initial_term_count = 0L;
        term_count = 0L;
        term_event_counter = 0L;
        transient_term_event_count = 0L;
        trans_condition = 0;
        trans_time = -1.0;
        initial_trans_time = 0.0;
        trans_count = 0L;
        initial_trans_count = 0L;
        trans_event_counter = 0L;
        in_steady_state = false;
        output_analysis_type = 0;
        incomplete = true;
        replication_count = 10;
        confidence_level = 0.9;
        total_time_elapsed = 0.0;
        total_transient_time = 0.0;
        min_batches = 10;
        max_batches = 20;
        default_trace = true;
        entity_trace = true;
        event_trace = true;
        detailed_report = false;
        include_seeds = false;
        root_seed = 4851L;
        seed_spacing = 100000;
        seed_source = new Sim_random_obj("Seed generator", root_seed);
        not_sampled = true;
        anim_stopped = false;
        generate_graphs = false;
        graph_file = "sim_graphs.sjg";
        efficient_measure_defined = false;
        SIM_ANY = new Sim_any_p();
        SIM_NONE = new Sim_none_p();
    }
}

