/*
 * Decompiled with CFR 0.152.
 */
package eduni.simjava;

import eduni.simjava.Sim_stat_exception;
import eduni.simjava.Sim_system;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Sim_stat
implements Serializable {
    public static final int RATE_BASED = 0;
    public static final int STATE_BASED = 1;
    public static final int INTERVAL_BASED = 2;
    static final int ARRIVAL = 0;
    static final int END_WAITING = 1;
    static final int END_SERVICE = 2;
    static final int END_RESIDENCE = 3;
    static final int END_HOLD = 4;
    public static final int ARRIVAL_RATE = 0;
    public static final int THROUGHPUT = 1;
    public static final int QUEUE_LENGTH = 2;
    public static final int UTILISATION = 3;
    public static final int WAITING_TIME = 4;
    public static final int RESIDENCE_TIME = 5;
    public static final int SERVICE_TIME = 6;
    private static final String[] measure_names = new String[]{"Arrival rate", "Throughput", "Queue length", "Utilisation", "Waiting time", "Residence time", "Service time"};
    private static final int[] measure_types = new int[]{0, 0, 1, 1, 2, 2, 2};
    private transient List tags;
    private transient List counters;
    private transient List init_counters;
    private List measures;
    private List observations = new ArrayList();
    private List levels = new ArrayList();
    private HashMap data;
    private List annotations;
    private transient int queue_length = 0;
    private transient double prev_time_queue = 0.0;
    private transient double prev_time_util = 0.0;
    private transient double started_busy;
    private transient boolean entity_busy = false;
    private int entity_id;
    private String entity_name;
    private double trans_time = -1.0;
    double end_time = -1.0;

    public Sim_stat() {
        this.measures = new ArrayList();
        this.tags = new ArrayList();
        this.counters = new ArrayList();
        this.init_counters = new ArrayList();
    }

    void set_entity_info(int n, String string) {
        this.entity_id = n;
        this.entity_name = string;
    }

    int get_id() {
        return this.entity_id;
    }

    public String get_name() {
        return this.entity_name;
    }

    public void add_measure(int n) {
        if (n < 0 || n > 6) {
            throw new Sim_stat_exception("The measure specified is not a default measure.");
        }
        if (this.is_selected(measure_names[n])) {
            throw new Sim_stat_exception(measure_names[n] + " is already being measured for this entity.");
        }
        this.measures.add(new Object[]{measure_names[n], new Integer(measure_types[n])});
        this.observations.add(new ArrayList());
    }

    public void add_measure(String string, int n) {
        if (n < 0 || n > 2) {
            throw new Sim_stat_exception("The specified measure type is not valid.");
        }
        if (this.is_selected(string)) {
            throw new Sim_stat_exception(string + " is already being measured for this entity.");
        }
        if (n == 1) {
            this.add_measure(string, n, 0.0);
        } else {
            this.measures.add(new Object[]{string, new Integer(n)});
            this.observations.add(new ArrayList());
        }
    }

    public void add_measure(String string, int n, double d) {
        if (n != 1) {
            throw new Sim_stat_exception("The specified measure type is not valid.");
        }
        if (this.is_selected(string)) {
            throw new Sim_stat_exception(string + " is already being measured for this entity.");
        }
        this.measures.add(new Object[]{string, new Integer(n), new Boolean(true)});
        this.observations.add(new ArrayList());
        this.counters.add(new Object[]{string, new Double(d), new Double(0.0)});
        this.init_counters.add(new Object[]{string, new Double(d), new Double(0.0)});
    }

    public void add_measure(String string, int n, boolean bl) {
        if (n != 1) {
            throw new Sim_stat_exception("The specified measure type is not valid.");
        }
        if (this.is_selected(string)) {
            throw new Sim_stat_exception(string + " is already being measured for this entity.");
        }
        if (bl) {
            this.add_measure(string, n, 0.0);
        } else {
            this.measures.add(new Object[]{string, new Integer(n), new Boolean(false)});
            this.observations.add(new ArrayList());
        }
    }

    public void calc_proportions(int n, double[] dArray) {
        this.calc_proportions(measure_names[n], dArray);
    }

    public void calc_proportions(String string, double[] dArray) {
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n == -1) {
            throw new Sim_stat_exception("The measure specified has not been defined.");
        }
        if (n2 != 1 && n2 != 2 || string.equals("Utilisation")) {
            throw new Sim_stat_exception("Exceedence proportions can't be calculated for " + string);
        }
        this.levels.add(new Object[]{string, dArray});
    }

    public void measure_for(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            Integer n2 = new Integer(nArray[n]);
            if (!this.tags.contains(n2)) {
                this.tags.add(n2);
            }
            ++n;
        }
    }

    public void set_efficient(int n) {
        this.set_efficient(measure_names[n]);
    }

    public void set_efficient(String string) {
        if (!this.is_selected(string)) {
            throw new Sim_stat_exception(string + " has not been measured for this entity.");
        }
        if (this.data == null) {
            this.data = new HashMap();
        }
        if (!this.data.containsKey(string)) {
            int n = this.get_type(this.get_id(string));
            switch (n) {
                case 0: {
                    this.data.put(string, new Long(0L));
                    break;
                }
                case 1: {
                    double d = 0.0;
                    Object[] objectArray = this.get_counters(string);
                    if (objectArray != null) {
                        d = (Double)objectArray[1];
                    }
                    if (this.get_levels(string) == null) {
                        this.data.put(string, new Object[]{new double[]{0.0, 0.0, 0.0, 0.0, d, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}});
                        break;
                    }
                    this.data.put(string, new Object[]{new double[]{0.0, 0.0, 0.0, 0.0, d, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}, new double[this.get_levels(string).length]});
                    break;
                }
                case 2: {
                    if (this.get_levels(string) == null) {
                        this.data.put(string, new Object[]{new double[]{0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0}});
                        break;
                    }
                    this.data.put(string, new Object[]{new double[]{0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0}, new double[this.get_levels(string).length]});
                }
            }
            Sim_system.efficient_measure_defined();
        }
    }

    void update(int n, int n2, double d) {
        if (n != 0) {
            throw new Sim_stat_exception("Invalid event type.");
        }
        if (d < 0.0) {
            throw new Sim_stat_exception("Invalid event occurance time.");
        }
        if (this.tags.contains(new Integer(n2)) || this.tags.size() == 0) {
            Object object;
            if (this.is_selected(measure_names[0])) {
                if (this.is_efficient(measure_names[0])) {
                    object = (Object[])this.data.get(measure_names[0]);
                    object = new Long(object.longValue() + 1L);
                    this.data.put(measure_names[0], object);
                } else {
                    ((List)this.observations.get(this.get_id(measure_names[0]))).add(new Double(d));
                }
                Sim_system.observation_collected(this.entity_id, measure_names[0]);
            }
            if (this.is_selected(measure_names[2])) {
                if (this.is_efficient(measure_names[2])) {
                    object = (Object[])this.data.get(measure_names[2]);
                    double[] dArray = (double[])object[0];
                    if (d == this.trans_time) {
                        dArray[4] = dArray[4] + 1.0;
                        this.data.put(measure_names[2], object);
                        Sim_system.observation_collected(this.entity_id, measure_names[2]);
                        return;
                    }
                    dArray[0] = dArray[0] + dArray[4] * (d - dArray[3]);
                    dArray[1] = dArray[1] + (d - dArray[3]);
                    if (((Object[])object).length == 2) {
                        double[] dArray2 = (double[])object[1];
                        double[] dArray3 = this.get_levels(measure_names[2]);
                        int n3 = 0;
                        while (n3 < dArray3.length) {
                            if (dArray[4] > dArray3[n3]) {
                                int n4 = n3;
                                dArray2[n4] = dArray2[n4] + (d - dArray[3]);
                            }
                            ++n3;
                        }
                    }
                    dArray[2] = dArray[3];
                    dArray[3] = d;
                    if (dArray[4] < dArray[5]) {
                        dArray[5] = dArray[4];
                    }
                    if (dArray[4] > dArray[6]) {
                        dArray[6] = dArray[4];
                    }
                    dArray[4] = dArray[4] + 1.0;
                    this.data.put(measure_names[2], object);
                    Sim_system.observation_collected(this.entity_id, measure_names[2]);
                } else {
                    ((List)this.observations.get(this.get_id(measure_names[2]))).add(new double[]{this.queue_length, this.prev_time_queue, d});
                    ++this.queue_length;
                    this.prev_time_queue = d;
                    Sim_system.observation_collected(this.entity_id, measure_names[2]);
                }
            }
        }
    }

    void update(int n, int n2, double d, double d2) {
        if (n < 1 || n > 3) {
            throw new Sim_stat_exception("Invalid event type.");
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            throw new Sim_stat_exception("Invalid event occurance times.");
        }
        if (this.tags.contains(new Integer(n2)) || this.tags.size() == 0) {
            switch (n) {
                case 1: {
                    int n3;
                    double[] dArray;
                    double[] dArray2;
                    double[] dArray3;
                    Object[] objectArray;
                    if (this.is_selected(measure_names[2])) {
                        if (this.is_efficient(measure_names[2])) {
                            objectArray = (Object[])this.data.get(measure_names[2]);
                            dArray3 = (double[])objectArray[0];
                            if (d2 == this.trans_time) {
                                dArray3[4] = dArray3[4] - 1.0;
                                this.data.put(measure_names[2], objectArray);
                            } else {
                                dArray3[0] = dArray3[0] + dArray3[4] * (d2 - dArray3[3]);
                                dArray3[1] = dArray3[1] + (d2 - dArray3[3]);
                                if (objectArray.length == 2) {
                                    dArray2 = (double[])objectArray[1];
                                    dArray = this.get_levels(measure_names[2]);
                                    n3 = 0;
                                    while (n3 < dArray.length) {
                                        if (dArray3[4] > dArray[n3]) {
                                            int n4 = n3;
                                            dArray2[n4] = dArray2[n4] + (d2 - dArray3[3]);
                                        }
                                        ++n3;
                                    }
                                }
                                dArray3[2] = dArray3[3];
                                dArray3[3] = d2;
                                if (dArray3[4] < dArray3[5]) {
                                    dArray3[5] = dArray3[4];
                                }
                                if (dArray3[4] > dArray3[6]) {
                                    dArray3[6] = dArray3[4];
                                }
                                dArray3[4] = dArray3[4] - 1.0;
                                this.data.put(measure_names[2], objectArray);
                            }
                        } else {
                            ((List)this.observations.get(this.get_id(measure_names[2]))).add(new double[]{this.queue_length--, this.prev_time_queue, d2});
                            this.prev_time_queue = d2;
                        }
                        Sim_system.observation_collected(this.entity_id, measure_names[2]);
                    }
                    if (!this.is_selected(measure_names[4])) break;
                    if (this.is_efficient(measure_names[4])) {
                        objectArray = (Object[])this.data.get(measure_names[4]);
                        dArray3 = (double[])objectArray[0];
                        dArray3[0] = dArray3[0] + (d2 - d);
                        dArray3[3] = dArray3[3] + 1.0;
                        if (d2 - d < dArray3[1]) {
                            dArray3[1] = d2 - d;
                        }
                        if (d2 - d > dArray3[2]) {
                            dArray3[2] = d2 - d;
                        }
                        if (objectArray.length == 2) {
                            dArray2 = (double[])objectArray[1];
                            dArray = this.get_levels(measure_names[4]);
                            n3 = 0;
                            while (n3 < dArray.length) {
                                if (d2 - d > dArray[n3]) {
                                    int n5 = n3;
                                    dArray2[n5] = dArray2[n5] + 1.0;
                                }
                                ++n3;
                            }
                        }
                        this.data.put(measure_names[4], objectArray);
                    } else {
                        ((List)this.observations.get(this.get_id(measure_names[4]))).add(new double[]{d, d2});
                    }
                    Sim_system.observation_collected(this.entity_id, measure_names[4]);
                    break;
                }
                case 3: {
                    Object object;
                    if (this.is_selected(measure_names[5])) {
                        if (this.is_efficient(measure_names[5])) {
                            object = (Object[])this.data.get(measure_names[5]);
                            double[] dArray = (double[])object[0];
                            dArray[0] = dArray[0] + (d2 - d);
                            dArray[3] = dArray[3] + 1.0;
                            if (d2 - d < dArray[1]) {
                                dArray[1] = d2 - d;
                            }
                            if (d2 - d > dArray[2]) {
                                dArray[2] = d2 - d;
                            }
                            if (((Object)object).length == 2) {
                                double[] dArray4 = (double[])object[1];
                                double[] dArray5 = this.get_levels(measure_names[5]);
                                int n6 = 0;
                                while (n6 < dArray5.length) {
                                    if (d2 - d > dArray5[n6]) {
                                        int n7 = n6;
                                        dArray4[n7] = dArray4[n7] + 1.0;
                                    }
                                    ++n6;
                                }
                            }
                            this.data.put(measure_names[5], object);
                        } else {
                            ((List)this.observations.get(this.get_id(measure_names[5]))).add(new double[]{d, d2});
                        }
                        Sim_system.observation_collected(this.entity_id, measure_names[5]);
                    }
                    if (!this.is_selected(measure_names[1])) break;
                    if (this.is_efficient(measure_names[1])) {
                        object = (Long)this.data.get(measure_names[1]);
                        object = new Long((Long)object + 1L);
                        this.data.put(measure_names[1], object);
                    } else {
                        ((List)this.observations.get(this.get_id(measure_names[1]))).add(new Double(d2));
                    }
                    Sim_system.observation_collected(this.entity_id, measure_names[1]);
                    break;
                }
                case 2: {
                    if (!this.is_selected(measure_names[6])) break;
                    if (this.is_efficient(measure_names[6])) {
                        Object[] objectArray = (Object[])this.data.get(measure_names[6]);
                        double[] dArray = (double[])objectArray[0];
                        dArray[0] = dArray[0] + (d2 - d);
                        dArray[3] = dArray[3] + 1.0;
                        if (d2 - d < dArray[1]) {
                            dArray[1] = d2 - d;
                        }
                        if (d2 - d > dArray[2]) {
                            dArray[2] = d2 - d;
                        }
                        if (objectArray.length == 2) {
                            double[] dArray6 = (double[])objectArray[1];
                            double[] dArray7 = this.get_levels(measure_names[6]);
                            int n8 = 0;
                            while (n8 < dArray7.length) {
                                if (d2 - d > dArray7[n8]) {
                                    int n9 = n8;
                                    dArray6[n9] = dArray6[n9] + 1.0;
                                }
                                ++n8;
                            }
                        }
                        this.data.put(measure_names[6], objectArray);
                    } else {
                        ((List)this.observations.get(this.get_id(measure_names[6]))).add(new double[]{d, d2});
                    }
                    Sim_system.observation_collected(this.entity_id, measure_names[6]);
                }
            }
        }
    }

    void update(int n, double d, double d2) {
        if (n != 4) {
            throw new Sim_stat_exception("Invalid event type.");
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            throw new Sim_stat_exception("Invalid event occurance times.");
        }
        if (this.is_selected(measure_names[3])) {
            if (this.is_efficient(measure_names[3])) {
                Object[] objectArray = (Object[])this.data.get(measure_names[3]);
                double[] dArray = (double[])objectArray[0];
                if (d < this.trans_time) {
                    d = this.trans_time;
                }
                dArray[0] = dArray[0] + (d2 - d);
                dArray[1] = dArray[1] + (d2 - dArray[3]);
                dArray[2] = d;
                dArray[3] = d2;
                this.data.put(measure_names[3], objectArray);
                this.entity_busy = false;
                Sim_system.observation_collected(this.entity_id, measure_names[3]);
                Sim_system.observation_collected(this.entity_id, measure_names[3]);
            } else {
                if (this.prev_time_util != 0.0) {
                    List list = (List)this.observations.get(this.get_id(measure_names[3]));
                    this.prev_time_util = ((double[])list.get(list.size() - 1))[2];
                    if (this.prev_time_util > d) {
                        d = this.prev_time_util;
                    }
                }
                int n2 = this.get_id(measure_names[3]);
                ((List)this.observations.get(n2)).add(new double[]{0.0, this.prev_time_util, d});
                ((List)this.observations.get(n2)).add(new double[]{1.0, d, d2});
                this.prev_time_util = d2;
                this.entity_busy = false;
                Sim_system.observation_collected(this.entity_id, measure_names[3]);
                Sim_system.observation_collected(this.entity_id, measure_names[3]);
            }
        }
    }

    public void update(String string, double d) {
        if (!Sim_system.running()) {
            return;
        }
        int n = this.get_id(string);
        if (n < 0) {
            throw new Sim_stat_exception(string + " is not being measured.");
        }
        if (this.get_type(n) != 0) {
            throw new Sim_stat_exception(string + " has an invalid type.");
        }
        if (d > Sim_system.sim_clock()) {
            throw new Sim_stat_exception("Attempted to update " + string + " past the current run time.");
        }
        if (this.is_efficient(string)) {
            Long l = (Long)this.data.get(string);
            l = new Long(l + 1L);
            this.data.put(string, l);
        } else {
            ((List)this.observations.get(n)).add(new Double(d));
        }
        Sim_system.observation_collected(this.entity_id, string);
    }

    public void update(String string, double d, double d2, double d3) {
        if (!Sim_system.running()) {
            return;
        }
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n < 0) {
            throw new Sim_stat_exception(string + " is not being measured.");
        }
        if (n2 != 1) {
            throw new Sim_stat_exception(string + " has an invalid type.");
        }
        if (d2 < 0.0 || d3 < 0.0 || d2 > d3) {
            throw new Sim_stat_exception("Invalid period specified.");
        }
        if (d3 > Sim_system.sim_clock()) {
            throw new Sim_stat_exception("Attempted to update " + string + " past the current run time.");
        }
        if (this.is_efficient(string)) {
            if (d3 < this.trans_time) {
                return;
            }
            Object[] objectArray = (Object[])this.data.get(string);
            double[] dArray = (double[])objectArray[0];
            if (d2 < this.trans_time) {
                d2 = this.trans_time;
            }
            dArray[0] = dArray[0] + d * (d3 - d2);
            dArray[1] = dArray[1] + (d3 - d2);
            if (objectArray.length == 2) {
                double[] dArray2 = (double[])objectArray[1];
                double[] dArray3 = this.get_levels(string);
                int n3 = 0;
                while (n3 < dArray3.length) {
                    if (d > dArray3[n3]) {
                        int n4 = n3;
                        dArray2[n4] = dArray2[n4] + (d3 - d2);
                    }
                    ++n3;
                }
            }
            if (d < dArray[5]) {
                dArray[5] = d;
            }
            if (d > dArray[6]) {
                dArray[6] = d;
            }
            this.data.put(string, objectArray);
        } else {
            if (d3 < this.trans_time) {
                return;
            }
            ((List)this.observations.get(n)).add(new double[]{d, d2, d3});
        }
        Sim_system.observation_collected(this.entity_id, string);
    }

    public void update(String string, double d, double d2) {
        if (!Sim_system.running()) {
            return;
        }
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n < 0) {
            throw new Sim_stat_exception(string + " is not being measured.");
        }
        if (n2 != 1 && n2 != 2) {
            throw new Sim_stat_exception(string + " has an invalid type.");
        }
        if (d2 > Sim_system.sim_clock()) {
            throw new Sim_stat_exception("Attempted to update " + string + " past the current run time.");
        }
        if (n2 == 1) {
            if (this.is_efficient(string)) {
                Object[] objectArray = (Object[])this.data.get(string);
                double[] dArray = (double[])objectArray[0];
                if (d2 < dArray[3]) {
                    throw new Sim_stat_exception("Invalid change time specified.");
                }
                if (d2 < this.trans_time) {
                    return;
                }
                if (d2 == this.trans_time) {
                    dArray[4] = d;
                    this.data.put(string, objectArray);
                    Sim_system.observation_collected(this.entity_id, string);
                    return;
                }
                dArray[0] = dArray[0] + dArray[4] * (d2 - dArray[3]);
                dArray[1] = dArray[1] + (d2 - dArray[3]);
                if (objectArray.length == 2) {
                    double[] dArray2 = (double[])objectArray[1];
                    double[] dArray3 = this.get_levels(string);
                    int n3 = 0;
                    while (n3 < dArray3.length) {
                        if (dArray[4] > dArray3[n3]) {
                            int n4 = n3;
                            dArray2[n4] = dArray2[n4] + (d2 - dArray[3]);
                        }
                        ++n3;
                    }
                }
                if (dArray[4] < dArray[5]) {
                    dArray[5] = dArray[4];
                }
                if (dArray[4] > dArray[6]) {
                    dArray[6] = dArray[4];
                }
                dArray[2] = dArray[3];
                dArray[3] = d2;
                dArray[4] = d;
                this.data.put(string, objectArray);
            } else {
                Object[] objectArray = this.get_counters(string);
                double d3 = (Double)objectArray[1];
                double d4 = (Double)objectArray[2];
                if (d2 < this.trans_time) {
                    return;
                }
                ((List)this.observations.get(n)).add(new double[]{d3, d4, d2});
                this.set_counters(string, d, d2);
            }
        } else {
            if (d < 0.0 || d2 < 0.0 || d > d2) {
                throw new Sim_stat_exception("Invalid period specified.");
            }
            if (this.is_efficient(string)) {
                Object[] objectArray = (Object[])this.data.get(string);
                double[] dArray = (double[])objectArray[0];
                if (d2 < this.trans_time) {
                    return;
                }
                dArray[0] = dArray[0] + (d2 - d);
                dArray[3] = dArray[3] + 1.0;
                if (d2 - d < dArray[1]) {
                    dArray[1] = d2 - d;
                }
                if (d2 - d > dArray[2]) {
                    dArray[2] = d2 - d;
                }
                if (objectArray.length == 2) {
                    double[] dArray4 = (double[])objectArray[1];
                    double[] dArray5 = this.get_levels(string);
                    int n5 = 0;
                    while (n5 < dArray5.length) {
                        if (d2 - d > dArray5[n5]) {
                            int n6 = n5;
                            dArray4[n6] = dArray4[n6] + 1.0;
                        }
                        ++n5;
                    }
                }
                this.data.put(string, objectArray);
            } else {
                if (d2 < this.trans_time) {
                    return;
                }
                ((List)this.observations.get(n)).add(new double[]{d, d2});
            }
        }
        Sim_system.observation_collected(this.entity_id, string);
    }

    void tidy_up() {
        Object object;
        Object[] objectArray;
        Object[] objectArray2;
        double d;
        this.end_time = d = Sim_system.sim_clock();
        if (this.is_selected(measure_names[2])) {
            if (this.is_efficient(measure_names[2])) {
                Object[] objectArray3 = (Object[])this.data.get(measure_names[2]);
                objectArray2 = (double[])objectArray3[0];
                if (objectArray2[3] < d) {
                    objectArray2[0] = objectArray2[0] + objectArray2[4] * (d - objectArray2[3]);
                    objectArray2[1] = objectArray2[1] + (d - objectArray2[3]);
                    if (objectArray3.length == 2) {
                        objectArray = (double[])objectArray3[1];
                        object = this.get_levels(measure_names[2]);
                        int n = 0;
                        while (n < ((Object)object).length) {
                            if (objectArray2[4] > object[n]) {
                                int n2 = n;
                                objectArray[n2] = objectArray[n2] + (d - objectArray2[3]);
                            }
                            ++n;
                        }
                    }
                    objectArray2[2] = objectArray2[3];
                    objectArray2[3] = d;
                    if (objectArray2[4] < objectArray2[5]) {
                        objectArray2[5] = objectArray2[4];
                    }
                    if (objectArray2[4] > objectArray2[6]) {
                        objectArray2[6] = objectArray2[4];
                    }
                    this.data.put(measure_names[2], objectArray3);
                    Sim_system.observation_collected(this.entity_id, measure_names[2]);
                }
            } else if (this.prev_time_queue < d) {
                ((List)this.observations.get(this.get_id(measure_names[2]))).add(new double[]{this.queue_length, this.prev_time_queue, d});
                this.prev_time_queue = d;
                Sim_system.observation_collected(this.entity_id, measure_names[2]);
            }
        }
        if (this.is_selected(measure_names[3])) {
            int n = this.get_id(measure_names[3]);
            if (this.entity_busy) {
                if (this.is_efficient(measure_names[3])) {
                    objectArray2 = (Object[])this.data.get(measure_names[3]);
                    objectArray = (double[])objectArray2[0];
                    if (this.started_busy < this.trans_time) {
                        objectArray[0] = objectArray[0] + (d - this.trans_time);
                        objectArray[2] = this.trans_time;
                    } else {
                        objectArray[0] = objectArray[0] + (d - this.started_busy);
                        objectArray[2] = this.started_busy;
                    }
                    objectArray[1] = objectArray[1] + (d - objectArray[3]);
                    objectArray[3] = d;
                    this.data.put(measure_names[3], objectArray2);
                } else {
                    ((List)this.observations.get(n)).add(new double[]{0.0, this.prev_time_util, this.started_busy});
                    ((List)this.observations.get(n)).add(new double[]{1.0, this.started_busy, d});
                    this.prev_time_util = d;
                }
                Sim_system.observation_collected(this.entity_id, measure_names[3]);
                Sim_system.observation_collected(this.entity_id, measure_names[3]);
            } else {
                if (this.is_efficient(measure_names[3])) {
                    objectArray2 = (Object[])this.data.get(measure_names[3]);
                    objectArray = (double[])objectArray2[0];
                    if (objectArray[3] < d) {
                        objectArray[1] = objectArray[1] + (d - objectArray[3]);
                        objectArray[3] = d;
                        this.data.put(measure_names[3], objectArray2);
                    }
                } else if (this.prev_time_util < d) {
                    ((List)this.observations.get(n)).add(new double[]{0.0, this.prev_time_util, d});
                }
                Sim_system.observation_collected(this.entity_id, measure_names[3]);
            }
        }
        int n = this.measures.size();
        int n3 = 0;
        while (n3 < n) {
            objectArray = (Object[])this.measures.get(n3);
            if (objectArray.length == 3 && ((Boolean)objectArray[2]).booleanValue()) {
                if (this.is_efficient((String)objectArray[0])) {
                    object = (String)objectArray[0];
                    Object[] objectArray4 = (Object[])this.data.get(object);
                    double[] dArray = (double[])objectArray4[0];
                    if (dArray[3] < d) {
                        dArray[0] = dArray[0] + dArray[4] * (d - dArray[3]);
                        dArray[1] = dArray[1] + (d - dArray[3]);
                        if (objectArray4.length == 2) {
                            double[] dArray2 = (double[])objectArray4[1];
                            double[] dArray3 = this.get_levels((String)object);
                            int n4 = 0;
                            while (n4 < dArray3.length) {
                                if (dArray[4] > dArray3[n4]) {
                                    int n5 = n4;
                                    dArray2[n5] = dArray2[n5] + (d - dArray[3]);
                                }
                                ++n4;
                            }
                        }
                        if (dArray[4] < dArray[5]) {
                            dArray[5] = dArray[4];
                        }
                        if (dArray[4] > dArray[6]) {
                            dArray[6] = dArray[4];
                        }
                        dArray[2] = dArray[3];
                        dArray[3] = d;
                        this.data.put(object, objectArray4);
                    }
                } else {
                    int n6 = this.get_id((String)objectArray[0]);
                    Object[] objectArray5 = this.get_counters((String)objectArray[0]);
                    double d2 = (Double)objectArray5[1];
                    double d3 = (Double)objectArray5[2];
                    if (d3 < d) {
                        ((List)this.observations.get(n6)).add(new double[]{d2, d3, d});
                        this.set_counters((String)objectArray[0], d3, d);
                        Sim_system.observation_collected(this.entity_id, (String)objectArray[0]);
                    }
                }
            }
            ++n3;
        }
    }

    void set_busy(double d) {
        this.entity_busy = true;
        this.started_busy = d;
    }

    void steady_state_reached(double d) {
        if (this.data == null) {
            return;
        }
        Set set = this.data.keySet();
        Collection collection = this.data.values();
        Iterator iterator = set.iterator();
        Iterator iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            int n = this.get_type(string);
            if (n == 0) {
                object = (Object[])iterator2.next();
                object = new Long(0L);
                this.data.put(string, object);
                continue;
            }
            if (n == 1) {
                object = (Object[])iterator2.next();
                object = ((Object[])object).length == 2 ? new Object[]{new double[]{0.0, 0.0, d, d, ((double[])object[0])[4], Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}, new double[this.get_levels(string).length]} : new Object[]{new double[]{0.0, 0.0, d, d, ((double[])object[0])[4], Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}};
                this.data.put(string, object);
                continue;
            }
            object = (Object[])iterator2.next();
            object = ((Object[])object).length == 2 ? new Object[]{new double[]{0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0}, new double[this.get_levels(string).length]} : new Object[]{new double[]{0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0}};
            this.data.put(string, object);
        }
        this.trans_time = d;
    }

    public int count(int n) {
        if (this.is_efficient(measure_names[n])) {
            return this.count_efficient(measure_names[n]);
        }
        return this.count(measure_names[n], 0.0, Sim_system.sim_clock());
    }

    public double average(int n) {
        if (this.is_efficient(measure_names[n])) {
            return this.average_efficient(measure_names[n]);
        }
        return this.average(measure_names[n], 0.0, Sim_system.sim_clock());
    }

    public double maximum(int n) {
        if (this.is_efficient(measure_names[n])) {
            return this.maximum_efficient(measure_names[n]);
        }
        return this.maximum(measure_names[n], 0.0, Sim_system.sim_clock());
    }

    public double minimum(int n) {
        if (this.is_efficient(measure_names[n])) {
            return this.minimum_efficient(measure_names[n]);
        }
        return this.minimum(measure_names[n], 0.0, Sim_system.sim_clock());
    }

    public double variance(int n) {
        if (this.is_efficient(measure_names[n])) {
            throw new Sim_stat_exception(measure_names[n] + " can't produce variance as an efficient measure.");
        }
        return this.variance(measure_names[n], 0.0, Sim_system.sim_clock());
    }

    public double std_deviation(int n) {
        if (this.is_efficient(measure_names[n])) {
            throw new Sim_stat_exception(measure_names[n] + " can't produce standard deviation as an efficient measure.");
        }
        return Math.sqrt(this.variance(measure_names[n], 0.0, Sim_system.sim_clock()));
    }

    public double[] exc_proportion(int n, double[] dArray) {
        if (this.is_efficient(measure_names[n])) {
            throw new Sim_stat_exception(measure_names[n] + " can't produce exceedence proportions with arbitrary levels as an efficient measure.");
        }
        return this.exc_proportion(measure_names[n], dArray, 0.0, Sim_system.clock());
    }

    public double exc_proportion(int n, double d) {
        if (this.is_efficient(measure_names[n])) {
            throw new Sim_stat_exception(measure_names[n] + " can't produce exceedence proportions with arbitrary levels as an efficient measure.");
        }
        return this.exc_proportion(measure_names[n], d, 0.0, Sim_system.sim_clock());
    }

    public double[] exc_proportion(int n) {
        double[] dArray = this.get_levels(n);
        if (dArray == null) {
            throw new Sim_stat_exception("No exceedence proportion levels have been specified for " + measure_names[n]);
        }
        if (this.is_efficient(measure_names[n])) {
            return this.exc_proportion_efficient(measure_names[n]);
        }
        return this.exc_proportion(measure_names[n], dArray, 0.0, Sim_system.sim_clock());
    }

    public int count(String string) {
        if (this.is_efficient(string)) {
            return this.count_efficient(string);
        }
        return this.count(string, 0.0, Sim_system.clock());
    }

    public double average(String string) {
        if (this.is_efficient(string)) {
            return this.average_efficient(string);
        }
        return this.average(string, 0.0, Sim_system.sim_clock());
    }

    public double maximum(String string) {
        if (this.is_efficient(string)) {
            return this.maximum_efficient(string);
        }
        return this.maximum(string, 0.0, Sim_system.sim_clock());
    }

    public double minimum(String string) {
        if (this.is_efficient(string)) {
            return this.minimum_efficient(string);
        }
        return this.minimum(string, 0.0, Sim_system.sim_clock());
    }

    public double variance(String string) {
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't produce variance as an efficient measure.");
        }
        return this.variance(string, 0.0, Sim_system.sim_clock());
    }

    public double std_deviation(String string) {
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't produce standard deviation as an efficient measure.");
        }
        return Math.sqrt(this.variance(string, 0.0, Sim_system.sim_clock()));
    }

    public double[] exc_proportion(String string, double[] dArray) {
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't produce exceedence proportions with arbitrary levels as an efficient measure.");
        }
        return this.exc_proportion(string, dArray, 0.0, Sim_system.clock());
    }

    public double exc_proportion(String string, double d) {
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't produce exceedence proportions with arbitrary levels as an efficient measure.");
        }
        return this.exc_proportion(string, d, 0.0, Sim_system.sim_clock());
    }

    public double[] exc_proportion(String string) {
        double[] dArray = this.get_levels(string);
        if (dArray == null) {
            throw new Sim_stat_exception("No exceedence proportion levels have been specified for " + string);
        }
        if (this.is_efficient(string)) {
            return this.exc_proportion_efficient(string);
        }
        return this.exc_proportion(string, dArray, 0.0, Sim_system.sim_clock());
    }

    public int count(int n, double d, double d2) {
        return this.count(measure_names[n], d, d2);
    }

    public double average(int n, double d, double d2) {
        return this.average(measure_names[n], d, d2);
    }

    public double maximum(int n, double d, double d2) {
        return this.maximum(measure_names[n], d, d2);
    }

    public double minimum(int n, double d, double d2) {
        return this.minimum(measure_names[n], d, d2);
    }

    public double variance(int n, double d, double d2) {
        return this.variance(measure_names[n], d, d2);
    }

    public double std_deviation(int n, double d, double d2) {
        return this.std_deviation(measure_names[n], d, d2);
    }

    public double[] exc_proportion(int n, double[] dArray, double d, double d2) {
        return this.exc_proportion(measure_names[n], dArray, d, d2);
    }

    public double exc_proportion(int n, double d, double d2, double d3) {
        return this.exc_proportion(measure_names[n], d, d2, d3);
    }

    public int count(String string, double d, double d2) {
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n < 0) {
            throw new Sim_stat_exception(string + " has not been measured for this entity.");
        }
        if (n2 != 0) {
            throw new Sim_stat_exception(string + " must be a rate-based measure.");
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            throw new Sim_stat_exception("Invalid period specified.");
        }
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't be an efficient measure and be used with this method.");
        }
        int[] nArray = this.observation_count(n, d, d2);
        if (nArray[1] == -1) {
            return 0;
        }
        return nArray[1] - nArray[0] + 1;
    }

    public double average(String string, double d, double d2) {
        double d3;
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n < 0) {
            throw new Sim_stat_exception(string + " has not been measured for this entity.");
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            throw new Sim_stat_exception("Invalid period specified.");
        }
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't be an efficient measure and be used with this method.");
        }
        if (n2 == 0) {
            int[] nArray = this.observation_count(n, d, d2);
            if (nArray[1] == -1) {
                return 0.0;
            }
            d3 = d2 - d == 0.0 ? 0.0 : (double)(nArray[1] - nArray[0] + 1) / (d2 - d);
        } else if (n2 == 1) {
            double[] dArray;
            double d4;
            int[] nArray;
            Object[] objectArray = (Object[])this.measures.get(n);
            boolean bl = true;
            if (objectArray.length == 3) {
                bl = (Boolean)objectArray[2];
            }
            if ((nArray = this.observation_count(n, d, d2))[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            double[] dArray2 = (double[])list.get(nArray[0]);
            double d5 = 0.0;
            if (dArray2[1] < d) {
                d4 = dArray2[0] * (dArray2[2] - d);
                d5 += dArray2[2] - d;
            } else {
                d4 = dArray2[0] * (dArray2[2] - dArray2[1]);
                d5 += dArray2[2] - dArray2[1];
            }
            int n3 = nArray[0] + 1;
            while (n3 < nArray[1]) {
                dArray = (double[])list.get(n3);
                d4 += dArray[0] * (dArray[2] - dArray[1]);
                d5 += dArray[2] - dArray[1];
                ++n3;
            }
            dArray = (double[])list.get(nArray[1]);
            if (bl) {
                d4 += dArray[0] * (d2 - dArray[1]);
                d5 += d2 - dArray[1];
            } else if (dArray[2] > d2) {
                d4 += dArray[0] * (d2 - dArray[1]);
                d5 += d2 - dArray[1];
            } else {
                d4 += dArray[0] * (dArray[2] - dArray[1]);
                d5 += dArray[2] - dArray[1];
            }
            d3 = d5 == 0.0 ? 0.0 : d4 / d5;
        } else {
            int[] nArray = this.observation_count(n, d, d2);
            if (nArray[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            double d6 = 0.0;
            int n4 = nArray[0];
            while (n4 <= nArray[1]) {
                double[] dArray = (double[])list.get(n4);
                d6 += dArray[1] - dArray[0];
                ++n4;
            }
            d3 = nArray[1] - nArray[0] + 1 == 0 ? 0.0 : d6 / (double)(nArray[1] - nArray[0] + 1);
        }
        return d3;
    }

    public double maximum(String string, double d, double d2) {
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n < 0) {
            throw new Sim_stat_exception(string + " has not been measured for this entity.");
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            throw new Sim_stat_exception("Invalid period specified.");
        }
        if (n2 != 1 && n2 != 2 || string.equals("Utilisation")) {
            throw new Sim_stat_exception("Invalid measure type. Must be state-based or interval-based.");
        }
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't be an efficient measure and be used with this method.");
        }
        double d3 = 0.0;
        if (n2 == 1) {
            int[] nArray = this.observation_count(n, d, d2);
            if (nArray[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            int n3 = nArray[0];
            while (n3 <= nArray[1]) {
                double[] dArray = (double[])list.get(n3);
                if (dArray[0] > d3) {
                    d3 = dArray[0];
                }
                ++n3;
            }
        } else {
            int[] nArray = this.observation_count(n, d, d2);
            if (nArray[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            int n4 = nArray[0];
            while (n4 <= nArray[1]) {
                double[] dArray = (double[])list.get(n4);
                if (dArray[1] - dArray[0] > d3) {
                    d3 = dArray[1] - dArray[0];
                }
                ++n4;
            }
        }
        return d3;
    }

    public double minimum(String string, double d, double d2) {
        double d3;
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n < 0) {
            throw new Sim_stat_exception(string + " has not been measured for this entity.");
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            throw new Sim_stat_exception("Invalid period specified.");
        }
        if (n2 != 1 && n2 != 2 || string.equals("Utilisation")) {
            throw new Sim_stat_exception("Invalid measure type. Must be state-based or interval-based.");
        }
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't be an efficient measure and be used with this method.");
        }
        if (n2 == 1) {
            int[] nArray = this.observation_count(n, d, d2);
            if (nArray[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            double[] dArray = (double[])list.get(nArray[0]);
            d3 = dArray[0];
            int n3 = nArray[0] + 1;
            while (n3 <= nArray[1]) {
                double[] dArray2 = (double[])list.get(n3);
                if (dArray2[0] < d3) {
                    d3 = dArray2[0];
                }
                ++n3;
            }
        } else {
            int[] nArray = this.observation_count(n, d, d2);
            if (nArray[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            double[] dArray = (double[])list.get(nArray[0]);
            d3 = dArray[1] - dArray[0];
            int n4 = nArray[0] + 1;
            while (n4 <= nArray[1]) {
                double[] dArray3 = (double[])list.get(n4);
                if (dArray3[1] - dArray3[0] < d3) {
                    d3 = dArray3[1] - dArray3[0];
                }
                ++n4;
            }
        }
        return d3;
    }

    public double variance(String string, double d, double d2) {
        double d3;
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n < 0) {
            throw new Sim_stat_exception(string + " has not been measured for this entity.");
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            throw new Sim_stat_exception("Invalid period specified.");
        }
        if (n2 != 1 && n2 != 2 || string.equals("Utilisation")) {
            throw new Sim_stat_exception("Invalid measure type. Must be state-based or interval-based.");
        }
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't be an efficient measure and be used with this method.");
        }
        if (n2 == 1) {
            double[] dArray;
            double d4;
            int[] nArray;
            Object[] objectArray = (Object[])this.measures.get(n);
            boolean bl = true;
            if (objectArray.length == 3) {
                bl = (Boolean)objectArray[2];
            }
            if ((nArray = this.observation_count(n, d, d2))[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            double[] dArray2 = (double[])list.get(nArray[0]);
            double d5 = 0.0;
            if (dArray2[1] < d) {
                d4 = Math.pow(dArray2[0], 2.0) * (dArray2[2] - d);
                d5 += dArray2[2] - d;
            } else {
                d4 = Math.pow(dArray2[0], 2.0) * (dArray2[2] - dArray2[1]);
                d5 += dArray2[2] - dArray2[1];
            }
            int n3 = nArray[0] + 1;
            while (n3 < nArray[1]) {
                dArray = (double[])list.get(n3);
                d4 += Math.pow(dArray[0], 2.0) * (dArray[2] - dArray[1]);
                d5 += dArray[2] - dArray[1];
                ++n3;
            }
            dArray = (double[])list.get(nArray[1]);
            if (bl) {
                d4 += Math.pow(dArray[0], 2.0) * (d2 - dArray[1]);
                d5 += d2 - dArray[1];
            } else if (dArray[2] > d2) {
                d4 += Math.pow(dArray[0], 2.0) * (d2 - dArray[1]);
                d5 += d2 - dArray[1];
            } else {
                d4 += Math.pow(dArray[0], 2.0) * (dArray[2] - dArray[1]);
                d5 += dArray[2] - dArray[1];
            }
            d3 = d5 == 0.0 ? 0.0 : d4 / d5 - Math.pow(this.average(string, d, d2), 2.0);
        } else {
            int[] nArray = this.observation_count(n, d, d2);
            if (nArray[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            double d6 = 0.0;
            int n4 = nArray[0];
            while (n4 <= nArray[1]) {
                double[] dArray = (double[])list.get(n4);
                d6 += Math.pow(dArray[1] - dArray[0], 2.0);
                ++n4;
            }
            double d7 = (double)(nArray[1] - nArray[0] + 1) * Math.pow(this.average(string, d, d2), 2.0);
            d3 = nArray[1] - nArray[0] == 0 ? 0.0 : (d6 - d7) / (double)(nArray[1] - nArray[0]);
        }
        return d3;
    }

    public double std_deviation(String string, double d, double d2) {
        return Math.sqrt(this.variance(string, d, d2));
    }

    public double[] exc_proportion(String string, double[] dArray, double d, double d2) {
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n < 0) {
            throw new Sim_stat_exception(string + " has not been measured for this entity.");
        }
        if (d < 0.0 || d2 < 0.0 || d > d2) {
            throw new Sim_stat_exception("Invalid period specified.");
        }
        if (n2 != 1 && n2 != 2 || string.equals("Utilisation")) {
            throw new Sim_stat_exception("Invalid measure type. Must be state-based or interval-based.");
        }
        if (this.is_efficient(string)) {
            throw new Sim_stat_exception(string + " can't be an efficient measure and be used with this method.");
        }
        double[] dArray2 = new double[dArray.length];
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray2[n3] = this.exc_proportion(string, dArray[n3], d, d2);
            ++n3;
        }
        return dArray2;
    }

    public double exc_proportion(String string, double d, double d2, double d3) {
        double d4;
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        if (n2 == 1) {
            double[] dArray;
            int[] nArray;
            Object[] objectArray = (Object[])this.measures.get(n);
            boolean bl = true;
            if (objectArray.length == 3) {
                bl = (Boolean)objectArray[2];
            }
            if ((nArray = this.observation_count(n, d2, d3))[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            double[] dArray2 = (double[])list.get(nArray[0]);
            double d5 = 0.0;
            double d6 = 0.0;
            if (dArray2[1] < d2) {
                d6 += dArray2[2] - d2;
                if (dArray2[0] > d) {
                    d5 = dArray2[2] - d2;
                }
            } else {
                d6 += dArray2[2] - dArray2[1];
                if (dArray2[0] > d) {
                    d5 = dArray2[2] - dArray2[1];
                }
            }
            int n3 = nArray[0] + 1;
            while (n3 < nArray[1]) {
                dArray = (double[])list.get(n3);
                d6 += dArray[2] - dArray[1];
                if (dArray[0] > d) {
                    d5 += dArray[2] - dArray[1];
                }
                ++n3;
            }
            dArray = (double[])list.get(nArray[1]);
            if (bl) {
                d6 += d3 - dArray[1];
                if (dArray[0] > d) {
                    d5 += d3 - dArray[1];
                }
            } else if (dArray[2] > d3) {
                d6 += d3 - dArray[1];
                if (dArray[0] > d) {
                    d5 += d3 - dArray[1];
                }
            } else {
                d6 += dArray[2] - dArray[1];
                if (dArray[0] > d) {
                    d5 += dArray[2] - dArray[1];
                }
            }
            d4 = d6 == 0.0 ? 0.0 : d5 / d6;
        } else {
            int[] nArray = this.observation_count(n, d2, d3);
            if (nArray[1] == -1) {
                return 0.0;
            }
            List list = (List)this.observations.get(n);
            double d7 = 0.0;
            int n4 = nArray[0];
            while (n4 <= nArray[1]) {
                double[] dArray = (double[])list.get(n4);
                if (dArray[1] - dArray[0] > d) {
                    d7 += 1.0;
                }
                ++n4;
            }
            d4 = nArray[1] - nArray[0] + 1 == 0 ? 0.0 : d7 / (double)(nArray[1] - nArray[0] + 1);
        }
        return d4;
    }

    private int count_efficient(String string) {
        int n = this.get_type(string);
        if (n != 0) {
            throw new Sim_stat_exception(string + " must be a rate-based measure.");
        }
        return (int)((Long)this.data.get(string)).longValue();
    }

    private double average_efficient(String string) {
        int n = this.get_type(string);
        if (n == 0) {
            if (this.trans_time < 0.0) {
                this.trans_time = 0.0;
            }
            if (this.end_time < 0.0) {
                return (double)((Long)this.data.get(string)).longValue() / (Sim_system.sim_clock() - this.trans_time);
            }
            return (double)((Long)this.data.get(string)).longValue() / (this.end_time - this.trans_time);
        }
        if (n == 1) {
            double[] dArray = (double[])((Object[])this.data.get(string))[0];
            if (dArray[1] == 0.0) {
                return 0.0;
            }
            return dArray[0] / dArray[1];
        }
        double[] dArray = (double[])((Object[])this.data.get(string))[0];
        if (dArray[3] == 0.0) {
            return 0.0;
        }
        return dArray[0] / dArray[3];
    }

    private double maximum_efficient(String string) {
        int n = this.get_type(string);
        if (n != 1 && n != 2 || string.equals("Utilisation")) {
            throw new Sim_stat_exception("Invalid measure type. Must be state-based or interval-based.");
        }
        double d = n == 1 ? ((double[])((Object[])this.data.get(string))[0])[6] : ((double[])((Object[])this.data.get(string))[0])[2];
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return d;
    }

    private double minimum_efficient(String string) {
        int n = this.get_type(string);
        if (n != 1 && n != 2 || string.equals("Utilisation")) {
            throw new Sim_stat_exception("Invalid measure type. Must be state-based or interval-based.");
        }
        double d = n == 1 ? ((double[])((Object[])this.data.get(string))[0])[5] : ((double[])((Object[])this.data.get(string))[0])[1];
        if (d == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return d;
    }

    private double[] exc_proportion_efficient(String string) {
        int n = this.get_type(string);
        if (n != 1 && n != 2 || string.equals("Utilisation")) {
            throw new Sim_stat_exception("Invalid measure type. Must be state-based or interval-based.");
        }
        if (n == 1) {
            double[] dArray = (double[])((Object[])this.data.get(string))[1];
            double d = ((double[])((Object[])this.data.get(string))[0])[1];
            double[] dArray2 = new double[dArray.length];
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray2[n2] = d == 0.0 ? 0.0 : dArray[n2] / d;
                ++n2;
            }
            return dArray2;
        }
        double[] dArray = (double[])((Object[])this.data.get(string))[1];
        double d = ((double[])((Object[])this.data.get(string))[0])[3];
        double[] dArray3 = new double[dArray.length];
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray3[n3] = d == 0.0 ? 0.0 : dArray[n3] / d;
            ++n3;
        }
        return dArray3;
    }

    int[] observation_count(String string, double d, double d2) {
        return this.observation_count(this.get_id(string), d, d2);
    }

    int[] observation_count(int n, double d, double d2) {
        List list = (List)this.observations.get(n);
        int n2 = this.get_type(n);
        int n3 = list.size();
        int n4 = 0;
        int n5 = n3 - 1;
        Object[] objectArray = (Object[])this.measures.get(n);
        boolean bl = true;
        if (objectArray.length == 3) {
            bl = (Boolean)objectArray[2];
        }
        int n6 = 0;
        while (n6 < n3) {
            Object e = list.get(n6);
            if (n2 == 0) {
                if ((Double)e >= d) {
                    n4 = n6;
                    break;
                }
            } else if (n2 == 1) {
                if (((double[])e)[2] > d) {
                    n4 = n6;
                    break;
                }
            } else if (((double[])e)[1] >= d) {
                n4 = n6;
                break;
            }
            ++n6;
        }
        int n7 = n4;
        while (n7 < n3) {
            Object e = list.get(n7);
            if (n2 == 0) {
                double d3 = (Double)e;
                if (d3 > d2) {
                    if (n7 == n4) {
                        n5 = n7;
                        break;
                    }
                    n5 = n7 - 1;
                    break;
                }
            } else if (n2 == 1) {
                if (((double[])e)[1] <= d2 && ((double[])e)[2] >= d2) {
                    n5 = n7;
                    break;
                }
                if (((double[])e)[1] >= d2 && ((double[])e)[2] > d2) {
                    if (n7 == n4) {
                        n5 = n7;
                        break;
                    }
                    n5 = n7 - 1;
                    break;
                }
            } else if (((double[])e)[1] > d2) {
                if (n7 == n4) {
                    n5 = n7;
                    break;
                }
                n5 = n7 - 1;
                break;
            }
            ++n7;
        }
        return new int[]{n4, n5};
    }

    public List[] get_data() {
        return new List[]{this.measures, this.observations};
    }

    public List get_measures() {
        return this.measures;
    }

    public List get_detailed_measures() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n = this.measures.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.measures.get(n2);
            if (!this.is_efficient((String)objectArray[0])) {
                arrayList.add(objectArray);
            }
            ++n2;
        }
        return arrayList;
    }

    public boolean is_efficient(int n) {
        if (this.data == null) {
            return false;
        }
        return this.data.containsKey(measure_names[n]);
    }

    public boolean is_efficient(String string) {
        if (this.data == null) {
            return false;
        }
        return this.data.containsKey(string);
    }

    public double[] get_levels(int n) {
        return this.get_levels(measure_names[n]);
    }

    public double[] get_levels(String string) {
        int n = this.levels.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.levels.get(n2);
            if (((String)objectArray[0]).equals(string)) {
                return (double[])objectArray[1];
            }
            ++n2;
        }
        return null;
    }

    private boolean is_selected(String string) {
        int n = this.measures.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.measures.get(n2);
            if (((String)objectArray[0]).equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int get_id(String string) {
        int n = this.measures.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.measures.get(n2);
            if (((String)objectArray[0]).equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int get_type(int n) {
        if (n == -1) {
            return -1;
        }
        return (Integer)((Object[])this.measures.get(n))[1];
    }

    int get_type(String string) {
        return this.get_type(this.get_id(string));
    }

    private String get_name(int n) {
        return (String)((Object[])this.measures.get(n))[0];
    }

    String get_name_default(int n) {
        return measure_names[n];
    }

    private Object[] get_counters(String string) {
        int n = this.counters.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.counters.get(n2);
            if (((String)objectArray[0]).equals(string)) {
                return objectArray;
            }
            ++n2;
        }
        return null;
    }

    private void set_counters(String string, double d, double d2) {
        int n = this.counters.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.counters.get(n2);
            if (((String)objectArray[0]).equals(string)) {
                this.counters.remove(n2);
                this.counters.add(new Object[]{string, new Double(d), new Double(d2)});
                break;
            }
            ++n2;
        }
    }

    double min_max_time(String string) {
        int n = this.get_id(string);
        int n2 = this.get_type(n);
        double d = -1.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        List list = (List)this.observations.get(n);
        int n3 = list.size();
        int n4 = 1;
        while (n4 < n3 - 1) {
            double[] dArray;
            int n5;
            double d2;
            double[] dArray2 = (double[])list.get(n4);
            if (n2 == 1) {
                d2 = dArray2[0];
                n5 = n4 + 1;
                while (n5 < n3) {
                    dArray = (double[])list.get(n5);
                    if (dArray[0] < d2) {
                        bl = true;
                    } else if (dArray[0] > d2) {
                        bl2 = true;
                    }
                    if (bl && bl2) {
                        bl3 = true;
                        break;
                    }
                    ++n5;
                }
                if (bl3) {
                    d = dArray2[1];
                    break;
                }
                bl = false;
                bl2 = false;
            } else {
                d2 = dArray2[1] - dArray2[0];
                n5 = n4 + 1;
                while (n5 < n3) {
                    dArray = (double[])list.get(n5);
                    if (dArray[1] - dArray[0] < d2) {
                        bl = true;
                    } else if (dArray[1] - dArray[0] > d2) {
                        bl2 = true;
                    }
                    if (bl && bl2) {
                        bl3 = true;
                        break;
                    }
                    ++n5;
                }
                if (bl3) {
                    d = dArray2[0];
                    break;
                }
                bl = false;
                bl2 = false;
            }
            ++n4;
        }
        return d;
    }

    void reset() {
        Object object;
        this.queue_length = 0;
        this.prev_time_queue = 0.0;
        this.prev_time_util = 0.0;
        this.entity_busy = false;
        this.observations.clear();
        this.counters.clear();
        int n = this.measures.size();
        int n2 = 0;
        while (n2 < n) {
            this.observations.add(new ArrayList());
            ++n2;
        }
        int n3 = this.init_counters.size();
        int n4 = 0;
        while (n4 < n3) {
            object = (Object[])this.init_counters.get(n4);
            this.counters.add(new Object[]{object[0], object[1], object[2]});
            ++n4;
        }
        if (this.data != null) {
            object = this.data.keySet();
            Iterator iterator = object.iterator();
            int n5 = this.data.size();
            String[] stringArray = new String[n5];
            int n6 = 0;
            while (n6 < n5) {
                stringArray[n6] = (String)iterator.next();
                ++n6;
            }
            this.data.clear();
            int n7 = 0;
            while (n7 < stringArray.length) {
                this.set_efficient(stringArray[n7]);
                ++n7;
            }
        }
        this.end_time = -1.0;
        this.trans_time = -1.0;
    }

    Sim_stat get_stat_copy() {
        Sim_stat sim_stat = new Sim_stat();
        sim_stat.set_entity_info(this.entity_id, this.entity_name);
        sim_stat.set_measures((List)((ArrayList)this.measures).clone());
        sim_stat.set_observations((List)((ArrayList)this.observations).clone());
        sim_stat.set_levels((List)((ArrayList)this.levels).clone());
        sim_stat.set_tags((List)((ArrayList)this.tags).clone());
        if (this.data != null) {
            sim_stat.set_data((HashMap)this.data.clone());
        }
        sim_stat.set_end_time(this.end_time);
        sim_stat.set_trans_time(this.trans_time);
        return sim_stat;
    }

    void set_measures(List list) {
        this.measures = list;
    }

    void set_observations(List list) {
        this.observations = list;
    }

    void set_levels(List list) {
        this.levels = list;
    }

    void set_tags(List list) {
        this.tags = list;
    }

    void set_data(HashMap hashMap) {
        this.data = hashMap;
    }

    void set_end_time(double d) {
        this.end_time = d;
    }

    void set_trans_time(double d) {
        this.trans_time = d;
    }

    /*
     * Unable to fully structure code
     */
    public Object[] averages(String var1_1, double[] var2_2) {
        block19: {
            block20: {
                block18: {
                    var3_3 = this.get_id(var1_1);
                    var4_4 = this.get_type(var3_3);
                    var5_5 = new double[var2_2.length];
                    var6_6 = (List)this.observations.get(var3_3);
                    var7_7 = var2_2[0];
                    var9_8 = var2_2[var2_2.length - 1];
                    var15_9 = var6_6.size();
                    if (var4_4 != 0) break block18;
                    var5_5[0] = 0.0;
                    var11_10 = 0.0;
                    var13_11 = 0.0;
                    var16_12 = 0;
                    var19_15 = 0;
                    while (var19_15 < var15_9) {
                        var17_18 = (Double)var6_6.get(var19_15);
                        if (var17_18 >= var2_2[0]) {
                            var16_12 = var19_15;
                            break;
                        }
                        ++var19_15;
                    }
                    var20_21 = 0;
                    var21_23 = 1;
                    ** GOTO lbl34
                    {
                        ++var16_12;
                        ++var20_21;
                        do {
                            if (var16_12 < var15_9 && (var17_18 = ((Double)var6_6.get(var16_12)).doubleValue()) <= var2_2[var21_23]) continue block1;
                            var5_5[var21_23] = (double)var20_21 / (var2_2[var21_23] - var2_2[0]);
                            if (var5_5[var21_23] < var11_10) {
                                var11_10 = var5_5[var21_23];
                            }
                            if (var5_5[var21_23] > var13_11) {
                                var13_11 = var5_5[var21_23];
                            }
                            ++var21_23;
lbl34:
                            // 2 sources

                        } while (var21_23 < var2_2.length);
                    }
                    break block19;
                }
                if (var4_4 != 1) break block20;
                var5_5[0] = 0.0;
                var11_10 = 0.0;
                var13_11 = 0.0;
                var16_13 = 0;
                var17_19 = 0.0;
                var19_16 = 0.0;
                var21_24 = 0.0;
                var23_26 = 0.0;
                var25_27 = null;
                var26_28 = 0;
                while (var26_28 < var15_9) {
                    var25_27 = (double[])var6_6.get(var26_28);
                    if (var25_27[2] > var2_2[0]) {
                        var16_13 = var26_28;
                        if (!(var25_27[1] < var7_7)) break;
                        ++var16_13;
                        var19_16 = var25_27[0] * (var25_27[2] - var2_2[0]);
                        var23_26 = var25_27[2] - var2_2[0];
                        break;
                    }
                    ++var26_28;
                }
                var27_29 = 1;
                ** GOTO lbl74
                {
                    var25_27 = (double[])var6_6.get(var16_13++);
                    var21_24 = var23_26;
                    var17_19 = var19_16;
                    var19_16 += var25_27[0] * (var25_27[2] - var25_27[1]);
                    var23_26 += var25_27[2] - var25_27[1];
                    do {
                        if (var16_13 < var15_9 && ((double[])var6_6.get(var16_13))[1] < var2_2[var27_29]) continue block4;
                        var5_5[var27_29] = var16_13 == 0 ? 0.0 : (var25_27[2] > var2_2[var27_29] ? (var17_19 + var25_27[0] * (var2_2[var27_29] - var25_27[1])) / (var21_24 + (var2_2[var27_29] - var25_27[1])) : var19_16 / var23_26);
                        if (var5_5[var27_29] < var11_10) {
                            var11_10 = var5_5[var27_29];
                        }
                        if (var5_5[var27_29] > var13_11) {
                            var13_11 = var5_5[var27_29];
                        }
                        ++var27_29;
lbl74:
                        // 2 sources

                    } while (var27_29 < var2_2.length);
                }
                break block19;
            }
            var5_5[0] = 0.0;
            var11_10 = 0.0;
            var13_11 = 0.0;
            var16_14 = 0;
            var17_20 = 0.0;
            var20_22 = 0;
            while (var20_22 < var15_9) {
                var19_17 = (double[])var6_6.get(var20_22);
                if (var19_17[1] >= var2_2[0]) {
                    var16_14 = var20_22;
                    break;
                }
                ++var20_22;
            }
            var21_25 = 0;
            var22_30 = 1;
            ** GOTO lbl104
            {
                var19_17 = (double[])var6_6.get(var16_14++);
                var17_20 += var19_17[1] - var19_17[0];
                ++var21_25;
                do {
                    if (var16_14 < var15_9 && ((double[])var6_6.get(var16_14))[1] <= var2_2[var22_30]) continue block7;
                    var5_5[var22_30] = var21_25 == 0 ? 0.0 : var17_20 / (double)var21_25;
                    if (var5_5[var22_30] < var11_10) {
                        var11_10 = var5_5[var22_30];
                    }
                    if (var5_5[var22_30] > var13_11) {
                        var13_11 = var5_5[var22_30];
                    }
                    ++var22_30;
lbl104:
                    // 2 sources

                } while (var22_30 < var2_2.length);
            }
        }
        return new Object[]{var5_5, new Double(var11_10), new Double(var13_11)};
    }

    public void addAnnotation(String string, Object[] objectArray) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            arrayList.add(objectArray);
            this.annotations.add(new Object[]{string, arrayList});
        } else {
            Object[] objectArray2;
            int n = this.annotations.size();
            int n2 = 0;
            while (n2 < n) {
                objectArray2 = (Object[])this.annotations.get(n2);
                if (((String)objectArray2[0]).equals(string)) {
                    ((List)objectArray2[1]).add(objectArray);
                    return;
                }
                ++n2;
            }
            objectArray2 = new ArrayList();
            objectArray2.add(objectArray);
            this.annotations.add(new Object[]{string, objectArray2});
        }
    }

    public List getAnnotations(String string) {
        if (this.annotations != null) {
            int n = this.annotations.size();
            int n2 = 0;
            while (n2 < n) {
                Object[] objectArray = (Object[])this.annotations.get(n2);
                if (((String)objectArray[0]).equals(string)) {
                    return (List)objectArray[1];
                }
                ++n2;
            }
        }
        return null;
    }

    public int detailed_measure_count() {
        if (this.data == null) {
            return this.measures.size();
        }
        return this.measures.size() - this.data.size();
    }
}

