/*
 * Decompiled with CFR 0.152.
 */
package eduni.simjava;

import eduni.simanim.Anim_entity;
import eduni.simanim.Anim_param;
import eduni.simanim.Anim_port;
import eduni.simanim.Sim_anim;
import eduni.simjava.Semaphore;
import eduni.simjava.Sim_event;
import eduni.simjava.Sim_exception;
import eduni.simjava.Sim_port;
import eduni.simjava.Sim_predicate;
import eduni.simjava.Sim_stat;
import eduni.simjava.Sim_system;
import eduni.simjava.Sim_type_p;
import eduni.simjava.distributions.Generator;
import java.util.ArrayList;
import java.util.List;

public class Sim_entity
extends Thread
implements Cloneable {
    private String name;
    private int me;
    private Sim_event evbuf;
    private Sim_stat stat;
    private int state;
    private Semaphore restart;
    private Semaphore reset;
    private List ports;
    private Anim_entity aent;
    private List generators;
    static final int RUNNABLE = 0;
    static final int WAITING = 1;
    static final int HOLDING = 2;
    static final int FINISHED = 3;

    public Sim_entity(String string) {
        if (string.indexOf(" ") != -1) {
            throw new Sim_exception("Sim_entity: Entity names can't contain spaces.");
        }
        this.name = string;
        this.me = -1;
        this.state = 0;
        this.restart = new Semaphore(0);
        this.reset = new Semaphore(0);
        this.ports = new ArrayList();
        this.generators = new ArrayList();
        this.aent = null;
        Sim_system.add(this);
    }

    public Sim_entity(String string, String string2, int n, int n2) {
        if (string.indexOf(" ") != -1) {
            throw new Sim_exception("Sim_entity: Entity names can't contain spaces.");
        }
        this.name = string;
        this.me = -1;
        this.state = 0;
        this.restart = new Semaphore(0);
        this.reset = new Semaphore(0);
        this.ports = new ArrayList();
        this.generators = new ArrayList();
        Sim_system.add(this);
        this.aent = new Anim_entity(string, string2);
        this.aent.set_position(n, n2);
        ((Sim_anim)Sim_system.get_trcout()).add_entity(this.aent);
    }

    public void set_invisible(boolean bl) {
        if (this.aent != null) {
            this.aent.set_invisible(bl);
        }
    }

    public String get_name() {
        return this.name;
    }

    public int get_id() {
        return this.me;
    }

    public Sim_port get_port(Sim_event sim_event) {
        int n = this.ports.size();
        int n2 = 0;
        while (n2 < n) {
            Sim_port sim_port = (Sim_port)this.ports.get(n2);
            if (sim_event.get_src() == sim_port.get_dest()) {
                return sim_port;
            }
            ++n2;
        }
        return null;
    }

    public Sim_port get_port(String string) {
        int n = this.ports.size();
        int n2 = 0;
        while (n2 < n) {
            Sim_port sim_port = (Sim_port)this.ports.get(n2);
            if (string.compareTo(sim_port.get_pname()) == 0) {
                return sim_port;
            }
            ++n2;
        }
        System.out.println("Sim_entity: could not find port " + string + " on entity " + this.name);
        return null;
    }

    public void add_port(Sim_port sim_port) {
        this.ports.add(sim_port);
        sim_port.set_src(this.me);
        Anim_port anim_port = sim_port.get_aport();
        if (anim_port != null && this.aent != null) {
            this.aent.add_port(anim_port);
        }
    }

    public void add_param(Anim_param anim_param) {
        this.aent.add_param(anim_param);
    }

    public void set_stat(Sim_stat sim_stat) {
        this.stat = sim_stat;
        sim_stat.set_entity_info(this.me, this.name);
    }

    public Sim_stat get_stat() {
        return this.stat;
    }

    public void body() {
        System.out.println("Entity " + this.name + " has no body().");
    }

    public void sim_trace(int n, String string) {
        if ((n & Sim_system.get_trace_level()) != 0) {
            Sim_system.ent_trace(this.me, string);
        }
    }

    public void sim_completed(Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        if (this.stat != null) {
            this.stat.update(3, sim_event.get_tag(), sim_event.event_time(), Sim_system.sim_clock());
            this.stat.update(2, sim_event.get_tag(), sim_event.end_waiting_time(), Sim_system.sim_clock());
        }
        Sim_system.job_completed(this.me, sim_event.get_tag());
    }

    public void sim_schedule(int n, double d, int n2, Object object) {
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.send(this.me, n, d, n2, object);
    }

    public void sim_schedule(int n, double d, int n2) {
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.send(this.me, n, d, n2, null);
    }

    public void sim_schedule(Sim_port sim_port, double d, int n, Object object) {
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.send(this.me, sim_port.get_dest(), d, n, object);
    }

    public void sim_schedule(Sim_port sim_port, double d, int n) {
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.send(this.me, sim_port.get_dest(), d, n, null);
    }

    public void sim_schedule(String string, double d, int n, Object object) {
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.send(this.me, this.get_port(string).get_dest(), d, n, object);
    }

    public void sim_schedule(String string, double d, int n) {
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.send(this.me, this.get_port(string).get_dest(), d, n, null);
    }

    public int sim_waiting(Sim_predicate sim_predicate) {
        return Sim_system.waiting(this.me, sim_predicate);
    }

    public int sim_waiting() {
        return Sim_system.waiting(this.me, Sim_system.SIM_ANY);
    }

    public void sim_select(Sim_predicate sim_predicate, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.select(this.me, sim_predicate);
        if (sim_event != null && this.evbuf != null) {
            sim_event.copy(this.evbuf);
            if (this.stat != null) {
                this.stat.update(1, sim_event.get_tag(), sim_event.event_time(), Sim_system.sim_clock());
                sim_event.set_end_waiting_time(Sim_system.sim_clock());
            }
        }
        this.evbuf = null;
    }

    public int sim_cancel(Sim_predicate sim_predicate, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return 1;
        }
        Sim_system.cancel(this.me, sim_predicate);
        if (sim_event != null && this.evbuf != null) {
            sim_event.copy(this.evbuf);
        }
        if (this.evbuf != null) {
            return 1;
        }
        return 0;
    }

    public void sim_putback(Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.putback((Sim_event)sim_event.clone());
    }

    public void sim_get_next(Sim_predicate sim_predicate, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        if (this.sim_waiting(sim_predicate) > 0) {
            this.sim_select(sim_predicate, sim_event);
        } else {
            this.sim_wait_for(sim_predicate, sim_event);
        }
    }

    public void sim_get_next(Sim_event sim_event) {
        this.sim_get_next(Sim_system.SIM_ANY, sim_event);
    }

    public int sim_current() {
        return this.get_id();
    }

    public void send_on(Sim_event sim_event, Sim_port sim_port) {
        this.sim_schedule(sim_port.get_dest(), 0.0, sim_event.type(), sim_event.get_data());
    }

    int get_state() {
        return this.state;
    }

    Sim_event get_evbuf() {
        return this.evbuf;
    }

    void restart() {
        this.restart.v();
    }

    void set_going() {
        this.restart.v();
    }

    void set_state(int n) {
        this.state = n;
    }

    void set_id(int n) {
        this.me = n;
    }

    void set_evbuf(Sim_event sim_event) {
        this.evbuf = sim_event;
    }

    void poison() {
    }

    void update(int n, int n2, double d) {
        if (this.stat != null) {
            this.stat.update(n, n2, d);
        }
    }

    void tidy_up_stat() {
        if (this.stat != null) {
            this.stat.tidy_up();
        }
    }

    boolean has_stat() {
        return this.stat != null;
    }

    protected Object clone() throws CloneNotSupportedException {
        Sim_entity sim_entity = (Sim_entity)super.clone();
        sim_entity.set_name(new String(this.name));
        sim_entity.set_evbuf(null);
        return sim_entity;
    }

    private void set_name(String string) {
        this.name = string;
    }

    void reset() {
        if (this.stat != null) {
            this.stat.reset();
        }
        int n = this.generators.size();
        int n2 = 0;
        while (n2 < n) {
            Generator generator = (Generator)this.generators.get(n2);
            generator.set_seed(Sim_system.next_seed());
            ++n2;
        }
    }

    public final void run() {
        Sim_system.paused();
        this.restart.p();
        this.body();
        this.state = 3;
        Sim_system.completed();
    }

    public void add_generator(Generator generator) {
        this.generators.add(generator);
    }

    void reseed_generators() {
        int n = this.generators.size();
        int n2 = 0;
        while (n2 < n) {
            Generator generator = (Generator)this.generators.get(n2);
            generator.set_seed(Sim_system.next_seed());
            ++n2;
        }
    }

    List get_generators() {
        return this.generators;
    }

    public void sim_process(double d) {
        if (d < 0.0) {
            throw new Sim_exception("Sim_entity: Negative delay supplied.");
        }
        if (!Sim_system.running()) {
            return;
        }
        double d2 = Sim_system.sim_clock();
        if (this.stat != null) {
            this.stat.set_busy(d2);
        }
        Sim_system.hold(this.me, d);
        Sim_system.paused();
        this.restart.p();
        if (!Sim_system.running()) {
            return;
        }
        if (this.stat != null) {
            this.stat.update(4, d2, Sim_system.sim_clock());
        }
    }

    public void sim_process_until(Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        this.sim_process_until(Sim_system.SIM_ANY, sim_event);
    }

    public void sim_process_until(Sim_predicate sim_predicate, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        double d = Sim_system.sim_clock();
        if (this.stat != null) {
            this.stat.set_busy(d);
        }
        if (Sim_system.default_tracing()) {
            Sim_system.trace(this.me, "start holding");
        }
        this.sim_wait_for(sim_predicate, sim_event);
        if (!Sim_system.running()) {
            return;
        }
        if (this.stat != null) {
            this.stat.update(4, d, Sim_system.sim_clock());
        }
    }

    public double sim_process_for(double d, Sim_event sim_event) {
        if (d < 0.0) {
            throw new Sim_exception("Sim_entity: Negative delay supplied.");
        }
        if (!Sim_system.running()) {
            return 0.0;
        }
        return this.sim_process_for(Sim_system.SIM_ANY, d, sim_event);
    }

    public double sim_process_for(Sim_predicate sim_predicate, double d, Sim_event sim_event) {
        if (d < 0.0) {
            throw new Sim_exception("Sim_entity: Negative delay supplied.");
        }
        if (!Sim_system.running()) {
            return 0.0;
        }
        double d2 = Sim_system.sim_clock();
        double d3 = 0.0;
        if (this.stat != null) {
            this.stat.set_busy(d2);
        }
        if (Sim_system.default_tracing()) {
            Sim_system.trace(this.me, "start holding");
        }
        this.sim_schedule(this.me, d, 9999);
        this.sim_wait_for(sim_predicate, sim_event);
        if (!Sim_system.running()) {
            return 0.0;
        }
        if (sim_event.get_tag() != 9999) {
            Sim_type_p sim_type_p = new Sim_type_p(9999);
            d3 = d - (sim_event.event_time() - d2);
            int n = this.sim_cancel(sim_type_p, null);
        }
        if (this.stat != null) {
            this.stat.update(4, d2, Sim_system.sim_clock());
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        return d3;
    }

    public void sim_pause(double d) {
        if (d < 0.0) {
            throw new Sim_exception("Sim_entity: Negative delay supplied.");
        }
        if (!Sim_system.running()) {
            return;
        }
        Sim_system.pause(this.me, d);
        Sim_system.paused();
        this.restart.p();
    }

    public void sim_pause_until(Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        this.sim_pause_until(Sim_system.SIM_ANY, sim_event);
    }

    public void sim_pause_until(Sim_predicate sim_predicate, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        if (Sim_system.default_tracing()) {
            Sim_system.trace(this.me, "start pausing");
        }
        this.sim_wait_for(sim_predicate, sim_event);
    }

    public double sim_pause_for(double d, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return 0.0;
        }
        return this.sim_pause_for(Sim_system.SIM_ANY, d, sim_event);
    }

    public double sim_pause_for(Sim_predicate sim_predicate, double d, Sim_event sim_event) {
        if (d < 0.0) {
            throw new Sim_exception("Sim_entity: Negative delay supplied.");
        }
        if (!Sim_system.running()) {
            return 0.0;
        }
        double d2 = Sim_system.sim_clock();
        double d3 = 0.0;
        if (Sim_system.default_tracing()) {
            Sim_system.trace(this.me, "start pausing");
        }
        this.sim_schedule(this.me, d, 9999);
        this.sim_wait_for(sim_predicate, sim_event);
        if (!Sim_system.running()) {
            return 0.0;
        }
        if (sim_event.get_tag() != 9999) {
            Sim_type_p sim_type_p = new Sim_type_p(9999);
            d3 = d - (sim_event.event_time() - d2);
            int n = this.sim_cancel(sim_type_p, null);
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        return d3;
    }

    public void sim_wait(Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        do {
            Sim_system.wait(this.me, Sim_system.SIM_ANY);
            Sim_system.paused();
            this.restart.p();
            if (Sim_system.running()) continue;
            return;
        } while (this.evbuf == null);
        if (sim_event != null && this.evbuf != null) {
            sim_event.copy(this.evbuf);
            if (this.stat != null) {
                this.stat.update(1, sim_event.get_tag(), sim_event.event_time(), Sim_system.sim_clock());
                sim_event.set_end_waiting_time(Sim_system.sim_clock());
            }
        }
        this.evbuf = null;
    }

    public void sim_wait_for(Sim_predicate sim_predicate, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return;
        }
        do {
            Sim_system.wait(this.me, sim_predicate);
            Sim_system.paused();
            this.restart.p();
            if (Sim_system.running()) continue;
            return;
        } while (this.evbuf == null);
        if (sim_event != null && this.evbuf != null) {
            sim_event.copy(this.evbuf);
        }
        this.evbuf = null;
        if (this.stat != null && sim_event.get_tag() != 9999) {
            this.stat.update(1, sim_event.get_tag(), sim_event.event_time(), Sim_system.sim_clock());
            sim_event.set_end_waiting_time(Sim_system.sim_clock());
        }
    }

    public double sim_wait_for(double d, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return 0.0;
        }
        return this.sim_wait_for(Sim_system.SIM_ANY, d, sim_event);
    }

    public double sim_wait_for(Sim_predicate sim_predicate, double d, Sim_event sim_event) {
        if (d < 0.0) {
            throw new Sim_exception("Sim_entity: Negative delay supplied.");
        }
        if (!Sim_system.running()) {
            return 0.0;
        }
        this.sim_schedule(this.me, d, 9999);
        this.sim_wait_for(sim_predicate, sim_event);
        double d2 = 0.0;
        if (!Sim_system.running()) {
            return 0.0;
        }
        if (sim_event.get_tag() != 9999) {
            Sim_type_p sim_type_p = new Sim_type_p(9999);
            d2 = d - (sim_event.event_time() - Sim_system.sim_clock());
            int n = this.sim_cancel(sim_type_p, null);
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        return d2;
    }

    public void sim_hold(double d) {
        if (!Sim_system.running()) {
            return;
        }
        this.sim_pause(d);
    }

    public double sim_hold_for(double d, Sim_event sim_event) {
        if (!Sim_system.running()) {
            return 0.0;
        }
        return this.sim_pause_for(d, sim_event);
    }
}

