/*
 * Decompiled with CFR 0.152.
 */
package eduni.simdiag;

import eduni.simdiag.Entry;
import eduni.simdiag.Event;
import eduni.simdiag.TypeParam;
import eduni.simdiag.Types;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

class Entries {
    protected List entries = new ArrayList();
    protected Types types = new Types();
    double starttime = 0.0;
    double endtime = 1.0;
    final int TYPES = 0;
    final int BARS = 1;
    final int EVENTS = 2;
    int section = 0;

    Entries() {
    }

    void reset() {
        this.entries.clear();
        this.types.getV().clear();
        this.starttime = 0.0;
        this.endtime = 1.0;
    }

    int addTrace(String string) {
        String string2;
        Entry entry;
        StringTokenizer stringTokenizer;
        int n = 1;
        if (string.startsWith("$")) {
            if ("$types".compareTo(string) == 0) {
                this.section = 0;
            } else if ("$bars".compareTo(string) == 0) {
                this.section = 1;
            } else if ("$events".compareTo(string) == 0) {
                this.section = 2;
            } else {
                System.out.println("Couldn't read section name " + string);
                n = 0;
            }
        } else if (this.section == 0) {
            this.types.add(new TypeParam(string));
        } else if (this.section == 1) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string);
            if (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                if (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    TypeParam typeParam = this.types.find(string4);
                    if (typeParam != null) {
                        this.entries.add(new Entry(string3, typeParam));
                    } else {
                        System.out.println("Couldn't find type " + string4);
                        n = 0;
                    }
                }
            }
        } else if (this.section == 2 && (stringTokenizer = new StringTokenizer(string, ": \n\r\t")).nextToken().charAt(0) == 'u' && (entry = this.find(string2 = stringTokenizer.nextToken())) != null) {
            stringTokenizer.nextToken();
            double d = Double.valueOf(stringTokenizer.nextToken());
            if (d > this.endtime) {
                this.endtime = d;
            }
            switch (stringTokenizer.nextToken().charAt(0)) {
                case 'P': {
                    String string5 = stringTokenizer.nextToken();
                    int n2 = entry.getType().get_index(string5);
                    entry.add(new Event(d, n2));
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n;
    }

    Types getTypes() {
        return this.types;
    }

    double getStartTime() {
        return this.starttime;
    }

    double getEndTime() {
        return this.endtime;
    }

    void draw(Graphics graphics, double d, double d2, int n, int n2) {
        int n3 = this.entries.size();
        if (n3 > 0) {
            double d3 = n2 / n3;
            double d4 = d3 * 0.75;
            int n4 = 0;
            while (n4 < n3) {
                Entry entry = (Entry)this.entries.get(n4);
                entry.setPosition(0, n4 * (int)d3, n, (int)d4);
                entry.draw(graphics, d, d2);
                ++n4;
            }
        }
    }

    void drawLabels(Graphics graphics, int n, int n2) {
        int n3 = this.entries.size();
        if (n3 > 0) {
            double d = n2 / n3;
            double d2 = d * 0.5;
            int n4 = 0;
            while (n4 < n3) {
                Entry entry = (Entry)this.entries.get(n4);
                entry.drawLabel(graphics, 0, n4 * (int)d + (int)d2);
                ++n4;
            }
        }
    }

    Entry find(String string) {
        Entry entry = null;
        int n = this.entries.size();
        int n2 = 0;
        while (n2 < n) {
            Entry entry2 = (Entry)this.entries.get(n2);
            if (string.compareTo(entry2.name) == 0) {
                entry = entry2;
            }
            ++n2;
        }
        return entry;
    }
}

