/*
 * Decompiled with CFR 0.152.
 */
package eduni.simdiag;

import eduni.simdiag.Entries;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class Diagram
extends Panel
implements MouseMotionListener,
MouseListener,
AdjustmentListener {
    Image backingIm;
    Graphics backg;
    Dimension backingSize;
    Color bg = new Color(50, 50, 60);
    Scrollbar sb;
    Entries entries;
    int startx;
    int starty;
    int Xpos;
    int Opos;
    boolean movingX;
    boolean movingO;
    double startt;
    double endt;
    int keySpace = 50;

    Diagram() {
        this.setBackground(this.bg);
        this.startx = 0;
        this.starty = 0;
        this.Xpos = 0;
        this.Opos = 0;
        this.movingX = false;
        this.movingO = false;
        this.entries = new Entries();
        this.startt = 0.0;
        this.endt = this.entries.getEndTime();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    void set_sb(Scrollbar scrollbar) {
        this.sb = scrollbar;
        scrollbar.addAdjustmentListener(this);
    }

    void reLayout() {
        this.entries.reset();
    }

    void processTrace(String string) {
        this.entries.addTrace(string);
    }

    void display() {
        this.unzoomb();
    }

    double xtot(int n) {
        return this.startt + (double)n * (this.endt - this.startt) / (double)this.backingSize.width;
    }

    int ttox(double d) {
        return (int)((double)this.backingSize.width * (d - this.startt) / (this.endt - this.startt));
    }

    void quitb() {
        System.exit(0);
    }

    void zoomb() {
        int n = this.Xpos;
        int n2 = this.Opos;
        if (n > n2) {
            n = this.Opos;
            n2 = this.Xpos;
        }
        if (n2 - n > 5) {
            this.startt = this.xtot(n);
            this.endt = this.xtot(n2);
        } else {
            this.endt = this.startt + (this.endt - this.startt) / 2.0;
        }
        this.drawData();
        this.repaint();
        this.sbset();
    }

    void sbset() {
        double d = this.entries.getEndTime();
        int n = (int)(1000.0 * (this.startt / d));
        int n2 = (int)(1000.0 * ((this.endt - this.startt) / d));
        this.sb.setValues(n, n2, 0, 1000);
    }

    void sbmoved() {
        int n = this.sb.getValue();
        double d = (double)n / 1000.0 * this.entries.getEndTime();
        double d2 = this.startt - d;
        this.startt = d;
        this.endt -= d2;
        this.drawData();
        this.repaint();
    }

    void unzoomb() {
        this.startt = 0.0;
        this.endt = this.entries.getEndTime();
        this.drawData();
        this.sbset();
        this.repaint();
    }

    void reloadb() {
    }

    Entries getEntries() {
        return this.entries;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.backingIm == null || dimension.width != this.backingSize.width || dimension.height != this.backingSize.height) {
            this.backingIm = this.createImage(dimension.width, dimension.height);
            this.backingSize = dimension;
            this.backg = this.backingIm.getGraphics();
            this.keySpace = (int)((double)this.backingSize.height * 0.1);
            this.drawData();
        }
        graphics.drawImage(this.backingIm, 0, 0, null);
        this.drawLines(graphics);
    }

    double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    void drawNotches(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        boolean bl = n2 == n4;
        double d3 = d2 - d;
        double d4 = this.log10(d3);
        int n5 = (int)d4;
        double d5 = Math.pow(10.0, n5);
        if (d3 / d5 < 3.0) {
            d5 /= 2.0;
        }
        double d6 = 0.5 + d / d5;
        int n6 = (int)d6;
        double d7 = (double)n6 * d5;
        graphics.setColor(Color.gray);
        graphics.drawLine(n, n2, n3, n4);
        int n7 = this.keySpace / 5;
        double d8 = d7;
        while (d8 <= d2) {
            int n8 = this.ttox(d8);
            String string = Double.toString(d8);
            graphics.setColor(Color.gray);
            graphics.drawLine(n8, n2, n8, n7 + n2);
            int n9 = graphics.getFontMetrics().stringWidth(string);
            int n10 = graphics.getFontMetrics().getHeight();
            int n11 = n2 + n7 + n10;
            if (n11 > n2 + this.keySpace) {
                n11 = n2 + this.keySpace;
            }
            graphics.drawString(string, n8 - n9 / 2, n11);
            graphics.setColor(Color.gray.darker());
            graphics.drawLine(n8, n2, n8, 0);
            d8 += d5;
        }
    }

    void drawLines(Graphics graphics) {
        graphics.setXORMode(this.bg);
        graphics.setColor(Color.blue);
        graphics.drawLine(this.Opos, 0, this.Opos, this.backingSize.height);
        graphics.setColor(Color.red);
        graphics.drawLine(this.Xpos, 0, this.Xpos, this.backingSize.height);
        graphics.setPaintMode();
    }

    void drawData() {
        this.backg.setColor(this.bg);
        this.backg.translate(0, 0);
        this.backg.fillRect(0, 0, this.backingSize.width, this.backingSize.height);
        this.drawNotches(this.backg, 0, this.backingSize.height - this.keySpace, this.backingSize.width, this.backingSize.height - this.keySpace, this.startt, this.endt);
        this.entries.draw(this.backg, this.startt, this.endt, this.backingSize.width, this.backingSize.height - this.keySpace);
    }

    int abs(int n) {
        return n < 0 ? -n : n;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.movingX) {
            this.drawLines(this.getGraphics());
            this.Xpos = n;
            this.drawLines(this.getGraphics());
        } else if (this.movingO) {
            this.drawLines(this.getGraphics());
            this.Opos = n;
            this.drawLines(this.getGraphics());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 4) != 0) {
            int n3 = this.Opos;
            int n4 = this.Xpos;
            if (n3 < n4) {
                n4 = this.Opos;
                n3 = this.Xpos;
            }
            if (n >= n4 && n <= n3) {
                this.zoomb();
            } else {
                this.unzoomb();
            }
        } else {
            this.drawLines(this.getGraphics());
            this.movingO = false;
            this.movingX = false;
            if (this.abs(n - this.Xpos) < this.abs(n - this.Opos)) {
                this.Xpos = n;
                this.movingX = true;
            } else {
                this.Opos = n;
                this.movingO = true;
            }
            this.drawLines(this.getGraphics());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.sbmoved();
    }
}

