/*
 * Decompiled with CFR 0.152.
 */
package eduni.simanim;

import eduni.simanim.Anim_applet;
import eduni.simanim.Anim_entity;
import eduni.simanim.Anim_event;
import eduni.simanim.Anim_port;
import eduni.simanim.Param_type;
import eduni.simanim.Param_type_list;
import eduni.simdiag.TraceEventObject;
import eduni.simdiag.TraceListener;
import eduni.simdiag.Traceable;
import eduni.simjava.Sim_output;
import eduni.simjava.Sim_reporter;
import eduni.simjava.Sim_system;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class Sim_anim
extends Panel
implements Sim_output,
Traceable {
    private int width = 100;
    private int height = 100;
    private int traceCount;
    private List events;
    private List entities;
    private Param_type_list ptypes;
    private String msgString;
    private Image staticImage = null;
    private Graphics staticGraphics = null;
    private Color bgcolor = new Color(192, 196, 192);
    private static NumberFormat nf;
    private long lastsimtime;
    private List sends = new ArrayList();
    private List traceListeners = new ArrayList();
    private TraceEventObject lastTraceEvent;
    private static List images;
    private static List img_names;
    static Anim_applet applet;

    public synchronized void addTraceListener(TraceListener traceListener) {
        this.traceListeners.add(traceListener);
    }

    public synchronized void removeTraceListener(TraceListener traceListener) {
        this.traceListeners.remove(traceListener);
    }

    public void forwardTrace(TraceEventObject traceEventObject) {
        List list;
        TraceEventObject traceEventObject2 = new TraceEventObject((Object)this, traceEventObject);
        Sim_anim sim_anim = this;
        synchronized (sim_anim) {
            list = (List)((ArrayList)this.traceListeners).clone();
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            TraceListener traceListener = (TraceListener)list.get(n2);
            traceListener.handleTrace(traceEventObject2);
            ++n2;
        }
    }

    public Sim_anim(Anim_applet anim_applet) {
        this.entities = new ArrayList();
        this.ptypes = new Param_type_list();
        this.msgString = new String();
        applet = anim_applet;
        System.gc();
        nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(2);
        this.lastsimtime = 0L;
    }

    public void link_ports(String string, String string2, String string3, String string4) {
        Anim_entity anim_entity = this.find_entity(string);
        Anim_entity anim_entity2 = this.find_entity(string3);
        if (anim_entity == null) {
            System.out.println("Couldn't find anim ent: " + string);
        } else if (anim_entity2 == null) {
            System.out.println("Couldn't find anim ent: " + string3);
        } else {
            Anim_port anim_port = anim_entity.find_port(string2);
            Anim_port anim_port2 = anim_entity2.find_port(string4);
            if (anim_port == null) {
                System.out.println("Couldn't find anim port: " + string2);
            } else if (anim_port2 == null) {
                System.out.println("Couldn't find anim port: " + string4);
            } else {
                anim_port.link_port(anim_port2, true);
                anim_port2.link_port(anim_port, false);
            }
        }
    }

    public void add_entity(Anim_entity anim_entity) {
        this.entities.add(anim_entity);
    }

    static Image get_image(String string) {
        Image image = null;
        int n = img_names.indexOf(string);
        if (n == -1) {
            URL uRL = applet.getCodeBase();
            if (uRL == null) {
                try {
                    uRL = new URL("file:./");
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            image = applet.getImage(uRL, "bitmaps" + System.getProperty("file.separator") + string + ".gif");
            MediaTracker mediaTracker = new MediaTracker(applet);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Image loaded");
            }
            if (image == null) {
                System.out.println("Failed to load image :" + string + ".gif");
            }
            img_names.add(string);
            images.add(image);
            return image;
        }
        return (Image)images.get(n);
    }

    public void initialise() {
        this.traceCount = 0;
        this.events = new ArrayList();
        this.entities = new ArrayList();
        this.ptypes.reset();
    }

    public void setup_static_initial() {
        boolean bl = false;
        this.width = 10;
        this.height = 10;
        int n = this.entities.size();
        int n2 = 0;
        while (n2 < n) {
            Point point = ((Anim_entity)this.entities.get(n2)).get_end_position();
            int n3 = (int)point.getX();
            int n4 = (int)point.getY();
            if (n3 > this.width) {
                this.width = n3;
                bl = true;
            }
            if (n4 > this.height) {
                this.height = n4;
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            this.width += 10;
            this.height += 50;
        }
        this.staticImage = this.createImage(this.width, this.height);
        this.staticGraphics = this.staticImage.getGraphics();
        this.staticGraphics.setFont(new Font("TimesRoman", 0, 12));
        this.setSize(this.width, this.height);
        this.set_message("Initialising");
    }

    private void setup_static() {
        this.staticImage = this.createImage(this.width, this.height);
        this.staticGraphics = this.staticImage.getGraphics();
        this.staticGraphics.setFont(new Font("TimesRoman", 0, 12));
        this.setSize(this.width, this.height);
    }

    void add_param_type(Param_type param_type) {
        this.ptypes.add(param_type);
    }

    public void genTraceHeader() {
        TraceEventObject traceEventObject = new TraceEventObject((Object)this, 1);
        this.forwardTrace(traceEventObject);
        traceEventObject.set("$types");
        this.forwardTrace(traceEventObject);
        List list = this.ptypes.getV();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Param_type param_type = (Param_type)list.get(n2);
            String string = new String(param_type.getSpec());
            traceEventObject.set(string);
            this.forwardTrace(traceEventObject);
            ++n2;
        }
        traceEventObject.set("$bars");
        this.forwardTrace(traceEventObject);
        int n3 = this.entities.size();
        int n4 = 0;
        while (n4 < n3) {
            Anim_entity anim_entity = (Anim_entity)this.entities.get(n4);
            String string = anim_entity.get_bar_string();
            if (string != null) {
                traceEventObject.set(anim_entity.get_bar_string());
                this.forwardTrace(traceEventObject);
            }
            ++n4;
        }
        traceEventObject.set("$events");
        this.forwardTrace(traceEventObject);
    }

    public void genTraceTail() {
        this.forwardTrace(new TraceEventObject((Object)this, 5));
    }

    public void dispTrace() {
        this.forwardTrace(new TraceEventObject((Object)this, 5));
    }

    public void println(String string) {
        long l = System.currentTimeMillis();
        ++this.traceCount;
        this.events.add(new Anim_event(string, this));
        l = System.currentTimeMillis() - l;
        this.forwardTrace(new TraceEventObject((Object)this, string));
    }

    public void close() {
    }

    Anim_entity find_entity(String string) {
        int n = this.entities.size();
        int n2 = 0;
        while (n2 < n) {
            Anim_entity anim_entity = (Anim_entity)this.entities.get(n2);
            if (anim_entity.get_name().equals(string)) {
                return anim_entity;
            }
            ++n2;
        }
        return null;
    }

    public void paint(Graphics graphics) {
        if (this.staticImage == null || this.width != this.getSize().width || this.height != this.getSize().height) {
            this.setup_static();
            this.draw_all_static();
        }
        graphics.drawImage(this.staticImage, 0, 0, this);
        this.draw_messages(graphics);
    }

    void draw_messages(Graphics graphics) {
        int n = this.sends.size();
        int n2 = 0;
        while (n2 < n) {
            Anim_port anim_port = (Anim_port)this.sends.get(n2);
            anim_port.draw_messages(graphics);
            ++n2;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void show_update(Thread thread) {
        this.repaint();
        if (thread != null) {
            do {
                try {
                    Thread.sleep(applet.get_speed());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (applet.get_paused());
        }
    }

    public void draw_all_static() {
        this.staticGraphics.setColor(this.bgcolor);
        this.staticGraphics.fillRect(0, 0, this.width, this.height);
        this.staticGraphics.setColor(Color.black);
        this.staticGraphics.drawString(this.msgString, 5, this.height - 5);
        int n = this.entities.size();
        int n2 = 0;
        while (n2 < n) {
            ((Anim_entity)this.entities.get(n2)).draw(this.staticGraphics);
            ++n2;
        }
    }

    public void set_message(String string) {
        this.staticGraphics.setColor(this.bgcolor);
        this.staticGraphics.drawString(this.msgString, 5, this.height - 5);
        this.staticGraphics.setColor(Color.black);
        this.staticGraphics.drawString(string, 5, this.height - 5);
        this.msgString = string;
    }

    public void animate(Thread thread) {
        int n = 10;
        double d = 0.0;
        this.draw_all_static();
        this.genTraceHeader();
        Sim_system.run_initialise();
        int n2 = 0;
        int n3 = 0;
        while (Sim_system.incomplete()) {
            if (!Sim_system.running()) {
                Sim_system.run_start();
            }
            while (Sim_system.check_conditions() && !applet.get_stopped()) {
                if (Sim_system.run_tick()) break;
                long l = System.currentTimeMillis();
                l = System.currentTimeMillis() - l;
                this.sends.clear();
                long l2 = (long)applet.get_speed() - l;
                if (l2 < 1L) {
                    l2 = 1L;
                }
                if (l2 > 1L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (++n3 == 100) {
                    n3 = 0;
                    this.set_message("Running: sim time = " + nf.format(Sim_system.clock()));
                    this.show_update(thread);
                }
                int n4 = this.events.size();
                while (n2 < n4) {
                    Anim_event anim_event = (Anim_event)this.events.get(n2);
                    d = anim_event.timestamp;
                    while (n2 < n4) {
                        anim_event = (Anim_event)this.events.get(n2);
                        if (anim_event.timestamp > d) break;
                        switch (anim_event.type) {
                            case 0: {
                                this.sends.add(anim_event.src_port);
                                anim_event.src_port.set_data(anim_event.data.toString());
                                break;
                            }
                            case 1: {
                                anim_event.src_ent.set_params(anim_event.data.toString());
                                anim_event.src_ent.draw(this.staticGraphics);
                            }
                        }
                        ++n2;
                    }
                    this.set_message("Running: sim time = " + nf.format(d));
                    this.dispTrace();
                    this.show_update(thread);
                    if (applet.get_speed() <= 1 || this.sends.size() <= 0) continue;
                    int n5 = 0;
                    while (n5 <= n) {
                        int n6 = this.sends.size();
                        int n7 = 0;
                        while (n7 < n6) {
                            Anim_port anim_port = (Anim_port)this.sends.get(n7);
                            if (n5 == n) {
                                anim_port.move_msg(-1.0);
                            } else {
                                anim_port.move_msg(1.0 * (double)n5 / (double)n);
                            }
                            ++n7;
                        }
                        this.show_update(thread);
                        ++n5;
                    }
                }
            }
            Sim_system.tidy_up_stats();
            if (applet.get_stopped()) {
                Sim_system.animation_stopped();
            }
            Sim_system.apply_variance_reduction();
            Sim_system.end_current_run();
            if (applet.get_stopped()) break;
        }
        Sim_system.run_stop();
        this.show_update(thread);
        this.set_message("Sim completed: sim time = " + nf.format(d));
        this.draw_all_static();
        this.genTraceTail();
        this.show_update(thread);
        Sim_system.generate_report();
        applet.finished();
    }

    public Sim_reporter get_reporter() {
        return applet;
    }

    public Anim_applet get_applet() {
        return applet;
    }

    static {
        images = new ArrayList();
        img_names = new ArrayList();
    }
}

