/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

    public WholeNumberField(int n, int n2) {
        super(n2);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(n);
    }

    public int getValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
        return n;
    }

    public void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            char[] cArray2 = new char[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if (Character.isDigit(cArray[n4])) {
                    cArray2[n3++] = cArray[n4];
                } else {
                    WholeNumberField.this.toolkit.beep();
                }
                ++n4;
            }
            super.insertString(n, new String(cArray2, 0, n3), attributeSet);
        }
    }
}

