/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.BorderLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.UIManager;
import visualmodeler.DisplayView;
import visualmodeler.FileModel;
import visualmodeler.IconView;
import visualmodeler.MenuView;
import visualmodeler.ResourceModel;
import visualmodeler.UserModel;

public class VisualModeler
extends JFrame
implements WindowListener {
    private MenuView menuView_;
    private IconView iconView_;
    private DisplayView displayView_;
    private UserModel userModel_;
    private ResourceModel resModel_;
    private FileModel fileModel_;

    public VisualModeler() {
        this.getContentPane().setLayout(new BorderLayout());
        super.setSize(570, 450);
        super.setLocation(10, 10);
        super.setTitle("Visual Modeler");
        this.addWindowListener(this);
        super.setDefaultCloseOperation(0);
        this.userModel_ = new UserModel();
        this.resModel_ = new ResourceModel();
        this.fileModel_ = new FileModel(this, this.userModel_, this.resModel_);
        this.menuView_ = new MenuView(this, this.fileModel_);
        this.iconView_ = new IconView(this, "North", this.fileModel_, this.userModel_, this.resModel_);
        this.displayView_ = new DisplayView(this, "Center", this.userModel_, this.resModel_);
        this.fileModel_.addObserver(this.iconView_);
        this.fileModel_.addObserver(this.menuView_);
        this.userModel_.addObserver(this.displayView_);
        this.userModel_.addObserver(this.menuView_);
        this.userModel_.addObserver(this.iconView_);
        this.resModel_.addObserver(this.displayView_);
        this.resModel_.addObserver(this.menuView_);
        this.resModel_.addObserver(this.iconView_);
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.fileModel_.quitProgram()) {
            this.dispose();
            System.exit(0);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        try {
            string = UIManager.getSystemLookAndFeelClassName();
            if (string.equals(string2)) {
                UIManager.setLookAndFeel(string);
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            VisualModeler visualModeler = new VisualModeler();
            visualModeler.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Exception occurs. Quit Program");
            exception.printStackTrace();
        }
    }
}

