/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserProperty
extends JDialog
implements ActionListener,
WindowListener {
    private Hashtable hashText_;
    private JButton ok_;
    private JButton cancel_;
    private JComboBox combo_;
    private JRadioButton radioFactor_;
    private JRadioButton radioValue_;
    private Toolkit toolkit_;
    private int hour_;
    private int min_;
    private int sec_;
    private int gridSize_;
    private int lengthSize_;
    private int fileSize_;
    private int outputSize_;
    private double gridMin_;
    private double gridMax_;
    private double lengthMin_;
    private double lengthMax_;
    private double fileMin_;
    private double fileMax_;
    private double outputMin_;
    private double outputMax_;
    private double baudRate_;
    private double delay_;
    private double bNum_;
    private double dNum_;
    private int id_;
    private String name_;
    private int comboPolicy_;
    private final String[] comboValue_ = new String[]{"No Optimisation", "Optimise Cost", "Optimise Cost Plus", "Optimise Cost and Time", "Optimise Time"};
    private boolean guiHasCreated_;
    private boolean curRadioFactor_;
    private boolean hasLoadXml_;

    public UserProperty(int n, String string, boolean bl, Random random) {
        super.setModal(true);
        super.setSize(500, 500);
        super.setLocation(100, 100);
        super.setTitle("User Property Dialog");
        if (bl) {
            this.randomValue(random);
        } else {
            this.defaultValue();
        }
        this.id_ = n;
        this.name_ = string;
        this.guiHasCreated_ = false;
        this.hasLoadXml_ = false;
        this.cancel_ = null;
        this.combo_ = null;
        this.hashText_ = null;
        this.ok_ = null;
        this.radioFactor_ = null;
        this.radioValue_ = null;
        this.toolkit_ = null;
    }

    public String getUserName() {
        return this.name_;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("ok")) {
            if (!this.saveValue()) {
                return;
            }
        } else {
            this.resetValue();
        }
        this.removeListeners();
        this.dispose();
    }

    public void showDialog() {
        if (!this.guiHasCreated_) {
            this.guiHasCreated_ = true;
            this.addWindowListener(this);
            this.initComponents();
        }
        this.ok_.addActionListener(this);
        this.cancel_.addActionListener(this);
        this.show();
    }

    public String generateCode(String string) {
        String string2 = "seed*997*(1+" + this.id_ + ")+1";
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("///////// Create ");
        stringBuffer.append(this.name_);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("random = new Random(");
        stringBuffer.append(string2);
        stringBuffer.append(");\n");
        stringBuffer.append(string);
        stringBuffer.append("glList = new GridletList();\n");
        stringBuffer.append(string);
        stringBuffer.append("count = (int) GridSimRandom.real(");
        stringBuffer.append(this.gridSize_);
        stringBuffer.append(", ");
        stringBuffer.append(this.gridMin_ / 100.0);
        stringBuffer.append(", ");
        stringBuffer.append(this.gridMax_ / 100.0);
        stringBuffer.append(", random.nextDouble());\n\n");
        stringBuffer.append(string);
        stringBuffer.append("// A loop that creates new Gridlets\n");
        stringBuffer.append(string);
        stringBuffer.append("for (int i = 0; i < count; i++) {\n");
        stringBuffer.append(string);
        stringBuffer.append("    ");
        stringBuffer.append("double len = GridSimRandom.real(");
        stringBuffer.append(this.lengthSize_);
        stringBuffer.append(", ");
        stringBuffer.append(this.lengthMin_ / 100.0);
        stringBuffer.append(", ");
        stringBuffer.append(this.lengthMax_ / 100.0);
        stringBuffer.append(", random.nextDouble());\n\n");
        stringBuffer.append(string);
        stringBuffer.append("    ");
        stringBuffer.append("long file = (long) GridSimRandom.real(");
        stringBuffer.append(this.fileSize_);
        stringBuffer.append(", ");
        stringBuffer.append(this.fileMin_ / 100.0);
        stringBuffer.append(", ");
        stringBuffer.append(this.fileMax_ / 100.0);
        stringBuffer.append(", random.nextDouble());\n\n");
        stringBuffer.append(string);
        stringBuffer.append("    ");
        stringBuffer.append("long out = (long) GridSimRandom.real(");
        stringBuffer.append(this.outputSize_);
        stringBuffer.append(", ");
        stringBuffer.append(this.outputMin_ / 100.0);
        stringBuffer.append(", ");
        stringBuffer.append(this.outputMax_ / 100.0);
        stringBuffer.append(", random.nextDouble());\n\n");
        stringBuffer.append(string);
        stringBuffer.append("    // Creates a new Gridlet entity \n");
        stringBuffer.append(string);
        stringBuffer.append("    ");
        stringBuffer.append("Gridlet gl = new Gridlet(i, len, file, out);\n");
        stringBuffer.append(string);
        stringBuffer.append("    glList.add(gl);   // Adds a new Gridlet into a list\n");
        stringBuffer.append(string);
        stringBuffer.append("}\n\n");
        stringBuffer.append(string);
        stringBuffer.append("expt = new Experiment(");
        stringBuffer.append(this.id_);
        stringBuffer.append(", glList, ");
        stringBuffer.append(this.comboPolicy_);
        stringBuffer.append(", ");
        stringBuffer.append(this.curRadioFactor_);
        stringBuffer.append(", ");
        stringBuffer.append(this.dNum_);
        stringBuffer.append(", ");
        stringBuffer.append(this.bNum_);
        stringBuffer.append(",\n");
        stringBuffer.append(string);
        stringBuffer.append("    \"report");
        stringBuffer.append(this.id_);
        stringBuffer.append(".txt\", resourceNameList);\n\n");
        stringBuffer.append(string);
        stringBuffer.append("userEntity = new UserEntity(\"User");
        stringBuffer.append(this.id_);
        stringBuffer.append("\", expt, ");
        stringBuffer.append(this.baudRate_);
        stringBuffer.append(", ");
        stringBuffer.append(string2);
        stringBuffer.append(",\n    ");
        stringBuffer.append(string);
        stringBuffer.append(this.delay_);
        stringBuffer.append(", false);\n");
        return stringBuffer.toString();
    }

    public String saveFile(String string) {
        String string2 = string + "    ";
        String string3 = string2 + "    ";
        String string4 = string3 + "    ";
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("\n\n");
        stringBuffer.append(string);
        stringBuffer.append("<user>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<id> ");
        stringBuffer.append(this.id_);
        stringBuffer.append(" </id>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<name> ");
        stringBuffer.append(this.name_);
        stringBuffer.append(" </name>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<baudRate> ");
        stringBuffer.append(this.baudRate_);
        stringBuffer.append(" </baudRate>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<time>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<hour> ");
        stringBuffer.append(this.hour_);
        stringBuffer.append(" </hour>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<minute> ");
        stringBuffer.append(this.min_);
        stringBuffer.append(" </minute>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<second> ");
        stringBuffer.append(this.sec_);
        stringBuffer.append(" </second>\n");
        stringBuffer.append(string2);
        stringBuffer.append("</time>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<delay> ");
        stringBuffer.append(this.delay_);
        stringBuffer.append(" </delay>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<schedulingStrategy> ");
        stringBuffer.append(this.comboValue_[this.comboPolicy_]);
        stringBuffer.append(" </schedulingStrategy>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<gridletProperty>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<gridlet>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<size> ");
        stringBuffer.append(this.gridSize_);
        stringBuffer.append(" </size>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<minDeviation> ");
        stringBuffer.append(this.gridMin_ / 100.0);
        stringBuffer.append(" </minDeviation>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<maxDeviation> ");
        stringBuffer.append(this.gridMax_ / 100.0);
        stringBuffer.append(" </maxDeviation>\n");
        stringBuffer.append(string3);
        stringBuffer.append("</gridlet>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<length>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<size> ");
        stringBuffer.append(this.lengthSize_);
        stringBuffer.append(" </size>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<minDeviation> ");
        stringBuffer.append(this.lengthMin_ / 100.0);
        stringBuffer.append(" </minDeviation>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<maxDeviation> ");
        stringBuffer.append(this.lengthMax_ / 100.0);
        stringBuffer.append(" </maxDeviation>\n");
        stringBuffer.append(string3);
        stringBuffer.append("</length>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<file>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<size> ");
        stringBuffer.append(this.fileSize_);
        stringBuffer.append(" </size>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<minDeviation> ");
        stringBuffer.append(this.fileMin_ / 100.0);
        stringBuffer.append(" </minDeviation>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<maxDeviation> ");
        stringBuffer.append(this.fileMax_ / 100.0);
        stringBuffer.append(" </maxDeviation>\n");
        stringBuffer.append(string3);
        stringBuffer.append("</file>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<output>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<size> ");
        stringBuffer.append(this.outputSize_);
        stringBuffer.append(" </size>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<minDeviation> ");
        stringBuffer.append(this.outputMin_ / 100.0);
        stringBuffer.append(" </minDeviation>\n");
        stringBuffer.append(string4);
        stringBuffer.append("<maxDeviation> ");
        stringBuffer.append(this.outputMax_ / 100.0);
        stringBuffer.append(" </maxDeviation>\n");
        stringBuffer.append(string3);
        stringBuffer.append("</output>\n");
        stringBuffer.append(string2);
        stringBuffer.append("</gridletProperty>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<budgetDeadlineProperty>\n");
        if (this.curRadioFactor_) {
            stringBuffer.append(string3);
            stringBuffer.append("<type> factor </type>\n");
        } else {
            stringBuffer.append(string3);
            stringBuffer.append("<type> value </type>\n");
        }
        stringBuffer.append(string3);
        stringBuffer.append("<budget> ");
        stringBuffer.append(this.bNum_);
        stringBuffer.append(" </budget>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<deadline> ");
        stringBuffer.append(this.dNum_);
        stringBuffer.append(" </deadline>\n");
        stringBuffer.append(string2);
        stringBuffer.append("</budgetDeadlineProperty>\n");
        stringBuffer.append(string);
        stringBuffer.append("</user>\n");
        return stringBuffer.toString();
    }

    public boolean hasLoadXml() {
        return this.hasLoadXml_;
    }

    public void loadXml(NodeList nodeList) {
        this.hasLoadXml_ = true;
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                String string;
                String string2 = node.getNodeName();
                if (string2.equals("id")) {
                    int n3;
                    string = node.getFirstChild().getNodeValue();
                    this.id_ = n3 = Integer.parseInt(string.trim());
                } else if (string2.equals("name")) {
                    string = node.getFirstChild().getNodeValue();
                    this.name_ = string.trim();
                } else if (string2.equals("baudRate")) {
                    double d;
                    string = node.getFirstChild().getNodeValue();
                    this.baudRate_ = d = Double.parseDouble(string.trim());
                } else if (string2.equals("time")) {
                    this.loadXmlTime(node.getChildNodes());
                } else if (string2.equals("delay")) {
                    double d;
                    string = node.getFirstChild().getNodeValue();
                    this.delay_ = d = Double.parseDouble(string.trim());
                } else if (string2.equals("schedulingStrategy")) {
                    string = node.getFirstChild().getNodeValue();
                    this.loadXmlPolicy(string.trim());
                } else if (string2.equals("budgetDeadlineProperty")) {
                    this.loadXmlBudgetDeadline(node.getChildNodes());
                } else if (string2.equals("gridletProperty")) {
                    this.loadXmlGridlet(node.getChildNodes());
                }
            }
            ++n2;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.resetValue();
        this.removeListeners();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void defaultValue() {
        this.sec_ = 0;
        this.min_ = 0;
        this.hour_ = 0;
        this.comboPolicy_ = 0;
        this.delay_ = 0;
        this.fileSize_ = 0;
        this.outputSize_ = 0;
        this.lengthSize_ = 0;
        this.gridSize_ = 0;
        this.lengthMax_ = 0.0;
        this.lengthMin_ = 0.0;
        this.gridMax_ = 0.0;
        this.gridMin_ = 0.0;
        this.outputMax_ = 0.0;
        this.outputMin_ = 0.0;
        this.fileMax_ = 0.0;
        this.fileMin_ = 0.0;
        this.curRadioFactor_ = false;
        this.dNum_ = 100.0;
        this.bNum_ = 100.0;
        this.baudRate_ = 100.0;
    }

    private void randomValue(Random random) {
        this.baudRate_ = random.nextInt(606);
        this.delay_ = random.nextInt(101);
        this.hour_ = random.nextInt(101);
        this.min_ = random.nextInt(101);
        this.sec_ = random.nextInt(101);
        this.gridSize_ = random.nextInt(101);
        this.gridMin_ = (double)random.nextInt(101) / 10.0;
        this.gridMax_ = (double)random.nextInt(101) / 10.0;
        this.lengthSize_ = random.nextInt(10201);
        this.lengthMin_ = (double)random.nextInt(101) / 10.0;
        this.lengthMax_ = (double)random.nextInt(101) / 10.0;
        this.fileSize_ = random.nextInt(101);
        this.fileMin_ = (double)random.nextInt(101) / 10.0;
        this.fileMax_ = (double)random.nextInt(101) / 10.0;
        this.outputSize_ = random.nextInt(101);
        this.outputMin_ = (double)random.nextInt(101) / 10.0;
        this.outputMax_ = (double)random.nextInt(101) / 10.0;
        this.curRadioFactor_ = false;
        if (this.curRadioFactor_) {
            this.bNum_ = (double)random.nextInt(101) / 100.0;
            this.dNum_ = (double)random.nextInt(101) / 100.0;
        } else {
            this.bNum_ = random.nextInt(10201);
            this.dNum_ = random.nextInt(10201);
        }
        this.comboPolicy_ = random.nextInt(this.comboValue_.length);
    }

    private void initComponents() {
        this.hashText_ = new Hashtable();
        this.toolkit_ = Toolkit.getDefaultToolkit();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Font font = new Font(null, 0, 14);
        JPanel jPanel = new JPanel(gridBagLayout);
        int n = 0;
        gridBagConstraints.insets = new Insets(10, 3, 10, 2);
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n++;
        JLabel jLabel = new JLabel("User Name:");
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        JTextField jTextField = new JTextField("" + this.name_, 20);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.hashText_.put("user", jTextField);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n++;
        JLabel jLabel2 = new JLabel("Baud Rate:");
        jLabel2.setFont(font);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jTextField = new JTextField("" + this.baudRate_, 4);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.hashText_.put("baud", jTextField);
        gridBagConstraints.gridy = n++;
        JLabel jLabel3 = new JLabel("Max. simulation time:");
        jLabel3.setFont(font);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.ipadx = 5;
        jTextField = new JTextField("" + this.hour_, 3);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.hashText_.put("hour", jTextField);
        jPanel.add((Component)new JLabel(" hour"), gridBagConstraints);
        jTextField = new JTextField("" + this.min_, 3);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.hashText_.put("min", jTextField);
        jPanel.add((Component)new JLabel(" minute"), gridBagConstraints);
        jTextField = new JTextField("" + this.sec_, 3);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.hashText_.put("sec", jTextField);
        jPanel.add((Component)new JLabel(" second"), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.ipadx = 0;
        JLabel jLabel4 = new JLabel("Successive experiment delay: ");
        jLabel4.setFont(font);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        jTextField = new JTextField("" + this.delay_, 4);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.hashText_.put("delay", jTextField);
        jPanel.add((Component)new JLabel("second"), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        JLabel jLabel5 = new JLabel("Scheduling strategy:");
        jLabel5.setFont(font);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        this.combo_ = new JComboBox<String>(this.comboValue_);
        this.combo_.setSelectedIndex(this.comboPolicy_);
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)this.combo_, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = new JPanel(new GridLayout(5, 4, 15, 15));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.createGridlet(jPanel2);
        gridBagConstraints.gridy = n++;
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.createBudgetDeadline(jPanel3);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.ok_ = new JButton("OK");
        jPanel.add((Component)this.ok_, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.cancel_ = new JButton("Cancel");
        jPanel.add((Component)this.cancel_, gridBagConstraints);
        int n2 = 22;
        int n3 = 30;
        JScrollPane jScrollPane = new JScrollPane(jPanel, n2, n3);
        this.getContentPane().add(jScrollPane);
    }

    private void createBudgetDeadline(JPanel jPanel) {
        Font font = new Font(null, 0, 12);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Budget and Deadline");
        titledBorder.setTitleFont(font.deriveFont(1, 16.0f));
        jPanel.setBorder(titledBorder);
        this.radioFactor_ = new JRadioButton("Factor-based");
        this.radioFactor_.setFont(font);
        this.radioFactor_.setActionCommand("factor");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.radioFactor_);
        this.radioValue_ = new JRadioButton("Value-based");
        this.radioValue_.setFont(font);
        this.radioValue_.setActionCommand("value");
        jPanel2.add(this.radioValue_);
        jPanel.add((Component)jPanel2, "North");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioFactor_);
        buttonGroup.add(this.radioValue_);
        if (this.curRadioFactor_) {
            this.radioFactor_.setSelected(true);
        } else {
            this.radioValue_.setSelected(true);
        }
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.createCenterComponent(jPanel3);
        jPanel.add((Component)jPanel3, "Center");
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("   Note: For factor-based, the range for both budget");
        stringBuffer.append(" and deadline is [0.0, 1.0]");
        JLabel jLabel = new JLabel(stringBuffer.toString());
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, "South");
    }

    private void createCenterComponent(JPanel jPanel) {
        Font font = new Font(null, 0, 12);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        JLabel jLabel = new JLabel("  Budget: ");
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = new JTextField("" + this.bNum_, 10);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.hashText_.put("budget", jTextField);
        gridBagConstraints.gridy = n++;
        jLabel = new JLabel("  Deadline: ");
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jTextField = new JTextField("" + this.dNum_, 10);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.hashText_.put("deadline", jTextField);
    }

    private void createGridlet(JPanel jPanel) {
        Font font = new Font(null, 0, 12);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Gridlet");
        titledBorder.setTitleFont(font.deriveFont(1, 16.0f));
        jPanel.setBorder(titledBorder);
        JLabel jLabel = new JLabel("blah");
        jLabel.setVisible(false);
        jPanel.add(jLabel);
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        jLabel = new JLabel("           Size");
        jLabel.setFont(font);
        jPanel.add(jLabel);
        jLabel = new JLabel("Min. Deviation (%)");
        jLabel.setFont(font);
        jPanel.add(jLabel);
        jLabel = new JLabel("Max. Devation (%)");
        jLabel.setFont(font);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = n++;
        jLabel = new JLabel("        Gridlet:");
        jLabel.setFont(font);
        jPanel.add(jLabel);
        JTextField jTextField = new JTextField("" + this.gridSize_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("grid_size", jTextField);
        jTextField = new JTextField("" + this.gridMin_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("grid_min", jTextField);
        jTextField = new JTextField("" + this.gridMax_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("grid_max", jTextField);
        jLabel = new JLabel("        Length:");
        jLabel.setFont(font);
        jPanel.add(jLabel);
        jTextField = new JTextField("" + this.lengthSize_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("length_size", jTextField);
        jTextField = new JTextField("" + this.lengthMin_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("length_min", jTextField);
        jTextField = new JTextField("" + this.lengthMax_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("length_max", jTextField);
        jLabel = new JLabel("        File:");
        jLabel.setFont(font);
        jPanel.add(jLabel);
        jTextField = new JTextField("" + this.fileSize_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("file_size", jTextField);
        jTextField = new JTextField("" + this.fileMin_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("file_min", jTextField);
        jTextField = new JTextField("" + this.fileMax_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("file_max", jTextField);
        jLabel = new JLabel("        Output:");
        jLabel.setFont(font);
        jPanel.add(jLabel);
        jTextField = new JTextField("" + this.outputSize_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("output_size", jTextField);
        jTextField = new JTextField("" + this.outputMin_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("output_min", jTextField);
        jTextField = new JTextField("" + this.outputMax_, 5);
        jPanel.add(jTextField);
        this.hashText_.put("output_max", jTextField);
    }

    private void removeListeners() {
        this.ok_.removeActionListener(this);
        this.cancel_.removeActionListener(this);
    }

    private boolean saveValue() {
        boolean bl;
        block4: {
            bl = true;
            this.comboPolicy_ = this.combo_.getSelectedIndex();
            this.name_ = ((JTextField)this.hashText_.get("user")).getText();
            String string = "";
            try {
                string = "baud rate";
                JTextField jTextField = (JTextField)this.hashText_.get("baud");
                this.baudRate_ = this.checkValue(this.baudRate_, jTextField);
                string = "delay";
                jTextField = (JTextField)this.hashText_.get("delay");
                this.delay_ = this.checkValue(this.delay_, jTextField);
                string = "hour";
                jTextField = (JTextField)this.hashText_.get("hour");
                this.hour_ = this.checkValue(this.hour_, jTextField);
                string = "minute";
                jTextField = (JTextField)this.hashText_.get("min");
                this.min_ = this.checkValue(this.min_, jTextField);
                string = "second";
                jTextField = (JTextField)this.hashText_.get("sec");
                this.sec_ = this.checkValue(this.sec_, jTextField);
                string = "gridlet size";
                jTextField = (JTextField)this.hashText_.get("grid_size");
                this.gridSize_ = this.checkValue(this.gridSize_, jTextField);
                string = "gridlet min deviation";
                jTextField = (JTextField)this.hashText_.get("grid_min");
                this.gridMin_ = this.checkValue(this.gridMin_, jTextField, "deviation");
                string = "gridlet max deviation";
                jTextField = (JTextField)this.hashText_.get("grid_max");
                this.gridMax_ = this.checkValue(this.gridMax_, jTextField, "deviation");
                string = "length size";
                jTextField = (JTextField)this.hashText_.get("length_size");
                this.lengthSize_ = this.checkValue(this.lengthSize_, jTextField);
                string = "length min deviation";
                jTextField = (JTextField)this.hashText_.get("length_min");
                this.lengthMin_ = this.checkValue(this.lengthMin_, jTextField, "deviation");
                string = "length max deviation";
                jTextField = (JTextField)this.hashText_.get("length_max");
                this.lengthMax_ = this.checkValue(this.lengthMax_, jTextField, "deviation");
                string = "file size";
                jTextField = (JTextField)this.hashText_.get("file_size");
                this.fileSize_ = this.checkValue(this.fileSize_, jTextField);
                string = "file min deviation";
                jTextField = (JTextField)this.hashText_.get("file_min");
                this.fileMin_ = this.checkValue(this.fileMin_, jTextField, "deviation");
                string = "file max deviation";
                jTextField = (JTextField)this.hashText_.get("file_max");
                this.fileMax_ = this.checkValue(this.fileMax_, jTextField, "deviation");
                string = "output size";
                jTextField = (JTextField)this.hashText_.get("output_size");
                this.outputSize_ = this.checkValue(this.outputSize_, jTextField);
                string = "output min deviation";
                jTextField = (JTextField)this.hashText_.get("output_min");
                this.outputMin_ = this.checkValue(this.outputMin_, jTextField, "deviation");
                string = "output max deviation";
                jTextField = (JTextField)this.hashText_.get("output_max");
                this.outputMax_ = this.checkValue(this.outputMax_, jTextField, "deviation");
                string = "budget";
                jTextField = (JTextField)this.hashText_.get("budget");
                this.bNum_ = this.checkValue(this.bNum_, jTextField, "factor");
                string = "deadline";
                jTextField = (JTextField)this.hashText_.get("deadline");
                this.dNum_ = this.checkValue(this.dNum_, jTextField, "factor");
                if (this.radioFactor_.isSelected()) {
                    this.curRadioFactor_ = true;
                    break block4;
                }
                this.curRadioFactor_ = false;
            }
            catch (NumberFormatException numberFormatException) {
                this.toolkit_.beep();
                JOptionPane.showMessageDialog(this, "Invalid value for number of " + string + ".", string + " value error", 0);
                bl = false;
            }
            catch (Exception exception) {
                this.toolkit_.beep();
                JOptionPane.showMessageDialog(this, exception.getMessage(), string + " value error", 0);
                bl = false;
            }
        }
        return bl;
    }

    private double checkValue(double d, JTextField jTextField) throws Exception {
        d = new Double(jTextField.getText());
        if (d < 0.0) {
            throw new Exception("Invalid for having negative value.");
        }
        return d;
    }

    private int checkValue(int n, JTextField jTextField) throws Exception {
        n = new Integer(jTextField.getText());
        if (n < 0) {
            throw new Exception("Invalid for having negative value.");
        }
        return n;
    }

    private double checkValue(double d, JTextField jTextField, String string) throws Exception {
        d = new Double(jTextField.getText());
        if (d < 0.0) {
            throw new Exception("Invalid for having negative value.");
        }
        if (string.equals("deviation")) {
            if (d > 100.0) {
                throw new Exception("Invalid value for exceeding 100.");
            }
        } else if (string.equals("factor") && this.radioFactor_.isSelected() && d > 1.0) {
            throw new Exception("Invalid value for exceeding 1.");
        }
        return d;
    }

    private void resetValue() {
        this.resetTextValue(this.name_, "user");
        this.resetTextValue(this.baudRate_, "baud");
        this.resetTextValue(this.delay_, "delay");
        this.resetTextValue(this.hour_, "hour");
        this.resetTextValue(this.min_, "min");
        this.resetTextValue(this.sec_, "sec");
        this.resetTextValue(this.bNum_, "budget");
        this.resetTextValue(this.dNum_, "deadline");
        this.resetTextValue(this.gridSize_, "grid_size");
        this.resetTextValue(this.gridMin_, "grid_min");
        this.resetTextValue(this.gridMax_, "grid_max");
        this.resetTextValue(this.lengthSize_, "length_size");
        this.resetTextValue(this.lengthMin_, "length_min");
        this.resetTextValue(this.lengthMax_, "length_max");
        this.resetTextValue(this.outputSize_, "output_size");
        this.resetTextValue(this.outputMin_, "output_min");
        this.resetTextValue(this.outputMax_, "output_max");
        this.resetTextValue(this.fileSize_, "file_size");
        this.resetTextValue(this.fileMin_, "file_min");
        this.resetTextValue(this.fileMax_, "file_max");
        this.combo_.setSelectedIndex(this.comboPolicy_);
        if (this.curRadioFactor_) {
            this.radioFactor_.setSelected(true);
        } else {
            this.radioValue_.setSelected(true);
        }
    }

    private void resetTextValue(String string, String string2) {
        JTextField jTextField = (JTextField)this.hashText_.get(string2);
        jTextField.setText(string);
        this.hashText_.put(string2, jTextField);
    }

    private void resetTextValue(double d, String string) {
        JTextField jTextField = (JTextField)this.hashText_.get(string);
        jTextField.setText("" + d);
        this.hashText_.put(string, jTextField);
    }

    private void resetTextValue(int n, String string) {
        JTextField jTextField = (JTextField)this.hashText_.get(string);
        jTextField.setText("" + n);
        this.hashText_.put(string, jTextField);
    }

    private void loadXmlTime(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                int n3;
                String string;
                String string2 = node.getNodeName();
                if (string2.equals("hour")) {
                    string = node.getFirstChild().getNodeValue();
                    this.hour_ = n3 = Integer.parseInt(string.trim());
                } else if (string2.equals("minute")) {
                    string = node.getFirstChild().getNodeValue();
                    this.min_ = n3 = Integer.parseInt(string.trim());
                } else if (string2.equals("second")) {
                    string = node.getFirstChild().getNodeValue();
                    this.sec_ = n3 = Integer.parseInt(string.trim());
                }
            }
            ++n2;
        }
    }

    private void loadXmlPolicy(String string) {
        int n = 0;
        int n2 = this.comboValue_.length;
        n = 0;
        while (n < n2) {
            if (this.comboValue_[n].equals(string)) break;
            ++n;
        }
        if (n == this.comboValue_.length) {
            n = 0;
        }
        this.comboPolicy_ = n;
    }

    private void loadXmlBudgetDeadline(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                double d;
                String string;
                String string2 = node.getNodeName();
                if (string2.equals("type")) {
                    string = node.getFirstChild().getNodeValue().trim();
                    this.curRadioFactor_ = string.equals("factor");
                } else if (string2.equals("budget")) {
                    string = node.getFirstChild().getNodeValue();
                    this.bNum_ = d = Double.parseDouble(string.trim());
                } else if (string2.equals("deadline")) {
                    string = node.getFirstChild().getNodeValue();
                    this.dNum_ = d = Double.parseDouble(string.trim());
                }
            }
            ++n2;
        }
    }

    private void loadXmlGridlet(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                String string = node.getNodeName();
                this.loadXmlGridletProperty(node.getChildNodes(), string);
            }
            ++n2;
        }
    }

    private void loadXmlGridletProperty(NodeList nodeList, String string) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                String string2;
                String string3 = node.getNodeName();
                if (string3.equals("size")) {
                    string2 = node.getFirstChild().getNodeValue();
                    int n3 = Integer.parseInt(string2.trim());
                    if (string.equals("gridlet")) {
                        this.gridSize_ = n3;
                    } else if (string.equals("length")) {
                        this.lengthSize_ = n3;
                    } else if (string.equals("file")) {
                        this.fileSize_ = n3;
                    } else if (string.equals("output")) {
                        this.outputSize_ = n3;
                    }
                } else if (string3.equals("minDeviation")) {
                    string2 = node.getFirstChild().getNodeValue();
                    double d = Double.parseDouble(string2.trim());
                    if (string.equals("gridlet")) {
                        this.gridMin_ = d * 100.0;
                    } else if (string.equals("length")) {
                        this.lengthMin_ = d * 100.0;
                    } else if (string.equals("file")) {
                        this.fileMin_ = d * 100.0;
                    } else if (string.equals("output")) {
                        this.outputMin_ = d * 100.0;
                    }
                } else if (string3.equals("maxDeviation")) {
                    string2 = node.getFirstChild().getNodeValue();
                    double d = Double.parseDouble(string2.trim());
                    if (string.equals("gridlet")) {
                        this.gridMax_ = d * 100.0;
                    } else if (string.equals("length")) {
                        this.lengthMax_ = d * 100.0;
                    } else if (string.equals("file")) {
                        this.fileMax_ = d * 100.0;
                    } else if (string.equals("output")) {
                        this.outputMax_ = d * 100.0;
                    }
                }
            }
            ++n2;
        }
    }
}

