/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.util.Observable;
import java.util.Random;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import visualmodeler.UserProperty;

public class UserModel
extends Observable {
    private Vector user_ = new Vector();
    private int userCounter_ = 1;
    private boolean hasChanged_ = false;

    public Vector getAllUserName() {
        Vector<String> vector = new Vector<String>();
        int n = this.user_.size();
        int n2 = 0;
        while (n2 < n) {
            String string = ((UserProperty)this.user_.elementAt(n2)).getUserName();
            vector.add(string);
            ++n2;
        }
        return vector;
    }

    public int getUserCounter() {
        return this.userCounter_;
    }

    public int getTotalUser() {
        return this.user_.size();
    }

    public void createUser(int n, boolean bl) {
        if (n == 0) {
            return;
        }
        String string = null;
        Random random = new Random();
        int n2 = 0;
        while (n2 < n) {
            string = "User " + this.userCounter_;
            UserProperty userProperty = new UserProperty(this.userCounter_, string, bl, random);
            this.user_.add(userProperty);
            ++this.userCounter_;
            ++n2;
        }
        this.hasChanged_ = true;
        this.setChanged();
        this.notifyObservers();
    }

    public void removeAllUser() {
        if (this.user_.size() == 0) {
            return;
        }
        this.hasChanged_ = true;
        this.user_.removeAllElements();
        this.setChanged();
        this.notifyObservers();
    }

    public void removeUser(int n) {
        try {
            this.user_.removeElementAt(n);
            if (this.user_.size() == 0) {
                this.userCounter_ = 1;
            }
        }
        catch (Exception exception) {
            System.out.println("Error - the grid user is not found.");
        }
        this.hasChanged_ = true;
        this.setChanged();
        this.notifyObservers();
    }

    public void showProperty(int n) {
        UserProperty userProperty = (UserProperty)this.user_.elementAt(n);
        String string = userProperty.getUserName();
        userProperty.showDialog();
        if (!userProperty.getUserName().equals(string)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void showProperty(String string) {
        UserProperty userProperty = (UserProperty)this.user_.elementAt(0);
        int n = this.user_.size();
        int n2 = 0;
        while (n2 < n) {
            userProperty = (UserProperty)this.user_.elementAt(n2);
            if (userProperty.getUserName().equals(string)) break;
            ++n2;
        }
        String string2 = userProperty.getUserName();
        userProperty.showDialog();
        if (!userProperty.getUserName().equals(string2)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String generateCode(String string) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("\n\n");
        stringBuffer.append(string);
        stringBuffer.append("// The starting point of creating Grid user entities\n");
        stringBuffer.append(string);
        stringBuffer.append("GridletList glList;      // A list of Gridlets or jobs\n");
        stringBuffer.append(string);
        stringBuffer.append("Experiment expt;\n");
        stringBuffer.append(string);
        stringBuffer.append("UserEntity userEntity;\n");
        stringBuffer.append(string);
        stringBuffer.append("int count = 0;\n");
        int n = this.user_.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((UserProperty)this.user_.elementAt(n2)).generateCode(string));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String saveFile(String string) {
        this.hasChanged_ = false;
        String string2 = string + "    ";
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("\n\n");
        stringBuffer.append(string);
        stringBuffer.append("<gridUser>\n");
        int n = this.user_.size();
        stringBuffer.append(string2);
        stringBuffer.append("<totalUser> ");
        stringBuffer.append(n);
        stringBuffer.append(" </totalUser>");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((UserProperty)this.user_.elementAt(n2)).saveFile(string2));
            ++n2;
        }
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("</gridUser>\n");
        return stringBuffer.toString();
    }

    public boolean hasChanged() {
        return this.hasChanged_;
    }

    public void newValue() {
        this.removeAllUser();
        this.hasChanged_ = false;
        this.userCounter_ = 1;
    }

    public void loadXml(NodeList nodeList) throws Exception {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                this.loadXmlUser(node, n);
            }
            ++n2;
        }
        ++this.userCounter_;
        this.setChanged();
        this.notifyObservers();
    }

    private void loadXmlUser(Node node, int n) throws Exception {
        try {
            String string = node.getNodeName();
            if (string.equals("totalUser")) {
                String string2 = node.getFirstChild().getNodeValue();
                int n2 = Integer.parseInt(string2.trim());
                int n3 = n / 2 - 1;
                if (n2 < 1 || n3 != n2) {
                    throw new NumberFormatException("<totalUser> error");
                }
            } else if (string.equals("user")) {
                this.loadXmlUserProperty(node.getChildNodes());
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Exception = " + numberFormatException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("Exception = " + exception.getMessage());
        }
    }

    private void loadXmlUserProperty(NodeList nodeList) throws Exception {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string.equals("id")) {
                int n2;
                String string2 = node.getFirstChild().getNodeValue();
                this.userCounter_ = n2 = Integer.parseInt(string2.trim());
                UserProperty userProperty = new UserProperty(n2, null, false, null);
                userProperty.loadXml(nodeList);
                this.user_.add(userProperty);
                break;
            }
            ++n;
        }
    }
}

