/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import visualmodeler.ResourceMachine;

public class ResourceProperty
extends JDialog
implements ActionListener,
ChangeListener,
WindowListener,
ListSelectionListener {
    private JSlider peakSlider_;
    private JSlider offSlider_;
    private JSlider holidaySlider_;
    private int peakLoad_;
    private int offLoad_;
    private int holidayLoad_;
    private double baudRate_;
    private int id_;
    private String name_;
    private JLabel peakLabel_;
    private JLabel offLabel_;
    private JLabel holidayLabel_;
    private JTextField resText_;
    private JTextField baudText_;
    private JButton ok_;
    private JButton cancel_;
    private boolean guiHasCreated_;
    private int comboPolicy_;
    private final String[] comboValue_ = new String[]{"Time-shared", "Space-shared"};
    private String arch_;
    private String os_;
    private double timeZone_;
    private double price_;
    private Vector machine_;
    private Vector machineName_;
    private JComboBox combo_;
    private JPanel charPanel_;
    private JTextField archText_;
    private JTextField osText_;
    private JTextField timeZoneText_;
    private JTextField priceText_;
    private JList machineList_;
    private JPanel machinePanel_;

    public ResourceProperty(int n, String string, boolean bl, Random random) {
        super.setModal(true);
        super.setSize(500, 500);
        super.setLocation(150, 100);
        super.setTitle("Resource Property");
        this.addWindowListener(this);
        this.machine_ = new Vector();
        this.machineName_ = new Vector();
        this.machinePanel_ = new JPanel();
        if (bl) {
            this.randomValue(random);
        } else {
            this.defaultValue();
        }
        this.id_ = n;
        this.name_ = string;
        this.guiHasCreated_ = false;
        this.archText_ = null;
        this.baudText_ = null;
        this.cancel_ = null;
        this.charPanel_ = null;
        this.combo_ = null;
        this.holidayLabel_ = null;
        this.holidaySlider_ = null;
        this.machineList_ = null;
        this.offLabel_ = null;
        this.offSlider_ = null;
        this.ok_ = null;
        this.osText_ = null;
        this.peakLabel_ = null;
        this.peakSlider_ = null;
        this.priceText_ = null;
        this.resText_ = null;
        this.timeZoneText_ = null;
    }

    public String getResourceName() {
        return this.name_;
    }

    public int getId() {
        return this.id_;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("ok")) {
            if (!this.saveValue()) {
                return;
            }
        } else {
            this.resetValue();
        }
        this.removeListeners();
        this.dispose();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        double d = (double)n / 10.0;
        if (jSlider == this.peakSlider_) {
            this.peakLabel_.setText("Peak Load:   " + d);
        } else if (jSlider == this.offSlider_) {
            this.offLabel_.setText("Off-peak Load:   " + d);
        } else {
            this.holidayLabel_.setText("Holiday Load:   " + d);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.machineList_.getSelectedIndex();
        ((ResourceMachine)this.machine_.elementAt(n)).showDialog(this.machinePanel_);
    }

    public void showDialog() {
        if (!this.guiHasCreated_) {
            this.guiHasCreated_ = true;
            this.initComponents();
        }
        this.ok_.addActionListener(this);
        this.cancel_.addActionListener(this);
        this.machineList_.addListSelectionListener(this);
        this.peakSlider_.addChangeListener(this);
        this.offSlider_.addChangeListener(this);
        this.holidaySlider_.addChangeListener(this);
        this.show();
    }

    public String generateCode(String string) {
        String string2 = "\"" + this.arch_ + "\"";
        String string3 = "\"" + this.os_ + "\"";
        String string4 = "\"" + this.name_ + "\"";
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("///////// Create ");
        stringBuffer.append(this.name_);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("mList = new MachineList();\t// A list of Machines\n");
        int n = this.machine_.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((ResourceMachine)this.machine_.elementAt(n2)).generateCode(string));
            ++n2;
        }
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("// Creates a new ResourceCharacteristics entity\n");
        stringBuffer.append(string);
        stringBuffer.append("resConfig = new ResourceCharacteristics(");
        stringBuffer.append(string2);
        stringBuffer.append(", ");
        stringBuffer.append(string3);
        stringBuffer.append(",\n");
        stringBuffer.append(string);
        stringBuffer.append("    mList, ");
        stringBuffer.append(this.comboPolicy_);
        stringBuffer.append(", ");
        stringBuffer.append(this.timeZone_);
        stringBuffer.append(", ");
        stringBuffer.append(this.price_);
        stringBuffer.append(");\n\n");
        stringBuffer.append(string);
        stringBuffer.append("// Creates a new GridResource entity\n");
        stringBuffer.append(string);
        stringBuffer.append("gridRes = new GridResource(");
        stringBuffer.append(string4);
        stringBuffer.append(", ");
        stringBuffer.append(this.baudRate_);
        stringBuffer.append(", seed*(" + this.id_ + "+1)+1,\n");
        stringBuffer.append(string);
        stringBuffer.append("    resConfig, ");
        stringBuffer.append(this.peakLoad_);
        stringBuffer.append(", ");
        stringBuffer.append(this.offLoad_);
        stringBuffer.append(", ");
        stringBuffer.append(this.holidayLoad_);
        stringBuffer.append(", Weekends, Holidays);\n");
        return stringBuffer.toString();
    }

    public String saveFile(String string) {
        String string2 = string + "    ";
        String string3 = string2 + "    ";
        String string4 = string3 + "    ";
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("\n\n");
        stringBuffer.append(string);
        stringBuffer.append("<resource>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<id> ");
        stringBuffer.append(this.id_);
        stringBuffer.append(" </id>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<name> ");
        stringBuffer.append(this.name_);
        stringBuffer.append(" </name>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<baudRate> ");
        stringBuffer.append(this.baudRate_);
        stringBuffer.append(" </baudRate>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<peakLoad> ");
        stringBuffer.append((double)this.peakLoad_ / 10.0);
        stringBuffer.append(" </peakLoad>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<offPeakLoad> ");
        stringBuffer.append((double)this.offLoad_ / 10.0);
        stringBuffer.append(" </offPeakLoad>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<holidayLoad> ");
        stringBuffer.append((double)this.holidayLoad_ / 10.0);
        stringBuffer.append(" </holidayLoad>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<resourceCharacteristics>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<architecture> ");
        stringBuffer.append(this.arch_);
        stringBuffer.append(" </architecture>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<operatingSystem> ");
        stringBuffer.append(this.os_);
        stringBuffer.append(" </operatingSystem>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<timeZone> ");
        stringBuffer.append(this.timeZone_);
        stringBuffer.append(" </timeZone>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<gridDollarPerApplication> ");
        stringBuffer.append(this.price_);
        stringBuffer.append(" </gridDollarPerApplication>\n");
        stringBuffer.append(string3);
        stringBuffer.append("<allocationPolicy> ");
        stringBuffer.append(this.comboValue_[this.comboPolicy_]);
        stringBuffer.append(" </allocationPolicy>\n\n");
        stringBuffer.append(string3);
        stringBuffer.append("<machineList>\n");
        int n = this.machine_.size();
        stringBuffer.append(string4);
        stringBuffer.append("<totalMachine> ");
        stringBuffer.append(n);
        stringBuffer.append(" </totalMachine>\n");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((ResourceMachine)this.machine_.elementAt(n2)).saveFile(string4));
            ++n2;
        }
        stringBuffer.append("\n");
        stringBuffer.append(string3);
        stringBuffer.append("</machineList>\n");
        stringBuffer.append(string2);
        stringBuffer.append("</resourceCharacteristics>\n");
        stringBuffer.append(string);
        stringBuffer.append("</resource>\n");
        return stringBuffer.toString();
    }

    public void loadXml(NodeList nodeList) throws Exception {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                String string;
                String string2 = node.getNodeName();
                if (string2.equals("id")) {
                    int n3;
                    string = node.getFirstChild().getNodeValue();
                    this.id_ = n3 = Integer.parseInt(string.trim());
                } else if (string2.equals("name")) {
                    string = node.getFirstChild().getNodeValue();
                    this.name_ = string.trim();
                } else if (string2.equals("baudRate")) {
                    double d;
                    string = node.getFirstChild().getNodeValue();
                    this.baudRate_ = d = Double.parseDouble(string.trim());
                } else if (string2.equals("peakLoad")) {
                    string = node.getFirstChild().getNodeValue();
                    double d = Double.parseDouble(string.trim());
                    this.peakLoad_ = (int)(d * 10.0);
                } else if (string2.equals("offPeakLoad")) {
                    string = node.getFirstChild().getNodeValue();
                    double d = Double.parseDouble(string.trim());
                    this.offLoad_ = (int)(d * 10.0);
                } else if (string2.equals("holidayLoad")) {
                    string = node.getFirstChild().getNodeValue();
                    double d = Double.parseDouble(string.trim());
                    this.holidayLoad_ = (int)(d * 10.0);
                } else if (string2.equals("resourceCharacteristics")) {
                    this.loadXmlResourceCharacteristics(node.getChildNodes());
                }
            }
            ++n2;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.resetValue();
        this.removeListeners();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void defaultValue() {
        this.peakLoad_ = 0;
        this.offLoad_ = 0;
        this.holidayLoad_ = 0;
        this.baudRate_ = 100.0;
        this.price_ = 100.0;
        this.timeZone_ = 0.0;
        this.comboPolicy_ = 0;
        this.arch_ = "Intel";
        this.os_ = "Red Hat Linux";
        this.machine_.add(new ResourceMachine(0, false, null));
        this.machineName_.add("Machine 0");
        this.machine_.add(new ResourceMachine(1, false, null));
        this.machineName_.add("Machine 1");
    }

    private void randomValue(Random random) {
        int n = 11;
        this.baudRate_ = random.nextInt(1001);
        this.peakLoad_ = random.nextInt(n);
        this.offLoad_ = random.nextInt(n);
        this.holidayLoad_ = random.nextInt(n);
        this.comboPolicy_ = random.nextInt(2);
        this.timeZone_ = random.nextInt(n);
        this.price_ = random.nextDouble() * 100.0;
        int n2 = 0;
        int n3 = 4;
        String[][] stringArrayArray = new String[][]{{"Compaq AlphaServer", "OSF1"}, {"Sun Ultra", "Solaris"}, {"Intel Pentium", "Linux"}, {"SGI Origin", "Irix"}};
        n2 = random.nextInt(n3);
        this.arch_ = stringArrayArray[n2][0];
        this.os_ = stringArrayArray[n2][1];
        n2 = random.nextInt(n);
        if (n2 < 1) {
            n2 = random.nextInt(n);
        }
        int n4 = 0;
        while (n4 < n2) {
            this.machine_.add(new ResourceMachine(n4, true, random));
            this.machineName_.add("Machine " + n4);
            ++n4;
        }
    }

    private void initComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        Font font = new Font(null, 0, 14);
        int n = 0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n++;
        JLabel jLabel = new JLabel("Resource Name:");
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.resText_ = new JTextField(this.name_, 20);
        jPanel.add((Component)this.resText_, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n++;
        jLabel = new JLabel("Baud Rate:");
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.baudText_ = new JTextField("" + this.baudRate_, 5);
        jPanel.add((Component)this.baudText_, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        double d = (double)this.peakLoad_ / 10.0;
        this.peakLabel_ = new JLabel("Peak Load:   " + d);
        this.peakLabel_.setFont(font);
        jPanel.add((Component)this.peakLabel_, gridBagConstraints);
        this.peakSlider_ = new JSlider(0, 10, this.peakLoad_);
        this.createSlider(jPanel, gridBagConstraints, this.peakSlider_);
        gridBagConstraints.gridy = n++;
        d = (double)this.offLoad_ / 10.0;
        this.offLabel_ = new JLabel("Off-peak Load:   " + d);
        this.offLabel_.setFont(font);
        jPanel.add((Component)this.offLabel_, gridBagConstraints);
        this.offSlider_ = new JSlider(0, 10, this.offLoad_);
        this.createSlider(jPanel, gridBagConstraints, this.offSlider_);
        gridBagConstraints.gridy = n++;
        d = (double)this.holidayLoad_ / 10.0;
        this.holidayLabel_ = new JLabel("Holiday Load:   " + d);
        this.holidayLabel_.setFont(font);
        jPanel.add((Component)this.holidayLabel_, gridBagConstraints);
        this.holidaySlider_ = new JSlider(0, 10, this.holidayLoad_);
        this.createSlider(jPanel, gridBagConstraints, this.holidaySlider_);
        this.charPanel_ = new JPanel(gridBagLayout);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(25, 0, 10, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.charPanel_, gridBagConstraints);
        this.initCharacteristic();
        n += 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.ok_ = new JButton("OK");
        jPanel.add((Component)this.ok_, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.cancel_ = new JButton("Cancel");
        jPanel.add((Component)this.cancel_, gridBagConstraints);
        int n2 = 20;
        int n3 = 30;
        JScrollPane jScrollPane = new JScrollPane(jPanel, n2, n3);
        this.getContentPane().add(jScrollPane);
    }

    private void initCharacteristic() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 5, 5, 15);
        Font font = new Font(null, 0, 12);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Characteristic");
        titledBorder.setTitleFont(font.deriveFont(1, 18.0f));
        this.charPanel_.setBorder(titledBorder);
        int n = 0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n++;
        JLabel jLabel = new JLabel("Architecture:");
        jLabel.setFont(font);
        this.charPanel_.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.archText_ = new JTextField(this.arch_, 20);
        this.charPanel_.add((Component)this.archText_, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n++;
        jLabel = new JLabel("Operating System:");
        jLabel.setFont(font);
        this.charPanel_.add((Component)jLabel, gridBagConstraints);
        this.osText_ = new JTextField(this.os_, 20);
        this.charPanel_.add((Component)this.osText_, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n++;
        jLabel = new JLabel("Time Zone (GMT) :");
        jLabel.setFont(font);
        this.charPanel_.add((Component)jLabel, gridBagConstraints);
        this.timeZoneText_ = new JTextField("" + this.timeZone_, 5);
        this.charPanel_.add((Component)this.timeZoneText_, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n++;
        jLabel = new JLabel("Grid $ / application operation:  ");
        jLabel.setFont(font);
        this.charPanel_.add((Component)jLabel, gridBagConstraints);
        this.priceText_ = new JTextField("" + this.price_, 5);
        this.charPanel_.add((Component)this.priceText_, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        jLabel = new JLabel("Allocation policy:");
        jLabel.setFont(font);
        this.charPanel_.add((Component)jLabel, gridBagConstraints);
        this.combo_ = new JComboBox<String>(this.comboValue_);
        this.combo_.setSelectedIndex(this.comboPolicy_);
        gridBagConstraints.gridwidth = 0;
        this.charPanel_.add((Component)this.combo_, gridBagConstraints);
        jLabel = new JLabel("List of Machines");
        jLabel.setFont(font.deriveFont(1, 16.0f));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = -1;
        this.charPanel_.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        this.machineList_ = new JList(this.machineName_);
        this.machineList_.setSelectionMode(0);
        this.machineList_.setSelectedIndex(0);
        int n2 = 20;
        int n3 = 30;
        JScrollPane jScrollPane = new JScrollPane(this.machineList_, n2, n3);
        ((ResourceMachine)this.machine_.elementAt(0)).showDialog(this.machinePanel_);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.machinePanel_);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(150);
        gridBagConstraints.gridy = n++;
        this.charPanel_.add((Component)jSplitPane, gridBagConstraints);
    }

    private void createSlider(JPanel jPanel, GridBagConstraints gridBagConstraints, JSlider jSlider) {
        jSlider.setMajorTickSpacing(1);
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        float f = 0.0f;
        int n = 0;
        while (n < 7) {
            hashtable.put(new Integer(n), new JLabel("" + f));
            f = (float)((double)f + 0.1);
            ++n;
        }
        hashtable.put(new Integer(7), new JLabel("0.7"));
        hashtable.put(new Integer(8), new JLabel("0.8"));
        hashtable.put(new Integer(9), new JLabel("0.9"));
        hashtable.put(new Integer(10), new JLabel("1.0"));
        jSlider.setLabelTable(hashtable);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)jSlider, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
    }

    private void removeListeners() {
        this.machineList_.removeListSelectionListener(this);
        this.ok_.removeActionListener(this);
        this.cancel_.removeActionListener(this);
        this.peakSlider_.removeChangeListener(this);
        this.offSlider_.removeChangeListener(this);
        this.holidaySlider_.removeChangeListener(this);
    }

    private boolean saveValue() {
        this.name_ = this.resText_.getText();
        this.peakLoad_ = this.peakSlider_.getValue();
        this.offLoad_ = this.offSlider_.getValue();
        this.holidayLoad_ = this.holidaySlider_.getValue();
        this.comboPolicy_ = this.combo_.getSelectedIndex();
        String string = "";
        try {
            string = "baud rate";
            this.baudRate_ = this.checkValue(this.baudRate_, this.baudText_, false);
            string = "time zone";
            this.timeZone_ = this.checkValue(this.timeZone_, this.timeZoneText_, true);
            string = "cost per sec";
            this.price_ = this.checkValue(this.price_, this.priceText_, false);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid value for " + string + ".", string + " value error", 0);
            return false;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), string + " value error", 0);
            return false;
        }
        int n = this.machine_.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResourceMachine)this.machine_.elementAt(n2)).saveValue();
            ++n2;
        }
        return true;
    }

    private double checkValue(double d, JTextField jTextField, boolean bl) throws Exception {
        d = new Double(jTextField.getText());
        if (d < 0.0 && !bl) {
            throw new Exception("Invalid for having negative value.");
        }
        if (bl && (d > 13.0 || d < -12.0)) {
            throw new Exception("Invalid value for GMT Time Zone.\nThe valid limits are GMT + 13:00 and GMT - 12:00");
        }
        return d;
    }

    private void resetValue() {
        double d = (double)this.peakLoad_ / 10.0;
        this.peakLabel_.setText("Peak Load:   " + d);
        this.peakSlider_.setValue(this.peakLoad_);
        d = (double)this.offLoad_ / 10.0;
        this.offLabel_.setText("Off-peak Load:   " + d);
        this.offSlider_.setValue(this.offLoad_);
        d = (double)this.holidayLoad_ / 10.0;
        this.holidayLabel_.setText("Holiday Load:   " + d);
        this.holidaySlider_.setValue(this.holidayLoad_);
        this.resText_.setText(this.name_);
        this.baudText_.setText("" + this.baudRate_);
        this.archText_.setText(this.arch_);
        this.osText_.setText(this.os_);
        this.timeZoneText_.setText("" + this.timeZone_);
        this.priceText_.setText("" + this.price_);
        this.combo_.setSelectedIndex(this.comboPolicy_);
        int n = this.machine_.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResourceMachine)this.machine_.elementAt(n2)).resetValue();
            ++n2;
        }
    }

    private void loadXmlResourceCharacteristics(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                double d;
                String string;
                String string2 = node.getNodeName();
                if (string2.equals("architecture")) {
                    string = node.getFirstChild().getNodeValue();
                    this.arch_ = string.trim();
                } else if (string2.equals("operatingSystem")) {
                    string = node.getFirstChild().getNodeValue();
                    this.os_ = string.trim();
                } else if (string2.equals("timeZone")) {
                    string = node.getFirstChild().getNodeValue();
                    this.timeZone_ = d = Double.parseDouble(string.trim());
                } else if (string2.equals("gridDollarPerApplication")) {
                    string = node.getFirstChild().getNodeValue();
                    this.price_ = d = Double.parseDouble(string.trim());
                } else if (string2.equals("allocationPolicy")) {
                    string = node.getFirstChild().getNodeValue();
                    this.loadXmlPolicy(string.trim());
                } else if (string2.equals("machineList")) {
                    this.machine_.clear();
                    this.machineName_.clear();
                    this.loadXmlMachine(node.getChildNodes());
                }
            }
            ++n2;
        }
    }

    private void loadXmlPolicy(String string) {
        int n = 0;
        int n2 = this.comboValue_.length;
        n = 0;
        while (n < n2) {
            if (this.comboValue_[n].equals(string)) break;
            ++n;
        }
        if (n == n2) {
            n = 0;
        }
        this.comboPolicy_ = n;
    }

    private void loadXmlMachine(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                this.loadXmlResourceMachine(node, n);
            }
            ++n2;
        }
    }

    private void loadXmlResourceMachine(Node node, int n) {
        try {
            String string = node.getNodeName();
            if (string.equals("totalMachine")) {
                String string2 = node.getFirstChild().getNodeValue();
                int n2 = Integer.parseInt(string2.trim());
                int n3 = n / 2 - 1;
                if (n2 < 1 || n3 != n2) {
                    throw new NumberFormatException("<totalMachine> error");
                }
            } else if (string.equals("machine")) {
                this.loadXmlResourceMachineProperty(node.getChildNodes());
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException.getMessage());
            numberFormatException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("obj = " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void loadXmlResourceMachineProperty(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string.equals("id")) {
                String string2 = node.getFirstChild().getNodeValue();
                int n3 = Integer.parseInt(string2.trim());
                ResourceMachine resourceMachine = new ResourceMachine(n3, false, null);
                resourceMachine.loadXml(nodeList);
                this.machine_.add(resourceMachine);
                this.machineName_.add("Machine " + n3);
                break;
            }
            ++n2;
        }
    }
}

