/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.util.Observable;
import java.util.Random;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import visualmodeler.ResourceProperty;

public class ResourceModel
extends Observable {
    private Vector res_ = new Vector();
    private int resCounter_ = 1;
    private final int SIZE = 1000;
    private boolean hasChanged_ = false;

    public Vector getAllResourceName() {
        Vector<String> vector = new Vector<String>();
        int n = this.res_.size();
        int n2 = 0;
        while (n2 < n) {
            String string = ((ResourceProperty)this.res_.elementAt(n2)).getResourceName();
            vector.add(string);
            ++n2;
        }
        return vector;
    }

    public int getResourceCounter() {
        return this.resCounter_;
    }

    public int getTotalResource() {
        return this.res_.size();
    }

    public void createResource(int n, boolean bl) {
        if (n == 0) {
            return;
        }
        String string = null;
        Random random = new Random();
        int n2 = 0;
        while (n2 < n) {
            string = "Resource " + this.resCounter_;
            ResourceProperty resourceProperty = new ResourceProperty(this.resCounter_, string, bl, random);
            this.res_.add(resourceProperty);
            ++this.resCounter_;
            ++n2;
        }
        this.hasChanged_ = true;
        this.setChanged();
        this.notifyObservers();
    }

    public void removeAllResource() {
        if (this.res_.size() == 0) {
            return;
        }
        this.hasChanged_ = true;
        this.res_.removeAllElements();
        this.setChanged();
        this.notifyObservers();
    }

    public void removeResource(int n) {
        try {
            this.res_.removeElementAt(n);
            if (this.res_.size() == 0) {
                this.resCounter_ = 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.hasChanged_ = true;
        this.setChanged();
        this.notifyObservers();
    }

    public void showProperty(int n) {
        if (this.res_.size() == 0) {
            return;
        }
        ResourceProperty resourceProperty = (ResourceProperty)this.res_.elementAt(n);
        String string = resourceProperty.getResourceName();
        resourceProperty.showDialog();
        if (!resourceProperty.getResourceName().equals(string)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void showProperty(String string) {
        if (this.res_.size() == 0) {
            return;
        }
        ResourceProperty resourceProperty = (ResourceProperty)this.res_.elementAt(0);
        int n = 0;
        while (n < this.res_.size()) {
            resourceProperty = (ResourceProperty)this.res_.elementAt(n);
            if (resourceProperty.getResourceName().equals(string)) break;
            ++n;
        }
        String string2 = resourceProperty.getResourceName();
        resourceProperty.showDialog();
        if (!resourceProperty.getResourceName().equals(string2)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String generateCode(String string) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("// The starting point of creating Grid Resource entities");
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("LinkedList Weekends = new LinkedList();\n");
        stringBuffer.append(string);
        stringBuffer.append("Weekends.add(new Integer(Calendar.SATURDAY));\n");
        stringBuffer.append(string);
        stringBuffer.append("Weekends.add(new Integer(Calendar.SUNDAY));\n");
        stringBuffer.append(string);
        stringBuffer.append("LinkedList Holidays = new LinkedList();\n\n");
        stringBuffer.append(string);
        stringBuffer.append("PEList peList;");
        stringBuffer.append(string);
        stringBuffer.append("// A list of PEs (Processing Elements)\n");
        stringBuffer.append(string);
        stringBuffer.append("MachineList mList;        // A list of Machine entities\n");
        stringBuffer.append(string);
        stringBuffer.append("ResourceCharacteristics resConfig;\n");
        stringBuffer.append(string);
        stringBuffer.append("GridResource gridRes;     // A GridResource entity\n\n");
        Vector vector = this.getAllResourceName();
        stringBuffer.append(string);
        stringBuffer.append("String[] resourceNameList = { ");
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 4 == 0) {
                stringBuffer.append("\n    ");
                stringBuffer.append(string);
            }
            stringBuffer.append("\"");
            stringBuffer.append(vector.get(n2));
            stringBuffer.append("\",  ");
            ++n2;
        }
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("};\n");
        n = this.res_.size();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(((ResourceProperty)this.res_.elementAt(n3)).generateCode(string));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String saveFile(String string) {
        this.hasChanged_ = false;
        String string2 = string + "    ";
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("\n\n");
        stringBuffer.append(string);
        stringBuffer.append("<gridResource>\n");
        int n = this.res_.size();
        stringBuffer.append(string2);
        stringBuffer.append("<totalResource> ");
        stringBuffer.append(n);
        stringBuffer.append(" </totalResource>");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((ResourceProperty)this.res_.elementAt(n2)).saveFile(string2));
            ++n2;
        }
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("</gridResource>\n");
        return stringBuffer.toString();
    }

    public boolean hasChanged() {
        return this.hasChanged_;
    }

    public void newValue() {
        this.removeAllResource();
        this.hasChanged_ = false;
        this.resCounter_ = 1;
    }

    public void loadXml(NodeList nodeList) throws Exception {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                this.loadXmlResource(node, n);
            }
            ++n2;
        }
        ++this.resCounter_;
        this.setChanged();
        this.notifyObservers();
    }

    private void loadXmlResource(Node node, int n) throws Exception {
        try {
            String string = node.getNodeName();
            if (string.equals("totalResource")) {
                String string2 = node.getFirstChild().getNodeValue();
                int n2 = Integer.parseInt(string2.trim());
                int n3 = n / 2 - 1;
                if (n2 < 1 || n3 != n2) {
                    throw new NumberFormatException("<totalResource> error");
                }
            } else if (string.equals("resource")) {
                this.loadXmlResourceProperty(node.getChildNodes());
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException.getMessage());
            numberFormatException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("obj = " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void loadXmlResourceProperty(NodeList nodeList) throws Exception {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string.equals("id")) {
                int n2;
                String string2 = node.getFirstChild().getNodeValue();
                this.resCounter_ = n2 = Integer.parseInt(string2.trim());
                ResourceProperty resourceProperty = new ResourceProperty(n2, null, false, null);
                resourceProperty.loadXml(nodeList);
                this.res_.add(resourceProperty);
                break;
            }
            ++n;
        }
    }
}

