/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Random;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import visualmodeler.WholeNumberField;

public class ResourceMachine {
    private int id_;
    private Hashtable pe_;
    private JPanel panel_;
    private boolean guiCreated_;
    private PETable peTable_;
    static /* synthetic */ Class class$java$lang$Integer;

    public ResourceMachine(int n, boolean bl, Random random) {
        this.id_ = n;
        this.pe_ = new Hashtable();
        this.panel_ = new JPanel();
        this.guiCreated_ = false;
        this.peTable_ = null;
        if (bl) {
            this.randomValue(random);
        } else {
            this.pe_.put(new Integer(0), new Integer(51));
        }
    }

    public int getMachineId() {
        return this.id_;
    }

    public int getNumPE() {
        return this.pe_.size();
    }

    public String generateCode(String string) {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("peList = new PEList();      // A list of PEs\n");
        Integer n = null;
        int n2 = this.pe_.size();
        int n3 = 0;
        while (n3 < n2) {
            n = (Integer)this.pe_.get(new Integer(n3));
            stringBuffer.append(string);
            stringBuffer.append("peList.add( new PE(");
            stringBuffer.append(n3);
            stringBuffer.append(", ");
            stringBuffer.append(n);
            stringBuffer.append(") );\n");
            ++n3;
        }
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("// Adding a new Machine into the list\n");
        stringBuffer.append(string);
        stringBuffer.append("mList.add( new Machine(");
        stringBuffer.append(this.id_);
        stringBuffer.append(", peList) );\n\n");
        return stringBuffer.toString();
    }

    public String saveFile(String string) {
        String string2 = string + "    ";
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("<machine>\n");
        stringBuffer.append(string2);
        stringBuffer.append("<id> ");
        stringBuffer.append(this.id_);
        stringBuffer.append(" </id>\n");
        int n = this.pe_.size();
        stringBuffer.append(string2);
        stringBuffer.append("<totalPE> ");
        stringBuffer.append(n);
        stringBuffer.append(" </totalPE>\n");
        Integer n2 = null;
        int n3 = 0;
        while (n3 < n) {
            n2 = (Integer)this.pe_.get(new Integer(n3));
            stringBuffer.append(string2);
            stringBuffer.append("<peId> ");
            stringBuffer.append(n3);
            stringBuffer.append(" </peId>\n");
            stringBuffer.append(string2);
            stringBuffer.append("<MIPSRating> ");
            stringBuffer.append(n2);
            stringBuffer.append(" </MIPSRating>\n");
            ++n3;
        }
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("</machine>\n");
        return stringBuffer.toString();
    }

    public void showDialog(JPanel jPanel) {
        jPanel.removeAll();
        if (!this.guiCreated_) {
            this.guiCreated_ = true;
            this.initComponents();
        }
        jPanel.add(this.panel_);
        jPanel.revalidate();
        jPanel.repaint();
    }

    public void saveValue() {
        if (!this.guiCreated_) {
            return;
        }
        this.peTable_.saveValue();
    }

    public void resetValue() {
        if (!this.guiCreated_) {
            return;
        }
        this.peTable_.resetValue();
    }

    public void loadXml(NodeList nodeList) {
        Integer n = null;
        Integer n2 = null;
        this.pe_.clear();
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1) {
                String string;
                String string2 = node.getNodeName();
                if (string2.equals("peId")) {
                    string = node.getFirstChild().getNodeValue();
                    n = new Integer(string.trim());
                } else if (string2.equals("MIPSRating")) {
                    string = node.getFirstChild().getNodeValue();
                    n2 = new Integer(string.trim());
                }
                if (n != null && n2 != null) {
                    this.pe_.put(n, n2);
                    n = null;
                    n2 = null;
                }
            }
            ++n3;
        }
    }

    private void randomValue(Random random) {
        int n = random.nextInt(21);
        while ((n = random.nextInt(21)) <= 2) {
        }
        Integer n2 = new Integer(random.nextInt(500));
        int n3 = 0;
        while (n3 < n) {
            this.pe_.put(new Integer(n3), n2);
            ++n3;
        }
    }

    private void initComponents() {
        this.peTable_ = new PETable();
        JTable jTable = new JTable(this.peTable_);
        jTable.setPreferredScrollableViewportSize(new Dimension(180, 250));
        TableColumn tableColumn = null;
        tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(20);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(50);
        int n = 22;
        int n2 = 31;
        JScrollPane jScrollPane = new JScrollPane(jTable, n, n2);
        this.setUpIntegerEditor(jTable);
        this.panel_.add(jScrollPane);
    }

    private void setUpIntegerEditor(JTable jTable) {
        final WholeNumberField wholeNumberField = new WholeNumberField(0, 10);
        wholeNumberField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(wholeNumberField){

            public Object getCellEditorValue() {
                return new Integer(wholeNumberField.getValue());
            }
        };
        jTable.setDefaultEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = ResourceMachine.class$("java.lang.Integer")) : class$java$lang$Integer, defaultCellEditor);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PETable
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"PE Id", "MIPS Rating"};
        private Hashtable previousValue_ = new Hashtable();

        private PETable() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return ResourceMachine.this.pe_.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new Integer(n);
            }
            return ResourceMachine.this.pe_.get(new Integer(n));
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            Integer n3 = new Integer(n);
            Integer n4 = ResourceMachine.this.pe_.put(n3, (Integer)object);
            this.previousValue_.put(n3, n4);
            this.fireTableCellUpdated(n, n2);
        }

        protected void saveValue() {
            this.previousValue_.clear();
        }

        protected void resetValue() {
            int n = 0;
            while (n < ResourceMachine.this.pe_.size()) {
                Integer n2 = new Integer(n);
                if (this.previousValue_.containsKey(n2)) {
                    Integer n3 = (Integer)this.previousValue_.get(n2);
                    ResourceMachine.this.pe_.put(n2, n3);
                }
                ++n;
            }
            this.previousValue_.clear();
        }
    }
}

