/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import visualmodeler.FileModel;
import visualmodeler.MenuAbout;

public class MenuView
implements ActionListener,
Observer {
    private JFrame frame_;
    private FileModel fileModel_;
    private JMenuItem saveItem_;

    public MenuView(JFrame jFrame, FileModel fileModel) {
        this.frame_ = jFrame;
        this.fileModel_ = fileModel;
        this.initComponents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("new")) {
            this.fileModel_.newFile();
        } else if (string.equals("open")) {
            this.fileModel_.openFile();
        } else if (string.equals("close")) {
            this.fileModel_.closeFile();
        } else if (string.equals("save")) {
            this.fileModel_.saveFile();
        } else if (string.equals("save_as")) {
            this.fileModel_.saveAsFile();
        } else if (string.equals("exit")) {
            if (this.fileModel_.quitProgram()) {
                this.frame_.dispose();
                System.exit(0);
            }
        } else if (string.equals("code")) {
            this.fileModel_.generateCode();
        } else if (string.equals("about")) {
            new MenuAbout(this.frame_).show();
        }
    }

    public void update(Observable observable, Object object) {
        if (object == null) {
            this.saveItem_.setEnabled(true);
        } else {
            this.saveItem_.setEnabled(false);
        }
    }

    private void initComponents() {
        JMenuBar jMenuBar = new JMenuBar();
        this.frame_.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.addMenu(jMenu, "New", "new", 78);
        this.addMenu(jMenu, "Open...", "open", 79);
        this.addMenu(jMenu, "Close", "close", 67);
        this.saveItem_ = new JMenuItem("Save");
        this.addMenu(jMenu, this.saveItem_, "save", 83);
        this.addMenu(jMenu, "Save As..", "save_as", 123);
        jMenu.addSeparator();
        this.addMenu(jMenu, "Exit", "exit", 81);
        JMenu jMenu2 = new JMenu("Project");
        jMenu2.setMnemonic(80);
        this.addMenu(jMenu2, "Generate GridSim code", "code", 71);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic(72);
        this.addMenu(jMenu3, "About", "about", 65);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
    }

    private void addMenu(JMenu jMenu, String string, String string2, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setMnemonic(n);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 2));
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
    }

    private void addMenu(JMenu jMenu, JMenuItem jMenuItem, String string, int n) {
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(string);
        jMenuItem.setMnemonic(n);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
    }
}

