/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import visualmodeler.ResourceModel;
import visualmodeler.UserModel;

public class IconWizard
extends JDialog
implements ActionListener {
    private final int USER = 0;
    private final int RESOURCE = 1;
    private UserModel userModel_;
    private ResourceModel resModel_;
    private JCheckBox check_;
    private JTextField userText_;
    private JTextField resText_;
    private JButton ok_;
    private JButton cancel_;
    private int numUser_;
    private int numRes_;

    public IconWizard(JFrame jFrame, UserModel userModel, ResourceModel resourceModel) {
        super((Frame)jFrame, true);
        this.setSize(400, 250);
        this.setLocation(150, 150);
        this.setTitle("Wizard Dialog");
        this.userModel_ = userModel;
        this.resModel_ = resourceModel;
        this.numUser_ = 0;
        this.numRes_ = 0;
        this.initComponent();
    }

    public void showDialog() {
        this.userText_.addActionListener(this);
        this.resText_.addActionListener(this);
        this.ok_.addActionListener(this);
        this.cancel_.addActionListener(this);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("user")) {
            this.collectInputValue(0, this.userText_.getText());
        } else if (string.equals("resource")) {
            this.collectInputValue(1, this.resText_.getText());
        } else if (string.equals("ok")) {
            boolean bl = true;
            boolean bl2 = true;
            bl = this.collectInputValue(0, this.userText_.getText());
            bl2 = this.collectInputValue(1, this.resText_.getText());
            if (bl && bl2) {
                if (this.numUser_ > 0) {
                    this.userModel_.createUser(this.numUser_, this.check_.isSelected());
                }
                if (this.numRes_ > 0) {
                    this.resModel_.createResource(this.numRes_, this.check_.isSelected());
                }
                this.resetValue();
                this.dispose();
            }
        } else {
            this.resetValue();
            this.dispose();
        }
    }

    private void initComponent() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        gridBagConstraints.fill = 2;
        Font font = new Font(null, 0, 14);
        JLabel jLabel = new JLabel("Number of users:   ");
        jLabel.setFont(font);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this.userText_ = new JTextField("" + this.numUser_, 5);
        this.userText_.setActionCommand("user");
        this.getContentPane().add((Component)this.userText_, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        JLabel jLabel2 = new JLabel("Number of resources:   ");
        jLabel2.setFont(font);
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        this.resText_ = new JTextField("" + this.numRes_, 5);
        this.resText_.setActionCommand("resource");
        this.getContentPane().add((Component)this.resText_, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        this.check_ = new JCheckBox("Auto-generate random user and resource properties", true);
        this.getContentPane().add((Component)this.check_, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 0;
        this.ok_ = new JButton("OK");
        this.ok_.setActionCommand("ok");
        this.getContentPane().add((Component)this.ok_, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.cancel_ = new JButton("Cancel");
        this.cancel_.setActionCommand("cancel");
        this.getContentPane().add((Component)this.cancel_, gridBagConstraints);
    }

    private void resetValue() {
        this.check_.setSelected(true);
        this.numUser_ = 0;
        this.numRes_ = 0;
        this.userText_.setText("" + this.numUser_);
        this.resText_.setText("" + this.numRes_);
        this.userText_.removeActionListener(this);
        this.resText_.removeActionListener(this);
        this.ok_.removeActionListener(this);
        this.cancel_.removeActionListener(this);
    }

    private boolean collectInputValue(int n, String string) {
        try {
            int n2 = new Integer(string);
            if (n2 < 0) {
                throw new Exception();
            }
            if (n == 0) {
                this.numUser_ = n2;
            } else {
                this.numRes_ = n2;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Invalid number. It should be a positive integer.", "Set " + n + " number error", 0);
            return false;
        }
        return true;
    }
}

