/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import visualmodeler.FileModel;
import visualmodeler.IconWizard;
import visualmodeler.ResourceModel;
import visualmodeler.UserModel;

public class IconView
extends JPanel
implements ActionListener,
Observer {
    private JButton saveButton_;
    private IconWizard iconWiz_;
    private FileModel fileModel_;
    private JFrame frame_;

    public IconView(JFrame jFrame, String string, FileModel fileModel, UserModel userModel, ResourceModel resourceModel) {
        this.frame_ = jFrame;
        this.fileModel_ = fileModel;
        this.iconWiz_ = new IconWizard(jFrame, userModel, resourceModel);
        this.createIconBar(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("new_file")) {
            this.fileModel_.newFile();
        } else if (string.equals("open_file")) {
            this.fileModel_.openFile();
        } else if (string.equals("close_file")) {
            this.fileModel_.closeFile();
        } else if (string.equals("save_file")) {
            this.fileModel_.saveFile();
        } else if (string.equals("wizard")) {
            this.iconWiz_.showDialog();
        } else if (string.equals("code")) {
            this.fileModel_.generateCode();
        } else if (string.equals("quit") && this.fileModel_.quitProgram()) {
            this.frame_.dispose();
            System.exit(0);
        }
    }

    public void update(Observable observable, Object object) {
        if (object == null) {
            this.saveButton_.setEnabled(true);
        } else {
            this.saveButton_.setEnabled(false);
        }
    }

    private void createIconBar(String string) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(true);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(true);
        jToolBar.setBorder(BorderFactory.createEtchedBorder());
        jToolBar.setMargin(new Insets(0, 15, 0, 15));
        String string2 = "";
        try {
            string2 = System.getProperty("user.dir") + "/image/";
        }
        catch (Exception exception) {
            System.out.println("VisualModeler : Error - Can't find image files.");
        }
        this.makeToolBarButton(jToolBar, string2, "file_new.gif", "New File", "new_file");
        this.makeToolBarButton(jToolBar, string2, "file_open.gif", "Open File", "open_file");
        this.makeToolBarButton(jToolBar, string2, "file_close.gif", "Close File", "close_file");
        this.saveButton_ = new JButton();
        this.makeToolBarButton(jToolBar, this.saveButton_, string2, "file_save.gif", "Save File", "save_file");
        jToolBar.addSeparator();
        this.makeToolBarButton(jToolBar, string2, "wizard.gif", "Auto wizard", "wizard");
        this.makeToolBarButton(jToolBar, string2, "code.gif", "Generate GridSim code", "code");
        jToolBar.addSeparator();
        this.makeToolBarButton(jToolBar, string2, "exit.gif", "Quit Program", "quit");
        this.frame_.getContentPane().add((Component)jToolBar, string);
    }

    private void makeToolBarButton(JToolBar jToolBar, String string, String string2, String string3, String string4) {
        Serializable serializable;
        ImageIcon imageIcon = new ImageIcon(string + string2);
        if (imageIcon.getIconWidth() == -1) {
            try {
                serializable = super.getClass().getResource("image/" + string2);
                Image image = Toolkit.getDefaultToolkit().getImage((URL)serializable);
                imageIcon.setImage(image);
            }
            catch (Exception exception) {
                System.out.println("Visual Modeler : Error - Can't find image files from visualmodeler.jar");
            }
        }
        serializable = new JButton(imageIcon);
        ((JComponent)serializable).setToolTipText(string3);
        ((AbstractButton)serializable).setBorderPainted(true);
        ((AbstractButton)serializable).setActionCommand(string4);
        ((AbstractButton)serializable).addActionListener(this);
        jToolBar.add((Component)serializable);
    }

    private void makeToolBarButton(JToolBar jToolBar, JButton jButton, String string, String string2, String string3, String string4) {
        ImageIcon imageIcon = new ImageIcon(string + string2);
        if (imageIcon.getIconWidth() == -1) {
            try {
                URL uRL = super.getClass().getResource("image/" + string2);
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                imageIcon.setImage(image);
            }
            catch (Exception exception) {
                System.out.println("Visual Modeler : Error - Can't find image files from visualmodeler.jar");
            }
        }
        jButton.setIcon(imageIcon);
        jButton.setEnabled(false);
        jButton.setToolTipText(string3);
        jButton.setBorderPainted(true);
        jButton.setActionCommand(string4);
        jButton.addActionListener(this);
        jToolBar.add(jButton);
    }
}

