/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import visualmodeler.DefaultFileFilter;
import visualmodeler.ResourceModel;
import visualmodeler.UserModel;

public class FileModel
extends Observable {
    private DefaultFileFilter fileFilter_;
    private JFrame frame_;
    private UserModel user_;
    private ResourceModel res_;
    private final JFileChooser fc_;
    private boolean hasSaved_;
    private JOptionPane optionPane_;
    private String fileName_;
    private Toolkit toolkit_;

    public FileModel(JFrame jFrame, UserModel userModel, ResourceModel resourceModel) {
        this.frame_ = jFrame;
        this.user_ = userModel;
        this.res_ = resourceModel;
        this.fileName_ = null;
        this.hasSaved_ = false;
        this.toolkit_ = Toolkit.getDefaultToolkit();
        this.fc_ = new JFileChooser();
        this.fileFilter_ = new DefaultFileFilter("xml", "XML Files");
        this.optionPane_ = new JOptionPane("Empty message", 3, 0);
    }

    public void saveFile() {
        if (!this.user_.hasChanged() && !this.res_.hasChanged()) {
            return;
        }
        if (this.fileName_ != null) {
            this.save();
            return;
        }
        this.fc_.setDialogTitle("Save");
        this.fc_.setFileFilter(this.fileFilter_);
        int n = this.fc_.showSaveDialog(this.frame_);
        if (n == 0) {
            this.displaySaveDialog();
        }
    }

    public void newFile() {
        if (this.hasSaved_) {
            this.hasSaved_ = false;
            this.user_.newValue();
            this.res_.newValue();
            this.fileName_ = null;
            return;
        }
        if (!this.user_.hasChanged() && !this.res_.hasChanged()) {
            return;
        }
        String string = "This file has not been saved yet.\nOpen a new file anyway?";
        if (this.confirmAction(string, "New File")) {
            this.user_.newValue();
            this.res_.newValue();
            this.hasSaved_ = false;
            this.fileName_ = null;
        }
    }

    public void openFile() {
        if (!this.user_.hasChanged() && !this.res_.hasChanged()) {
            this.displayOpenDialog();
            return;
        }
        String string = "This file has not been saved yet.\nOpen a new file anyway?";
        if (this.confirmAction(string, "Open File")) {
            this.displayOpenDialog();
        }
    }

    public void closeFile() {
        if (!this.user_.hasChanged() && !this.res_.hasChanged()) {
            return;
        }
        String string = "The file has not been saved yet.\nClose anyway?";
        if (this.confirmAction(string, "Close File")) {
            this.user_.newValue();
            this.res_.newValue();
            this.fileName_ = null;
        }
    }

    public void saveAsFile() {
        this.fc_.setDialogTitle("Save As");
        this.fc_.setFileFilter(this.fileFilter_);
        int n = this.fc_.showSaveDialog(this.frame_);
        if (n == 0) {
            this.displaySaveDialog();
        }
    }

    public boolean quitProgram() {
        if (!this.user_.hasChanged() && !this.res_.hasChanged()) {
            return true;
        }
        String string = "The file has not been saved yet.\nQuit anyway?";
        if (this.confirmAction(string, "Exit Program")) {
            this.user_.newValue();
            this.res_.newValue();
            return true;
        }
        return false;
    }

    public void generateCode() {
        String string;
        File file;
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter("java", "Java Files");
        this.fc_.setDialogTitle("Generate GridSim code");
        this.fc_.setFileFilter(defaultFileFilter);
        int n = this.fc_.showSaveDialog(this.frame_);
        if (n != 0) {
            return;
        }
        File file2 = this.fc_.getSelectedFile();
        String string2 = file2.getName();
        string2 = this.fileFilter_.getFileNameOnly(string2);
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(file2.getAbsolutePath());
        if (this.fileFilter_.getExtension(file2) == null) {
            stringBuffer.append(".java");
        }
        if ((file = new File(string = stringBuffer.toString())).exists()) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string);
            stringBuffer.append(" already exists.\nDo you want to replace it?");
            if (!this.confirmAction(stringBuffer.toString(), "Generate GridSim code")) {
                return;
            }
        }
        String string3 = "    ";
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append("// This file is auto-generated by VisualModeler.\n");
        stringBuffer.append("// Created on ");
        Date date = Calendar.getInstance().getTime();
        stringBuffer.append(date.toString());
        stringBuffer.append("\n\n");
        stringBuffer.append("import java.util.*;\n");
        stringBuffer.append("import gridsim.*;\n");
        stringBuffer.append("import gridbroker.*;\n");
        stringBuffer.append("\npublic class ");
        stringBuffer.append(string2);
        stringBuffer.append(" \n{\n\n");
        stringBuffer.append(string3);
        stringBuffer.append("public static void main(String[] args)\n");
        stringBuffer.append(string3);
        stringBuffer.append("{\n\n");
        String string4 = "        ";
        stringBuffer.append(string4);
        stringBuffer.append("try\n");
        stringBuffer.append(string4);
        stringBuffer.append("{\n");
        String string5 = "            ";
        stringBuffer.append(string5);
        stringBuffer.append("Calendar calendar = Calendar.getInstance();\n");
        stringBuffer.append(string5);
        stringBuffer.append("Random random;\n");
        stringBuffer.append(string5);
        stringBuffer.append("long seed = 11L*13*17*19*23+1;\n");
        stringBuffer.append(string5);
        stringBuffer.append("seed = seed * 97 + 1;\n\n");
        stringBuffer.append(string5);
        stringBuffer.append("String[] eff = {\"\"};\n");
        stringBuffer.append(string5);
        stringBuffer.append("String[] efp = {\"\"};\n");
        stringBuffer.append(string5);
        stringBuffer.append("String[] category = { \"*.USER.GridletCompletion\",\n");
        stringBuffer.append(string3);
        stringBuffer.append(string5);
        stringBuffer.append("\"*.USER.TimeUtilization\", ");
        stringBuffer.append("\"*.USER.BudgetUtilization\" };\n\n");
        stringBuffer.append(string5);
        stringBuffer.append("String ReportWriterName = \"ReportWriter");
        stringBuffer.append(string2);
        stringBuffer.append("\";\n\n");
        int n2 = this.user_.getTotalUser();
        int n3 = this.res_.getTotalResource();
        stringBuffer.append(string5);
        stringBuffer.append("// Initializing GridSim for ");
        stringBuffer.append(n2);
        stringBuffer.append(" grid users and ");
        stringBuffer.append(n3);
        stringBuffer.append(" grid resources\n");
        stringBuffer.append(string5);
        stringBuffer.append("GridSim.init(");
        stringBuffer.append(n2);
        stringBuffer.append(", calendar, true, eff, efp, ReportWriterName);\n\n");
        stringBuffer.append(string5);
        stringBuffer.append("// Creates Report Writer entity\n");
        stringBuffer.append(string5);
        stringBuffer.append("new ReportWriter(ReportWriterName, ");
        stringBuffer.append(n2);
        stringBuffer.append(", ");
        stringBuffer.append(n3);
        stringBuffer.append(", \"reportFile");
        stringBuffer.append(string2);
        stringBuffer.append("\",\n");
        stringBuffer.append(string3);
        stringBuffer.append(string5);
        stringBuffer.append("category, false, null, true, 10000);\n\n");
        stringBuffer.append(this.res_.generateCode(string5));
        stringBuffer.append(this.user_.generateCode(string5));
        stringBuffer.append("\n");
        stringBuffer.append(string5);
        stringBuffer.append("// Starts grid simulation\n");
        stringBuffer.append(string5);
        stringBuffer.append("GridSim.startGridSimulation();\n");
        stringBuffer.append(string4);
        stringBuffer.append("}\n");
        stringBuffer.append(string4);
        stringBuffer.append("catch (Exception e) {\n");
        stringBuffer.append(string5);
        stringBuffer.append("e.printStackTrace();\n");
        stringBuffer.append(string4);
        stringBuffer.append("}\n    } \n} \n\n");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(stringBuffer.toString().getBytes());
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            this.toolkit_.beep();
            JOptionPane.showMessageDialog(this.frame_, "Sorry, cannot generate Java file.", "Generate GridSim code", 0);
        }
        this.toolkit_.beep();
        JOptionPane.showMessageDialog(this.frame_, "Finish generating Java code.", "Generate GridSim code", 1);
    }

    private boolean confirmAction(String string, String string2) {
        this.optionPane_.setMessage(string);
        JDialog jDialog = this.optionPane_.createDialog(this.frame_, string2);
        this.toolkit_.beep();
        jDialog.show();
        try {
            int n = (Integer)this.optionPane_.getValue();
            if (n == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("FileModel.confirmAction() : " + exception.getMessage());
        }
        return false;
    }

    private void displayOpenDialog() {
        this.fc_.setDialogTitle("Open");
        this.fc_.setFileFilter(this.fileFilter_);
        int n = this.fc_.showOpenDialog(this.frame_);
        if (n == 0) {
            File file = this.fc_.getSelectedFile();
            this.user_.newValue();
            this.res_.newValue();
            this.fileName_ = file.getAbsolutePath();
            String string = this.fileFilter_.getExtension(file);
            if (string == null) {
                this.fileName_ = this.fileName_ + ".xml";
            }
            this.loadXmlFile(this.fileName_);
        }
    }

    private void loadXmlFile(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    String string2 = node.getNodeName();
                    NodeList nodeList2 = node.getChildNodes();
                    if (string2.equals("gridUser")) {
                        this.user_.loadXml(nodeList2);
                    } else if (string2.equals("gridResource")) {
                        this.res_.loadXml(nodeList2);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("FileModel.loadXMLFile() : Error - unable to open and/or read \"" + string + "\"");
        }
    }

    private void displaySaveDialog() {
        File file;
        File file2 = this.fc_.getSelectedFile();
        this.fileName_ = file2.getAbsolutePath();
        String string = this.fileFilter_.getExtension(file2);
        if (string == null) {
            this.fileName_ = this.fileName_ + ".xml";
        }
        if ((file = new File(this.fileName_)).exists()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.fileName_);
            stringBuffer.append(" already exists.\n");
            stringBuffer.append("Do you want to replace it?");
            if (!this.confirmAction(stringBuffer.toString(), "Save File")) {
                this.fileName_ = null;
                return;
            }
        }
        this.save();
    }

    private void save() {
        String string = "    ";
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n\n");
        stringBuffer.append("<!-- This file is auto-generated by VisualModeler.\n");
        stringBuffer.append("     Created on ");
        Date date = Calendar.getInstance().getTime();
        stringBuffer.append(date.toString());
        stringBuffer.append("\n-->\n\n");
        stringBuffer.append("\n<gridsimProject>");
        stringBuffer.append(this.user_.saveFile(string));
        stringBuffer.append(this.res_.saveFile(string));
        stringBuffer.append("\n</gridsimProject>\n");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName_);
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.close();
            this.hasSaved_ = true;
            this.setChanged();
            this.notifyObservers("save");
        }
        catch (Exception exception) {
            this.toolkit_.beep();
            JOptionPane.showMessageDialog(this.frame_, "Sorry, cannot save this file.", "Saving error", 0);
        }
        this.toolkit_.beep();
        JOptionPane.showMessageDialog(this.frame_, "Finish saving file.", "Saving file success", 1);
    }
}

