/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import visualmodeler.ResourceModel;
import visualmodeler.UserModel;

public class DisplayView
extends JPanel
implements ActionListener,
Observer {
    private final int USER = 0;
    private final int RESOURCE = 1;
    private JFrame frame_;
    private UserModel user_;
    private ResourceModel res_;
    private JList userList_;
    private JList resList_;
    private JLabel userLabel_;
    private JLabel resLabel_;

    public DisplayView(JFrame jFrame, String string, UserModel userModel, ResourceModel resourceModel) {
        this.frame_ = jFrame;
        this.user_ = userModel;
        this.res_ = resourceModel;
        this.createDisplayPanel(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = 0;
        if (string.equals("add_user")) {
            this.user_.createUser(1, true);
        } else if (string.equals("add_res")) {
            this.res_.createResource(1, true);
        } else if (string.equals("del_user")) {
            n = this.userList_.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.user_.removeUser(n);
        } else if (string.equals("del_res")) {
            n = this.resList_.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.res_.removeResource(n);
        } else if (string.equals("view_user")) {
            n = this.userList_.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.user_.showProperty(n);
        } else if (string.equals("view_res")) {
            n = this.resList_.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.res_.showProperty(n);
        }
    }

    public void update(Observable observable, Object object) {
        int n = 0;
        if (observable == this.user_) {
            n = this.user_.getTotalUser();
            this.userLabel_.setText("          Total Users:  " + n);
            this.userList_.clearSelection();
            this.userList_.setListData(this.user_.getAllUserName());
            this.userList_.setSelectedIndex(n - 1);
        } else if (observable == this.res_) {
            n = this.res_.getTotalResource();
            this.resLabel_.setText("          Total Resources:  " + n);
            this.resList_.clearSelection();
            this.resList_.setListData(this.res_.getAllResourceName());
            this.resList_.setSelectedIndex(n - 1);
        }
        this.revalidate();
        this.repaint();
    }

    private void createDisplayPanel(String string) {
        int n = 30;
        int n2 = 20;
        JPanel jPanel = new JPanel(new GridLayout(0, 1, n, n));
        JPanel jPanel2 = new JPanel(new BorderLayout(n, n2));
        JPanel jPanel3 = new JPanel(new BorderLayout(n, n2));
        Font font = new Font(null, 1, 16);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("User");
        titledBorder.setTitleFont(font);
        jPanel2.setBorder(titledBorder);
        jPanel2.setSize(50, 100);
        this.userList_ = new JList();
        this.userLabel_ = new JLabel("          Total Users:  0");
        this.createList(jPanel2, this.userList_, this.userLabel_, 0);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Resource");
        titledBorder2.setTitleFont(font);
        jPanel3.setBorder(titledBorder2);
        this.resList_ = new JList();
        this.resLabel_ = new JLabel("          Total Resources:  0");
        this.createList(jPanel3, this.resList_, this.resLabel_, 1);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        int n3 = 20;
        int n4 = 30;
        JScrollPane jScrollPane = new JScrollPane(jPanel, n3, n4);
        this.frame_.getContentPane().add((Component)jScrollPane, string);
    }

    private void createList(JPanel jPanel, JList jList, JLabel jLabel, final int n) {
        Font font = new Font(null, 0, 14);
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, "North");
        JLabel jLabel2 = new JLabel("   ");
        jPanel.add((Component)jLabel2, "West");
        jList.setSize(20, 20);
        jList.setSelectionMode(0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n2 = mouseEvent.getClickCount();
                Point point = mouseEvent.getPoint();
                if (n == 0) {
                    DisplayView.this.userMouseClicked(n2, point);
                } else {
                    DisplayView.this.resourceMouseClicked(n2, point);
                }
            }
        };
        jList.addMouseListener(mouseAdapter);
        int n2 = 20;
        int n3 = 30;
        JScrollPane jScrollPane = new JScrollPane(jList, n2, n3);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("View Property");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 80, 10));
        JButton jButton2 = new JButton("Add");
        jButton2.addActionListener(this);
        jPanel3.add(jButton2);
        JButton jButton3 = new JButton("Delete");
        jButton3.addActionListener(this);
        jPanel3.add(jButton3);
        jPanel.add((Component)jPanel3, "South");
        String string = "";
        try {
            string = System.getProperty("user.dir") + "/image/";
        }
        catch (Exception exception) {
            System.out.println("VisualModeler : Error - Can't find image files.");
        }
        if (n == 0) {
            this.setButtonDisplay(jButton, "  View User", "view_user", string, "view_user.gif");
            this.setButtonDisplay(jButton2, "  Add User", "add_user", string, "add_user.gif");
            this.setButtonDisplay(jButton3, "  Delete User", "del_user", string, "del_user.gif");
        } else {
            this.setButtonDisplay(jButton, "  View Resource", "view_res", string, "view_res.gif");
            this.setButtonDisplay(jButton2, "  Add Resource", "add_res", string, "add_res.gif");
            this.setButtonDisplay(jButton3, "  Delete Resource", "del_res", string, "del_res.gif");
        }
    }

    private void setButtonDisplay(JButton jButton, String string, String string2, String string3, String string4) {
        ImageIcon imageIcon = new ImageIcon(string3 + string4);
        if (imageIcon.getIconWidth() == -1) {
            try {
                URL uRL = super.getClass().getResource("image/" + string4);
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                imageIcon.setImage(image);
            }
            catch (Exception exception) {
                System.out.println("Visual Modeler : Error - Can't find image files from visualmodeler.jar");
            }
        }
        jButton.setActionCommand(string2);
        jButton.setText(string);
        jButton.setIcon(imageIcon);
    }

    private void userMouseClicked(int n, Point point) {
        if (n == 2) {
            int n2 = this.userList_.locationToIndex(point);
            this.user_.showProperty(n2);
        }
    }

    private void resourceMouseClicked(int n, Point point) {
        if (n == 2) {
            int n2 = this.resList_.locationToIndex(point);
            this.res_.showProperty(n2);
        }
    }

    private void userPropertyActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = new Integer(string);
        this.user_.showProperty(n - 1);
    }

    private void resourcePropertyActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = new Integer(string);
        this.res_.showProperty(n - 1);
    }
}

