/*
 * Decompiled with CFR 0.152.
 */
package visualmodeler;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class DefaultFileFilter
extends FileFilter {
    private Hashtable filters_ = new Hashtable();
    private String desc_ = null;
    private String fullDesc_ = null;

    public DefaultFileFilter(String string, String string2) {
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public DefaultFileFilter(String[] stringArray, String string) {
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.addExtension(stringArray[n2]);
                ++n2;
            }
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters_.get(string) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        if (file != null) {
            String string = file.getName();
            if (string == null) {
                return null;
            }
            int n = string.lastIndexOf(46);
            if (n > 0 && n < string.length() - 1) {
                return string.substring(n + 1).toLowerCase();
            }
        }
        return null;
    }

    public String getFileNameOnly(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            return string.substring(0, n);
        }
        return string;
    }

    public String getDescription() {
        if (this.fullDesc_ == null) {
            if (this.desc_ == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.desc_ == null ? "(" : this.desc_ + " (");
                Enumeration enumeration = this.filters_.keys();
                if (enumeration != null) {
                    stringBuffer.append("." + (String)enumeration.nextElement());
                    while (enumeration.hasMoreElements()) {
                        stringBuffer.append(", .");
                        stringBuffer.append((String)enumeration.nextElement());
                    }
                }
                stringBuffer.append(")");
                this.fullDesc_ = stringBuffer.toString();
            } else {
                this.fullDesc_ = this.desc_;
            }
        }
        return this.fullDesc_;
    }

    private void setDescription(String string) {
        this.desc_ = string;
        this.fullDesc_ = null;
    }

    private void addExtension(String string) {
        if (string == null) {
            return;
        }
        if (this.filters_ == null) {
            this.filters_ = new Hashtable(5);
        }
        this.filters_.put(string.toLowerCase(), this);
        this.fullDesc_ = null;
    }
}

