/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import gridsim.GridSim;
import gridsim.Machine;
import gridsim.MachineList;

public class ResourceCharacteristics {
    private int id_ = -1;
    private String architecture_;
    private String OS_;
    private MachineList machineList_;
    private double timeZone_;
    private double costPerSec_;
    private int allocationPolicy_;
    public static final int TIME_SHARED = 0;
    public static final int SPACE_SHARED = 1;
    public static final int OTHER_POLICY_SAME_RATING = 2;
    public static final int OTHER_POLICY_DIFFERENT_RATING = 3;
    public static final int ADVANCE_RESERVATION = 4;

    public ResourceCharacteristics(String string, String string2, MachineList machineList, int n, double d, double d2) {
        this.architecture_ = string;
        this.OS_ = string2;
        this.machineList_ = machineList;
        this.allocationPolicy_ = n;
        this.timeZone_ = d;
        this.costPerSec_ = d2;
    }

    public void SetID(int n) {
        this.setResourceID(n);
    }

    public void setResourceID(int n) {
        this.id_ = n;
    }

    public int GetID() {
        return this.getResourceID();
    }

    public int getResourceID() {
        return this.id_;
    }

    public String GetName() {
        return this.getResourceName();
    }

    public String getResourceName() {
        return GridSim.getEntityName(this.id_);
    }

    public String GetArch() {
        return this.getResourceArch();
    }

    public String getResourceArch() {
        return this.architecture_;
    }

    public String GetOS() {
        return this.getResourceOS();
    }

    public String getResourceOS() {
        return this.OS_;
    }

    public MachineList GetMachines() {
        return this.getMachineList();
    }

    public MachineList getMachineList() {
        return this.machineList_;
    }

    public Machine getMachineWithFreePE() {
        return this.machineList_.getMachineWithFreePE();
    }

    public int GetAllocationPolicy() {
        return this.getResourceAllocationPolicy();
    }

    public int getResourceAllocationPolicy() {
        return this.allocationPolicy_;
    }

    public double GetTimeZone() {
        return this.getResourceTimeZone();
    }

    public double getResourceTimeZone() {
        return this.timeZone_;
    }

    public int GetMIPSRatingOfOnePE() {
        return this.getMIPSRatingOfOnePE();
    }

    public int getMIPSRatingOfOnePE() {
        if (this.machineList_.size() == 0) {
            return -1;
        }
        return this.machineList_.getMachine(0).getPEList().getMIPSRating(0);
    }

    public int GetMIPSRatingOfOnePE(int n, int n2) {
        return this.getMIPSRatingOfOnePE(n, n2);
    }

    public int getMIPSRatingOfOnePE(int n, int n2) {
        if (this.machineList_.size() == 0) {
            return -1;
        }
        return this.machineList_.getMachine(n).getPEList().getMIPSRating(n2);
    }

    public int GetMIPSRating() {
        return this.getMIPSRating();
    }

    public int getMIPSRating() {
        int n = 0;
        switch (this.allocationPolicy_) {
            case 0: 
            case 2: {
                n = this.getMIPSRatingOfOnePE() * this.machineList_.getNumPE();
                break;
            }
            case 1: 
            case 3: {
                for (int i = 0; i < this.machineList_.size(); ++i) {
                    n += ((Machine)this.machineList_.get(i)).getMIPSRating();
                }
                break;
            }
        }
        return n;
    }

    public double CPU_time(double d, double d2) {
        return this.getCPUTime(d, d2);
    }

    public double getCPUTime(double d, double d2) {
        double d3 = 0.0;
        switch (this.allocationPolicy_) {
            case 0: {
                d3 = d / ((double)this.getMIPSRatingOfOnePE() * (1.0 - d2));
                break;
            }
        }
        return d3;
    }

    public int GetNoOfPEs() {
        return this.getNumPE();
    }

    public int getNumPE() {
        return this.machineList_.getNumPE();
    }

    public int getNumFreePE() {
        return this.machineList_.getNumFreePE();
    }

    public int getNumBusyPE() {
        return this.machineList_.getNumBusyPE();
    }

    public boolean setStatusPE(boolean bl, int n, int n2) {
        return this.machineList_.setStatusPE(bl, n, n2);
    }

    public void SetCostPerSec(double d) {
        this.setCostPerSec(d);
    }

    public void setCostPerSec(double d) {
        this.costPerSec_ = d;
    }

    public double GetCostPerSec() {
        return this.getCostPerSec();
    }

    public double getCostPerSec() {
        return this.costPerSec_;
    }

    public double GetCostPerMI() {
        return this.getCostPerMI();
    }

    public double getCostPerMI() {
        return this.costPerSec_ / (double)this.getMIPSRatingOfOnePE();
    }

    public int ByteSize() {
        return this.getByteSize();
    }

    public int getByteSize() {
        int n = 8;
        int n2 = 16;
        int n3 = this.architecture_.length() + this.OS_.length() + this.machineList_.getByteSize() + n + n2;
        return n3;
    }
}

