/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.ResourceCalendar;

public class ResGridlet {
    private Gridlet gridlet_;
    private double arrivalTime_;
    private double finishedTime_;
    private double gridletFinishedSoFar_;
    private double startExecTime_;
    private double totalCompletionTime_;
    private int gridletID_;
    private int userID_;
    private int machineID_;
    private int peID_;

    public ResGridlet(Gridlet gridlet) {
        this.gridlet_ = gridlet;
        this.arrivalTime_ = GridSim.clock();
        this.gridlet_.setSubmissionTime(this.arrivalTime_);
        this.finishedTime_ = -1.0;
        this.machineID_ = -1;
        this.peID_ = -1;
        this.startExecTime_ = 0.0;
        this.totalCompletionTime_ = 0.0;
        this.gridletID_ = this.gridlet_.getGridletID();
        this.userID_ = this.gridlet_.getUserID();
        this.gridletFinishedSoFar_ = this.gridlet_.getGridletFinishedSoFar();
    }

    public int getGridletID() {
        return this.gridletID_;
    }

    public int getUserID() {
        return this.userID_;
    }

    public double getGridletLength() {
        return this.gridlet_.getGridletLength();
    }

    public boolean setGridletStatus(int n) {
        int n2 = this.gridlet_.getGridletStatus();
        if (n2 == n) {
            return false;
        }
        boolean bl = true;
        try {
            double d = GridSim.clock();
            this.gridlet_.setGridletStatus(n);
            if (n2 == 3 && (n == 6 || n == 7 || n == 4)) {
                this.totalCompletionTime_ += d - this.startExecTime_;
                return true;
            }
            if (n2 == 8 && n == 4) {
                this.totalCompletionTime_ += d - this.startExecTime_;
                return true;
            }
            if (n == 3 || n2 == 7 && n == 8) {
                this.startExecTime_ = d;
                this.gridlet_.setExecStartTime(this.startExecTime_);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public double getExecStartTime() {
        return this.gridlet_.getExecStartTime();
    }

    public void setExecParam(double d, double d2) {
        this.gridlet_.setExecParam(d, d2);
    }

    public void SetIDs(int n, int n2) {
        this.setMachineAndPEID(n, n2);
    }

    public void setMachineAndPEID(int n, int n2) {
        this.machineID_ = n;
        this.peID_ = n2;
    }

    public int GetMachineID() {
        return this.getMachineID();
    }

    public int getMachineID() {
        return this.machineID_;
    }

    public int GetPEID() {
        return this.getPEID();
    }

    public int getPEID() {
        return this.peID_;
    }

    public double GetRemainingLength() {
        return this.getRemainingGridletLength();
    }

    public double getRemainingGridletLength() {
        double d = this.gridlet_.getGridletLength() - this.gridletFinishedSoFar_;
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public void finalizeGridlet() {
        double d = GridSim.clock() - this.arrivalTime_;
        this.gridlet_.setExecParam(d, this.totalCompletionTime_);
        double d2 = 0.0;
        d2 = this.gridlet_.getGridletLength() < this.gridletFinishedSoFar_ ? this.gridlet_.getGridletLength() : this.gridletFinishedSoFar_;
        this.gridlet_.setGridletFinishedSoFar(d2);
    }

    public void UpdateGridletFinishedSoFar(double d) {
        this.updateGridletFinishedSoFar(d);
    }

    public void updateGridletFinishedSoFar(double d) {
        this.gridletFinishedSoFar_ += d;
    }

    public double GetArrivalTime() {
        return this.getGridletArrivalTime();
    }

    public double getGridletArrivalTime() {
        return this.arrivalTime_;
    }

    public void SetFinishTimeForTimeSharedResource(double d, ResourceCalendar resourceCalendar) throws NullPointerException {
        this.setFinishTimeForTimeSharedResource(d, resourceCalendar);
    }

    public void setFinishTimeForTimeSharedResource(double d, ResourceCalendar resourceCalendar) throws NullPointerException {
    }

    public void SetFinishTimeForSpaceSharedResource(double d) {
        this.setFinishTimeForSpaceSharedResource(d);
    }

    public void setFinishTimeForSpaceSharedResource(double d) {
    }

    public void setFinishTime(double d) {
        if (d < 0.0) {
            return;
        }
        this.finishedTime_ = d;
    }

    public double GetFinishTime() {
        return this.getGridletFinishTime();
    }

    public double getGridletFinishTime() {
        return this.finishedTime_;
    }

    public Gridlet GetGridlet() {
        return this.getGridlet();
    }

    public Gridlet getGridlet() {
        return this.gridlet_;
    }

    public int getGridletStatus() {
        return this.gridlet_.getGridletStatus();
    }
}

