/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import gridsim.GridSim;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Gridlet {
    private int userID_ = -1;
    private double gridletLength_;
    private long gridletFileSize_;
    private long gridletOutputSize_;
    private int gridletID_;
    private int status_ = 0;
    private DecimalFormat num_;
    private double finishTime_;
    private double execStartTime_;
    private StringBuffer history_;
    private ArrayList resList_;
    private int index_;
    public static final int CREATED = 0;
    public static final int READY = 1;
    public static final int QUEUED = 2;
    public static final int INEXEC = 3;
    public static final int SUCCESS = 4;
    public static final int FAILED = 5;
    public static final int CANCELED = 6;
    public static final int PAUSED = 7;
    public static final int RESUMED = 8;

    public Gridlet(int n, double d, long l, long l2) {
        this.gridletID_ = n;
        this.gridletLength_ = Math.max(1.0, d);
        this.gridletFileSize_ = Math.max(1L, l);
        this.gridletOutputSize_ = Math.max(1L, l2);
        this.execStartTime_ = 0.0;
        this.finishTime_ = -1.0;
        this.resList_ = new ArrayList();
        this.index_ = -1;
        this.num_ = new DecimalFormat("#0.00#");
        this.history_ = new StringBuffer(1000);
        this.history_.append("Time below denotes the simulation time.");
        this.history_.append(System.getProperty("line.separator"));
        this.history_.append("Time (sec)       Description Gridlet #" + n);
        this.history_.append(System.getProperty("line.separator"));
        this.history_.append("------------------------------------------");
        this.history_.append(System.getProperty("line.separator"));
        this.write("Creates Gridlet ID #" + n);
    }

    public String getGridletHistory() {
        return this.history_.toString();
    }

    public double getGridletFinishedSoFar() {
        if (this.index_ == -1) {
            return this.gridletLength_;
        }
        double d = ((Resource)this.resList_.get((int)this.index_)).finishedSoFar;
        if (d > this.gridletLength_) {
            return this.gridletLength_;
        }
        return d;
    }

    public boolean isFinished() {
        if (this.index_ == -1) {
            return false;
        }
        boolean bl = false;
        double d = ((Resource)this.resList_.get((int)this.index_)).finishedSoFar;
        double d2 = this.gridletLength_ - d;
        if (d2 <= 0.0) {
            bl = true;
        }
        return bl;
    }

    public void setGridletFinishedSoFar(double d) {
        if (d < 0.0 || this.index_ < 0) {
            return;
        }
        Resource resource = (Resource)this.resList_.get(this.index_);
        resource.finishedSoFar = d;
        this.write("Sets the length's finished so far to " + d);
    }

    public int GetGridletID() {
        return this.getGridletID();
    }

    public int getGridletID() {
        return this.gridletID_;
    }

    public void SetUserID(int n) {
        this.setUserID(n);
    }

    public void setUserID(int n) {
        this.userID_ = n;
        this.write("Assigns the Gridlet to " + GridSim.getEntityName(n) + " (ID #" + n + ")");
    }

    public int GetUserID() {
        return this.getUserID();
    }

    public int getUserID() {
        return this.userID_;
    }

    public int GetResourceID() {
        return this.getResourceID();
    }

    public int getResourceID() {
        if (this.index_ == -1) {
            return -1;
        }
        return ((Resource)this.resList_.get((int)this.index_)).resourceId;
    }

    public long GetGridletFileSize() {
        return this.getGridletFileSize();
    }

    public long getGridletFileSize() {
        return this.gridletFileSize_;
    }

    public long GetGridletOutputSize() {
        return this.getGridletOutputSize();
    }

    public long getGridletOutputSize() {
        return this.gridletOutputSize_;
    }

    public void SetResParam(int n, double d) {
        this.setResourceParameter(n, d);
    }

    public void setResourceParameter(int n, double d) {
        Resource resource = new Resource();
        resource.resourceId = n;
        resource.costPerSec = d;
        resource.resourceName = GridSim.getEntityName(n);
        this.resList_.add(resource);
        if (this.index_ == -1) {
            this.write("Allocates this Gridlet to " + resource.resourceName + " (ID #" + n + ") with cost = $" + d + "/sec");
        } else {
            int n2 = ((Resource)this.resList_.get((int)this.index_)).resourceId;
            String string = ((Resource)this.resList_.get((int)this.index_)).resourceName;
            this.write("Moves Gridlet from " + string + " (ID #" + n2 + ") to " + resource.resourceName + " (ID #" + n + ") with cost = $" + d + "/sec");
        }
        ++this.index_;
    }

    public void SetSubmissionTime(double d) {
        this.setSubmissionTime(d);
    }

    public void setSubmissionTime(double d) {
        if (d < 0.0 || this.index_ < 0) {
            return;
        }
        Resource resource = (Resource)this.resList_.get(this.index_);
        resource.submissionTime = d;
        this.write("Sets the submission time to " + this.num_.format(d));
    }

    public double getSubmissionTime() {
        if (this.index_ == -1) {
            return 0.0;
        }
        return ((Resource)this.resList_.get((int)this.index_)).submissionTime;
    }

    public void SetExecStartTime(double d) {
        this.setExecStartTime(d);
    }

    public void setExecStartTime(double d) {
        this.execStartTime_ = d;
        this.write("Sets the execution start time to " + this.num_.format(d));
    }

    public double getExecStartTime() {
        return this.execStartTime_;
    }

    public void SetExecParam(double d, double d2) {
        this.setExecParam(d, d2);
    }

    public void setExecParam(double d, double d2) {
        if (d < 0.0 || d2 < 0.0 || this.index_ < 0) {
            return;
        }
        Resource resource = (Resource)this.resList_.get(this.index_);
        resource.wallClockTime = d;
        resource.actualCPUTime = d2;
        this.write("Sets the wall clock time to " + this.num_.format(d) + " and the actual CPU time to " + this.num_.format(d2));
    }

    public void SetStatus(int n) throws Exception {
        this.setGridletStatus(n);
    }

    public void setGridletStatus(int n) throws Exception {
        if (this.status_ == n) {
            return;
        }
        if (n < 0 || n > 8) {
            throw new Exception("Gridlet.setGridletStatus() : Error - Invalid integer range for Gridlet status.");
        }
        if (n == 4) {
            this.finishTime_ = GridSim.clock();
        }
        String string = "Sets Gridlet status from " + this.getGridletStatusString();
        this.status_ = n;
        this.write(string + " to " + this.getGridletStatusString());
    }

    public int GetStatus() {
        return this.getGridletStatus();
    }

    public int getGridletStatus() {
        return this.status_;
    }

    public String GetStatusString() {
        return this.getGridletStatusString();
    }

    public String getGridletStatusString() {
        return Gridlet.getStatusString(this.status_);
    }

    public static String getStatusString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Created";
                break;
            }
            case 1: {
                string = "Ready";
                break;
            }
            case 3: {
                string = "InExec";
                break;
            }
            case 4: {
                string = "Success";
                break;
            }
            case 2: {
                string = "Queued";
                break;
            }
            case 5: {
                string = "Failed";
                break;
            }
            case 6: {
                string = "Canceled";
                break;
            }
            case 7: {
                string = "Paused";
                break;
            }
            case 8: {
                string = "Resumed";
                break;
            }
        }
        return string;
    }

    public double GetGridletLength() {
        return this.getGridletLength();
    }

    public double getGridletLength() {
        return this.gridletLength_;
    }

    public double GetActualCPUTime() {
        return this.getActualCPUTime();
    }

    public double getActualCPUTime() {
        if (this.index_ == -1) {
            return 0.0;
        }
        return ((Resource)this.resList_.get((int)this.index_)).actualCPUTime;
    }

    public double GetCostPerSec() {
        return this.getCostPerSec();
    }

    public double getCostPerSec() {
        if (this.index_ == -1) {
            return 0.0;
        }
        return ((Resource)this.resList_.get((int)this.index_)).costPerSec;
    }

    public double GetProcessingCost() {
        return this.getProcessingCost();
    }

    public double getProcessingCost() {
        if (this.index_ == -1) {
            return 0.0;
        }
        Resource resource = null;
        double d = 0.0;
        for (int i = 0; i <= this.index_; ++i) {
            resource = (Resource)this.resList_.get(i);
            d += resource.actualCPUTime * resource.costPerSec;
        }
        return d;
    }

    public double GetWallClockTime() {
        return this.getWallClockTime();
    }

    public double getWallClockTime() {
        if (this.index_ == -1) {
            return 0.0;
        }
        return ((Resource)this.resList_.get((int)this.index_)).wallClockTime;
    }

    public String[] getAllResourceName() {
        int n = this.resList_.size();
        String[] stringArray = null;
        if (n > 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((Resource)this.resList_.get((int)i)).resourceName;
            }
        }
        return stringArray;
    }

    public int[] getAllResourceID() {
        int n = this.resList_.size();
        int[] nArray = null;
        if (n > 0) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = ((Resource)this.resList_.get((int)i)).resourceId;
            }
        }
        return nArray;
    }

    public double getActualCPUTime(int n) {
        Resource resource = null;
        int n2 = this.resList_.size();
        for (int i = 0; i < n2; ++i) {
            resource = (Resource)this.resList_.get(i);
            if (n != resource.resourceId) continue;
            return resource.actualCPUTime;
        }
        return 0.0;
    }

    public double getCostPerSec(int n) {
        Resource resource = null;
        int n2 = this.resList_.size();
        for (int i = 0; i < n2; ++i) {
            resource = (Resource)this.resList_.get(i);
            if (n != resource.resourceId) continue;
            return resource.costPerSec;
        }
        return 0.0;
    }

    public double getGridletFinishedSoFar(int n) {
        Resource resource = null;
        int n2 = this.resList_.size();
        for (int i = 0; i < n2; ++i) {
            resource = (Resource)this.resList_.get(i);
            if (n != resource.resourceId) continue;
            return resource.finishedSoFar;
        }
        return 0.0;
    }

    public double getSubmissionTime(int n) {
        Resource resource = null;
        int n2 = this.resList_.size();
        for (int i = 0; i < n2; ++i) {
            resource = (Resource)this.resList_.get(i);
            if (n != resource.resourceId) continue;
            return resource.submissionTime;
        }
        return 0.0;
    }

    public double getWallClockTime(int n) {
        Resource resource = null;
        int n2 = this.resList_.size();
        for (int i = 0; i < n2; ++i) {
            resource = (Resource)this.resList_.get(i);
            if (n != resource.resourceId) continue;
            return resource.wallClockTime;
        }
        return 0.0;
    }

    public String getResourceName(int n) {
        Resource resource = null;
        int n2 = this.resList_.size();
        for (int i = 0; i < n2; ++i) {
            resource = (Resource)this.resList_.get(i);
            if (n != resource.resourceId) continue;
            return resource.resourceName;
        }
        return null;
    }

    public double GetFinishTime() {
        return this.getFinishTime();
    }

    public double getFinishTime() {
        return this.finishTime_;
    }

    private void write(String string) {
        this.history_.append(this.num_.format(GridSim.clock()));
        this.history_.append("   " + string + System.getProperty("line.separator"));
    }

    private class Resource {
        public double submissionTime = 0.0;
        public double wallClockTime = 0.0;
        public double actualCPUTime = 0.0;
        public double costPerSec = 0.0;
        public double finishedSoFar = 0.0;
        public int resourceId = -1;
        public String resourceName = null;
    }
}

