/*
 * Decompiled with CFR 0.152.
 */
package eduni.simjava.distributions;

import eduni.simjava.distributions.ContinuousGenerator;
import eduni.simjava.distributions.Sim_parameter_exception;
import eduni.simjava.distributions.Sim_random_obj;

public class Sim_weibull_obj
implements ContinuousGenerator {
    private Sim_random_obj source;
    private double scale;
    private double shape;
    private String name;

    public Sim_weibull_obj(String string, double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_weibull_obj: Scale and shape parameters must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG");
        this.scale = d;
        this.shape = d2;
        this.name = string;
    }

    public Sim_weibull_obj(String string, double d, double d2, long l) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_weibull_obj: Scale and shape parameters must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG", l);
        this.scale = d;
        this.shape = d2;
        this.name = string;
    }

    public double sample() {
        return this.scale * Math.pow(Math.log(this.source.sample()), 1.0 / this.shape);
    }

    static double sample(Sim_random_obj sim_random_obj, double d, double d2) {
        return d * Math.pow(Math.log(sim_random_obj.sample()), 1.0 / d2);
    }

    public void set_seed(long l) {
        this.source.set_seed(l);
    }

    public long get_seed() {
        return this.source.get_seed();
    }

    public String get_name() {
        return this.name;
    }
}

