/*
 * Decompiled with CFR 0.152.
 */
package eduni.simjava.distributions;

import eduni.simjava.distributions.ContinuousGenerator;
import eduni.simjava.distributions.Sim_parameter_exception;
import eduni.simjava.distributions.Sim_random_obj;

public class Sim_normal_obj
implements ContinuousGenerator {
    private Sim_random_obj source;
    private double mean;
    private double std_dev;
    private boolean not_sampled = true;
    private double u1;
    private double u2;
    private static boolean not_sampled_st = true;
    private static double u1_st;
    private static double u2_st;
    private String name;

    public Sim_normal_obj(String string, double d, double d2) {
        if (d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_normal_obj: The variance must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG");
        this.mean = d;
        this.std_dev = Math.sqrt(d2);
        this.name = string;
    }

    public Sim_normal_obj(String string, double d, double d2, long l) {
        if (d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_normal_obj: The variance must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG", l);
        this.mean = d;
        this.std_dev = Math.sqrt(d2);
        this.name = string;
    }

    public double sample() {
        double d;
        if (this.not_sampled) {
            this.u1 = this.source.sample();
            this.u2 = this.source.sample();
            d = this.mean + this.std_dev * Math.cos(Math.PI * 2 * this.u1) * Math.sqrt(-2.0 * Math.log(this.u2));
        } else {
            d = this.mean + this.std_dev * Math.sin(Math.PI * 2 * this.u1) * Math.sqrt(-2.0 * Math.log(this.u2));
        }
        return d;
    }

    static double sample(Sim_random_obj sim_random_obj, double d, double d2) {
        double d3;
        double d4 = Math.sqrt(d2);
        if (not_sampled_st) {
            u1_st = sim_random_obj.sample();
            u2_st = sim_random_obj.sample();
            d3 = d + d4 * Math.cos(Math.PI * 2 * u1_st) * Math.sqrt(-2.0 * Math.log(u2_st));
        } else {
            d3 = d + d4 * Math.sin(Math.PI * 2 * u1_st) * Math.sqrt(-2.0 * Math.log(u2_st));
        }
        return d3;
    }

    public void set_seed(long l) {
        this.source.set_seed(l);
    }

    public long get_seed() {
        return this.source.get_seed();
    }

    public String get_name() {
        return this.name;
    }
}

