/*
 * Decompiled with CFR 0.152.
 */
package eduni.simdiag;

import eduni.simdiag.TraceEventObject;
import eduni.simdiag.TraceListener;
import eduni.simdiag.Traceable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TraceSaver
implements Traceable,
TraceListener {
    private PrintWriter trcstream;
    private String fname;
    private boolean isBroke = false;

    public TraceSaver(String string) {
        this.fname = string;
        this.open();
    }

    void open() {
        this.isBroke = false;
        try {
            if (this.trcstream != null) {
                this.trcstream.close();
            }
            this.trcstream = new PrintWriter(new FileOutputStream(this.fname));
        }
        catch (IOException iOException) {
            this.isBroke = true;
            System.out.println("TraceSaver: Error - couldn't open trace file");
        }
        catch (Exception exception) {
            this.isBroke = true;
            System.out.println("TraceSaver: file error. Probably security checks won't allow writing of a tracefile.  " + exception);
        }
    }

    void close() {
        if (!this.isBroke) {
            this.trcstream.close();
        }
    }

    public void handleTrace(TraceEventObject traceEventObject) {
        if (traceEventObject.getCmd() == 0) {
            if (!this.isBroke) {
                this.trcstream.println(traceEventObject.getLine());
            }
        } else if (traceEventObject.getCmd() == 1) {
            if (!this.isBroke) {
                this.open();
            }
        } else if (traceEventObject.getCmd() == 5 && !this.isBroke) {
            this.trcstream.flush();
        }
    }
}

